# Summary

- [Introduction](intro.md)

# Installation

- [Installation](installation.md)

# Building images

- [Building images](building/guidance.md)
- [Container runtime vs bootc runtime](building/bootc-runtime.md)
- [Users, groups, SSH keys](building/users-and-groups.md)
- [Kernel arguments](building/kernel-arguments.md)
- [Secrets](building/secrets.md)
- [Management Services](building/management-services.md)

# Using bootc

- [Upgrade and rollback](upgrades.md)
- [Accessing registries and offline updates](registries-and-offline.md)
- [Logically bound images](logically-bound-images.md)
- [Booting local builds](booting-local-builds.md)
- [`man bootc`](man/bootc.md)
- [`man bootc-status`](man/bootc-status.md)
- [`man bootc-upgrade`](man/bootc-upgrade.md)
- [`man bootc-switch`](man/bootc-switch.md)
- [`man bootc-rollback`](man/bootc-rollback.md)
- [`man bootc-usr-overlay`](man/bootc-usr-overlay.md)
- [`man bootc-fetch-apply-updates.service`](man-md/bootc-fetch-apply-updates.service.md)
- [`man bootc-status-updated.path`](man-md/bootc-status-updated.path.md)
- [`man bootc-status-updated.target`](man-md/bootc-status-updated.target.md)
- [Controlling bootc via API](bootc-via-api.md)

# Using `bootc install`

- [Understanding `bootc install`](bootc-install.md)
- [`man bootc-install`](man/bootc-install.md)
- [`man bootc-install-config`](man-md/bootc-install-config.md)
- [`man bootc-install-to-disk`](man/bootc-install-to-disk.md)
- [`man bootc-install-to-filesystem`](man/bootc-install-to-filesystem.md)
- [`man bootc-install-to-existing-root`](man/bootc-install-to-existing-root.md)

# Bootc usage in containers

- [Read-only when in a default container](bootc-in-container.md)
- [`man bootc-container-lint`](man/bootc-container-lint.md)

# Architecture

- [Image layout](bootc-images.md)
- [Filesystem](filesystem.md)
- [Filesystem: sysroot](filesystem-sysroot.md)
- [Container storage](filesystem-storage.md)
- [Bootloader](bootloader.md)

# Experimental features

- [bootc image](experimental-bootc-image.md)
- [fsck](experimental-fsck.md)
- [--progress-fd](experimental-progress-fd.md)

# More information

- [Package manager integration](package-managers.md)
- [Relationship with other projects](relationships.md)
- [Relationship with OCI artifacs](relationship-oci-artifacts.md)
- [Relationship with systemd "particles"](relationship-particles.md)
