# frozen_string_literal: true

# See http://doc.gitlab.com/ce/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.
class UpdateCsVulnerabilityConfidenceColumn < ActiveRecord::Migration[5.2]
  include Gitlab::Database::MigrationHelpers

  disable_ddl_transaction!

  DOWNTIME = false
  BATCH_SIZE = 1_000
  INTERVAL = 5.minutes

  # 137_424 records to be updated on GitLab.com,
  # giving us an estimated runtime of 12 hours.
  def up
    # no-op in CE
    return unless Gitlab.ee?

    migration = Gitlab::BackgroundMigration::UpdateVulnerabilityConfidence
    migration_name = migration.to_s.demodulize
    relation = migration::Occurrence.container_scanning_reports_with_medium_confidence
    queue_background_migration_jobs_by_range_at_intervals(relation,
                                                          migration_name,
                                                          INTERVAL,
                                                          batch_size: BATCH_SIZE)
  end

  def down
    # no-op
  end
end
