# Multiple Assignees for Issues **(STARTER)**

> **Note:**
[Introduced](https://gitlab.com/gitlab-org/gitlab/issues/1904)
in [GitLab Starter 9.2](https://about.gitlab.com/blog/2017/05/22/gitlab-9-2-released/#multiple-assignees-for-issues).

## Overview

In large teams, where there is shared ownership of an issue, it can be difficult
to track who is working on it, who already completed their contributions, who
didn't even start yet.

In [GitLab Enterprise Edition](https://about.gitlab.com/pricing/),
you can also select multiple assignees to an issue, making it easier to
track, and making clearer who is accountable for it.

![multiple assignees for issues](img/multiple_assignees_for_issues.png)

## Use cases

Consider a team formed by frontend developers, backend developers,
UX designers, QA testers, and a product manager working together to bring an idea to
market.

Multiple Assignees for Issues makes collaboration smoother,
and allows shared responsibilities to be clearly displayed.
All assignees are shown across your team's workflows and receive notifications (as they
would as single assignees), simplifying communication and ownership.

Once an assignee had their work completed, they would remove themselves as assignees, making
it clear that their role is complete.

## How it works

From an opened issue, expand the right sidebar, locate the assignees entry,
and click on **Edit**. From the dropdown menu, select as many users as you want
to assign the issue to.

![adding multiple assignees](img/multiple_assignees.gif)

An assignee can be easily removed by deselecting them from the same dropdown menu.
