;	$Id: dino-compile.el,v 1.15 2004/03/03 12:35:17 vanicat Exp $	
;;; dino-compile.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; a ne sert qu' la compilation

(setq load-path (cons "." load-path))

(defun compile-my-file (file)
  (unless (string-equal file "dino-compile.el")
    (byte-compile-file file)))
 
(defun compile-all () 
  (let ((files (directory-files "." () "\\.el$")))
    (mapcar 'compile-my-file files)))

(defun dino-make-autoload (file)
  (require 'autoload)
  (let ((generated-autoload-file (concat default-directory
					 "/dino-autoload.el"))
	(files (directory-files "." () "\\.el$")))
    (mapcar 'update-file-autoloads files))
  (save-some-buffers 't))
