;	$Id: dino-console-mode.el,v 1.19 2004/03/03 12:35:17 vanicat Exp $
;;; dino-msg-mode.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; ce fichier concerne le mode de lecture des messages
;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier 

(require 'dino-autoload)
(require 'cl)
(require 'dino-cnx)
(require 'dino-gestion)
(require 'dino-dinorc-serveur)

(defvar dino-console-mode-hook ()
  "*Un hook pour le poste-mode de dino")

(defvar dino-console-mode-load-hook ()
  "*Un hook lanc aprs le chargement de dino-console-mode")

(defvar dino-console-mode-map ()
  "*Un map pour le console-mode de dino")

(put 'dino-console-mode 'mode-class 'special)

;;;###autoload
(defun dino-erase-buffer ()
  "efface le buffer *dino*"
  (interactive)
  (let ((old-buffer (current-buffer)))
    (unwind-protect
	(progn
	  (set-buffer (process-buffer dino-connection))
	  (save-excursion
	    ;; Insert the text, moving the process-marker.
	    (erase-buffer)
	    (set-marker (process-mark dino-connection) (point))))
      (set-buffer old-buffer))))

(defun dino-console-send-command (str)
  "envoie la ligne courante comme commande"
  (interactive (list (save-excursion
		       (beginning-of-line)
		       (prog1
			   (let ((beg (point)))
			     (end-of-line)
			     (buffer-substring beg (point)))
			 (insert "\n")
			 (set-marker (process-mark dino-connection) 
				     (point))))))
  (dino-send-command str))

;; mode console
(unless dino-console-mode-map
  (setq dino-console-mode-map (make-keymap))
  (define-key dino-console-mode-map "\C-cs" 'dino-save-all)
  (define-key dino-console-mode-map "\C-cn" 'dino-next-non-lu)
  (define-key dino-console-mode-map "\C-cN" 'dino-next-non-lu-tous)
  (define-key dino-console-mode-map "\C-cg" 'dino-goto-theme)
  (define-key dino-console-mode-map "\C-cc" 'dino-connect)
  (define-key dino-console-mode-map "\C-cr" 'dino-connect)
  (define-key dino-console-mode-map "\C-cz" 'dino-marque-lu)
  (define-key dino-console-mode-map "\C-cm" 'dino-poste)
  (define-key dino-console-mode-map "\C-cl" 'dino-lit-themes)
  (define-key dino-console-mode-map "\C-cL" 'dino-lit-themes-tous)
  (define-key dino-console-mode-map "\C-cq" 'dino-quit)
  (define-key dino-console-mode-map "\C-j"  'dino-console-send-command)
  (define-key dino-console-mode-map [menu-bar dino]
	(cons "dino" (make-sparse-keymap "dino")))
  (define-key dino-console-mode-map [menu-bar dino help]
        (cons "aide" 'describe-mode))
  (define-key dino-console-mode-map [menu-bar dino dinorc]
    (cons "dinorc" dino-dinorc-map))
  (define-key dino-console-mode-map [menu-bar dino dinorc2]
    (cons "dinorc2" dino-dinorc2-map))
  (define-key dino-console-mode-map [menu-bar dino dinorc-serv]
    (cons "dinorc serveur" dino-rc-serv-map))
  (define-key dino-console-mode-map [menu-bar dino next-non-lu]
        (cons "Prochain non lu" 'dino-next-non-lu))
  (define-key dino-console-mode-map [menu-bar dino goto-theme]
        (cons "Va dans le thme" 'dino-goto-theme))
  (define-key dino-console-mode-map [menu-bar dino quit]
        (cons "Quitter" 'dino-quit))
  (define-key dino-console-mode-map [menu-bar dino connect]
        (cons "Reconnexion" 'dino-connect))
  (define-key dino-console-mode-map [menu-bar dino marque-lu]
        (cons "Marquer lu" 'dino-marque-lu))
  (define-key dino-console-mode-map [menu-bar dino refait-console]
        (cons "Relit la console" 'dino-lit-themes))
  (define-key dino-console-mode-map [menu-bar dino poste]
        (cons "Poste" 'dino-poste)))

(defun dino-console-mode ()
  "mode pour la console de dino

\\{dino-console-mode-map}"

  (interactive)
  (kill-all-local-variables)
  (cond ((boundp 'mode-line-modified)
	 (setq mode-line-modified "--- "))
	((listp (default-value 'mode-line-format))
	 (setq mode-line-format
	       (list* "--" 
		      '(dino-rc2-modifie
			"*" 
			(dino-rc-serv-type 
			 (dino-rc-serv-modified "*" "")
			 ""))
		      '(dino-non-lu-struct "m" "")
		      '(dino-waiting-server "w" "")
		      "- "
		      (cdr (default-value 'mode-line-format))))))
  (setq major-mode 'dino-console-mode)
  (setq mode-name "console")
  (make-local-variable 'minor-mode-alist)
  (use-local-map dino-console-mode-map)
  (buffer-disable-undo (current-buffer))
  (run-hooks 'dino-console-mode-hook))

;;;###autoload
(defun dino-get-console-buffer ()
  (let ((buff (get-buffer "*dino*")))
    (if buff buff
      (let ((old-buffer (current-buffer)))
	(unwind-protect
	    (progn
	      (setq buff (get-buffer-create "*dino*"))
	      (set-buffer buff)
	      (dino-console-mode)
	      buff)
	  (set-buffer old-buffer))))))

(provide 'dino-console-mode)
(run-hooks 'dino-console-mode-load-hook)
