;	$Id: dino-dinorc-serveur.el,v 1.5 2004/03/03 12:35:17 vanicat Exp $
;;; dino-dinorc-serveur.el

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; gestion du .dinorc et des listes messages/thmes lus/non lus
;;; 
;;; 

(require 'dino-autoload)

(defvar dino-rc-serv-timestamp '(0 . 0)
  "temps de la derniere lecture sur le serveur")

(defvar dino-rc-serv-type ()
  "type du dinorc du serveur
vaut 'old si c'est l'ancien format
     'new si c'est le nouveaux
     () s'il n'y a rien")

(defcustom dino-rc-serv-ignore ()
  "*non nil signifie qu'on ingore les dinorc du serveur"
  :group 'dino
  :type 'boolean)

(defvar dino-rc-serv-modified ()
  "vrai si le dinorc du serveur est outdated")

(defvar dino-rc-serv-map ()
  "Un map pour le sauvergarde et la lecture du dinorc")

(defvar dino-rc-serv-easy-menu (list "dinorc serveur"
				     ["sauve" dino-rc-serv-save-dinorc-interactive t]
				     ["lit" dino-rc-serv-read-dinorc-maybe t]
				     ["sauve nouveau" dino-rc-serv-save-new-dinorc t]
				     ["sauve nouveau" dino-rc-serv-save-new-dinorc t])
  "Un menu pour le sauvergarde et la lecture du dinorc du serveur")

(unless dino-rc-serv-map
  (setq dino-rc-serv-map (make-sparse-keymap "dinorc serv"))
  (suppress-keymap dino-rc-serv-map)
  (define-key dino-rc-serv-map [save-old] 
    (cons "sauve ancien" 'dino-rc-serv-save-old-dinorc))
  (define-key dino-rc-serv-map [save-new] 
    (cons "sauve nouveau" 'dino-rc-serv-save-new-dinorc))
  (define-key dino-rc-serv-map [read]
    (cons "lit" 'dino-rc-serv-read-dinorc-maybe))
  (define-key dino-rc-serv-map [save] 
    (cons "sauve" 'dino-rc-serv-save-dinorc-interactive)))

;;;###autoload
(defun dino-rc-serv-read-dinorc-maybe ()
  "lit le dinorc du serveur si ncessaire"
  (interactive)
  (unless dino-rc-serv-ignore
    (dino-reconnect)
    (dino-send-command-unireponse "time_dinorc\n" ()
				  'dino-rc-serv-read-dinorc-maybe-accept)))

(defun dino-rc-serv-read-dinorc-maybe-accept (proc str)
  (unless (string-equal str "Err: dinorc non trouv")
    (if (string-equal (substring str 0 3) "Err")
	(dino-ecrit-recut () str)
      (when (string-match "Ok/1:.* \\([0-9]*\\)\\([0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\\)" str)
	(let ((res (cons (read (match-string 1 str)) 
			 (read (match-string 2 str)))))
	  (when (or (< (car dino-rc-serv-timestamp) (car res))
		    (and (= (car dino-rc-serv-timestamp) (car res))
			 (< (cdr dino-rc-serv-timestamp) (cdr res))))
	    (setq dino-rc-serv-timestamp res)
	    (dino-rc-serv-read-dinorc)))))))

(defun dino-rc-serv-read-dinorc ()
  (when (not dino-rc-serv-ignore)
    (dino-reconnect)
    (dino-send-command-multireponse "get_dinorc\n" ()
				    'dino-rc-serv-read-dinorc-accept)))

(defun dino-rc-serv-read-dinorc-accept (proc str)
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut () str)
    (let ((old-buffer (current-buffer))
	  (buffer (generate-new-buffer "*dino read dinorc")))
      (unwind-protect
	  (progn
	    (set-buffer buffer)
	    (insert str)
	    (goto-char 0)
	    (when (looking-at "Ok/n: dinorc du .*\n")
	      (replace-match ""))
	    (while (search-forward-regexp "^|" () 't)
	      (replace-match ""))
	    (goto-char 0)
	    (cond
	     ((looking-at "[^\n].*VERSION: 0.*\n")
	      (setq dino-rc-serv-type 'old)
	      (replace-match "")
	      (dino-read-old-dinorc))
	     ((looking-at "# $VERSION *: *1.0")
	      (setq dino-rc-serv-type 'new)
	      (dino-read-dinorc2))
	     ('t
	      (message "je ne comprend pas le dinorc sur le serveur")
	      (sleep-for 2)
	      (message ())))
	    (dino-save-dinorc))
	(set-buffer old-buffer)
	(kill-buffer buffer)))))

(defun dino-rc-serv-save-dinorc-interactive ()
  (interactive)
  (when (not dino-rc-serv-type)
    (setq dino-rc-serv-type 'new))
  (dino-rc-serv-save-dinorc-maybe))

(defun dino-rc-serv-save-dinorc-maybe ()
  (when (and (not dino-rc-serv-ignore)
	     dino-rc-serv-modified)
    (dino-rc-serv-save-dinorc)))

(defun dino-rc-serv-save-dinorc ()
  (unless dino-rc-serv-ignore
    (cond 
     ((eq dino-rc-serv-type 'old)
      (dino-rc-serv-save-old-dinorc))
     ((eq dino-rc-serv-type 'new)
      (dino-rc-serv-save-new-dinorc)))))

(defun dino-rc-serv-save-new-dinorc ()
  (interactive)
  (setq dino-rc-serv-type 'new)
  (setq dino-rc-serv-modified ())
  (let ((old-buffer (current-buffer))
	(buffer (generate-new-buffer " *dino read dinorc")))
    (unwind-protect
	(progn
	  (set-buffer buffer)
	  (dino-rc2-insert-dinorc2)
	  (goto-char (point-max))
	  (insert ".\n")
	  (dino-reconnect)
	  (dino-send-command-unireponse "put_dinorc\n" ()
					'dino-noop)
	  (dino-send-command-unireponse (buffer-string) ()
					'dino-rc-serv-save-accept))
      (set-buffer old-buffer)
      (kill-buffer buffer))))

(defun dino-rc-serv-save-old-dinorc ()
  (interactive)
  (setq dino-rc-serv-type 'old)
  (setq dino-rc-serv-modified ())
  (let ((old-buffer (current-buffer))
	(buffer (generate-new-buffer " *dino read dinorc")))
    (unwind-protect
	(progn
	  (set-buffer buffer)
	  (insert "# $VERSION: 0\n")
	  (dino-rc2-insert-old-dinorc)
	  (goto-char (point-max))
	  (insert ".\n")
	  (dino-reconnect)
	  (dino-send-command-unireponse "put_dinorc\n" ()
					'dino-noop)
	  (dino-send-command-unireponse (buffer-string) ()
					'dino-rc-serv-save-accept))
      (set-buffer old-buffer)
      (kill-buffer buffer))))


(defun dino-rc-serv-save-accept (proc str)
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut () str)    
    (when (string-match "Ok/1:.* \\([0-9]*\\)\\([0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\\).*rempl.*" str)
      (setq dino-rc-serv-timestamp (cons (read (match-string 1 str)) 
					 (read (match-string 2 str)))))))

(provide 'dino-dinorc-serveur)

