;	$Id: dino-dinorc2.el,v 1.12 2004/03/03 12:35:17 vanicat Exp $
;;; dino-gestion.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; nouvelle gestion du .dinorc2 et des listes messages/thmes lus/non lus
;;; 

(require 'cl)
(require 'dino-general)

;;; les grosses structures contenant les informations sur le dinorc2

(defvar dino-rc2-alist-themes-alire-struct ()
  "une alist contenant les informations sur ce qui est lu ou non
contiens des listes (theme max-know abone alire) o
theme est le nom d'un theme
max-know maximal pour les messages existant connus pour sur
alire est une liste qui contient : 
le symbole 'beg comme premier element puis des element qui sont
soit un entier correspondant  un message non lu
soit un cons (deb . end) correspondant a un bloque de message lu
tous a dans l'ordre croissant des messages
ne contient que le dbut des infos, il peux y avoir des messages non lu
sur le serveur non encore conut, mme avant la fin des read-block")

(defvar dino-rc2-alist-dinorc2-var ())
(defvar dino-rc2-modifie ())

(defvar dino-nbmsg 0
  "le numro du plus grand message lu")

(defun dino-rc2-get-alire (them)
  "cherche la structure alire pour le theme THEM, en la creant si ncessaire"
  (let ((struct (dino-get-alist dino-rc2-alist-themes-alire-struct them)))
    (when (null struct)
      (setq struct (list them 0 t))
      (setq dino-rc2-alist-themes-alire-struct
	    (let* ((list  (cons () dino-rc2-alist-themes-alire-struct))
		   (deb list)
		   (pas-finis 't))
	      (while pas-finis
		(cond ((null (cdr list))
		       (setcdr list (cons struct ()))
		       (setq pas-finis ()))
		      ((dino-string< them (car (car (cdr list))))
		       (setcdr list (cons struct (cdr list)))
		       (setq pas-finis ())))
		(setq list (cdr list)))
	      (cdr deb))))
    struct))

;;; modification/lecture d'une structure correspondant  un thme

(defun dino-rc2-set-abonne (struct abone)
  (setcar (cddr struct) (if abone 't ())))

(defun dino-rc2-get-abone (struct)
  (caddr struct))

(defun dino-rc2-add-read-block-int (pointer beg end max-know)
  (let ((tail-call 't))
    (while tail-call
      (setq tail-call ())
      (if pointer
	  (if (consp (car pointer))
	      (cond 
	       ((> beg (cdar pointer))	;nouveaux bloc apres
		(let ((res (dino-rc2-add-read-block-int (cdr pointer)
							beg end max-know)))
		  (if (and (consp (car res))
			   (< (caar res) max-know))
		      (progn
			(setq dino-rc2-modifie 't)
			(setcdr (car pointer) (cdar res))
			(setcdr pointer (cdr res))
			pointer)
		    (setcdr pointer res))))  ;; valeur de retour : pointeur
	       ((< end (caar pointer))	; nouveaux bloc avant
		(if (> (caar pointer) max-know)
		    (cons (cons beg end) pointer)
		  (setq dino-rc2-modifie 't)
		  (setq end (cdar pointer))
		  (setq pointer (cdr pointer))
		  (setq tail-call 't)))
	       ((and (<= (caar pointer) beg)
		     (<= end (cdar pointer)))) ; nouveaux bloc inclut
	       ;; valeur de retour : pointer
	       ('t				; overlap
		(setq dino-rc2-modifie 't)
		(setq beg (min beg (caar pointer)))
		(setq end (max end (cdar pointer)))
		(setq pointer (cdr pointer))
		(setq tail-call 't)))
	    (cond 
	     ((> beg (car pointer))		; nouveaux bloc apres
	      (setcdr pointer (dino-rc2-add-read-block-int (cdr pointer)
							   beg end max-know)))
	     ;; valeur de retour : pointer
	     ((< end (car pointer))		;nouveaux bloc avant
	      (setq pointer (cons (cons beg end) pointer)))
	     ;; valeur de retour : pointer
	     ('t 				;element dans le nouveaux bloc
	      (setq pointer (cdr pointer))
	      (setq tail-call 't))))
	(setq pointer (cons (cons beg end) ()))))
    pointer))
	     
      

;(defun dino-rc2-add-read-block (struct beg end)
;  "ajoute le noveaux block (beg . end)"
;  (let* ((max-know (cadr struct))
;	 (loc (cddr struct)))
;    (setcdr loc (dino-rc2-add-read-block-int (cdr loc) beg end max-know))))

(defun dino-rc2-add-read-block (struct beg end)
  (let ((max-know (cadr struct))
	(loc (cddr struct))
	pointer cont
	(rec-call 't))
    (while rec-call
      (setq pointer (cdr loc))
      (setq cont (car pointer))
      (if pointer
	  (if (consp cont)
	      (cond 
	       ((> beg (cdr cont))	;nouveaux bloc apres
		(setq loc (cdr loc)))
	       ((< end (car cont))	; nouveaux bloc avant
		(setq dino-rc2-modifie 't)
		(if (> (car cont) max-know)
		    (progn
		      (setcdr loc (cons (cons beg end) pointer))
		      (setq rec-call ()))
		  (setq end (cdr cont))
		  (setcdr loc (cdr pointer))))
	       ((and (<= (car cont) beg)
		     (<= end (cdr cont))) ; nouveaux bloc inclut
		(setq rec-call ()))
	       ;; valeur de retour : pointer
	       ('t				; overlap
		(setq dino-rc2-modifie 't)
		(setq beg (min beg (car cont)))
		(setq end (max end (cdr cont)))
		(setcdr loc (cdr pointer))))
	    (cond 
	     ((> beg cont)		; nouveaux bloc apres
	      (setq loc (cdr loc)))
	     ;; valeur de retour : pointer
	     ((< end cont)		;nouveaux bloc avant
	      (setq dino-rc2-modifie 't)
	      (setcdr loc (cons (cons beg end) pointer))
	      (setq rec-call ()))
	     ;; valeur de retour : pointer
	     ('t 				;element dans le nouveaux bloc
	      (setq dino-rc2-modifie 't)
	      (setcdr loc (cdr pointer)))))
	(setq rec-call ())
	(setcdr loc  (cons (cons beg end) ()))))
    ;; ici, eventuellement on a 2 bloc qui ce suive (mais pas plus) 
    ;; on teste
    (if (and (consp (car loc))
	     (consp (cadr loc))
	     (<= (caadr loc) max-know))
	(progn
	  (setcdr (car loc) (cdadr loc))
	  (setcdr loc (cddr loc))))
    ;; maintenant on change max-know si le premier block est plus gros
    (setq cont (cadddr struct))
    (if (and (consp cont)
	     (< max-know (cdr cont)))
	(setcar (cdr struct) (cdr cont))))
  ;; FIXME ne devrai pas tre ncessaire
  (dino-rc2-netoie-struct struct))
	     

(defun dino-rc2-netoie-struct (struct)
  (let* ((cur (cdddr struct))
	 (cur-cont (car cur))
	 (next-cont))
    (while cur
      (setq next-cont (cadr cur))
      (if (and (consp cur-cont)
	       next-cont
	       (numberp next-cont)
	       (<= next-cont (cdr cur-cont)))
	  (setcdr cur (cddr cur))
	(setq cur (cdr cur))))))
  

(defun dino-rc2-add-non-lu (struct non-lu)
  "non-lu ne devrais pas tre vide, ni contenir un lment
dj considere comme non lu dans la liste (voir mme un lment
ce trouvant avant max-know) en fait il devrai contenir une suite
de message du theme suivant max-know"
  (let* ((value (car non-lu))
	 (max (car non-lu))
	 (cur (cddr struct))
	 (cur-cont (car cur))
	 (next (cdr cur))
	 (next-cont (car next)))
    (while (and next
		non-lu)
      (setq max (max max (car non-lu)))
      (if (consp next-cont)
	  (if (<= (car next-cont) value)
	      (progn
		(if (consp cur-cont)
		    (progn
		      (setcdr cur-cont (cdr next-cont))
		      (setcdr cur (cdr next)))
		  (setq cur next)
		  (setq cur-cont next-cont))
		(when (<= value (cdr next-cont))
		  (setq max (cdr next-cont))
		  (while (and non-lu (<= value (cdr next-cont)))
		    (setq non-lu (cdr non-lu))
		    (setq value (car non-lu))))
		(setq next (cdr next))
		(setq next-cont (car next)))
	    (setcdr cur (cons value next))
	    (setq cur (cdr cur))
	    (setq cur-cont (car cur))
	    (setq non-lu (cdr non-lu))
	    (setq value (car non-lu)))
	(setq cur next)
	(setq cur-cont next-cont)
	(setq next (cdr next))
	(setq next-cont (car next))))
    (when (null next)
      (setcdr cur non-lu))
    (when (< dino-nbmsg max)
      (setq dino-nbmsg max))
    (setcar (cdr struct)
	    (apply 'max (cadr struct)
		   max
		   non-lu))))

(defun dino-rc2-first-non-lu (struct)
  (let* ((beg-loc (cddr struct))
	 (next (cdr beg-loc))
	 (cont (car next)))
    (while (and next (consp cont))
      (setq beg-loc next
	    next (cdr next))
      (setq cont (car next)))
    cont))

(defun dino-rc2-all-non-lu (struct)
  (let* ((next (cdddr struct))
	 (cont (car next))
	 (value))
    (while next
      (unless (consp cont)
	(setq value (cons cont value)))
      (setq next (cdr next))
      (setq cont (car next)))
    (nreverse value)))


(defun dino-rc2-first-end-lu (struct)
  (let* ((cont (cadddr struct)))
    (if (consp cont)
	(cdr cont)
      0)))
  

;;; lecture/ecriture des vieux dinorc 

;;;###autoload
(defun dino-read-old-dinorc (&optional buffer)
  "lit le dinorc contenue ds BUFFER (le buffer courant si BUFFER = nil)"
  (save-excursion
    (let ((finie)
	  (them)
	  (lu)
	  (strcut)
	  (abone))
      (when buffer (set-buffer buffer))
      (goto-char (point-max))
      (forward-line 0)
      (while (not finie)
	(when (looking-at "\\([^ ]*\\) +\\([0-9]*\\)\\( +\\*\\)?")
	  (setq them (buffer-substring (match-beginning 1)
				       (match-end 1)))
	  (setq lu (read (buffer-substring (match-beginning 2)
					   (match-end 2))))
	  (setq abone (not (match-beginning 3)))
	  (setq strcut (dino-rc2-get-alire them))
	  (dino-rc2-set-abonne strcut abone)
	  (when (<= 1 lu)
	    (dino-rc2-add-read-block strcut 1 lu)))
	(setq finie (= (point) (point-min)))
	(forward-line -1)))))
	       

;;;###autoload
(defun dino-rc2-insert-old-dinorc (&optional buffer)
  "insert the dinorc in the bufer (current if buffer = nil)"
  (save-excursion
    (when buffer (set-buffer buffer))
    (let ((all-struct dino-rc2-alist-themes-alire-struct)
	  (abone) (next) (cont) (value) (struct) (them))
      (while all-struct
	(setq struct (car all-struct))
	(setq them (car struct))
	(setq abone (caddr struct))
	(setq next (cdddr struct))
	(setq cont (car next))
	(setq value 0)
	(when (consp cont)
	  (setq value (cdr cont)))
	(insert them " ")
	(insert (int-to-string value))
	(unless abone (insert " *"))
	(insert "\n")
	(setq all-struct (cdr all-struct))))))

;;; lecture/ecriture des nouveaux dinorc 

;;;###autoload
(defun dino-rc2-insert-dinorc2 (&optional buffer)
  "insert the dinorc in the bufer (current if buffer = nil)"
  (save-excursion
    (when buffer (set-buffer buffer))
    (insert "# $VERSION: 1.0\n")
    (let ((all-struct dino-rc2-alist-themes-alire-struct)
	  (abone) (next) (cont) (struct) (them) (first))
      (setq next dino-rc2-alist-dinorc2-var)
      (while next
	(insert "# $")
	(insert (caar next))
	(insert ": ")
	(setq cont (cdar next))
	(cond
	 ((functionp cont) (insert (apply cont)))
	 ((and (consp cont) (functionp (car cont)) (functionp (cdr cont)))
	  (insert (apply (car cont))))
	 ('t 
	  (insert cont)))
	(insert "\n")
	(setq next (cdr next)))
      (while all-struct
	(setq struct (car all-struct))
	(setq them (car struct))
	(setq abone (caddr struct))
	(setq next (cdddr struct))
	(setq cont (car next))
	(insert them)
	(if abone (insert ": ")
	  (insert "! "))
	(setq first 't)
	(while next
	  (when (consp cont)
	    (when (not first) (insert ","))
	    (setq first ())
	    (if (= (car cont) (cdr cont))
		(insert (int-to-string (car cont)))
	      (insert (int-to-string (car cont)))
	      (insert "-")
	      (insert (int-to-string (cdr cont)))))
	  (setq next (cdr next))
	  (setq cont (car next)))
	(insert "\n")
	(setq all-struct (cdr all-struct))))))

;;;###autoload
(defun dino-read-dinorc2 (&optional buffer)
  (save-excursion
    (let ((variable)
	  (value)
	  (asso)
	  (finie)
	  (them)
	  (lu-beg)
	  (lu-end)
	  (pos)
	  (struct)
	  (abone))
      (when buffer (set-buffer buffer))
      (goto-char (point-min))
      (unless (looking-at "#? *\\$?VERSION *: *1.0 *\n")
	(error "not a dinorc2 format"))
      (goto-char (point-max))
      (forward-line 0)
      (while (not finie)
	(cond
	 ((looking-at "# *\\$\\(.*\\) *: *\\([^ ]*\\) *\n")
	  (setq variable (buffer-substring (match-beginning 1)
					   (match-end 1))
		value (buffer-substring (match-beginning 2)
					(match-end 2)))
	  (setq asso (dino-get-alist dino-rc2-alist-dinorc2-var variable))
	  (if asso
	      (let ((cont (cdr asso)))
		(cond ((functionp cont)
		       (apply cont value))
		      ((and (consp cont)
			    (functionp (car cont))
			    (functionp (cdr cont)))
		       (apply (cdr cont) value))
		      ('t
		       (setcdr asso value))))
	    (setq dino-rc2-alist-dinorc2-var
		  (dino-set-alist dino-rc2-alist-dinorc2-var
				  variable value))))
	 ((looking-at "#.*"))
	 ((looking-at " *$"))
	 ((looking-at "\\(.*\\)\\([:!]\\) *\\(.*\\)")
	  (setq pos (point))
	  (setq them (buffer-substring (match-beginning 1)
				       (match-end 1)))
	  (setq abone (string= (buffer-substring (match-beginning 2)
						 (match-end 2))
			       ":"))
	  (setq struct (dino-rc2-get-alire them))
	  (dino-rc2-set-abonne struct abone)
	  (goto-char (match-beginning 3))
	  (while (not (eolp))
	    (cond
	     ((looking-at "\\([0-9]+\\)-\\([0-9]+\\) *,? *")
	      (setq lu-beg (string-to-int (buffer-substring (match-beginning 1)
							    (match-end 1))))
	      (setq lu-end (string-to-int (buffer-substring (match-beginning 2)
							    (match-end 2))))
	      (dino-rc2-add-read-block struct lu-beg lu-end)
	      (goto-char (match-end 0)))
	     ((looking-at "\\([0-9]+\\) *,? *")
	      (setq lu-beg (string-to-int (buffer-substring (match-beginning 1)
							    (match-end 1))))
	      (dino-rc2-add-read-block struct lu-beg lu-beg)
	      (goto-char (match-end 0)))
	     ('t
	      (error "je ne comprend pas ce fichier ???"))))
	  (goto-char pos))
	 ('t
	  (error "je ne comprend pas ce fichier ???")))
    	(setq pos (point))
	(forward-line -1)
	(setq finie (= (point) (point-min)))))))

(provide 'dino-dinorc2)

