;	$Id: dino-entete-mode.el,v 1.23 2004/03/03 12:35:17 vanicat Exp $
;;; dino-entete-mode.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; le mode entte 
;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

;;;
;;;
;;;

(require 'dino-autoload)
(require 'cl)
(require 'dino-general)
(require 'dino-gestion)
(require 'dino-dinorc-serveur)
(require 'dino-msg-mode)

(defvar dino-entete-mode-load-hook ()
  "*Un hook lanc aprs le chargement de dino-entete-mode")

(defvar dino-entete-buffer-name "*entete dino*"
  "nom du buffer pour la liste des enttes des messages")

(defvar dino-entete-buffer ()
  "buffer pour la liste des enttes des messages")

(defvar dino-lit-entetes-stopp ()
  "true si on a essay de stopper le chargement des enttes")
  
(defvar dino-entete-mode-hook ()
  "*Un hook pour le entete-mode de dino")

(defvar dino-entete-mode-map ()
  "*Un map pour le entete-mode de dino")

(put 'dino-entete-mode 'mode-class 'special)

(defcustom dino-lit-entetep ()
  "*si non nil, le client regarde la liste des messages  chaque nouveau 
thme"
  :group 'dino
  :type 'boolean)

(defun dino-get-entete-buffer ()
  "retourne le buffer entte"
  (if (buffer-live-p dino-entete-buffer) dino-entete-buffer
    (let ((old-buffer (current-buffer)))
      (unwind-protect
	  (progn
	    (setq dino-entete-buffer 
		  (get-buffer-create dino-entete-buffer-name))
	    (set-buffer dino-entete-buffer)
	    (dino-entete-mode)
	    dino-entete-buffer)
	(set-buffer old-buffer)))))

(unless dino-entete-mode-map
  (setq dino-entete-mode-map (make-keymap))
  (suppress-keymap dino-entete-mode-map)  
  (define-key dino-entete-mode-map "\C-m" 'dino-entete-lit-msg)
  (define-key dino-entete-mode-map "s" 'dino-lit-entetes-stop)
  (define-key dino-entete-mode-map "n" 'dino-next-non-lu)
  (define-key dino-entete-mode-map "N" 'dino-next-non-lu-tous)
  (define-key dino-entete-mode-map "t" 'dino-next-theme-non-lu)
  (define-key dino-entete-mode-map "\C-i" 'dino-next-non-lu)
;  (define-key dino-entete-mode-map "+" 'dino-next-msg)
  (define-key dino-entete-mode-map "g" 'dino-goto-theme)
  (define-key dino-entete-mode-map "a" 'dino-abonne)
  (define-key dino-entete-mode-map "d" 'dino-desabonne)
  (define-key dino-entete-mode-map "p" 'dino-prev)
;  (define-key dino-entete-mode-map "-" 'dino-prev-msg)
  (define-key dino-entete-mode-map " " 'scroll-up)
  (define-key dino-entete-mode-map "c" 'dino-connect)
  (define-key dino-entete-mode-map "[" 'dino-prev)
  (define-key dino-entete-mode-map "]" 'dino-next)
  (define-key dino-entete-mode-map "<" 'dino-prev)
  (define-key dino-entete-mode-map ">" 'dino-next)
  (define-key dino-entete-mode-map "v" 'dino-lit-message)
;  (define-key dino-entete-mode-map "z" 'dino-msg-marque-lu)
  (define-key dino-entete-mode-map "r" 'dino-reply)
  (define-key dino-entete-mode-map "R" 'dino-reply-include)
  (define-key dino-entete-mode-map "m" 'dino-poste)
  (define-key dino-entete-mode-map "l" 'dino-lit-themes)
  (define-key dino-entete-mode-map "L" 'dino-lit-themes-tous)
  (define-key dino-entete-mode-map "q" 'dino-quit)
  (define-key dino-entete-mode-map "^" 'dino-lit-parents)
  (define-key dino-entete-mode-map ":" 'dino-send-command)
  (define-key dino-entete-mode-map "P" 'dino-pile-show)

;; Barre de menu
  (define-key dino-entete-mode-map [menu-bar dino]
	(cons "dino" (make-sparse-keymap "dino")))
  (define-key dino-entete-mode-map [menu-bar dino help]
        (cons "aide" 'describe-mode))
  (define-key dino-entete-mode-map [menu-bar dino dinorc]
    (cons "dinorc" dino-dinorc-map))
  (define-key dino-entete-mode-map [menu-bar dino dinorc2]
    (cons "dinorc2" dino-dinorc2-map))
  (define-key dino-entete-mode-map [menu-bar dino dinorc-serv]
    (cons "dinorc serveur" dino-rc-serv-map))
  (define-key dino-entete-mode-map [menu-bar dino next-non-lu]
        (cons "Prochain non lu" 'dino-next-non-lu))
  (define-key dino-entete-mode-map [menu-bar dino next]
        (cons "Suivant dans thme" 'dino-next))
  (define-key dino-entete-mode-map [menu-bar dino prev]
        (cons "Prcdent dans thme" 'dino-prev))
;  (define-key dino-entete-mode-map [menu-bar dino prev-msg]
;        (cons "Suivant" 'dino-next-msg))
;  (define-key dino-entete-mode-map [menu-bar dino next-msg]
;        (cons "Prcdent" 'dino-prev-msg))
  (define-key dino-entete-mode-map [menu-bar dino goto-theme]
        (cons "Va dans le thme" 'dino-goto-theme))
  (define-key dino-entete-mode-map [menu-bar dino quit]
        (cons "Quitter" 'dino-quit))
  (define-key dino-entete-mode-map [menu-bar dino connect]
        (cons "Reconnexion" 'dino-connect))
  (define-key dino-entete-mode-map [menu-bar dino marque-lu]
        (cons "Marquer lu" 'dino-marque-lu))
  (define-key dino-entete-mode-map [menu-bar dino refait-list]
        (cons "Relit la liste" 'dino-lit-themes))
  (define-key dino-entete-mode-map [menu-bar dino poste]
        (cons "Poste" 'dino-poste))
  (define-key dino-entete-mode-map [mouse-2]
        (cons "Lit thme" 'dino-entete-mouse-lit-msg))
; Pile :
; commente, pour ne pas troubler l'utilisateur
;  (define-key dino-entete-mode-map [menu-bar dino pile-pop]
;    (cons "Dsempile" 'dino-pile-pop))
  (define-key dino-entete-mode-map [menu-bar dino pile-show]
    (cons "Pile" 'dino-pile-show))
  )

(defun dino-entete-mode () 
  "mode pour lire les enttes de dino

\\{dino-entete-mode-map}"
  
  (interactive)
  (kill-all-local-variables)
  (cond ;((boundp 'mode-line-modified)
	; (setq mode-line-modified "--- "))
	((listp (default-value 'mode-line-format))
	 (setq mode-line-format
	       (list* "-" 
		      'dino-theme-courant
		      "--" 
		      '(dino-rc2-modifie
			"*" 
			(dino-rc-serv-type 
			 (dino-rc-serv-modified "*" "")
			 ""))
		      '(dino-non-lu-struct "m" "")
		      '(dino-waiting-server "w" "")
		      "- "
		      (cdr (default-value 'mode-line-format))))))
  (setq major-mode 'dino-entete-mode)
  (setq mode-name "entete")
  (make-local-variable 'minor-mode-alist)
  (make-local-variable 'dino-theme-courant)
  (use-local-map dino-entete-mode-map)
  (buffer-disable-undo (current-buffer))
  (setq buffer-read-only t)
  (set-buffer-modified-p ())
  (setq truncate-lines t)
  (run-hooks 'dino-entete-mode-hook))

(defun dino-entete-lit-msg ()
  (interactive)
  (let ((msg (save-excursion 
	   (set-buffer (dino-get-entete-buffer))
	   (dino-message-get-number 
	    (get-text-property (point) 'dino-msg)))))
    (when msg
      (dino-split-windows-et-lit-message msg))))

(defun dino-entete-mouse-lit-msg (event)
  (interactive "@e")
;   (let ((msg (save-excursion 
; 	       (set-buffer (dino-get-entete-buffer))
; 	       (dino-message-get-number 
; 		(get-text-property (point) 'dino-msg)))))
  (let ((msg (dino-message-get-number 
	      (get-text-property (car (cdr (car (cdr event))))
				 'dino-msg))))
    (when msg
      (dino-split-windows-et-lit-message msg))))

;;gestion des entetes

;;;###autoload
(defun dino-lit-entetes (theme from)
  "lit la liste des entte"
  (interactive (let ((th (dino-ask-theme "Thme  : ")))
		 (list th (dino-ask-number "Message :" 
					   (cdr (assoc th dino-lu-themes))))))
  (setq dino-lit-entetes-stopp ())
  (dino-reconnect)
  (switch-to-buffer (dino-get-entete-buffer))
  (setq buffer-read-only ())
  (erase-buffer)
  (setq dino-theme-courant theme)
  (setq dino-themes-courants (list theme))
  (setq buffer-read-only t)
  (set-buffer-modified-p ())
  (dino-send-command-unireponse (concat "suivant " 
					(number-to-string from)
					" " theme "\n")
				(list (function dino-lit-entetes-internal) 
				      theme)
				(function dino-next-prev-accept)))

(defun dino-lit-entetes-stop ()
  "arrte le chargement des enttes"
  (interactive)
  (setq dino-lit-entetes-stopp 't))

(defun dino-lit-entetes-internal (msg theme)
  (when (/= msg 0)
    (dino-lit-entete msg)
    (unless dino-lit-entetes-stopp
      (dino-send-command-unireponse (concat "suivant " 
					    (number-to-string msg)
					    " " theme "\n")
				    (list 
				     (function dino-lit-entetes-internal) 
				     theme)
				    (function dino-next-prev-accept)))))
  
  
(defun dino-lit-entete (msg)
  "lit une entte"
  (dino-send-command-multireponse (concat "entete " (int-to-string msg) "\n")
				  ()
				  (function dino-accept-entete)))

;;;###autoload
(defun dino-accept-entete-internal (proc str)
  "parse l'entte (aprs rcption)"
  (let ((buffer (generate-new-buffer "*dino-msg-traite*"))
	buff
	result
	ici 
	(fin (make-marker)))
    (save-excursion
      (set-buffer buffer)
      (erase-buffer)
      (insert str)
      (goto-char 0)
      (re-search-forward "Ok/n:.*\n" nil t)
      (replace-match "" nil nil)
      
      (re-search-forward "|NUMB:\\(.*\\)\n")
      (replace-match "(\\1 " nil nil)
      
      (if (looking-at "|DATE:\\(.*\\)\n")
	  (progn
	    (re-search-forward "|DATE:\\(.*\\)\n" nil t)
	    (setq buff (buffer-substring (match-beginning 1) (match-end 1)))
	    (replace-match "" nil nil)
	    (insert (format "%S " buff)))
	(insert "\"\""))
      
      (re-search-forward "|AUTH:\\(.*\\)\n")
      (setq buff (buffer-substring (match-beginning 1) (match-end 1)))
      (replace-match "" nil nil)
      (insert (format "%S " buff))
      
      (re-search-forward "|SUBJ:\\(.*\\)\n")
      (setq buff (buffer-substring (match-beginning 1) (match-end 1)))
      (replace-match "" nil nil)
      (insert (format "%S (" buff))	;le ( pour la liste des sujets
      
      (setq ici (point))
      (re-search-forward "|THEM:\\(.*\\)\n")
      (replace-match "\\1 " nil nil)
      (set-marker fin (point))
      (goto-char ici)
      (while (< (point) fin)
	(re-search-forward "\\([^ ]*\\) *" fin)
	(setq buff (buffer-substring (match-beginning 1) (match-end 1)))
	(replace-match "" nil nil)
	(insert (format "%S " buff)))
      (insert ") ")

      (if (looking-at "|REPL:\\(.*\\)\n")
	  (replace-match "(\\1) ")
	(insert "() "))
      
      (insert "( ")
      (setq ici (point))
      (re-search-forward "|CENS:\\(.*\\)\n")
      (replace-match "\\1 " nil nil)
      (set-marker fin (point))
      (goto-char ici)
      (while (< (point) fin)
	(re-search-forward "\\([^ ]*\\) *" fin)
	(setq buff (buffer-substring (match-beginning 1) (match-end 1)))
	(replace-match "" nil nil)
	(insert (format "%S " buff)))
      (insert ") ")
      
      (if (looking-at "|SIGN:\\(.*\\)\n")
	  (progn
	    (re-search-forward "|SIGN:\\(.*\\)\n" nil t)
	    (setq buff (buffer-substring (match-beginning 1) (match-end 1)))
	    (replace-match "" nil nil)
	    (insert (format "%S " buff)))
	(insert "\"\""))

      (if (looking-at "|EFFA:\\(.*\\)\n")
	  (progn
	    (re-search-forward "|EFFA:\\(.*\\)\n" nil t)
	    (setq buff (buffer-substring (match-beginning 1) (match-end 1)))
	    (replace-match "" nil nil)
	    (insert (format "%S " buff)))
	(insert "()"))
	    
      
      (insert ")")
    
      (re-search-forward "#fin")
      (replace-match "" nil nil)
      
      (goto-char 0)
      
      (setq result (read buffer))
      (kill-buffer buffer)
      result)))


(defun dino-accept-entete (proc str)
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut () str)
    (let ((old  (current-buffer))
	  (msg (dino-accept-entete-internal proc str)))
      (unwind-protect 
	  (let (deb fin)
	    (set-buffer (dino-get-entete-buffer))
	    (save-excursion
	      (setq buffer-read-only ())
	      (goto-char (point-max))
	      (setq deb (point))
	      (insert (format "%7d %15s %s" 
			      (dino-message-get-number msg)
			      (substring (concat (dino-message-get-auth msg) 
						 "               ")
					 0 15)
			      (dino-message-get-sujet msg)))
	      (setq fin (point))
	      (put-text-property deb fin 'mouse-face 'highlight)
	      (put-text-property deb fin 'dino-msg msg)
	      (insert "\n")))
	(progn 
	  (setq buffer-read-only 't)
	  (set-buffer-modified-p ())
	  (set-buffer old))))))
  
(provide 'dino-entete-mode)


(run-hooks dino-entete-mode-load-hook)