;	$Id: dino-filtre.el,v 1.3 2004/03/03 12:35:17 vanicat Exp $
;;; dino-filtre.el

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; ce fichier concerne la gestion de filtre
;;; 
;;; 

(require 'cl)
(require 'dino-general)
(require 'dino-autoload)

(defvar dino-filtre-force ())

(defcustom dino-filtre ()
  "*variable grant le filtre dans dinel
doit contenir une liste de liste de la forme :
(HEADER ACCEPT REGLE) 
ou
(HEADER ACCEPT REGLE MODIFIER)

HEADER doit contenir un des symboles suivant :
sujet       filtre sur le sujet
auteur      filtre sur l auteur
signe       filtre sur le nom de la personne signant
censure     filtre sur la censure

si ACCEPT est non nil alors si la rgle est positive, le message est
accepter, si il vaut nil alors si la rgle est positive, le message est
filtr 

REGLE dcide si la rgle est positive ou ngative (MODIFIER peux modifier
le rsultat), par dfaut (MODIFIER absent ou nil):

si REGLE est une chane de caractre, elle est alors interprt comme une
regexp, et la rgle est positive si le champ et present, et que la valeur
du champ match la REGLE 
si REGLE est une fonction, elle est appeler avec comme unique argument la
valeur du champ (nil si absent) et doit renvoyer non nil si la rgle est
positive, nil sinon.

MODIFIER permet de modifier le comportement par dfaut :
- ou-absent alors si le champs est absent, la rgle devient positive
- inverse alors la rgle est positive si le champs et prsent et ne 
  correspond par  REGLE
- inverse-ou-absent alors la regle est positive si le champ est absent
  ou si il ne correspond pas  REGLE
- nil : comportement par dfaut

chaque lment de la liste est utiliser les un aprs les autres, jusqu' 
trouver une premire rgle positive alors le rsultat de ACCEPT est utilise,
sinon le message est accepter.

dino-filtre peux aussi tre une fonction au quelle cas cette fonction
est appeler avec quatre argument : sujet auteur signe censure
(dans cette ordre) et doit renvoyer nil pour les messages refuser, non-nil
sinon

Quand un message est filtr, la touche f dans dino-message affiche le
message quand mme."
  :group 'dino
  :type '(repeat (list (choice (const sujet) (const auteur)
			       (const signe) (const censure))
		       boolean
		       regexp
		       (choice (const ())
			       (const ou-absent)
			       (const inverse)
			       (cont inverse-ou-absent)))))


(defun dino-filtre (msg them)
  "filtre le message d'apres les regles de dino-filtre
voir la documentation de la variable dino-filtre pour plus de dtail"
  (if dino-filtre-force (progn (setq dino-filtre-force ()) 't)
    (let* ((filtre dino-filtre)
	   (at-them (concat them "@"))
	   (sujet (dino-message-get-sujet msg))
	   (auteur (dino-message-get-auth msg))
	   (signe (dino-message-get-signe msg))
	   (censure* (dino-message-get-cens msg))
	   (censure (if (member them censure*)
			them
		      (if (member at-them censure*)
			  at-them
			())))
	   rule good
	   header accept regle modifier pos
	   header-val)
      (if (functionp filtre)
	  (apply filtre sujet auteur signe censure)
	(while (and filtre (not pos))
	  (setq rule (car filtre))
	  (setq header (car rule))
	  (setq good 't)
	  (if (not (member header '(sujet auteur signe censure)))
	      (setq good ())
	    (setq header-val (eval header)))
	  (setq accept (cadr rule))
	  (setq regle (caddr rule))
	  (setq modifier (cadddr rule))
	  (if (not (member modifier '(ou-absent inverse inverse-ou-absent ())))
	      (setq good ()))
	  (setq filtre (cdr filtre))
	  (if good
	      (progn
		(setq pos
		      (if (functionp regle)
			  (apply regle header-val)
			(if (null header-val)
			    ()
			  (string-match regle header-val))))
		(setq pos (cond
			   ((eq modifier ())
			    pos)
			   ((eq modifier 'ou-absent)
			    (or (null header-val) pos))
			   ((eq modifier 'inverse)
			    (and header-val (not pos)))
			   ((eq modifier 'inverse-ou-absent)
			    (not pos))
			   ('t (error "bad dino-filtre")))))
	    (message "bad dino-filtre")))
	(if pos accept 't)))))
		
	  
(provide 'dino-filtre)