(require 'dino-autoload)

(defvar dino-alist-themes ())

(defconst dino-message-erreur
  '(0 "" "darklight" ("client") () () "darklight"
      (""))
  "le message d'erreur (non affich mais stock...)")

(defvar dino-controle-sequence-alist
  '((bold . "") (underline . "") (default . "")))

(defvar dino-ugly-hack-false-history-list ()
  "variable interne")

(defun dino-message-get-number (msg) (car msg))
(defun dino-message-get-date   (msg) (car (cdr msg)))
(defun dino-message-get-auth   (msg) (car (cdr (cdr msg))))
(defun dino-message-get-sujet  (msg) (car (cdr (cdr (cdr msg)))))
(defun dino-message-get-themes (msg) (car (cdr (cdr (cdr (cdr msg))))))
(defun dino-message-get-reply  (msg) (nth 5 msg))
(defun dino-message-get-cens   (msg) (nth 6 msg))
(defun dino-message-get-signe  (msg) (nth 7 msg))
(defun dino-message-get-effa   (msg) (nth 8 msg))
(defun dino-message-get-msg    (msg) (nth 9 msg))

;;fonction a propos general

(defcustom dino-default-signe (getenv "DINO_SIGNE")
  "*signe par dfaut si non-nil, autrement ne signe que sur demande
Prcisment, quand on rpond RET a la question \"voulez vous signez\"
cela veux dire oui si cette variable est non-nil, et non si cette 
variable est nil"
  :group 'dino
  :type 'boolean)

(defvar dino-y-or-n-p-map-anonyme )
(setq dino-y-or-n-p-map-anonyme (copy-keymap query-replace-map))
(define-key dino-y-or-n-p-map-anonyme [return] 'skip)

(defvar dino-y-or-n-p-map-signe )
(setq dino-y-or-n-p-map-signe (copy-keymap query-replace-map))
(define-key dino-y-or-n-p-map-signe [return] 'act)

(defun dino-y-or-n-signe-p (prompt)
  (let ((temp query-replace-map))
    (unwind-protect
	(progn
	  (setq query-replace-map 
		(if dino-default-signe dino-y-or-n-p-map-signe
		  dino-y-or-n-p-map-anonyme))
	  (y-or-n-p prompt))
      (setq query-replace-map temp))))


(defun dino-ask-theme (prompt &optional default)
  "demande le nom d'un thme  l'utilisateur"
  (interactive)
  (let ((res 
	 (completing-read prompt  dino-rc2-alist-themes-alire-struct nil t default)))
    (unless (string-equal res "") res)))
      

(defun dino-ask-number (prompt &optional default)
  "lit un nombre, renvoie le nombre ou nil"
  (let ((rep (read-string prompt (if default (number-to-string default)))))
       (unless (string= rep "") (string-to-number rep))))
	   
(defun dino-ask-list-number (prompt default)
  (let ((list ()) rep)
    (setq rep (dino-ask-number prompt default))
    (while rep
      (setq list (cons rep list))
      (setq rep (dino-ask-number prompt)))
    (nreverse list)))
      
(defun dino-ask-list-theme (prompt &optional default)
  (let ((list ()) rep)
    (setq rep (dino-ask-theme prompt (car default)))
    (while rep
      (setq list (cons rep list))
      (setq default (cdr default))
      (setq rep (dino-ask-theme prompt (car default))))
    (nreverse list)))

;;;###autoload
(defun dino-ask-passwd (prompt &optional default)
  "lit le password, directement inspir de ange-ftp-read-passwd du package
ange-ftp.el de Andy Norman (ange@hplb.hpl.hp.com)"
  (let ((pass (if default default ""))
	(c 0)
	(echo-keystrokes 0)
	(cursor-in-echo-area t))
    (while (progn (message "%s%s"
			   prompt
			   (make-string (length pass) ?.))
		  (setq c (read-char))
		  (and (/= c ?\r) (/= c ?\n) (/= c ?\e)))
      (if (= c ?\C-u)
	  (setq pass "")
	(if (and (/= c ?\b) (/= c ?\177))
	    (setq pass (concat pass (char-to-string c)))
	  (if (> (length pass) 0)
	      (setq pass (substring pass 0 -1))))))
    (message "")
    (message nil)
    pass))

(defun dino-set-alist (alist key val)
  (let* ((list  (cons () alist))
	 (deb list)
	 (pas-finis 't))
    (while pas-finis
      (cond ((null (cdr list))
	     (setcdr list (cons (cons key val) ()))
	     (setq pas-finis ()))
	    ((equal (car (car (cdr list))) key)
	     (setcdr (car ( cdr list)) val)
	     (setq pas-finis ()))
	    ((dino-string< key (car (car (cdr list))))
	     (setcdr list (cons (cons key val) (cdr list)))
	     (setq pas-finis ())))
      (setq list (cdr list)))
    (cdr deb)))

(defun dino-get-alist (alist key)
  (let ((list alist)
	(pas-finis 't)
	result)
    (while pas-finis
      (cond ((or (null list)
		 (dino-string< key (car (car list))))
	     (setq pas-finis ()))
	    ((string= key (car (car list)))
	     (setq pas-finis ())
	     (setq result (car list)))
	    ('t (setq list (cdr list)))))
    result))

(defun dino-rotate-list (list)
  (let ((fst (car list)) (rest (cdr list)) (li list))
    (while rest
      (setcar li (car rest))
      (setq li (cdr li))
      (setq rest (cdr rest)))
    (setcar li fst))
  list)

(defun dino-string< (st1 st2)
  (let ((ust1 (upcase st1))
	(ust2 (upcase st2)))
    (if (string= ust1 ust2)
	(string< st1 st2)
      (string< ust1 ust2))))

(provide 'dino-general)

