;	$Id: dino-gestion.el,v 1.42 2004/03/03 12:48:37 vanicat Exp $
;;; dino-gestion.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; gestion du .dinorc .dinorc2
;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

(require 'dino-general)
(require 'dino-autoload)
(require 'dino-dinorc2)
(require 'dino-dinorc-serveur)
(require 'dino-msg-gestion)
(require 'dino-cnx)

(defvar dino-gestion-load-hook ())
(defvar dino-save-dinorc-hook ())
(defvar dino-sauve-lit-vieux-dino ())
(defvar dino-sauve-lit-dino2 ())
(defcustom dino-sauve-lit-vieux-dino-jamais ()
  "*non nil : le .dinorc ne doit jamais tre lu ou ecrit"
  :group 'dino
  :type 'boolean)
(defcustom dino-sauve-lit-dino2-jamais ()
  "*non nil : le .dinorc2 ne doit jamais tre lu ou ecrit"
  :group 'dino
  :type 'boolean)

(defcustom dino-dinorc "~/.dinorc"
  "*le dinorc"
  :group 'dino
  :type 'file)
(defcustom dino-dinorc2 "~/.dinorc2"
  "*le dinorc2"
  :group 'dino
  :type 'file)

;(defvar dino-dinorc-buffer ()
;  "le buffer contenant le dinorc")

(defvar dino-dinorc2-buffer ()
  "le buffer contenant le dinorc")


;(defvar dino-list-themes-abonne ()
;  "liste des thmes o on est abonn")

;(defvar dino-message-liste
;  ()
;  "liste des message chacun sous la forme
;(NUM DATE AUTH SUJET LIST_DES_THEMS LIST_DES_REPLY LIST_DES_CENSURE SIGNER 
; EFFA) ")


(defvar dino-dinorc-map ()
  "*Un map pour le sauvergarde et la lecture du dinorc")

(defvar dino-dinorc-easy-menu (list "dinorc"
				    ["sauve" dino-va-sauve-vieux-dinorc t]
				    ["lit" dino-lit-vieux-dinorc t]
				    ["detruit" dino-detruit-vieux-dinorc t])
  "*Un menu pour le sauvergarde et la lecture du dinorc")

(unless dino-dinorc-map
  (setq dino-dinorc-map (make-sparse-keymap "dinorc"))
  (suppress-keymap dino-dinorc-map)
  (define-key dino-dinorc-map [save] (cons "sauve" 'dino-va-sauve-vieux-dinorc))
  (define-key dino-dinorc-map [read] (cons "lit" 'dino-lit-vieux-dinorc))
  (define-key dino-dinorc-map [delete] (cons "detruit" 'dino-detruit-vieux-dinorc)))

(defvar dino-dinorc2-map ()
  "*Un map pour le sauvergarde et la lecture du dinorc2")


(defvar dino-dinorc2-easy-menu (list "dinorc2"
				     ["sauve" dino-va-sauve-dinorc2 t]
				     ["lit" dino-lit-dinorc2 t]
				     ["detruit" dino-detruit-dinorc2 t])
  "*Un menu pour le sauvergarde et la lecture du dinorc2")

(unless dino-dinorc2-map
  (setq dino-dinorc2-map (make-sparse-keymap "dinorc2"))
  (suppress-keymap dino-dinorc2-map)
  (define-key dino-dinorc2-map [save] (cons "sauve" 'dino-va-sauve-dinorc2))
  (define-key dino-dinorc2-map [read] (cons "lit" 'dino-lit-dinorc2))
  (define-key dino-dinorc2-map [delete] (cons "detruit" 'dino-detruit-dinorc2)))
;; gestion du dinorc

(defun dino-lit-dinorc ()
  "lit les dinorc"
    (save-excursion
      (if (and (not dino-sauve-lit-dino2-jamais)
	       (file-readable-p dino-dinorc2)
	       (file-writable-p dino-dinorc2))
	  (dino-lit-dinorc2)
	(setq dino-sauve-lit-dino2 ()))
      (if (and (not dino-sauve-lit-vieux-dino-jamais)
	       (file-readable-p dino-dinorc)
	       (file-writable-p dino-dinorc))
	  (dino-lit-vieux-dinorc)
	(setq dino-sauve-lit-vieux-dino ()))
      (cond 
       ((or dino-sauve-lit-vieux-dino
	    dino-sauve-lit-dino2))
       ((and (not dino-sauve-lit-vieux-dino-jamais)
	     (file-writable-p dino-dinorc)
	     (not (file-exists-p dino-dinorc)))
	(setq dino-sauve-lit-vieux-dino 't))
       ((and (not dino-sauve-lit-dino2-jamais)
	     (file-writable-p dino-dinorc2)
	     (not (file-exists-p dino-dinorc)))
	(setq dino-sauve-lit-dino2 't))
       ((and dino-sauve-lit-dino2-jamais
	     dino-sauve-lit-vieux-dino-jamais)
	(error "J'ai besoin d'avoir le droit de manipuler le .dinorc ou le .dinorc2"))
       (t 
	(error "je ne peux acceder aux dinorc vrifier les permissions")))))


(defun dino-lit-vieux-dinorc ()
  "lit le .dinorc"
  (interactive)
  (setq dino-sauve-lit-vieux-dino 't)
  (let (buffer modifie)
    (setq modifie dino-rc2-modifie)
    (setq buffer (generate-new-buffer " *dino-read-dinorc*"))
    (set-buffer buffer)
    (insert-file-contents dino-dinorc)
    (dino-read-old-dinorc)
    (setq dino-rc2-modifie modifie)
    (kill-buffer buffer)))

(defun dino-lit-dinorc2 ()
  "lit le .dinorc2"
  (interactive)
  (setq dino-sauve-lit-dino2 't)
  (let (buffer modifie)
    (setq modifie dino-rc2-modifie)
    (setq buffer (generate-new-buffer " *dino-read-dinorc*"))
    (set-buffer buffer)
    (insert-file-contents dino-dinorc2)
    (dino-read-dinorc2)
    (setq dino-rc2-modifie modifie)
    (kill-buffer buffer)))

;;;###autoload
(defun dino-save-dinorc ()
  "pour le sauver, ce dinorc"
  (interactive)
  (when dino-rc2-modifie 
    (save-excursion
      (setq dino-rc-serv-modified 't)
      (when dino-sauve-lit-dino2
	(dino-save-dinorc2)
	(setq dino-rc2-modifie ()))
      (when dino-sauve-lit-vieux-dino
	(dino-save-vieux-dinorc)
	(setq dino-rc2-modifie ()))
      (when dino-rc2-modifie
	(error "aucun des deux dinorc n'a t sauver, il y a un problme"))
      (run-hooks 'dino-save-dinorc-hook))))

(defun dino-save-vieux-dinorc ()
  (find-file dino-dinorc)
  (erase-buffer)
  (dino-rc2-insert-old-dinorc)
  (save-buffer)
  (kill-buffer (current-buffer)))

(defun dino-save-dinorc2 ()
  (find-file dino-dinorc2)
  (erase-buffer)
  (dino-rc2-insert-dinorc2)
  (save-buffer)
  (kill-buffer (current-buffer)))

(defun dino-va-sauve-dinorc2 ()
  (interactive)
  (save-excursion
    (setq dino-sauve-lit-dino2 't)
    (dino-save-dinorc2)))

(defun dino-detruit-dinorc2 ()
  (interactive)
  (unless dino-sauve-lit-vieux-dino
    (error "doit utiliser au moins un des deux dinorc local"))
  (setq dino-sauve-lit-dino2 ())
  (when (file-exists-p dino-dinorc2)
    (delete-file dino-dinorc2)))

(defun dino-va-sauve-vieux-dinorc ()
  (interactive)
  (save-excursion
    (setq dino-sauve-lit-vieux-dino 't)
    (dino-save-vieux-dinorc)))

(defun dino-detruit-vieux-dinorc ()
  (interactive)
  (unless dino-sauve-lit-dino2
    (error "doit utiliser au moins un des deux dinorc local"))
  (setq dino-sauve-lit-vieux-dino ())
  (when (file-exists-p dino-dinorc)
    (delete-file dino-dinorc)))

(defun dino-save-all ()
  "sauve (si ncessaire) les dinorc (y compris sur le serveur)"
  (interactive)
  (dino-save-dinorc)
  (dino-rc-serv-save-dinorc-maybe))

;;pour marquer tous les messages lus

(defun dino-marque-lu (them &optional tous)
  "marque tous les messages du thme them comme lus"
  (interactive (let ((theme (dino-ask-theme "Theme  : ")))
		 (if (y-or-n-p (concat "marquer tous les messages de " 
				       theme " comme lus ? "))
		     (list theme 
			   (y-or-n-p "marquer tous les messages dans tous les thmes comme lus ? "))
		   '(() ()))))
;  (dino-raptor-marque-lu them tous)
  (cond (tous
	 (mapcar (lambda (x)
		   (dino-rc2-add-read-block x 1
					    (cdr 
					     (assoc (car x) dino-max-themes)))
		   (dino-efface-them-non-lu (car x)))
		 dino-rc2-alist-themes-alire-struct))
	(them
	 (let ((struct (dino-rc2-get-alire them)))
	   (dino-rc2-add-read-block struct 1 (cadr struct))
	   (dino-efface-them-non-lu them)))))
      
  
;;;;
;;;;   abonnement dsabonnement
;;;;   

(defun dino-abonne (them) 
  "pour s'abonner  un thme" 
  (interactive (list (dino-ask-theme "Thme  : ")))
  (dino-rc2-set-abonne (dino-rc2-get-alire them) 't))

(defun dino-desabonne (them) 
  "pour se dsabonner  un thme" 
  (interactive (list (dino-ask-theme "Thme  : ")))
  (dino-rc2-set-abonne (dino-rc2-get-alire them) ()))
	    
;;;###autoload
(defun dino-lit-nbmsg ()
  "pour mettre  jour nbmsg"
  (interactive)
  (dino-reconnect)
  (dino-send-command-unireponse "nbmsg\n" 
				() 
				(function dino-accept-nbmsg)))

(defun dino-accept-nbmsg (arg1 chaine)
  "pour mettre  jour nbmsg, traite de la reception du message"
  (if (string-match "Ok/1: \\([0-9]*\\)\n" chaine)
      (setq dino-nbmsg 
	    (string-to-int (substring chaine (match-beginning 1) 
				      (match-end 1))))
    (dino-ecrit-recut arg1 chaine)))

(defun dino-lit-is-new-message ()
  "pour servir de xboeuf"
  (let ((nbmsg dino-nbmsg))
    (dino-lit-nbmsg)
    (dino-coordonne-apply 'dino-accept-is-new-message nbmsg)))

(defun dino-accept-is-new-message (nbmsg)
  (when (< nbmsg dino-nbmsg)
    (dino-lit-themes)
    (beep)))

(defun dino-lance-check-message ()
  (interactive)
  (setq dino-check-message
	(run-at-time "1 min" 't 'dino-lit-is-new-message)))

;; la censure, pas forcement le meuilleur endroit pour le mettre, mains bon

(defun dino-censure-message (message theme)
  "censure un message, les verifications sont laisses au serveur"
  (interactive (list (dino-ask-number "Numro du message : ")
		     (dino-ask-theme  "Thme o censurer : ")))
  (dino-send-command-unireponse (concat "censure "
					(number-to-string message)
					" "
					theme
					"\n")
				dino-connection
				(function dino-ecrit-recut)))
		
   
(defun dino-libere-message (message theme)
  "libre un message, les verifications sont laisses au serveur"
  (interactive (list (dino-ask-number "Numro du message : ")
		     (dino-ask-theme  "Thme o librer : ")))
  (dino-send-command-unireponse (concat "libre "
					(number-to-string message)
					" "
					theme
					"\n")
				dino-connection
				(function dino-ecrit-recut)))

(provide 'dino-gestion)   

(run-hooks 'dino-gestion-load-hook)


