;	$Id: dino-list-mode.el,v 1.37 2004/03/03 12:35:17 vanicat Exp $
;;; dino-list-mode.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; dino-list-mode (liste des thmes)
;;;
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

(require 'dino-autoload)
(require 'dino-general)
(require 'dino-dinorc2)
(require 'dino-dinorc-serveur)
(require 'dino-gestion)
(require 'dino-overlay)

(defvar dino-list-theme-buffer-name "*liste-dino*"
  "nom du buffer pour la liste des thmes")

(defcustom dino-list-non-lu-face 'bold
  "*face des thmes o il y a des messages non lus"
  :type 'face
  :group 'dino)

(defcustom dino-list-lu-face 'default
  "*face des thmes o il n'y a pas de message non lu"
  :type 'face
  :group 'dino)

(defcustom dino-taille-themes 19
  "*taille suppose des thmes"
  :type 'integer
  :group 'dino)

(defvar dino-taille-colonne 19
  "taille des colonnes 
recalcul rgulirement  partir de dino-taille-themes")

(defvar dino-list-nbcol 2
  "nombre de colonnes dans la liste
recalcul rgulirement  partir de dino-taille-themes")

(defvar dino-last-column (* dino-taille-themes dino-list-nbcol)
  "dernire colonne de la liste")

(defvar dino-list-mode-hook ()
  "*Un hook pour le list-mode de dino")

(defvar dino-list-mode-map ()
  "*Un map pour le list-mode de dino")

(defvar dino-list-mode-syntax-table ()
  "La table de syntaxe pour le list mode")

(defvar dino-list-overlay-alist ())

(put 'dino-list-mode 'mode-class 'special)

(defun dino-get-list-buffer ()
  (let ((buff (get-buffer dino-list-theme-buffer-name)))
    (if buff buff
      (let ((old-buffer (current-buffer)))
	(unwind-protect
	    (progn
	      (setq buff (get-buffer-create dino-list-theme-buffer-name))
	      (set-buffer buff)
	      (dino-list-mode)
	      buff)
	  (set-buffer old-buffer))))))

;;;###autoload
(defun dino-ecrit-theme-non-lu (them)
  "marque THEM comme non lu"
  (let ((overlay (cdr (assoc them dino-list-overlay-alist))))
    (when overlay
      (dino-overlay-set-face overlay dino-list-non-lu-face))))


(defun dino-ecrit-themes-non-lu ()
  (interactive)
  (let ((all-struct dino-rc2-alist-themes-alire-struct))
    (while all-struct
      (goto-char 0)
      (when (dino-rc2-first-non-lu (car all-struct))
	(dino-ecrit-theme-non-lu (caar all-struct)))
      (setq all-struct (cdr all-struct)))))
    

;;;###autoload
(defun dino-efface-them-non-lu (them)
  (let ((overlay (cdr (assoc them dino-list-overlay-alist))))
    (when overlay
      (dino-overlay-set-face overlay dino-list-lu-face))))


;; list de theme
(defun dino-calc-nb-column ()
  "recalcule le nombre de colonnes de la liste"
  (setq dino-list-nbcol (max (/ (window-width) dino-taille-themes)
			     1))
  (setq dino-taille-colonne (/ (window-width) dino-list-nbcol))
  (setq dino-last-column (* dino-list-nbcol dino-taille-colonne)))

(unless dino-list-mode-map
  (setq dino-list-mode-map (make-keymap))
  (suppress-keymap dino-list-mode-map)
  (define-key dino-list-mode-map "s" 'dino-save-all)
  (define-key dino-list-mode-map "n" 'dino-next-non-lu)
  (define-key dino-list-mode-map "N" 'dino-next-non-lu-tous)
  (define-key dino-list-mode-map " " 'dino-next-non-lu)
  (define-key dino-list-mode-map "\C-i" 'dino-next-non-lu)
  (define-key dino-list-mode-map "g" 'dino-goto-theme)
  (define-key dino-list-mode-map "\C-m" 'dino-list-goto-theme)
  (define-key dino-list-mode-map "c" 'dino-connect)
  (define-key dino-list-mode-map "z" 'dino-list-marque-lu)
  (define-key dino-list-mode-map "m" 'dino-poste)
  (define-key dino-list-mode-map "l" 'dino-lit-themes)
  (define-key dino-list-mode-map "L" 'dino-lit-themes-tous)
  (define-key dino-list-mode-map "e" 'dino-lit-entetes)
  (define-key dino-list-mode-map "a" 'dino-abonne)
  (define-key dino-list-mode-map "d" 'dino-desabonne)
  (define-key dino-list-mode-map "v" 'dino-lit-message)
  (define-key dino-list-mode-map "q" 'dino-quit)
  (define-key dino-list-mode-map ":" 'dino-send-command)
  (define-key dino-list-mode-map "v" 'dino-lit-message)
;; Raccourcis pour la pile
  (define-key dino-list-mode-map "P" 'dino-pile-show)
  (define-key dino-list-mode-map ")" 'dino-pile-pop)

;; Barre de menu

  (define-key dino-list-mode-map [mouse-2]
        (cons "Lit thme" 'dino-list-mouse-goto-theme))

)

(defun dino-list-add-menu ()
  (easy-menu-define dino-list-mode-menu (list dino-list-mode-map) ""
    (list "dino" 
	  ["Va dans le thme" dino-goto-theme t]
	  
	  ["Prochain non lu" dino-next-non-lu t]
	  ["Relit la liste" dino-lit-themes t]
	  ["Poste" dino-poste t]
	  ["Marquer lu" dino-marque-lu t]
	  
	  dino-rc-serv-easy-menu
	  dino-dinorc2-easy-menu
	  dino-dinorc-easy-menu 
	  
	  ["Reconnexion" dino-connect t]
	  
	  ["Quitter" dino-quit t]
	  
	  ["Pile" dino-pile-show t]
	  ["Dsempile" dino-pile-pop t]
	  
	  ["aide" describe-mode t])))

(setq dino-list-mode-syntax-table (make-syntax-table))
(modify-syntax-entry ?? "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?! "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?, "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?. "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?: "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?\; "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?- "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?_ "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?+ "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?= "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?* "w" dino-list-mode-syntax-table)
(modify-syntax-entry ?/ "w" dino-list-mode-syntax-table)

(defun dino-list-mode ()
  "mode pour la liste de dino

\\{dino-list-mode-map}"

  (interactive)
  (kill-all-local-variables)
  (cond ((listp (default-value 'mode-line-format))
	 (setq mode-line-format
	       (list*
		"--"
;		'(dino-lit-raptorp "*" "")
;		'(dino-theme-non-lu "m" "")
		'(dino-rc2-modifie
		  "*" 
		  (dino-rc-serv-type 
		   (dino-rc-serv-modified "*" "")
		   ""))
		'(dino-non-lu-struct "m" "")
		'(dino-waiting-server "w" "")
		"- " (cdr (default-value 'mode-line-format))))))
  (setq major-mode 'dino-list-mode)
  (setq mode-name "list")
  (make-local-variable 'minor-mode-alist)
  (use-local-map dino-list-mode-map)
  (buffer-disable-undo (current-buffer))
  (setq truncate-lines t)
  (setq buffer-read-only t)
  (set-buffer-modified-p ())
  (set-syntax-table dino-list-mode-syntax-table)
  (dino-list-add-menu)
  (easy-menu-add dino-list-mode-menu)
  (run-hooks 'dino-list-mode-hook))
  
(defun dino-list-goto-theme ()
  (interactive)
  (let ((them (save-excursion 
	   (set-buffer dino-list-theme-buffer-name)
;	   (let ((beg (progn
;			(if (>= (current-column) (/ (window-width) 2))
;			    (move-to-column (/ (window-width) 2))
;			  (beginning-of-line))
;			(1+ (point))))
;		 (end (progn (forward-word 1) (point))))
;	     (buffer-substring beg end)))))
	   (get-text-property (point) 'dino-theme))))
    (set-text-properties 0 (length them) () them)
    (dino-goto-theme them)))

(defun dino-list-mouse-goto-theme (e)
  (interactive "e")
  (mouse-set-point e)
  (dino-list-goto-theme))

(defun dino-list-marque-lu (them &optional tous)
  "marquer les messages du thme sous le curseur comme lus
ventuellement de tous les thmes"
  (interactive (let ((them (get-text-property (point) 'dino-theme)))
		 (if (y-or-n-p (concat "marquer tous les messages de " 
				       them " comme lus ? "))
		     (list them
			   (y-or-n-p "marquer tous les messages dans tous les thmes comme lus ?"))
		   '(() ()))))
  (dino-marque-lu them tous))


(defun dino-lit-themes-internal (tousp)
  "liste la liste des thmes o on est abonn si tousp est nil,
tous sinon"
  (dino-reconnect)
  (dino-calc-nb-column)
  (dino-lit-nbmsg)
  (dino-ecrit-list tousp)

;  (dino-send-command-multireponse "liste\n" tousp
;				  (function dino-accept-themes))
  (switch-to-buffer (dino-get-list-buffer))


  (sleep-for 1)
  (accept-process-output)
  (message ""))

;;;###autoload
(defun dino-lit-themes ()
  "demande la liste des thmes"
  (interactive)
  (dino-read-unread ())
  (dino-lit-themes-internal ())
  (dino-ecrit-themes-non-lu))

(defun dino-lit-themes-tous ()
  "demande la liste des thmes"
  (interactive)
  (dino-read-unread 't)
  (dino-lit-themes-internal 't))

(defun dino-ecrit-list (tousp)
  "ecriture et mise  jour des variables, pour la liste des thmes"
  (let ((structs dino-rc2-alist-themes-alire-struct) (i 0)
	cur-struct deb fin them overlay)
    (save-excursion
      (set-buffer (dino-get-list-buffer))
      (setq buffer-read-only ())
      (setq dino-alist-themes ())
      (setq dino-list-overlay-alist ())
      (erase-buffer)
      (while structs
	(setq cur-struct (car structs))
	(setq them (car cur-struct))
	(if (or tousp
		(dino-rc2-get-abone cur-struct))
	    (progn
	      (insert " ")
	      (setq deb (point))
	      (insert them)
	      (setq fin (point))
	      (if (> (- dino-last-column (current-column))
		     dino-taille-colonne)
		  (move-to-column (* (1+ (/ (current-column) 
					    dino-taille-colonne))
				     dino-taille-colonne)
				  't)
		(end-of-line)
		(insert "\n"))
	      (setq fin (1- (point)))
	      (setq overlay (dino-overlay-make-overlay deb fin))
	      (setq dino-list-overlay-alist
		    (cons (cons them overlay) dino-list-overlay-alist))
	      (dino-overlay-set-mouse-face overlay 'highlight)
	      (dino-overlay-set-face overlay dino-list-lu-face)
	      (put-text-property deb fin 'dino-theme (car cur-struct))))
	(setq dino-alist-themes (cons (cons (car cur-struct) i)
				      dino-alist-themes))
	(setq i (1+ i))
	(setq structs (cdr structs)))
      (setq buffer-read-only t)
      (set-buffer-modified-p ()))))
	
(provide 'dino-list-mode)

(run-hooks 'dino-list-mode-hook)

