;	$Id: dino-map.el,v 1.5 2002/05/21 11:49:04 vanicat Exp $

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; ici, une map construit sur les avls elib
;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; ou /home/rvanicat/lang/elisp doit etre remplacer par le repertoire
;;; ou ce trouve ce fichier dans son .emacs

;;; TODO : bug-fixe
;;; Bugs List: 
;;;   pb en cas d'insertion d'un message contenant un message a mon format
;;;   Il s'auterai des messages ??

(require 'avltree)

(defun dino-map-compare (arg1 arg2)
  "compare ARG1 to ARG2"
  (dino-string< (car arg1) (car arg2)))

(defun dino-map-create ()
  "create a dino-map"
  (avltree-create (function dino-map-compare)))

(defun dino-map-enter (map key value)
  "add the binding key-value to the dino-map"
  (avltree-enter map (cons key value)))

(defun dino-map-value (map key)
  (avltree-member map (cons key ())))

(defun dino-map-map (map map-function)
  (avltree-map map (lambda (arg) (apply map-function (car arg) (cdr arg)))))

(defun dino-map-first (map)
  (avltree-first map))

(defun dino-map-last (map)
  (avltree-last map))

(defun dino-map-copy (map)
  (avltree-copy map))

(defun dino-map-flatten (map)
  (avltree-flatten map))

(defun dino-map-size (map)
  (avltree-size map))
  