;	$Id: dino-msg-gestion.el,v 1.10 2004/03/03 12:35:17 vanicat Exp $
;;; dino-msg-gestion.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; nouvelle gestion des messages suivants et nombres de messages
;;; 

(require 'dino-autoload)
(require 'dino-dinorc2)
(require 'dino-general)


(defvar dino-theme-struct ())
(defvar dino-non-lu-struct ()
  "struct des themes o il y a des messages non lu")
(defvar dino-peut-etre-non-lu-struct ()
  "struct des themes o il y a des messages non lu")
;(defvar dino-themes-msgs-non-lu ())
(defvar dino-fin-theme ()
  "true si dernier message etait a la fin d'un theme")
(defvar dino-fin-all ()
  "true si dernier message etait a la fin de tout")

(defvar dino-msg-gestion-read-ahead 100
  "nombre maximum de message remarqu comme etant non lu pour chaque theme")

(defvar dino-max-themes ()
  "attention, le nom de cette variable est mal choisi...")
(defvar dino-msg-gestion-lazy ()
  "*non nil diminue les echanges reseaux")

(defun dino-read-unread (tousp)
  "demande au serveur les messages non lus"
  (interactive)
  (dino-reconnect)
  ;; on demande le max de chaque theme
  (dino-send-command-multireponse "derniers\n" tousp
				  (function dino-read-unread-accept)))

(defun dino-read-unread-accept (tousp str)
  "lecture du max de chaque theme
lecture ventuelle des numros de message non lu"
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut () str)
    ;; pas d'erreur : on construit la alist theme/max renvoyer par le serveur
    (let ((max-themes (dino-read-max str))
	  (pointer dino-rc2-alist-themes-alire-struct)
	  this-max theme pointer-theme)
      (setq dino-max-themes max-themes)
      (while max-themes
	(setq this-max (cdar max-themes))
	(setq theme (caar max-themes))
	(setq pointer-theme (caar pointer))
	(cond
	 ;; tiens, un nouveaux theme, on l'ajoute
	 ((or (null pointer)
	      (dino-string< theme pointer-theme))
	  (dino-read-unread-theme (dino-rc2-get-alire theme)
				  this-max)
	  (setq max-themes (cdr max-themes)))
	 ;; on connaissais dj ce theme, on met a jour le max
	 ((string= theme pointer-theme)
	  ;; met a jour le max et ventuellement lit les numro
	  ;; des messages nouveaux
	  (when (or tousp
		  (dino-rc2-get-abone (car pointer)))
	    (dino-read-unread-theme (car pointer) this-max))
	  (setq max-themes (cdr max-themes))
	  (setq pointer (cdr pointer)))
	 ('t
	  (message "Tiens, le serveur ne connais pas le thme %s" theme)
	  (setq pointer (cdr pointer))))))))

(defun dino-read-max (str)
  "construit a partir du rsultat de la commande derniers une alist
theme/max"
  (let ((buffer (generate-new-buffer "*dino-read-max-traite*"))
	(old-buffer (current-buffer))
	result)
    (unwind-protect
	(progn
	  (set-buffer buffer)
	  (erase-buffer)
	  (insert str)
	  (goto-char 0)
	  (re-search-forward "Ok/n:.*\n" nil t)
	  (while (re-search-forward "|\\(.*\\) : \\([0-9]*\\)\n" nil t)
	    (setq result (cons (cons (match-string 1)
				     (string-to-int (match-string 2)))
			       result))))
      (kill-buffer buffer)
      (set-buffer old-buffer))
    (sort result (lambda (x y) (dino-string< (car x) (car y))))))

(defun dino-read-unread-theme (struct max)
  "met a jour le max, et lit ventuellement la liste des messages non lu"
  (if (< (cadr struct) max)
      ;; du nouveaux
      (dino-read-unread-theme-no-max struct)
    ;; tout n'etait peut-tre pas lu
    (dino-set-non-lu-maybe struct)))
	

(defun dino-read-unread-theme-no-max (struct)
  "regarde les ventuelles dino-msg-gestion-read-ahead messages suivants"
  (dino-reconnect)
  (dino-send-command-multireponse 
	 (format "suivants %d %s %d\n"
		 (cadr struct)
		 (car struct)
		 dino-msg-gestion-read-ahead)
	 struct
	 (function dino-read-unread-theme-accept)))

(defun dino-read-unread-theme-accept (struct str)
  "regarde les ventuelles 100 messages suivants
lecture de la rponse du serveur"
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut () str)
    (let ((buffer (generate-new-buffer "*dino-read-unread-theme-accept*"))
	  (old-buf (current-buffer))
	  result)
      (unwind-protect
	  (progn
	    (set-buffer buffer)
	    (insert str)
	    (goto-char 0)
	    (re-search-forward "Ok/n:.*\n" nil t)
	    (while (re-search-forward "| \\([0-9]*\\)\n" nil t)
	      (setq result (cons (string-to-int (match-string 1))
				 result)))
	    (setq result (sort result (function <)))
	    (when result
	      (dino-rc2-add-non-lu struct result))
	    (dino-set-non-lu-maybe struct))
	(set-buffer old-buf)
	(kill-buffer buffer)))))

(defun dino-set-non-lu-maybe (struct)
  "verifie s'il n'y a pas de nouveaux messages non lu"
  (let ((non-lu (dino-rc2-first-non-lu struct)))
    (if non-lu
	(progn
	  (dino-ecrit-theme-non-lu (car struct))
	  (if (and struct
		   (not (memq struct dino-non-lu-struct)))
	      (setq dino-non-lu-struct
		    (nconc dino-non-lu-struct
			   (list struct)))))
      (dino-efface-them-non-lu (car struct))
      (setq dino-non-lu-struct (delq struct dino-non-lu-struct)))))

(defun dino-next-msg-in-thems ()
  (if dino-msg-gestion-lazy
      (dino-rc2-first-non-lu dino-theme-struct)
    (let ((non-lu (dino-rc2-all-non-lu dino-theme-struct)))
      (when (= (length non-lu) 1)
	(dino-read-unread-theme-no-max dino-theme-struct))
      (car non-lu))))

(defun dino-next-struct-theme (tousp)
  (while (and dino-non-lu-struct
	      (or (null (dino-rc2-first-non-lu (car dino-non-lu-struct)))
		  (and (not tousp)
		       (not (dino-rc2-get-abone (car dino-non-lu-struct))))))
    (setq dino-non-lu-struct (cdr dino-non-lu-struct)))
  (let ((struct (car dino-non-lu-struct)))
    (if (and dino-msg-gestion-lazy
	     struct)
	(setq dino-non-lu-struct (nconc (cdr dino-non-lu-struct)
					(list struct)))
      (setq dino-non-lu-struct (cdr dino-non-lu-struct)))
    ;; ici, pe lancer la verification de nouveaux messages ds le nouveaux
    ;; theme					
    (when (or (null dino-non-lu-struct)
	      (and (null (cdr dino-non-lu-struct))
		   (not dino-msg-gestion-lazy)))
      (dino-read-unread tousp))
    (when struct
      (setq dino-fin-all ()))
    struct))
    
(defun dino-next-msg-non-lu (tousp)
  (if dino-theme-struct 
      ;;; dino-theme-struct dj initialis
      (let ((next (dino-next-msg-in-thems)))
	;; il y a t il un message non lu dans le theme courant ?
	(if (and (null next) (not dino-fin-theme))
	    ;; non : on est a la fin du theme
	    (progn
;;;	  (dino-insert-simple-message "fin du thme")
	      (dino-efface-them-non-lu dino-theme-courant)
	      (setq dino-fin-theme 't)
	      (dino-save-dinorc)
	      'fin-theme)
	  (if (null next)
	      ;; pas de message ds le theme courant, et on etait dj a la fin)
	      (dino-next-msg-autre-theme tousp)
	    next)))
;;;	(dino-lit-message-internal next)
    ;; pas de dino-theme-struct
    (dino-next-msg-autre-theme tousp)))

(defun dino-next-msg-autre-theme (tousp)
  (let (theme)
    (setq theme (dino-next-struct-theme tousp))
    (if theme
	(progn
	  (setq dino-fin-all ())
	  (setq dino-fin-theme ())
	  (setq dino-theme-courant (car theme))
	  (setq dino-theme-struct theme)
	  (dino-next-msg-non-lu tousp))
      (dino-save-dinorc)
      (setq dino-fin-all 't)
      'fin-all)))

(defun dino-message-lu (struct msg)
  (dino-rc2-add-read-block struct msg msg)
  (when (null (dino-rc2-first-non-lu struct))
    (setq dino-non-lu-struct (delq struct dino-non-lu-struct))
    (dino-efface-them-non-lu (car struct))))
  

(defun dino-set-theme (theme)
  (setq dino-theme-courant theme)
  (setq dino-theme-struct (dino-rc2-get-alire theme)))


(provide 'dino-msg-gestion)
