;	$Id: dino-msg-mode.el,v 1.52 2004/03/03 12:35:18 vanicat Exp $
;;; dino-msg-mode.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; ce fichier concerne le mode de lecture des messages
;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

(require 'cl)
(require 'dino-general)
(require 'dino-autoload)
(require 'dino-dinorc-serveur)
(require 'dino-gestion)
(require 'browse-url)
(require 'dino-msg-gestion)
(require 'dino-filtre)

(defvar dino-msg-mode-load-hook ())

(defvar dino-msg-buffer-name "*msg-dino*"
  "nom du buffer pour la liste des thme")

(defvar dino-msg-mode-hook ()
  "*Un hook pour le msg-mode de dino")

(defvar dino-msg-mode-map ()
  "*Un map pour le msg-mode de dino")

(defvar dino-fin-du-header
  "-Fin du Header, debut du message\n"
  "*pour marquer le dbut d'un msg")

(defvar dino-message-courant ()
  "le message courant de ce buffer sous la forme 
(NUM DATE AUTH SUJET LIST_DES_THEMS LIST_DES_REPLY LIST_DES_CENSURE SIGNER 
EFFA LIST_DESLIGNE_DU_MESSAGE) ")

(defvar dino-message-rien-de-nouveau "Rien de nouveau"
  "messsage afficher quand il n'y a pas de nouveaux messages")

(defvar dino-message-fin-du-theme "Fin du thme"
  "messsage afficher quand on et  la fin du thmes")

(make-variable-buffer-local 'dino-message-courant)
(defvar dino-numero-message-courant 0)
(make-variable-buffer-local 'dino-numero-message-courant)
(defvar dino-numero-message-precedant 0)
(make-variable-buffer-local 'dino-numero-message-precedant)
(defvar dino-dernier-message ())
;;;###autoload
(defvar dino-theme-courant ())
(defvar dino-themes-courants ())
(make-variable-buffer-local 'dino-themes-courants)

(defvar dino-split-window-size 8
  "taille des fentres du haut aprs un split pour les modes entte et pile")

(defvar dino-alire-courant-st 0)

;(defun dino-browse-url-at-point ()
;  "Ask a WWW browser to load the URL at or before point.
;Doesn't let you edit the URL like `browse-url'.  Variable
;`browse-url-browser-function' says which browser to use."
;  (interactive)
;  (if browse-url-new-window-p
;      (browse-url (browse-url-url-at-point) 't)
;    (browse-url (browse-url-url-at-point))))

(defalias 'dino-browse-url-at-point 'browse-url-at-point)

(put 'dino-msg-mode 'mode-class 'special)

(defun dino-msg-marque-lu (them &optional tous)
  (interactive (if (y-or-n-p (concat "marquer tous les messages de " 
				     dino-theme-courant " comme lu ? "))
		   (list dino-theme-courant 
			 (y-or-n-p "marquer tous les messages dans tous les thmes comme lus ?"))
		 '(() ())))
  (dino-marque-lu them tous))
  

;;;
;;; dino-msg-mode
;;;

(unless dino-msg-mode-map
  (setq dino-msg-mode-map (make-keymap))
  (suppress-keymap dino-msg-mode-map)
  (define-key dino-msg-mode-map "w" 'dino-fill-msg)
  (define-key dino-msg-mode-map "s" 'dino-save-all)
  (define-key dino-msg-mode-map "f" 'dino-force-ecrit-message)
  (define-key dino-msg-mode-map "n" 'dino-next-non-lu)
  (define-key dino-msg-mode-map "b" 'dino-browse-url-at-point)
  (define-key dino-msg-mode-map "u" 'dino-browse-url-at-point)
  (define-key dino-msg-mode-map "N" 'dino-next-non-lu-tous)
  (define-key dino-msg-mode-map "t" 'dino-next-theme-non-lu)
  (define-key dino-msg-mode-map "\C-i" 'dino-next-non-lu)
  (define-key dino-msg-mode-map "+" 'dino-next-msg)
  (define-key dino-msg-mode-map "g" 'dino-goto-theme)
  (define-key dino-msg-mode-map "a" 'dino-abonne)
  (define-key dino-msg-mode-map "d" 'dino-desabonne)
  (define-key dino-msg-mode-map "p" 'dino-prev)
  (define-key dino-msg-mode-map "-" 'dino-prev-msg)
  (define-key dino-msg-mode-map " " 'scroll-up)
  (define-key dino-msg-mode-map "c" 'dino-connect)
  (define-key dino-msg-mode-map "[" 'dino-prev)
  (define-key dino-msg-mode-map "]" 'dino-next)
  (define-key dino-msg-mode-map "<" 'dino-prev)
  (define-key dino-msg-mode-map ">" 'dino-next)
  (define-key dino-msg-mode-map "v" 'dino-lit-message)
  (define-key dino-msg-mode-map "z" 'dino-msg-marque-lu)
  (define-key dino-msg-mode-map "r" 'dino-reply)
  (define-key dino-msg-mode-map "R" 'dino-reply-include)
  (define-key dino-msg-mode-map "m" 'dino-poste)
  (define-key dino-msg-mode-map "l" 'dino-lit-themes)
  (define-key dino-msg-mode-map "L" 'dino-lit-themes-tous)
  (define-key dino-msg-mode-map "e" 'dino-msg-lit-entetes)
  (define-key dino-msg-mode-map "q" 'dino-quit)
  (define-key dino-msg-mode-map "^" 'dino-lit-parents)
  (define-key dino-msg-mode-map ":" 'dino-send-command)
  (define-key dino-msg-mode-map "k" 'dino-toggle-censure-message-msg)
  (define-key dino-msg-mode-map "\C-_" 'dino-msg-undo)

;; Raccourcis pour la pile
  (define-key dino-msg-mode-map "P" 'dino-pile-show)
  (define-key dino-msg-mode-map "(" 'dino-pile-push)
  (define-key dino-msg-mode-map ")" 'dino-pile-pop)
  
;; Souris : empilement avec bouton du milieu
  (define-key dino-msg-mode-map [mouse-2]  
    (cons "Empile le message courant" 'dino-pile-push)))

;;; Barre de menu

(defun dino-msg-add-menu ()
  (easy-menu-define dino-msg-mode-menu (list dino-msg-mode-map) ""
    (list "dino"
	  ["Poste" dino-poste t]
	  ["Relit la liste" dino-lit-themes t]
	  ["Marquer lu" dino-msg-marque-lu t]
	  ["Reconnexion" dino-connect t]
	  dino-rc-serv-easy-menu
	  dino-dinorc2-easy-menu
	  dino-dinorc-easy-menu 
	  ["Quitter" dino-quit t]
	  ["Va dans le thme" dino-goto-theme t]
	  ["Prochain non lu" dino-next-non-lu t]
	  ["Suivant dans thme" dino-next t]
	  ["Prcdent dans thme" dino-prev t]
	  ["Suivant" dino-next-msg t]
	  ["Prcdent" dino-prev-msg t]
	  ["Empile le message" dino-pile-push t]
	  ["Dsempile" dino-pile-pop t]
	  ["Pile" dino-pile-show t]
	  ["aide" describe-mode t])))


(defun dino-msg-mode ()
  "mode pour lire les messages de dino

\\{dino-msg-mode-map}"

  (interactive)
  (kill-all-local-variables)
  (cond ;((boundp 'mode-line-modified)
	; (setq mode-line-modified "--- "))
	((listp (default-value 'mode-line-format))
	 (setq mode-line-format
	       (list* "--" 
		      'dino-theme-courant
		      "-"
		      'dino-alire-courant-st
		      "-"
;		      '(dino-lit-raptorp "*" "")
		      '(dino-rc2-modifie
			"*" 
			(dino-rc-serv-type 
			 (dino-rc-serv-modified "*" "")
			 ""))
		      '(dino-non-lu-struct "m" "")
		      '(dino-waiting-server "w" "")
		      "-"
		      (cdr (default-value 'mode-line-format))))))
  (setq major-mode 'dino-msg-mode)
  (setq mode-name "message")
  (make-local-variable 'minor-mode-alist)
  (use-local-map dino-msg-mode-map)
  (buffer-disable-undo (current-buffer))
  (dino-msg-add-menu)
  (easy-menu-add dino-msg-mode-menu)
  (setq buffer-read-only t)
  (set-buffer-modified-p ())
  (run-hooks 'dino-msg-mode-hook))

;;;###autoload
(defun dino-get-msg-buffer ()
  (let ((buff (get-buffer dino-msg-buffer-name)))
    (if buff buff
      (let ((old-buffer (current-buffer)))
	(unwind-protect
	    (progn
	      (setq buff (get-buffer-create dino-msg-buffer-name))
	      (set-buffer buff)
	      (dino-msg-mode)
	      buff)
	  (set-buffer old-buffer))))))


(defun dino-msg-lit-entetes (theme from)
  "lit la liste des entte"
  (interactive (list dino-theme-courant
		     (dino-message-get-number dino-message-courant)))
  (dino-lit-entetes theme from))


		  
;; pour lire les messages

;;;###autoload
(defun dino-lit-message (msg)
  "lit un message"
  (interactive "NNumro: ")
  (setq dino-theme-courant ())
  (setq dino-themes-courants ())
  (dino-lit-message-internal msg)
  (switch-to-buffer (dino-get-msg-buffer))
  (sleep-for 1)
  (accept-process-output)
  (message ""))

;;;###autoload
(defun dino-split-windows-et-lit-message (msg)
  "spare la fentre en deux et lit un message
modifier la variable dino-split-window-size pour changer la taille des fentres"
  (let ((msg-buffer (dino-get-msg-buffer)))
    (if (one-window-p 't) (split-window-vertically dino-split-window-size))
    (pop-to-buffer msg-buffer)
    (dino-lit-message msg)))

(defun dino-lit-parents ()
  "Permet de lire les parents de l'article courant"
  ;; j'utilise honteusement une sale hack avec l'history
  ;; mais a marche, que demande le peuple?
  
  ;; Du pain et des jeux ! (merci JYM)
  (interactive)
  (let ((msg
	 (let ((lmsg (dino-message-get-reply dino-message-courant)))
	   (if (null (cdr lmsg))
	       (car lmsg)
	     (let ((lsmsg (mapcar 'number-to-string lmsg)))
	       (let ((alsmg (mapcar (lambda (x) (cons x ())) lsmsg)))
		 (setq dino-ugly-hack-false-history-list
		       lsmsg)
		 (string-to-number
		  (completing-read 
		   "Message : " alsmg () 't (car lsmsg)
		   'dino-ugly-hack-false-history-list))))))))
    (if (numberp msg) (dino-lit-message msg)
      (error "Pas de parents"))))

(defun dino-insert-simple-message (text)
  (let ((old-buffer (current-buffer)))
    (unwind-protect
	(progn
	  (set-buffer (dino-get-msg-buffer))
	  (setq buffer-read-only ())
	  (erase-buffer)
	  (setq dino-message-courant 
		dino-message-erreur)
	  (setq dino-numero-message-precedant dino-numero-message-courant)
	  (insert-char ?\n (1- (/ (window-height) 2)))
	  (move-to-column (- (/ (window-width) 2) 6) 't)
	  (insert text)
	  (setq buffer-read-only t)
	  (set-buffer-modified-p ())
	  (setq dino-themes-courants (list dino-theme-courant))
	  (dino-efface-them-non-lu dino-theme-courant))
      (set-buffer old-buffer))))

(defun dino-lit-message-et-change-buffer (msg &optional rien)
  (switch-to-buffer (dino-get-msg-buffer))
  (dino-lit-message-internal msg rien))

(defun dino-lit-message-internal (msg &optional rien)
  "lit un message"
;  (if (= 0 msg)
;      (let ((old-buffer (current-buffer)))
;	(unwind-protect
;	    (progn
;	      (set-buffer (dino-get-msg-buffer))
;	      (setq buffer-read-only ())
;	      (erase-buffer)
;	      (setq dino-message-courant 
;		    dino-message-erreur)
;	      (setq dino-numero-message-precedant dino-numero-message-courant)
;	      (insert-char ?\n (1- (/ (window-height) 2)))
;	      (move-to-column (- (/ (window-width) 2) 6) 't)
;	      (insert "fin du thme")
;	      (setq buffer-read-only t)
;	      (setq dino-themes-courants (list dino-theme-courant))
;	      (dino-efface-them-non-lu dino-theme-courant))
;	  (set-buffer old-buffer)))
  (setq dino-alire-courant-st 
	(format "%d"
		(length (dino-rc2-all-non-lu dino-theme-struct))))
  (cond 
   ((eq msg 'fin-theme)
    (dino-insert-simple-message dino-message-fin-du-theme))
   ((eq msg 'fin-all)
    (dino-insert-simple-message dino-message-rien-de-nouveau))
   ('t
    (dino-reconnect)
    (dino-send-command-multireponse (concat "msg " (int-to-string msg) "\n")
				    ()
				    (function dino-accept-message)))))

(defun dino-accept-message-internal (proc str)
  "parse le msg (aprs rcption)"
  (let ((buffer (generate-new-buffer "*dino-msg-traite*"))
	result (fin (make-marker))
	numb date auth subj them repl cens sign effa body)
    (save-excursion
      (set-buffer buffer)
      (erase-buffer)
      (insert str)
      (goto-char 0)
      (re-search-forward "Ok/n:.*\n" nil t)
      (replace-match "" nil nil)
      
      (re-search-forward "|NUMB:\\(.*\\)\n")
      (setq numb (string-to-number (match-string 1)))
      
      (if (looking-at "|DATE:\\(.*\\)\n")
	    (setq date (match-string 1))
	(setq date ""))
      
      (re-search-forward "|AUTH:\\(.*\\)\n")
      (setq auth (match-string 1))
      
      (re-search-forward "|SUBJ:\\(.*\\)\n")
      (setq subj (match-string 1))
      
      (re-search-forward "|THEM:\\(.*\\)\n")
      (set-marker fin (point))
      (goto-char (match-beginning 1))
      (while (< (point) fin)
	(re-search-forward "\\([^ \n]*\\)[ \n]*" fin)
	(setq them
	      (cons (buffer-substring (match-beginning 1) (match-end 1)) them)))
      (setq them (nreverse them))

      (when (looking-at "|REPL:\\(.*\\)\n")
	(set-marker fin (match-end 1))
	(goto-char (match-beginning 1))
	(while (< (point) fin)
	  (re-search-forward "\\([^ \n]*\\)[ \n]*" fin)
	  (setq repl
		(cons (string-to-int 
		       (buffer-substring (match-beginning 1) (match-end 1)))
		      repl)))
	(setq repl (nreverse repl)))
					 
      (re-search-forward "|CENS:\\(.*\\)\n")
      (set-marker fin (point))
      (goto-char (match-beginning 1))
      (while (< (point) fin)
	(re-search-forward "\\([^ \n]*\\)[ \n]*" fin)
	(setq cens 
	      (cons (buffer-substring (match-beginning 1) (match-end 1)) cens)))
      (setq cens (nreverse cens))
      
      (when (looking-at "|SIGN:\\(.*\\)\n")
	(setq sign (buffer-substring (match-beginning 1) (match-end 1))))

      (when (looking-at "|EFFA:\\(.*\\)\n")
	(setq effa (buffer-substring (match-beginning 1) (match-end 1))))

      (while (re-search-forward "||\\(.*\\)\n" nil t)
	(setq body (cons (buffer-substring (match-beginning 1) (match-end 1))
			 body)))
      (setq body (nreverse body))
    
      (re-search-forward "#fin")
      
      (goto-char 0)
      
      (setq result (list numb date auth subj them repl cens sign effa body))
      (kill-buffer buffer)
      result)))

(defun dino-affiche-message-et-plein-de-chose (msg)
  (setq dino-fin-theme ())
  (setq dino-fin-all ())
  (let ((old-buffer (current-buffer))
	(res msg)
	buff)
    (unwind-protect
	(progn
	  (set-buffer (dino-get-msg-buffer))
	  (setq buffer-read-only ())
	  (erase-buffer)
	  (setq dino-message-courant res)
	  (setq dino-numero-message-precedant dino-numero-message-courant)
	  (setq dino-numero-message-courant (dino-message-get-number res))
	  (insert (format "Message      : %d\n" 
			  (dino-message-get-number res)))
	  (insert (concat "Date         : " 
			  (dino-message-get-date res) "\n"))
	  (insert (concat "Auteur       : " 
			  (dino-message-get-auth res) "\n"))
	  (when (not (string-equal "" (dino-message-get-signe res)))
	    (insert (concat "Sign par    : " 
			    (dino-message-get-signe res) "\n")))
	  (when (not (string-equal "" (dino-message-get-sujet res)))
	    (insert (concat "Sujet        : " 
			    (dino-message-get-sujet res) "\n")))
	  (setq buff (dino-message-get-themes res))
	  (insert         "Thme(s)     : ")
	  (when (or (null dino-theme-courant)
		    (not (member dino-theme-courant buff)))
	    (dino-set-theme (car buff)))
	  (setq dino-themes-courants buff)
	  (setq dino-alire-courant-st 
		(format "%d"
			(length (dino-rc2-all-non-lu dino-theme-struct))))
	  (dino-message-lu dino-theme-struct 
			   (dino-message-get-number 
			    dino-message-courant))
	  
	  (while buff
	    (insert (concat (car buff) " "))
	    (setq buff (cdr buff)))
	  (setq buff (dino-message-get-reply res))
	  (when buff
	    (insert "\nRponse     : ")
	    (while buff
	      (insert (format "%s " (car buff)))
	      (setq buff (cdr buff))))
	  
	  (setq buff (dino-message-get-cens res))
	  (when buff
	    (insert "\nCensur dans : ")
	    (while buff
	      (insert (concat (car buff) " "))
	      (setq buff (cdr buff))))
	  
	  (setq buff (dino-message-get-effa res))
	  (when buff
	    (insert "\nInterdit : ")
	    (insert buff))
	  
	  (setq buff (dino-message-get-msg res))
	  (insert "\n")
	  (insert dino-fin-du-header)
	  (insert "\n")
	  (if (dino-filtre res dino-theme-courant)
	      (while buff
		(insert (concat (car buff) "\n"))
		(setq buff (cdr buff)))
	    (insert "ce message a t filtr"))
	  (goto-char 0)
	  (setq buffer-read-only t)
	  (set-buffer-modified-p ()))
      (set-buffer old-buffer))))

(defun dino-accept-message (proc str)
  "crit le message reut dans le buffer *dino-msg*"
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut proc str)
    (dino-affiche-message-et-plein-de-chose
     (dino-accept-message-internal proc str))))

(defun dino-force-ecrit-message (msg)
  "crit le message courant, en forcant le filtre"
  (interactive (list dino-message-courant))
  (when msg
    (let ((dino-filtre-force t))
      (dino-affiche-message-et-plein-de-chose msg))))

(defun dino-accept-message2 (proc str)
  "crit le message reut dans le buffer *dino-msg*"
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut proc str)
    (dino-accept-message proc str)
    (goto-char 0)
    (while (re-search-forward "\\([^
]*\\)\\(\\|$\\)" nil t)
      (replace-match "\\1")
      (put-text-property (1- (match-beginning 1)) (1- (match-end 1))
			 'face 'bold))
    (goto-char 0)
    (while (re-search-forward "\\([^
]*\\)\\(\\|$\\)" nil t)
      (replace-match "\\1")
      (put-text-property (1- (match-beginning 1)) (1- (match-end 1))
			 'face 'underline))
    (goto-char 0)
    (setq buffer-read-only t)
    (set-buffer-modified-p ())))

(defun dino-next-prev-accept (proc str)
  "(dino-next-prev-accept PROC STR) permet la rcption des messages next et
prev PROC est une liste (A B C D E F ....) o A est une fonction 
qui sert ainsi :
 (A N B C D E F ....) o N est le numro du message retourn"
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut proc str)
    (string-match "Ok/1: *\\([0-9]+\\) *\n" str)
    (let ((n (string-to-number (substring str (match-beginning 1) 
					  (match-end 1)))))
      (message ())
      (eval (list* (car proc) n (cdr proc))))))
  
(defun dino-next-prev (theme msg nextp)
  (when (null theme) (setq theme dino-theme-courant))
  (when (null msg)   (setq msg (dino-message-get-number
				dino-message-courant)))
  (dino-reconnect)
  (dino-send-command-unireponse (concat (if nextp "suivant " "precedent ")
					(number-to-string msg)
					" " theme "\n")
				'(dino-lit-message-internal)
				(function dino-next-prev-accept))
  (switch-to-buffer (dino-get-msg-buffer))
  (sleep-for 1)
  (accept-process-output)
  (message "")
  (message ()))

(defun dino-next (&optional theme msg)
  (interactive  '(() ()))
  (dino-next-prev theme msg 't))
	  
(defun dino-prev (&optional theme msg)
  (interactive  '(() ()))
  (dino-next-prev theme msg ()))

;;;###autoload
(defun dino-goto-theme (them)
  "pour aller au thme THEM"
  (interactive (list (dino-ask-theme "Thme  : ")))
;    (if (string= "message" mode-name)
;	(dino-raptor-reactualise dino-theme-courant dino-alire-courant))
    (set-buffer (dino-get-msg-buffer))
    (setq dino-themes-courants (list them))
    (dino-set-theme them)
;    (dino-raptor-actualise them)
    (setq dino-fin-theme ())
    (dino-next-non-lu))

(defun dino-next-non-lu-pe-tous (tous)
  (cond ((string= mode-name "entete") 
	 (dino-goto-theme dino-theme-courant))
	((and dino-dernier-message
	      (null dino-non-lu-struct))
	 (dino-read-unread tous)
	 (sleep-for 1)
	 (accept-process-output)
	 (setq dino-dernier-message ())
	 (dino-coordonne-apply 'dino-next-non-lu-pe-tous tous))
	(t (let ((new-message (dino-next-msg-non-lu tous)))
	     (if (eq new-message 'fin-all)
		 (setq dino-dernier-message 't)
	       (setq dino-dernier-message ()))
	     (dino-lit-message-et-change-buffer new-message)))))

(defun dino-next-non-lu ()
  "ben, vous devinez non ?"
  (interactive)
;; FIXME : devrait regarder si on est abonn au thme courant
  (dino-next-non-lu-pe-tous ()))

(defun dino-next-non-lu-tous ()
  "ben, vous devinez non ?"
  (interactive)
  (dino-next-non-lu-pe-tous 't))

(defun dino-next-theme-non-lu ()
  "ben, vous devinez non ?"
  (interactive)
  (switch-to-buffer (dino-get-msg-buffer))
  (dino-lit-message-et-change-buffer (dino-next-msg-autre-theme ())))


;(defun dino-next-non-lu-internal (them) 
;  (message "cherche un nouveau thme......")
;    (if them
;	(if (or (not dino-lit-entetep) (string= mode-name "entete"))
;	    (dino-goto-theme them)
;	  (switch-to-buffer (dino-get-entete-buffer))
;	  (setq dino-theme-courant them)
;	  (setq dino-themes-courants (list them))
;	  (dino-lit-entetes them (cdr (assoc them dino-lu-themes))))
;      (switch-to-buffer (dino-get-msg-buffer))
;      (setq buffer-read-only ())
;      (erase-buffer)
;      (setq dino-message-courant 
;	    dino-message-erreur)
;      (insert-char ?\n (1- (/ (window-height) 2)))
;      (move-to-column (- (/ (window-width) 2) 9) 't)
;      (insert "rien de nouveau")
;      (dino-save-dinorc)
;      (setq buffer-read-only t)
;      (sleep-for 1)
;      (message ())))

(defun dino-prev-msg ()
  (interactive)
  (when dino-message-courant
    (if (= 0 (dino-message-get-number dino-message-courant))
	(progn 
	  (dino-lit-message dino-nbmsg))
      (dino-lit-message (1- (dino-message-get-number 
			     dino-message-courant))))))
(defun dino-next-msg ()
  (interactive)
  (when dino-message-courant
    (dino-lit-message (1+ (dino-message-get-number 
			   dino-message-courant)))))


(defun dino-libere-message-msg (message theme)
  (interactive (list dino-message-courant dino-theme-courant))
  (dino-libere-message message theme))

(defun dino-censure-message-msg (message theme)
  (interactive (list dino-message-courant dino-theme-courant))
  (dino-censure-message message theme))

(defun dino-toggle-censure-message-msg ()
  (interactive)
  (if (or (member dino-theme-courant 
		  (dino-message-get-cens dino-message-courant))
	  (member (concat dino-theme-courant "@")
		  (dino-message-get-cens dino-message-courant)))
      (dino-libere-message dino-numero-message-courant dino-theme-courant)
    (dino-censure-message dino-numero-message-courant dino-theme-courant)))

(defun dino-fill-msg ()
  (interactive)
  (save-excursion
    (goto-char (point-min))
    (search-forward dino-fin-du-header)
    (let ((beg (point))
	  (end (point-max))
	  (wrt buffer-read-only))
      (setq buffer-read-only ())
      (fill-region beg end)
      (setq buffer-read-only wrt)
      (set-buffer-modified-p ()))))

(defun dino-msg-undo ()
  (interactive)
  (dino-lit-message-internal dino-numero-message-precedant))

(provide 'dino-msg-mode)

(run-hooks 'dino-msg-mode-load-hook)
