;	$Id: dino-overlay.el,v 1.6 2002/05/24 09:49:52 vanicat Exp $
;;; dino-list-mode.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; dino-overlay gestion des overlay pour GNU Emacs et XEmacs
;;;
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

(defvar dino-xemacs (equal (substring (version) 0 6) "XEmacs"))

(if dino-xemacs
    (progn 
      (defun dino-overlay-make-overlay (deb fin)
	(make-extent deb fin))
      (defun dino-overlay-set-face (overlay face)
	(set-extent-face overlay face))
      (defun dino-overlay-set-mouse-face (overlay face)
	(set-extent-mouse-face overlay face)))
  (defun dino-overlay-set-face (overlay face)
    (overlay-put overlay 'face face))
  (defun dino-overlay-make-overlay (deb fin)
    (make-overlay deb fin))
  (defun dino-overlay-set-mouse-face (overlay face)
    (overlay-put overlay 'mouse-face face)))

(provide 'dino-overlay)

