;	$Id: dino-pile.el,v 1.21 2004/03/03 12:35:18 vanicat Exp $
;;; dino-pile.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; dino-pile gestion de la pile

;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

(require 'dino-general)
(require 'cl)
(require 'dino-autoload)
(require 'dino-gestion)
(require 'dino-dinorc-serveur)
(require 'dino-msg-mode)

(defvar dino-pile ()
  "liste des messages dans la pile permanente")
(defvar dino-pile-modified ()
  "non-nil si la pile n'est pas sauvegarde")
(defvar dino-pile-load-hook ())

(defcustom dino-pile-file "~/.dino-pile"
  "*fichier o la pile permanente est stocke"
  :type 'file
  :group 'dino)

(defvar dino-pile-buffer-name "*pile dino*"
  "nom du buffer pour la pile des messages")

(defvar dino-pile-buffer ()
  "buffer pour la pile des messages")

(defvar dino-pile-mode-hook ()
  "*Un hook pour le pile-mode de dino")

(defvar dino-pile-mode-map ()
  "*Une map pour le pile-mode de dino")

;(defvar dino-pile-popped ()
;  "dernier message retir de la pile")

(put 'dino-pile-mode 'mode-class 'special) ; dino-pile-mode est mode : emacs le sait

(unless dino-pile-mode-map
  ;;; Specific stuff
  (setq dino-pile-mode-map (make-keymap))
  (suppress-keymap dino-pile-mode-map)  
  (define-key dino-pile-mode-map "s" 'dino-save-all)
  (define-key dino-pile-mode-map "\C-m" 'dino-pile-lit-msg)
  (define-key dino-pile-mode-map "\C-k" 'dino-pile-del-msg)
  (define-key dino-pile-mode-map ")" 'dino-pile-pop)
  (define-key dino-pile-mode-map [mouse-1]
        (cons "Lit message" 'dino-pile-mouse-lit-msg))
  (define-key dino-pile-mode-map [mouse-3]
        (cons "Supprime de la pile" 'dino-pile-mouse-del-msg))

  ;;; Commandes habituelles
  (define-key dino-pile-mode-map "n" 'dino-next-non-lu)
  (define-key dino-pile-mode-map "N" 'dino-next-non-lu-tous)
  (define-key dino-pile-mode-map "t" 'dino-next-theme-non-lu)
  (define-key dino-pile-mode-map "\C-i" 'dino-next-non-lu)
;  (define-key dino-pile-mode-map "+" 'dino-next-msg)
  (define-key dino-pile-mode-map "g" 'dino-goto-theme)
  (define-key dino-pile-mode-map "a" 'dino-abonne)
  (define-key dino-pile-mode-map "d" 'dino-desabonne)
  (define-key dino-pile-mode-map "p" 'dino-prev)
;  (define-key dino-pile-mode-map "-" 'dino-prev-msg)
  (define-key dino-pile-mode-map " " 'scroll-up)
  (define-key dino-pile-mode-map "c" 'dino-connect)
  (define-key dino-pile-mode-map "[" 'dino-prev)
  (define-key dino-pile-mode-map "]" 'dino-next)
  (define-key dino-pile-mode-map "<" 'dino-prev)
  (define-key dino-pile-mode-map ">" 'dino-next)
  (define-key dino-pile-mode-map "v" 'dino-lit-message)
;  (define-key dino-pile-mode-map "z" 'dino-msg-marque-lu)
  (define-key dino-pile-mode-map "r" 'dino-reply) ; FIXME
  (define-key dino-pile-mode-map "R" 'dino-reply-include) ;FIXME
  (define-key dino-pile-mode-map "m" 'dino-poste)
  (define-key dino-pile-mode-map "l" 'dino-lit-themes)
  (define-key dino-pile-mode-map "L" 'dino-lit-themes-tous)
  (define-key dino-pile-mode-map "q" 'dino-quit)
  (define-key dino-pile-mode-map "^" 'dino-lit-parents)
  (define-key dino-pile-mode-map ":" 'dino-send-command)

;; Barre de menu
  (define-key dino-pile-mode-map [menu-bar dino]
	(cons "Dino" (make-sparse-keymap "dino")))
  (define-key dino-pile-mode-map [menu-bar dino help]
        (cons "Aide" 'describe-mode))
  (define-key dino-pile-mode-map [menu-bar dino dinorc]
    (cons "dinorc" dino-dinorc-map))
  (define-key dino-pile-mode-map [menu-bar dino dinorc2]
    (cons "dinorc2" dino-dinorc2-map))
  (define-key dino-pile-mode-map [menu-bar dino dinorc-serv]
    (cons "dinorc serveur" dino-rc-serv-map))
  (define-key dino-pile-mode-map [menu-bar dino next-non-lu]
        (cons "Prochain non lu" 'dino-next-non-lu))
  (define-key dino-pile-mode-map [menu-bar dino next]
        (cons "Suivant dans thme" 'dino-next))
  (define-key dino-pile-mode-map [menu-bar dino prev]
        (cons "Prcdent dans thme" 'dino-prev))
;  (define-key dino-pile-mode-map [menu-bar dino prev-msg]
;        (cons "Suivant" 'dino-next-msg))
;  (define-key dino-pile-mode-map [menu-bar dino next-msg]
;        (cons "Prcdent" 'dino-prev-msg))
  (define-key dino-pile-mode-map [menu-bar dino goto-theme]
        (cons "Va dans le thme" 'dino-goto-theme))
  (define-key dino-pile-mode-map [menu-bar dino quit]
        (cons "Quitter" 'dino-quit))
  (define-key dino-pile-mode-map [menu-bar dino connect]
        (cons "Reconnexion" 'dino-connect))
  (define-key dino-pile-mode-map [menu-bar dino marque-lu]
        (cons "Marquer lu" 'dino-marque-lu)) ; FIXME
  (define-key dino-pile-mode-map [menu-bar dino refait-list]
        (cons "Relit la liste" 'dino-lit-themes))
  (define-key dino-pile-mode-map [menu-bar dino poste]
        (cons "Poste" 'dino-poste))
  (define-key dino-pile-mode-map [menu-bar dino pile-pop]
    (cons "Dsempile" 'dino-pile-pop)))
;; FIXME : ajout des comandes locale au menu

(defun dino-pile-mode () 
  "mode pour lire les enttes des messages de dino mis de cot

\\{dino-pile-mode-map}"
  
  (interactive)
  (kill-all-local-variables)
  (cond ;((boundp 'mode-line-modified)
	; (setq mode-line-modified "--- "))
	((listp (default-value 'mode-line-format))
	 (setq mode-line-format
	       (list* "--" 
		      'dino-theme-courant
		      "--"
		      '(dino-rc2-modifie
			"*" 
			(dino-rc-serv-type 
			 (dino-rc-serv-modified "*" "")
			 ""))
		      '(dino-non-lu-struct "m" "")
		      '(dino-waiting-server "w" "")
		      "- " 
		      (cdr (default-value 'mode-line-format))))))
  (setq major-mode 'dino-pile-mode)
  (setq mode-name "pile")
  (make-local-variable 'minor-mode-alist)
  (use-local-map dino-pile-mode-map)
  (buffer-disable-undo (current-buffer))
  (setq buffer-read-only t)
  (set-buffer-modified-p ())
  (setq truncate-lines t)
  (run-hooks 'dino-pile-mode-hook))

(defun dino-pile-show ()
  "affiche la pile et montre le buffer"
  (interactive)
  (unless (buffer-live-p dino-pile-buffer)
    (dino-pile-display))
  (switch-to-buffer dino-pile-buffer))

(defun dino-pile-get-buffer-simple ()
  (unless (buffer-live-p dino-pile-buffer)
    (let ((old (current-buffer)))
      (setq dino-pile-buffer 
	    (get-buffer-create dino-pile-buffer-name))
      (set-buffer dino-pile-buffer)
      (setq buffer-read-only 't)
      (set-buffer-modified-p ())
      (dino-pile-mode)
      (set-buffer old)))
  dino-pile-buffer)

(defun dino-pile-print-entete (msg ins) ; au debut si ins n'est pas nil, 
					;  la fin sinon
  (let ((old  (current-buffer)))
    (unwind-protect 
	(let (deb fin)
	  (set-buffer (dino-pile-get-buffer-simple))
	  (save-excursion
 	    (setq buffer-read-only ())
	    (if ins
		(goto-char (point-min))
	      (goto-char (point-max)))
 	    (setq deb (point))
   	    (insert (format "%7d %15s %s" 
   			    (dino-message-get-number msg)
   			    (substring (concat (dino-message-get-auth msg)
   					       "               ")
   				       0 15)
   			    (dino-message-get-sujet msg)))
 	    (setq fin (point))
 	    (put-text-property deb fin 'mouse-face 'highlight)
 	    (put-text-property deb fin 'dino-msg msg)
 	    (insert "\n")))
      (setq buffer-read-only 't)
      (set-buffer-modified-p ())
      (set-buffer old))))

(defun dino-pile-print-entete-first (msg)
  (dino-pile-print-entete msg t))

(defun dino-pile-print-entete-last (msg)
  (dino-pile-print-entete msg ()))

(defun dino-pile-print (l)
  "affiche une liste de messages dans l'ordre"
  (let ((li l))
    (while li
      (dino-pile-print-entete-last (car li))
      (setq li (cdr li)))))

(defun dino-pile-display ()
  "met  jour le buffer affichant la pile"
  (interactive)
  (let ((old-buffer (current-buffer)))
    (unwind-protect
	(progn
	  (set-buffer (dino-pile-get-buffer-simple))
	  (setq buffer-read-only ())
	  (erase-buffer)
	  (dino-pile-print dino-pile)
	  (setq buffer-read-only t)
	  (set-buffer-modified-p ())
	  (dino-pile-mode))
      (set-buffer old-buffer))))

(defun dino-pile-get-buffer ()
  (unless (buffer-live-p dino-pile-buffer)
    (dino-pile-display))
  dino-pile-buffer)

(defun dino-pile-accept-entete (proc str)
  "chope l'entte d'un message, l'ajoute dans la pile, et l'affiche"
  (if (string-equal (substring str 0 3) "Err")
      (dino-ecrit-recut () str)
    (let ((msg (dino-accept-entete-internal proc str))) ; definie dans 
					                ; entete-mode.el
      (setq dino-pile (cons msg dino-pile))
      (dino-pile-print-entete-first msg))))


(defun dino-pile-lit-entete (num)
  "lit un entte, l'ajoute  la pile, et l'affiche"
  (dino-send-command-multireponse (concat "entete " (int-to-string num) "\n")
				  ()
				  (function dino-pile-accept-entete)))

(defun dino-pile-push ()
  "met le message courant dans la pile"
  (interactive)
  (dino-reconnect)
  (setq dino-pile-modified 't)
  (dino-pile-get-buffer) ; cree le buffer si necessaire et affiche la pile
  (dino-pile-lit-entete (dino-message-get-number dino-message-courant))
  (message "Message empil"))


(defun dino-pile-filter-internal (num l)
  "retire les messages num de la liste l, en la modifiant"
  (let ((li (cons () l))
	res
	(rest l)
	hd
	tl)
    (setq res li)
    (while li
      (setq hd (car rest))
      (setq tl (cdr rest))
      (if (eq num (dino-message-get-number hd))
	  (setcdr li tl)
	(setq li rest))
      (setq rest tl))
    (cdr res)))
	
	    


(defun dino-pile-filter (num)
  "supprime de la pile tous les messages numerots num"
  (interactive "NNumro du message  supprimer : ")
  (setq dino-pile-modified 't)
  (setq dino-pile (dino-pile-filter-internal num dino-pile))
  (dino-pile-display))


(defun dino-pile-pop ()
  "lit le message suprieur de la pile, et l'enlve de la pile"
  (interactive)
  (setq dino-pile-modified 't)
  (let ((msg (car dino-pile)))
    (when msg
      (dino-lit-message (dino-message-get-number msg))
      (setq dino-pile (cdr dino-pile))))
  (dino-pile-display))

(defun dino-pile-top ()
  "lit le message suprieur de la pile, sans l'enlever de la pile"
  (interactive)
  (let ((msg (car dino-pile)))
    (if msg (dino-lit-message (dino-message-get-number msg)))))


(defun dino-pile-look-msg (n)
  (interactive "nmsg a lire :")
  "regarde le n me message dans la pile"
  (let ((msg (nth (1- n) dino-pile)))
    (if msg (dino-lit-message (dino-message-get-number msg)))))


(defun dino-pile-clear ()
  (interactive)
  "vide la pile"
  (setq dino-pile-modified 't)
  (setq dino-pile ())
  (dino-pile-display))
		    

(defun dino-pile-build (numlist)
  "convertit la liste des numros en liste des enttes (inverse)"
  (setq dino-pile ())
  (let ((l numlist))
    (while l
      (dino-pile-lit-entete (car l))
      (setq l (cdr l)))))

(defun dino-pile-unbuild (msglist)
  "convertit la liste des enttes en liste des numros (inversee)"
  (let ((l msglist)
	(res ()))
    (while l
      (setq res (cons 
		 (dino-message-get-number (car l))
		 res)) 
      (setq l (cdr l)))
    res))


(defun dino-pile-load ()
  (interactive)
  "lit la pile depuis le fichier o elle est memorise"
  (when (file-exists-p dino-pile-file)
    (let ((new-buffer (generate-new-buffer " *dino-pile work*")))
      (set-buffer new-buffer)
      (insert-file-contents dino-pile-file)
      (goto-char (point-min))
      (dino-pile-build (read new-buffer))
      (kill-buffer new-buffer))))

(defun dino-pile-save ()
  (interactive)
  "enregistre la pile dans le fichier .dino-pile"
  (when dino-pile-modified
    (let ((new-buffer (generate-new-buffer " *dino-pile work*")))
      (set-buffer new-buffer)
      (print (dino-pile-unbuild dino-pile) new-buffer)
      (write-region (point-min) (point-max) dino-pile-file () 2)	
      (setq dino-pile-modified ())
      (kill-buffer new-buffer))))

(defun dino-pile-lit-msg ()
  (interactive)
  "lit le message o le curseur est positionn"
  (let ((msg-num (save-excursion 
		   (set-buffer (dino-pile-get-buffer))
		   (dino-message-get-number 
		    (get-text-property (point) 'dino-msg)))))
    (when msg-num
      (dino-split-windows-et-lit-message msg-num))))

(defun dino-pile-mouse-lit-msg (event)
  (interactive "@e")
  "lit le message sur lequel on clique avec mouse-2"
  (let ((msg-num (dino-message-get-number 
		  (get-text-property (car (cdr (car (cdr event))))
				     'dino-msg))))
    (if msg-num
	(dino-split-windows-et-lit-message msg-num))))

(defun dino-pile-del-msg ()
  (interactive)
  "supprime de la pile le message o le curseur est positionn"
  (let ((msg-num (save-excursion 
	   (set-buffer (dino-pile-get-buffer))
	   (dino-message-get-number 
	    (get-text-property (point) 'dino-msg)))))
    (if msg-num (dino-pile-filter msg-num))))

(defun dino-pile-mouse-del-msg (event)
  (interactive "@e")
  "supprime de la pile le message sur lequel on clique avec mouse-3"
  (let ((msg-num (dino-message-get-number 
		  (get-text-property (car (cdr (car (cdr event))))
				     'dino-msg))))
    (if msg-num (dino-pile-filter msg-num))))

(add-hook 'dino-save-dinorc-hook 'dino-pile-save)
(add-hook 'dino-quit-hook 'dino-pile-save)

(provide 'dino-pile)

