;	$Id: dino-poste-mode.el,v 1.33 2004/03/03 12:35:18 vanicat Exp $
;;; dino-msg-mode.el 

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; ce fichier concerne le mode pour l'criture et l'envoi de postes
;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

;; le mode poste

(require 'dino-general)
(require 'dino-autoload)
(require 'dino-cnx)
(require 'dino-gestion)
(require 'dino-dinorc-serveur)
(require 'dino-msg-mode)
(require 'cl)

(defvar dino-poste-mode-load-hook ())

(defvar dino-poste-mode-hook ()
  "*Un hook pour le poste-mode de dino")

(defvar dino-send-buffer-hook ()
  "*Liste de fonctions lances avant d'envoyer un message au serveur dino")

(defvar dino-poste-mode-map ()
  "*Un map pour le poste-mode de dino")

(defvar dino-poste-mode-nick-history `(,dino-nick))

(defvar dino-poste-auto-save-directory "~/.dino.d/"
  "*repertoire o on doit sauver les postes non envoyer")

(put 'dino-poste-mode 'mode-class 'special)

(defvar dino-poste-sujet "")
(defvar dino-poste-reply ())
(defvar dino-buffer-reply ())
(defvar dino-cite "> " "*chane au debut de chaque ligne cite")

(unless dino-poste-mode-map
  (setq dino-poste-mode-map (make-keymap))
  (define-key dino-poste-mode-map "\C-c\C-s" 'dino-send-buffer)
  (define-key dino-poste-mode-map "\C-c\C-c" 'dino-send-buffer)
  (define-key dino-poste-mode-map "\C-c\C-r" 'dino-connect)
  (define-key dino-poste-mode-map "\C-c\C-i" 'dino-include)  
  (define-key dino-poste-mode-map "\C-xk" 'dino-kill-message-interactive)
  (define-key dino-poste-mode-map [menu-bar dino]
    (cons "Dino" (make-sparse-keymap "dino")))
  (define-key dino-poste-mode-map [menu-bar dino help]
        (cons "Aide" 'describe-mode))
  (define-key dino-poste-mode-map [menu-bar dino dinorc]
    (cons "dinorc" dino-dinorc-map))
  (define-key dino-poste-mode-map [menu-bar dino dinorc2]
    (cons "dinorc2" dino-dinorc2-map))
  (define-key dino-poste-mode-map [menu-bar dino dinorc-serv]
    (cons "dinorc serveur" dino-rc-serv-map))
  (define-key dino-poste-mode-map [menu-bar dino help]
        (cons "Include" 'dino-include))
  (define-key dino-poste-mode-map [menu-bar dino help]
        (cons "Annule" 'kill-buffer))
  (define-key dino-poste-mode-map [menu-bar dino help]
        (cons "Envoie" 'dino-send-buffer)))

(defun dino-poste-mode ()
   "mode pour diter un futur poste de dino

\\{dino-poste-mode-map}"
  (interactive)
  (kill-all-local-variables)
  (goto-char (point-max))
  (when (search-backward "
Local Variables:
mode: dino-poste
" () 't)
    (narrow-to-region (point-min) (point)))
  (goto-char (point-min))
  (setq major-mode 'dino-poste-mode)
  (setq mode-name "poste")
  (cond ;((boundp 'mode-line-modified)
	; (setq mode-line-modified "--- "))
	((listp (default-value 'mode-line-format))
	 (setq mode-line-format
	       (list* "--" 
		      'dino-theme-courant
		      "--"
;		      '(dino-lit-raptorp "*" "")
		      '(dino-rc2-modifie
			"*" 
			(dino-rc-serv-type 
			 (dino-rc-serv-modified "*" "")
			 ""))
		      '(dino-non-lu-struct "m" "")
		      '(dino-waiting-server "w" "")
		      "-" 
		      (cdr (default-value 'mode-line-format))))))
  (make-local-variable 'minor-mode-alist)
  (make-local-variable 'dino-poste-reply)
  (make-local-variable 'dino-poste-sujet)
  (make-local-variable 'dino-buffer-reply)
  (make-local-variable 'dino-theme-courant)
  (use-local-map dino-poste-mode-map)
  (auto-fill-mode)
  (run-hooks 'dino-poste-mode-hook))

(defun dino-include (buffer)
  (interactive 
   (list
    (read-buffer "buffer :" (if dino-buffer-reply
				dino-buffer-reply
			      dino-msg-buffer-name) 't)))
  (save-excursion 
    (let ((beg (point)))
      (insert-buffer (if (eq (get-buffer buffer) (current-buffer))
			 (dino-get-msg-buffer)
		       (get-buffer buffer)))
      (goto-char beg)
      (when (re-search-forward (concat "\\`\\([^a].*\n\\)*auteur *: \\(.+\\)\n\\([^-].*\n\\)*" 
				       dino-fin-du-header) nil t)
	(replace-match ">>>> \\2 a crit\n")
	(goto-char beg)
	(while (re-search-forward "^.*$" nil t)
	  (beginning-of-line)
	  (insert dino-cite))))))

(defun dino-poste-insert (post sujet them thems)
  (insert (format "
Local Variables:
mode: dino-poste
dino-poste-reply: %S
dino-poste-sujet: %S
dino-theme-courant: %S
dino-themes-courant: %S
End:
" post sujet them thems)))

(defun dino-poste-prepare (post sujet them thems)
  (find-file (make-temp-name (expand-file-name "poste" dino-poste-auto-save-directory)))
  (dino-poste-insert post sujet them thems)
  (dino-poste-mode))

(defun dino-poste ()
  (interactive)
  (let ((theme dino-theme-courant)
	(list-themes dino-themes-courants))
    (dino-poste-prepare () "" theme list-themes)
    (setq dino-theme-courant theme)
    (setq dino-themes-courants list-themes)))

(defun dino-reply (post them thems sujet buffer)
  (interactive (list 
		(dino-message-get-number dino-message-courant)
		dino-theme-courant
		dino-themes-courants
		(dino-message-get-sujet dino-message-courant)
		(current-buffer)))
  (dino-poste-prepare post sujet them thems)
  (setq dino-poste-reply post
	dino-poste-sujet (dino-make-sujet-reply sujet)
	dino-theme-courant them
	dino-themes-courants thems
	dino-buffer-reply (buffer-name buffer)))



(defun dino-reply-include (post them thems sujet buffer)
  (interactive (list 
		(dino-message-get-number dino-message-courant)
		dino-theme-courant
		dino-themes-courants
		(dino-message-get-sujet dino-message-courant)
		(current-buffer)))
  (dino-reply post them thems sujet buffer)
  (dino-include buffer))


(defun dino-make-sujet-reply (sujet)
  (if (and (>= (length sujet) 3) (string= (substring sujet 0 3) "Re:"))
      sujet
    (concat "Re: " sujet)))


;;envoi d'un message


(defun dino-send-buffer (buffer nick theme sujet rep signe)
  (interactive (list (current-buffer)
		     (setq dino-nick (read-string "Nick    : " dino-nick 'dino-poste-mode-nick-history ))
		     (let ((ths (dino-ask-list-theme "Thme     :" 
						     (if dino-themes-courants
							 dino-themes-courants
						       (list dino-theme-courant)))))
		       (setq dino-theme-courant (car ths))
		       (setq dino-themes-courants ths))
		     (setq dino-poste-sujet 
			   (read-string "Sujet   : " dino-poste-sujet))
		     (dino-ask-list-number "Reply     :" dino-poste-reply)
		     (prog1
			 (dino-y-or-n-signe-p "Signer ? ")
		       (message "")
		       (message ()))))
  (run-hooks 'dino-send-buffer-hook)
  (dino-reconnect)
  (do-auto-save)
  (let ((str '("\n")) (save-theme theme))
    (unless (string-equal "" sujet)
      (setq str (cons " sujet " (cons sujet str))))
    (setq rep (nreverse rep))
    (while rep
	(setq str (cons " rep " (cons (number-to-string (car rep)) str)))
	(setq rep (cdr rep)))
    (unless (string-equal dino-login nick)
      (setq str (cons " pseudo " (cons nick str))))
    (when signe (setq str (cons " signe" str)))
    (setq theme (nreverse theme))
    (while theme
	(setq str (cons " them " (cons (car theme) str)))
	(setq theme (cdr theme)))
    (dino-lock 
     (lambda (str)
       (dino-send-command-unireponse-in-lock (apply 'concat "poste" str)
					     (cons save-theme buffer)
					     (function dino-send-buffer-internal)))
     (list str)))
  (bury-buffer))
    
        
(defun dino-send-buffer-internal (buff str)
  "ouais, ben voil quoi, aprs que la demande de poste a march, ben 
j'envoie le buffer"
 (if (string-equal (substring str 0 3) "Err")
      (progn (dino-ecrit-recut dino-connection str)
	     ())
   (set-buffer (cdr buff))
   (goto-char 0)
   (while (re-search-forward "^\\.$" nil t)
     (replace-match ". " nil nil))
;   (if (text-property-not-all (point-min) (point-max) 'face ())
;       (let ((pos (next-single-property-change (point-min) 'face))
;	     (prop) (old-prop) (eol))
;	 (while (or pos old-prop)
;	   (setq eol (line-end-position))
;	   (if (and old-prop (or (null pos) (< eol pos)))
;	       (progn 
;		 (goto-char (1+ eol))
;		 (insert old-prop)
;		 (setq pos (+ eol 2)))
;	     (goto-char pos)
;	     (setq prop (cdr (assoc (get-text-property pos 'face)
;				    dino-controle-sequence-alist)))
;	     (if (not (equal prop old-prop))
;		 (if prop 
;		     (progn
;		       (insert prop)
;		       (setq old-prop prop)
;		       (setq pos (1+ pos)))
;		   (if old-prop
;		       (progn
;			 (setq old-prop ())
;			 (insert "")
;			 (setq pos (1+ pos))))))
;	     (setq pos (next-single-property-change pos 'face))))))
   (goto-char (point-max))
   (insert "\n.\n")
   (dino-send-command-unireponse-in-lock (buffer-substring (point-min) (point-max))
					 buff
					 (function dino-poste-succed)))
 (dino-unlock))

(defun dino-poste-succed (buff str) 
  (if (string-equal (substring str 0 3) "Err")
      (progn (dino-ecrit-recut dino-connection str)
	     ()) 
    (let ((old-buff (current-buffer)) (theme (car buff)))
      (dino-kill-message (cdr buff))
      (set-buffer old-buff)
      (while theme
	(dino-read-unread-theme-no-max (dino-rc2-get-alire (car theme)))
	(setq theme (cdr theme)))
      (dino-ecrit-recut dino-connection str))))

(defun dino-kill-message (buff)
  "detruit le buffer ainsi que les fichiers concern, sans poser de question"
  (let ((filename (buffer-file-name buff))
	(auto-save (progn (set-buffer buff)
			  buffer-auto-save-file-name)))
    (set-buffer-modified-p ())
    (kill-buffer buff)
    (when (file-exists-p filename)
      (delete-file filename))
    (when (file-exists-p (make-backup-file-name filename))
      (delete-file (make-backup-file-name filename)))
    (when (file-exists-p auto-save)
      (delete-file auto-save))))

(defun dino-kill-message-interactive (realy)
  "detruit le buffer ainsi que les fichiers concern, sans poser de question"
  (interactive (list (let ((query-replace-map dino-y-or-n-p-map-signe))
		       (y-or-n-p "Vraiment abandoner l'criture de ce message ?"))))
  (when realy
    (dino-kill-message (current-buffer))))



(provide 'dino-poste-mode)

(run-hooks 'dino-poste-mode-load-hook)

