;	$Id: dino.el,v 1.41 2004/03/03 12:48:37 vanicat Exp $	

;;; Copyright (C) 1998  Vanicat Remi
;;;
;; Author: Remi Vanicat (vanicat@labri.u-bordeaux.fr)
;; Keywords: Dino 
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; A copy of the GNU General Public License can be obtained from 
;;; Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 
;;; 02139, USA.
;;; http://www.gnu.org/copyleft/gpl.html

;;; Commentary:
;;;
;;; ce package est pour permetre la lecture de dino dans emacs
;;; 
;;; 
;;; 
;;; pour installer : ajouter 
;;; (setq load-path (cons "/home/rvanicat/lang/elisp" load-path))
;;; (autoload 'dino "dino" "" 't)
;;; dans son .emacs
;;; o /home/rvanicat/lang/elisp doit tre remplac par le rpertoire
;;; o se trouve ce fichier

;;; TODO : bug-fixe
;;; Bugs List: 
;;;   pb en cas d'insertion d'un message contenant un message  mon format
;;;   Il sauterait des messages ??

(require 'cl)
(require 'dino-autoload)
(require 'tq2)
(require 'timer)
(require 'dino-general)
(require 'dino-cnx)
(require 'dino-console-mode)
(require 'dino-entete-mode)
(require 'dino-gestion)
(require 'dino-list-mode)
(require 'dino-msg-mode)
(require 'dino-poste-mode)
(require 'dino-pile)
(require 'dino-overlay)
(require 'dino-msg-gestion)
(require 'dino-dinorc2)
(require 'dino-dinorc-serveur)
(require 'dino-console-mode)
(require 'dino-msg-mode)
(require 'dino-list-mode)
(require 'dino-entete-mode)
(require 'dino-cnx)
(require 'dino-gestion)
(require 'dino-pile)
(require 'dino-poste-mode)
(require 'dino-dinorc-serveur)

(defgroup dino () "Groupe de customisation dino")

;  (autoload 'dino-raptor "dino-raptor" "" 't)
;  (autoload 'dino-pile-push "dino-pile" 
;    "met le message num (courant par dfaut) dans la pile" 't)
;  (autoload 'dino-pile-pop "dino-pile" 
;    "lit le message suprieur de la pile, et l'enlve de la pile" 't)
;  (autoload 'dino-pile-top "dino-pile" 
;    "lit le message suprieur de la pile, sans l'enlever de la pile" 't)
;  (autoload 'dino-pile-look-msg "dino-pile" 
;    "regarde le n me message dans la pile" 't)
;  (autoload 'dino-pile-mode "dino-pile"
;    "mode pour lire les enttes des messages de dino mis de cot" 't) ; mj

;; programme principal

(defvar dino-load-hook ())

(defvar dino-version "DineL, client dino pour emacs version 2.5"
  "chane contenant la version du client")


(defvar dino-exist ()
  "Non Nil mean that dino is running somewhere")

(defvar dino-auto-save-idle-timer ())
(defcustom dino-auto-save-time 300
  "*temps (en seconde) avant que Emacs essai de sauver les dinorc locaux"
  :group 'dino
  :type 'integer)

(defvar dino-auto-save-serveur-idle-timer ())
(defcustom dino-auto-save-serveur-time 1800
  "*temps (en seconde) avant que Emacs essai de sauver le dinorc du serveur"
  :group 'dino
  :type 'integer)

;; programme d'accs au aprite d'un message

;;;###autoload
(defun dino ()
  "Commande lanant DineL.
Les commandes  connatres :
dino-next-non-lu : message non lu suivant
dino-next-non-lu-tous : message non lu suivant, mme dans les thmes dsabonns
dino-lit-themes : relit la liste des thmes, ractualise les thmes non lu.
dino-lit-themes-tous  : pareil, mais avec les thmes dsabonns
dino-next-theme-non-lu : aller dans le thme non lu suivant
dino-next : message suivant dans le thme courant
dino-prev : message prcdent dans le thme courant
il y a les quivalent avec tous
dino-next-msg : message suivant (ordre chronologique)
dino-prev-msg : message prcdent (ordre chronologique)
dino-goto-theme : pour aller dans un thme prcis
dino-marque-lu : pour marquer tous les messages d'un thme ou de dino comme lus
dino-quit : pour quitter
browse-url-at-point : regarde l'url sous le curseur

les racourcis clavier valables dans la liste des thmes :
\\<dino-list-mode-map>
key             binding
---             -------

\\[dino-next-non-lu] 		dino-next-non-lu
\\[dino-next-non-lu-tous]		dino-next-non-lu-tous
\\[dino-lit-themes] 		dino-lit-themes
\\[dino-lit-themes-tous] 		dino-lit-themes-tous
\\[dino-list-goto-theme]		dino-list-goto-theme
\\[dino-list-marque-lu]		dino-list-marque-lu
\\[dino-quit]		dino-quit
\\[dino-abonne]		dino-abonne
\\[dino-desabonne]		dino-desabonne
\\[dino-lit-entetes]		dino-lit-entetes
\\[dino-poste]		dino-poste

les racourcis clavier valables dans le mode lecture de poste :

\\{dino-msg-mode-map}

les racourcis clavier valables dans le mode criture de poste :
\\<dino-poste-mode-map>
key             binding
---             -------

\\[dino-include]		dino-include
\\[dino-connect]		dino-connect
\\[dino-send-buffer]		dino-send-buffer
"

  (interactive)
  (if dino-exist
      (progn
	(dino-read-unread ())
	(dino-coordonne-apply (function dino-lit-themes)))
    (unless (file-exists-p dino-poste-auto-save-directory)
      (make-directory dino-poste-auto-save-directory))
    (switch-to-buffer (dino-get-list-buffer))
    (dino-lit-dinorc)
    (dino-connect)
    (dino-read-unread ())
    (dino-coordonne-apply (function dino-lit-themes))
    (setq dino-exist 't)
    (dino-pile-load)
    (when (numberp dino-auto-save-time)
      (setq dino-auto-save-idle-timer
	    (run-with-idle-timer dino-auto-save-time 't 'dino-save-dinorc)))
    (when (and (numberp dino-auto-save-serveur-time)
	       (not dino-rc-serv-ignore))
      (setq dino-auto-save-serveur-idle-timer
	    (run-with-idle-timer dino-auto-save-serveur-time 't 
				 'dino-rc-serv-save-dinorc-maybe)))))


(defun dino-reinit ()
  (interactive)
  (when dino-tq
    (tq2-close dino-tq))
  (setq dino-tq ())
;  (setq dino-lu-themes ())
;  (setq dino-max-themes ())
;  (setq dino-theme-non-lu ())
;  (setq dino-list-themes ())
  (setq dino-alist-themes ())
  (setq dino-exist 't)
  (dino-lit-dinorc)
  (dino-ecrit-list ())
  (dino-pile-load))


(defun dino-quit ()
  (interactive)
  "pour quitter dino"
  (when (y-or-n-p "tes vous sur de vouloir partir ?")
    (dino-save-dinorc)
    (dino-rc-serv-save-dinorc-maybe)
    (dino-deconnect)
    (sleep-for 1)
    (accept-process-output)
    (when dino-auto-save-idle-timer
      (cancel-timer dino-auto-save-idle-timer))
    (when dino-auto-save-serveur-idle-timer
      (cancel-timer dino-auto-save-serveur-idle-timer))
    (when dino-check-message 
;     (cancel-timer dino-check-message)
      (setq dino-check-message ()))
    (when (buffer-live-p dino-buffer)
      (kill-buffer dino-buffer))
    (when (get-buffer dino-list-theme-buffer-name)
      (kill-buffer dino-list-theme-buffer-name))
    (when (get-buffer dino-msg-buffer-name)
      (kill-buffer dino-msg-buffer-name))
;    (when (buffer-live-p dino-dinorc-buffer)
;      (kill-buffer dino-dinorc-buffer))
    (when (buffer-live-p dino-entete-buffer)
      (kill-buffer dino-entete-buffer))
    (when (buffer-live-p dino-pile-buffer) ; mj
      (kill-buffer dino-pile-buffer))  ; mj

    (accept-process-output)
    (setq dino-connection ()
	  dino-tq ()
	  dino-exist ()
;         dino-dinorc-buffer ()
	  dino-alist-themes ()
;         dino-list-themes ()
;	  dino-lu-themes ()
;	  dino-theme-non-lu ()
	  dino-max-themes ()
	  dino-buffer ()
	  dino-rc2-alist-dinorc2-var ()
	  dino-rc2-alist-themes-alire-struct ()
;	  dino-list-themes-abonne ()
	  dino-tq-lock ())
    (message "au revoir et  bientt")))


(run-hooks 'dino-load-hook)

(provide 'dino)

