/* cache.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include <libintl.h>
#include <limits.h>
#include "defs.h"
#include "main.h"
#include "serveur.h"
#include "init.h"
#include "noms.h"
#include "numeros.h"
#include "interface.h"
#include "routineur.h"
#include "conv.h"


static message_t **ZE_cache;
static int temps=1; // Va servir à garder une trace de l'ordre d'accès des messages
static int messages_alloues;
static int nb_msg_cache=0;
static int nb_corps=0;
static pthread_mutex_t mutex_messages=PTHREAD_MUTEX_INITIALIZER;

// Déclarations de trucs qui sont en bas.
message_t *trouver_message(int nunum);
message_t *ajouter_message_cache(char *dassault);


/* realloue_sibesoin

   Si besoin est, réalloue de la mémoire pour mettre les messages. Notons dès maintenant que leur nombre augmente toujours, car si on peut en supprimer le corps, on ne supprime jamais les en-têtes.

Ajout : en profite pour allouer la mémoire pour le message correspondant.
*/

static void realloue_sibesoin(int erim)
{
  if(nb_msg_cache==messages_alloues)
    {
      ZE_cache=realloc(ZE_cache,2*messages_alloues*sizeof(message_t *));
      memset(ZE_cache+messages_alloues,0,messages_alloues*sizeof(message_t *));
      messages_alloues*=2;
    }
  ZE_cache[erim]=calloc(1,sizeof(message_t));
}


/* faireplace_sibesoin

Incrémente nb_corps. Si besoin est, libère le corps du message dont la date d'accès est la plus ancienne. */

static void faireplace_sibesoin()
{
  int i,horreur,nullite=0;

  if(nb_corps<taille_cache)
    nb_corps++;
  else
    {
      horreur=INT_MAX;
      for(i=0;i<nb_msg_cache;i++)
	if(ZE_cache[i]->corps!=NULL && ZE_cache[i]->heure<horreur)
	  {
	    horreur=ZE_cache[i]->heure;
	    nullite=i;
	  }
      frite(ZE_cache[nullite]->corps);
      ZE_cache[nullite]->corps=NULL;
    }
}


/* freetmessage_sibesoin

   Après lecture, libère toutes les ressources d'un message si celui-ci n'est pas un vrai message avec un numéro et tout et tout. Renvoie 1 si on a fait quelque chose. */

int freetmessage_sibesoin(message_t *ramway)
{
  if(ramway==NULL || ramway->heure)
    return 0;
  frite(ramway->reponses);
  frite(ramway->auteur);
  frite(ramway->signe);
  frite(ramway->sujet);
  frite(ramway->date);
  frite(ramway->themes);
  frite(ramway->censure);
  frite(ramway->corps);
  frite(ramway);
  return 1;
}


/* marquer_lu

   Oh, je viens de lire un message. Faudrait peut-être voir à le faire savoir... */

void marquer_lu(message_t *ryptique, int mess_poste)
{
  int i,j,k;
  theme *t;
  message_t *rain;

  pthread_mutex_lock(&mutex_messages);
  if(freetmessage_sibesoin(ryptique) || ryptique==NULL)
    {
      pthread_mutex_unlock(&mutex_messages);
      return;
    }

  ryptique->lu=1;

  if(ryptique->numero>dernier_msg_lu && (mess_poste==0 || ryptique->numero==dernier_msg_lu+1 || ryptique->numero==message_courant+1))
    { // On ne prend en compte le message dans dernier_lu que si rien d'autre n'a été posté avant.
      dernier_msg_lu=ryptique->numero;
      ecrire_dernier_lu(dernier_msg_lu);
    }
  pthread_mutex_unlock(&mutex_messages);
  
  pthread_mutex_lock(&mutex_themes);
  for(i=0;i<ryptique->nbthemes;i++)
    {
      t=ryptique->themes[i];
      j=0;
      while(j<t->nb_mesg && t->messages[j]<=t->dernier_lu) j++;
      for(;;)
	{
	  if(j==t->nb_mesg || (rain=trouver_message(t->messages[j]))==NULL)
	    break;
	  if(lire_censure)
	    {
	      if(rain->lu==0)
		break;
	    }
	  else
	    {
	      for(k=0;k<rain->nbthemes;k++)
		if(rain->themes[k]==t)
		  break;
	      if(rain->censure[k]==0 && rain->lu==0)
		break;
	    }
	  
	  t->dernier_lu=t->messages[j++];
	}
    }
  ecrire_dinorc();
  pthread_mutex_unlock(&mutex_themes);
}


/* message_lu_dans_cache

Marquer un message comme lu, en ajoutant si besoin une entrée dans le cache. */

void message_lu_dans_cache(int egrale)
{
  char glo[BUFMSIZE];
  //  int i;
  
  sprintf(glo,"msg3 %i\n",egrale);
  marquer_lu(ajouter_message_cache(recup_commande(envoyer_commande(glo))),1);

}


/* ajouter_message_cache

Ajoute un message dans le cache, à partir des données retournées par le serveur. Fait un free sur ce qu'on lui donne, ça permet de l'utiliser directement avec recup_commande. 
Ne pas oublier ensuite de faire un themes_nouveau_message si besoin est.
*/

message_t *ajouter_message_cache(char *dassault) // (rires)
{
  int i,j,k,bloup;
  int nu;
  char *leclerc; // (ouaaaahhhahahahaaaa !!!)
  message_t *empo;

  leclerc=strstr(dassault,"\n|NUMB");
  if(leclerc==NULL)
    return NULL;
  leclerc+=7;
  sscanf(leclerc,"%i",&nu);
  
  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,_("Adding message %i to the cache\n"),nu);
      fflush(logfile);
    }

  pthread_mutex_lock(&mutex_messages);
  for(i=0;i<nb_msg_cache;i++)
    if(ZE_cache[i]->numero==nu)
      break;
  if(i==nb_msg_cache)
    {
      realloue_sibesoin(i);
      nb_msg_cache++;
      ZE_cache[i]->numero=nu;
    }

  empo=ZE_cache[i];

  empo->heure=temps++;

  if(empo->reponses==NULL)
    {
      leclerc=strstr(dassault,"\n|REPL");
      if(leclerc!=NULL)
	{
	  leclerc+=7;
	  j=0;
	  empo->reponses=malloc((MAXREPLYS+1)*sizeof(int));
	  while(leclerc[0]!='\n' && j<MAXREPLYS)
	    {
	      if(sscanf(leclerc,"%i",empo->reponses+j)==1)
		j++;
	      while(leclerc[0]!=' ' && leclerc[0]!='\n')
		leclerc++;
	      if(leclerc[0]==' ')
		leclerc++;
	    }
	  if(j>0)
	    {
	      empo->reponses[j]=0;
	      empo->reponses=realloc(empo->reponses,(j+1)*sizeof(int));
	    }
	  else
	    {
	      frite(empo->reponses);
	      empo->reponses=NULL;
	    }
	}
    }

  if(empo->charset==NULL)
    {
      leclerc=strstr(dassault,"\n|CHAR");
      if(leclerc==NULL)
	{
          empo->charset=strdup("ISO-8859-15");
        }
      else
        {
          leclerc+=7;
	  j=0;
	  while(leclerc[j]!='\n') j++;
	  empo->charset=malloc(j+1);
	  strncpy(empo->charset,leclerc,j);
	  empo->charset[j]=0;
          if (strcmp(empo->charset, "UTF8")==0
              || strcmp(empo->charset, "utf8")==0
              || strcmp(empo->charset, "utf-8")==0)
            {
              free(empo->charset);
              empo->charset=strdup("UTF-8");
            }
	}
    }

  iconv_t cd=(iconv_t) -1;
  if (strcmp(empo->charset, "UTF-8") == 0) {
    /* On va quand même vérifier l'encodage UTF-8 */
    cd = cd_utf8;
  } else if (strcmp(empo->charset, "ISO-8859-15")==0) {
    cd = cd_iso_8859_15;
  } else {
    cd = iconv_open("UTF-8//TRANSLIT", empo->charset);
    if (cd == (iconv_t) (-1))
      cd = iconv_open("UTF-8", empo->charset);
  }

  if(empo->auteur==NULL)
    {
      leclerc=strstr(dassault,"\n|AUTH")+7;
      j=0;
      while(leclerc[j]!='\n') j++;
      empo->auteur=malloc(j+1);
      j=strcpy_iconv_realloc(cd, &leclerc, j, &empo->auteur, 0, j, 1);
      empo->auteur[j]=0;
    }

  if(empo->signe==NULL)
    {
      leclerc=strstr(dassault,"\n|SIGN");
      if(leclerc!=NULL)
	{
	  leclerc+=7;
	  j=0;
	  while(leclerc[j]!='\n') j++;
	  empo->signe=malloc(j+1);
	  strncpy(empo->signe,leclerc,j);
	  empo->signe[j]=0;
	}
    }

  if(empo->sujet==NULL)
    {
      leclerc=strstr(dassault,"\n|SUBJ")+7;
      j=0;
      while(leclerc[j]!='\n') j++;
      if(j)
	{
	  empo->sujet=malloc(j+1);
          j=strcpy_iconv_realloc(cd, &leclerc, j, &empo->sujet, 0, j, 1);
	  empo->sujet[j]=0;
	}
      else
	empo->sujet=strdup(_("no subject"));
    }

  if(empo->date==NULL)
    {
      leclerc=strstr(dassault,"\n|DATE")+7;
      j=0;
      while(leclerc[j]!='\n') j++;
      empo->date=malloc(j+1);
      strncpy(empo->date,leclerc,j);
      empo->date[j]=0;
    }

  if(empo->nbthemes==0)
    {
      leclerc=strstr(dassault,"\n|THEM")+7;
      j=0;
      
      empo->themes=malloc(MAXREPLYS*sizeof(theme *));
      while(leclerc[0]!='\n' && j<MAXREPLYS)
	{
	  k=0;
	  while(leclerc[k]!=' ' && leclerc[k]!='\n') k++;
	  for(bloup=0;bloup<nbthemes;bloup++)
	    if(k==strlen(themes[bloup].nom) && strncmp(leclerc,themes[bloup].nom,k)==0)
	      {
		empo->themes[j]=themes+bloup;
		j++;
		break;
	      }
	  if(bloup==nbthemes) // Nouveau thème.
	    {
	      char amx30[BUFMSIZE];
	      strncpy(amx30,leclerc,k);
	      amx30[k]=0;
	      empo->themes[j++]=nouveau_theme(amx30); // ATTENTION AUX MUTEX RÉCURSIFS !!! ON VA BLOQUER mutex_themes LÀ-DEDANS !!!
	    }
	  leclerc+=k;
	  if(leclerc[0]==' ')
	    leclerc++;
	}
      empo->nbthemes=j;
      empo->themes=realloc(empo->themes,j*sizeof(theme *));
    }

  leclerc=strstr(dassault,"\n|TYPE:html");
  if(leclerc!=NULL)
    empo->html=1;

  // Reste à faire la censure
  if(empo->censure==NULL)
    empo->censure=malloc(empo->nbthemes*sizeof(int));
  memset(empo->censure,0,empo->nbthemes*sizeof(int));
  leclerc=strstr(dassault,"\n|CENS")+7;
  // On la refait à chaque fois, elle peut avoir changé.
  while(leclerc[0]!='\n')
    {
      k=0;
      while(leclerc[k]!=' ' && leclerc[k]!='@' && leclerc[k]!='#' && leclerc[k]!='\n') k++;
      for(j=0;j<empo->nbthemes;j++)
	if(strncmp(leclerc,empo->themes[j]->nom,k)==0)
	  {
	    if(leclerc[k]=='#' || (leclerc[k]=='@' && leclerc[k+1]=='@'))
	      {
		for(j=0;j<empo->nbthemes;j++)
		  empo->censure[j]=2; // Censuré par les administrateurs
		break;
	      }
	    else if(leclerc[k]=='@') // Par l'utilisateur
	      empo->censure[j]=1;
	    else
	      empo->censure[j]=3; // Par le modérateur
	  }
      leclerc+=k;
      while(leclerc[0]==' ' || leclerc[0]=='@' || leclerc[0]=='#') leclerc++;
    }

  if(empo->corps==NULL)
    {
      leclerc=strstr(dassault,"\n||");
      if(leclerc!=NULL)
	{
	  faireplace_sibesoin();
	  empo->corps=malloc(BUFSIZE);
	  j=0;
#if 0
          strcpy(empo->corps, empo->charset);
          j=strlen(empo->charset);
          empo->corps[j++]='\n';
#endif
	  while(leclerc!=NULL)
	    {
	      k=0;
	      leclerc+=3;
	      while(leclerc[k]!='\n') k++;
              j += strcpy_iconv_realloc(cd, &leclerc, k, &empo->corps, j, BUFSIZE-j, 0);
              empo->corps[j++]='\n';
	      if(!leclerc[0] || !leclerc[1] || !leclerc[2] || leclerc[1]=='#')
		leclerc=NULL;
	    }

	  empo->corps[j++]='\0';
	  empo->corps=realloc(empo->corps,j);
	}
    }

  if (cd != (iconv_t)(-1) && cd != cd_iso_8859_15 && cd != cd_utf8) {
    /* fermeture de la traduction si c'est une non standard */
    iconv_close(cd);
  }
  pthread_mutex_unlock(&mutex_messages);
  frite(dassault);
  quisera(empo->signe);

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,_("Message %i added\n"),nu);
      fflush(logfile);
    }

  return empo;
}


/* recup_message

   Renvoie un pointeur vers le message correspondant au numéro. Le corps du message doit être disponible. Si le serveur est indisponible, on renvoie NULL (ou un message sans corps si on dispose déjà des en-têtes), pour ne pas bloquer le thread principal.
 */

message_t *recup_message(int nunum)
{
  int i;
  char tampon[BUFMSIZE];
  message_t *blouc;

  if(nunum==-1)
    {
      blouc=calloc(1,sizeof(message_t));
      blouc->numero=-3;
      return blouc;
    }
  if(nunum>nb_messages || nunum<1)
    return NULL;

  pthread_mutex_lock(&mutex_messages);
  
  for(i=0;i<nb_msg_cache;i++)
    if(ZE_cache[i]->numero==nunum)
      break;
  
  if(i<nb_msg_cache)
    {
      ZE_cache[i]->heure=temps++;
      if(ZE_cache[i]->corps!=NULL)
	{
	  pthread_mutex_unlock(&mutex_messages);
	  return ZE_cache[i];
	}
    }
  pthread_mutex_unlock(&mutex_messages);
  sprintf(tampon,"msg3 %i\n",nunum);

  if(serveur_up)
    {
      blouc=ajouter_message_cache(recup_commande(envoyer_commande(tampon)));
      themes_nouveau_message(blouc,0);
      return blouc;
    }
  if(i<nb_msg_cache)
    return ZE_cache[i];
  blouc=calloc(1,sizeof(message_t));
  blouc->numero=nunum;
  return blouc;
}


/* trouver_message

   Renvoie un pointeur vers le message correspondant à un numéro.
   Si le message n'est pas dans la base de données, renvoie NULL. */

message_t *trouver_message(int nunum)
{
  int i;

  if(nunum==0)
    return NULL;

  pthread_mutex_lock(&mutex_messages);
  
  for(i=0;i<nb_msg_cache;i++)
    if(ZE_cache[i]->numero==nunum)
      break;
  
  if(i==nb_msg_cache)
    {
      pthread_mutex_unlock(&mutex_messages);
      return NULL;
    }
  ZE_cache[i]->heure=temps++;
  pthread_mutex_unlock(&mutex_messages);
  return ZE_cache[i];
}


int censure(message_t *hor, theme *aeiou)
{
  int i;
  char meur[BUFMSIZE];
  char *te=NULL;

  if(serveur_up==0 || hor==NULL || hor->numero<=0 || hor->censure==NULL)
    return 1;
  for(i=0;i<hor->nbthemes;i++)
    if(hor->themes[i]==aeiou)
      break;
  if(i==hor->nbthemes)
    {
      status_bar(_("What the hell is happening ?"),0);
      return 1;
    }
  if(hor->censure[i])
    {
      sprintf(meur,"libere %i %s\n",hor->numero,aeiou->nom);
      te=recup_commande(envoyer_commande(meur));
      if(te[0]=='E')
	status_bar(_("Unable to uncensor"),0);
      else
	{
	  sprintf(meur,_("Message %i uncensored"),hor->numero);
	  status_bar(meur,0);
	  hor->censure[i]=0;
	}
    }
  else
    {
      sprintf(meur,"censure %i %s\n",hor->numero,aeiou->nom);
      te=recup_commande(envoyer_commande(meur));
      if(te[0]=='E')
	status_bar(_("Unable to censor"),0);
      else
	{
	  sprintf(meur,_("Message %i censored"),hor->numero);
	  status_bar(meur,0);
	  if(hor->signe!=NULL && strcmp(hor->signe,login)==0)
	    hor->censure[i]=1;
	  else
	    hor->censure[i]=3;
	}
    }
  frite(te); // ho ho ho
  return 0;
}


void CacheMessages()
{
  int *elligent;
  int i,j;
  int ra, muros;
  int er, villes;
  char gement[BUFMSIZE];
  message_t *rou;

  //init_signaux();

  messages_alloues=taille_cache;
  ZE_cache=calloc(taille_cache,sizeof(message_t *));

  elligent=calloc(read_ahead_blk,sizeof(int));



  for(;;)
    {
      i=0;
      j=0;
      ra=message_courant;
      muros=theme_courant;
      er=muros;
      villes=0;
      if(sens_lecture==9 || sens_lecture==0)
	sens_lecture=9-sens_lecture;
      while(i<read_ahead_blk && j<read_ahead_max)
	{
	  if(ra==0 || ra>nb_messages || (villes && er==muros))
	    break;  // N'a plus rien.
	  if((rou=trouver_message(ra))==NULL || rou->corps==NULL)
	    { // Faut le récupérer.
	      sprintf(gement,"msg3 %i\n",ra);
	      elligent[i++]=envoyer_commande(gement);
	    }
	  j++;
	  
	  // On avance d'un message
	  switch(sens_lecture)
	    {
	    case 0:
	    case 1:
	      ra=ra+1;
	      if(ra>nb_messages)
		ra=0;
	      break;
	    case -1:
	      ra=ra-1;
	      if(ra<1)
		ra=0;
	      break;
	    case 2:
	      ra=message_suivant_alire(ra,themes+er,1);
	      break;
	    case -2:
	      ra=message_precedent_alire(ra,themes+er,1);
	      break;
	    case 9:
	    case 10:
	    default:
	      ra=message_suivant_absolu(ra,&er,1);
	      if(er!=muros)
		villes=1;
	      break;
	    }
	}
      for(j=0;j<i;j++)
	themes_nouveau_message(ajouter_message_cache(recup_commande(elligent[j])),0);
#ifdef HAVE_NANOSLEEP
      nanosleep(une_seconde,NULL);
#else
      sleep(1);
#endif
    }
}

