/* commandes.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ncurses.h>
#include <libintl.h>
#include "defs.h"
#include "interface.h"
#include "serveur.h"
#include "noms.h"
#include "init.h"

void date_serveur()
{
  char *tata;
  if(serveur_up)
    {
      tata=recup_commande(envoyer_commande("date\n"));
      status_bar(tata+6,0);
      frite(tata);
    }
  else
    mybeep();
}

void bidous_bidous(message_t *mess)
{
  char *tata;
  char toto[BUFMSIZE];
  if(serveur_up)
    {
      if(mess!=NULL && mess->signe!=NULL)
	tata=mess->signe;
      else
	tata=login_aleatoire();
      if(mess!=NULL && mess->numero>0 && mess->signe!=NULL)
	sprintf(toto,"bidou-bidou %s %i\n",tata,mess->numero);
      else
	sprintf(toto,"bidou-bidou %s\n",tata);
      tata=recup_commande(envoyer_commande(toto));
      if(tata[0]=='E')
	status_bar(_("Error"),0);
      else
	status_bar(_("Bidou-bidous sent !"),0);
      frite(tata);
    }
  else
    mybeep();
}

void changer_type()
{
  defaut_type++;
  if(defaut_type>2)
    defaut_type=0;
  status_bar(defaut_type?((defaut_type==1)?_("HTML format, with checking"):_("Basic text format")):_("Pure HTML format (be CAREFUL)"),0);
}


/* nombre_lignes

Retourne le nombre de lignes du corps de message texte.
texte DOIT être non NULL.
 */

int nombre_lignes(char *texte)
{
  int i,nblignes=0,
    c=0,alacon=0,temp=0;
  
  for(i=0;texte[i];i++)
    switch(texte[i])
	{
	case '\n':
	  c=0;
	  nblignes++;
	  break;
	case '<':
	  alacon=1;
	  break;
	case '&':
	  if(alacon==0)
	    temp=1;
	  break;
	case '\t':
	  c+=7-(c%8);
	default:
	  if(texte[i]==';' && temp)
	    temp=0;
	  if(!alacon && !temp && affichable(texte[i]))
	    c++;
	  if(texte[i]=='>' && alacon)
	    alacon=0;
	  if(c>COLS-1)
	    {
	      c=0;
	      nblignes++;
	    }
	}
  return nblignes;
}


/* texte_numero

Renvoie le texte à placer en haut à gauche (numéro du message) dans le pager. */

char *texte_numero(message_t *mess)
{
  if(mess==NULL)
    return(strdup(_("Error")));
  switch(mess->numero)
    {
    case 0:
      return(strdup(_("End of the theme")));
      break;
    case -1:
      return(strdup(_("List of the themes")));
      break;
    case -2:
      return(strdup(_("Server command")));
      break;
    case -3:
      return(strdup(_("Error")));
      break;
    case -4:
      return(strdup(_("Finished")));
      break;
    case -5:
      return(strdup(_("List of users")));
      break;
    case -6:
      return(strdup(_("Help on the commands")));
      break;
    default:
      {
	char *tinier;
	tinier=malloc(BUFMSIZE);
	sprintf(tinier,_("Message %i"),mess->numero);
	return tinier;
      }
    }
}

