/* conv.h

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#ifndef CONV_H
#define CONV_H

#include "config.h"
extern char *conversion(const char *entree,int type,int rep);

#ifdef HAVE_ICONV
#include <iconv.h>
extern iconv_t scribus,subircs,cd_iso_8859_15,cd_utf8;
extern size_t scribuser(const char *ga, size_t bu, char *zo, size_t meu);
extern size_t subircser(const char *ga, size_t bu, char *zo, size_t meu);
extern size_t strcpy_iconv_realloc(iconv_t cd, char**from, size_t inlength,
                            char **to, size_t skip, size_t outlength, size_t offset);
extern void amen(void);
#else
typedef void* iconv_t;
#define cd_iso_8859_15 ((iconv_t)(-1))
#define cd_utf8 ((iconv_t)(-1))
#define iconv_open(from,to) ((iconv_t)(-1))
#define iconv_close(cd) (0)
#define strcpy_iconv_realloc(cd, from, inlength, to, skip, outlength, offset) \
  strcpy_noiconv_realloc(cd, from, inlength, to, skip, outlength, offset)
#endif

static inline
size_t strcpy_noiconv_realloc(iconv_t cd, char**from, size_t inlength,
                            char **to, size_t skip, size_t outlength, size_t offset) {
  strncpy((*to)+skip, *from, inlength);
  (*from) += inlength;
  return inlength;
}
#endif /* CONV_H */
