// #define VERSION "2.1.1"

/* defs.h

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/


#include "config.h"

#define LONGMAXNOMFICH 1024
#define NMAXARGS 8 /* Nombre maximal d'arguments pour l'éditeur et le browser (commande et nom du fichier inclus) */

#define BUFSIZE 65536 /* Gros buffer (taille limite du message) */
#define BUFMSIZE 512 /* Petit buffer */

#define DINO2_DIR ".dino2" /* Le répertoire depuis le HOME où on trouve les fichiers (defaults, plugins...) */
// #define DINO2_DEFS_DIR "@sysconfdir@/dino2" /* Le répertoire où dino2 cherche les fichiers de configuration globaux */
// #define FICHIER_AIDE "@datadir@/dino2/aide.html" // Chemin complet du fichier d'aide.
#define FICHIER_DINORC ".dinorc" /* Le chemin du dinorc à partir du HOME. */
#define PORT_DEFAUT "4030" /* C'est explicite je trouve */
#define EDITEUR_DEFAUT "pico"
#define BROWSER_DEFAUT "lynx"
#define REPONSE_DEFAUT ">>> %a a écrit :"

#define TAILLEMINPILE 20
#define MAXREPLYS 20 // Définit aussi le nombre max de thèmes où on peut poster.
#define DELAI_STATUS_BAR 5 // Temps en seconde au bout duquel on efface la barre de statut

// Ces 3 valeurs sont à considérer par défaut :
#define CACHE_DEFAUT 200 // Taille par défaut du cache.
#define READ_AHEAD_BLK 3 // Taille des blocs de lecture par avance des messages
#define READ_AHEAD_MAX 10 // Nombre de messages à lire par avance au maximum.


#define MAX_THEMES 1024 // Ne prend de la mémoire qu'à l'initialisation, sans importance donc.
#define MAX_NVX_THEMES 8 // Nombre maximal de thèmes pouvant être créés au cours de l'exécution.

#define MAX_SIMULT_COMMANDES 512 // Combien de commandes je laisse en vol ?
// 256 me paraît raisonnable, mais par sécurité je mets 512.
// Il faut bien vérifier qu'EN AUCUN CAS la somme de tout ce que peuvent envoyer simultanément les threads sans le récupérer ne peut pas excéder ça, sinon le programme va se bloquer sur un sémaphore. Sachant que le thread principal peut envoyer 2 instructions par thème, ça limite grossièrement à 200 thèmes (à moins que je rajoute une fonction de limitation au moment de l'initialisation).

// Déboguage
#define LOGFILE "dino.log"
#define LOGFILE_OLD "dino.log.old"


#define affichable(x) (((x)>31 && (x)<127) || ((x)>= 128))
#define COUL(A) (((couleur)?(COLOR_PAIR(A)):(0)))

// Touches (j'ai pas tout compris)

#define CONTROL_L 12
#define CONTROL_K 11
#define CONTROL_U 21
#define CONTROL_G 7
#define ESCAPE 27
#define HOME2 362
#define END2 385

#define MBACKSPACE 8
#define MDELETE 127


// Libération plus propre de la mémoire
#define frite(x) if((x)!=NULL) free(x)

// Idem pour strdup
#define strbleurp(x) ((x)==NULL?NULL:strdup(x))

//#ifdef PTHREAD_MUTEX_RECURSIVE_NP
//#define PTHREAD_MUTEX_RECURSIVE PTHREAD_MUTEX_RECURSIVE_NP
//#endif


#define _(String) gettext(String)
#define _n(String,Stringplur,n) ngettext(String,Stringplur,n)


// Structures

typedef struct
{
  char *argus[NMAXARGS];
  int nbarg;
  int asynchrone;
  int virerstdout;
  char *fichier_sortie;
} extern_t;

typedef struct
{
  char *nom;
  char *infos;
  int abonne;
  int dernier_lu;
  int dernier_msg;
  int nb_mesg;
  int *messages;
  int nbms_alloc;
} theme;

typedef struct
{
  int numero;  /*  0, fin du thème
		  -1, liste des thèmes
		  -2, sortie du serveur
		  -3, numéro de message indisponible
	          -4, vous avez tout lu
                  -5, liste des utilisateurs
                  -6, aide   */
  int lu;
  int heure; // Moment du dernier accès au message, 0 s'il est malloué.
  int html;
  int *reponses; // Terminé par un 0, NULL s'il n'y en a pas.
  char *auteur;
  char *signe; // Login du posteur, pas le nom. NULL si non signé.
  char *sujet;
  char *date;
  char *charset;
  int nbthemes;
  theme **themes;
  int *censure; // Pour chaque thème : 1 par auteur, 2 par admin, 3 par modérateur
  char *corps;
} message_t;


// Énumération des fonctions

enum {
  F_NONE = 0,

  // Aller directement au message (laisser au début)
  F_1,
  F_2,
  F_3,
  F_4,
  F_5,
  F_6,
  F_7,
  F_8,
  F_9,

  // Fonctions intégrées du pager
  F_NPAGE_OR_NMESS,
  F_REDRAW,
  F_LAUNCHBROWSER,
  F_BEGINNING,
  F_END,
  F_PPAGE,
  F_NPAGE,
  F_PLINE,
  F_NLINE,

  // Gestion des piles
  F_CHANGE_STACK,
  F_PUSH_YSTACK,
  F_PUSH_BSTACK,
  F_POP_YSTACK,
  F_POP_BSTACK,
  F_RIGHT_ROLL,
  F_LEFT_ROLL,
  F_REVERSE_STACK,
  F_STACK_DROP,
  F_GOTO_REF_Y,
  F_GOTO_REF_B,

  // Changement de message
  F_PREV_MSG,
  F_NEXT_MSG,
  F_LAST_MSG,
  F_LAST_READ_MSG,
  F_PREV_IN_THEME,
  F_NEXT_IN_THEME,

  // Gestion des thèmes
  F_CHANGE_THEME,
  F_LIST_THEMES,
  F_LIST_ALL_THEMES,
  F_TOGGLE_SUBSCRIBE,
  F_MARK_READ,
  F_MARK_ALL_READ,

  // Composition
  F_PUSH_REPLY,
  F_REPLY,
  F_FAST_REPLY,
  F_NEW_MESSAGE,
  F_MAIL_REPLY,

  // Censure
  F_TOGGLE_READCENS,
  F_CENSOR,
  F_FILTER,

  // Commandes diverses
  F_SERVER_DATE,
  F_SERVER_COMMAND,
  F_BIDOU_BIDOU,
  F_CHANGE_MSG_TYPE,
  F_HELP,
  F_APPLY_FILTER,
  F_LIST_USERS,
  F_DISCONNECT,
  F_QUIT,
  F_FAST_QUIT,

  // À laisser à la fin
  FUNCTIONS_NUMBER
};
