/* externe.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/


#include "defs.h"

#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_ICONV
#include <limits.h>
#include <iconv.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <libintl.h>


#include "interface.h"
#include "init.h"
#include "main.h"
#include "conv.h"

pid_t pid_fils=0;



extern_t *separ_argus(char *donnay)
{
  extern_t *blop;
  int i,k;

  blop=calloc(1,sizeof(extern_t));
  blop->nbarg=1;
  blop->asynchrone=0;
  blop->virerstdout=0;
  blop->fichier_sortie=NULL;
  blop->argus[0]=donnay;
  for(i=0; donnay[i] ; i++)
    {
      if((donnay[i]=='\\') && donnay[i+1])
	{
	  for(k=i;donnay[k];k++)
	    donnay[k]=donnay[k+1];
	  i++;
	  if(donnay[i]==0)
	    break;
	}
      if((donnay[i]==' ') || (donnay[i]=='\t'))
	{
	  donnay[i++]=0;
	  while((donnay[i]==' ') || (donnay[i]=='\t'))
	    i++;
	  if((donnay[i]==0)||(blop->nbarg>NMAXARGS-2))
	    break;
	  if(donnay[i]=='&')
	    {
	      blop->asynchrone=1;
	      break;
	    }
	  blop->argus[blop->nbarg++]=donnay+i;
	}
      else if(donnay[i]=='&')
	{
	  donnay[i]=0;
	  blop->asynchrone=1;
	  break;
	}
      else if(donnay[i]=='>')
	{
	  donnay[i++]=0;
	  while((donnay[i]==' ') || (donnay[i]=='\t') || (donnay[i]=='>'))
	    i++;
	  if(donnay[i]==0 || donnay[i]=='&')
	    i--;
	  else
	    blop->fichier_sortie=donnay+i;
	}
    }
  
  return blop;
}


int lancer_externe(extern_t *erni,char *argu_supp,const char *texte_entree, char *texte_sortie)
{
  int toto,fd_stdin=0,fd_stdout=0;
  FILE *flux_in=NULL;
  FILE *flux_out;
  char *chaine1=NULL;
  char *chaine2=NULL;

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Appel externe\n");
      fflush(logfile);
    }

  if(texte_entree!=NULL || texte_sortie!=NULL || erni->fichier_sortie!=NULL)
    erni->asynchrone=0;

  if(erni->asynchrone==0 && texte_sortie==NULL)
    effacer_ecran();

  if(texte_entree!=NULL)
    {
#ifdef __CYGWIN__
      fd_stdin=mkstemp(chaine1=strdup("_d2trans_XXXXXX"));
#else
      fd_stdin=mkstemp(chaine1=strdup("/tmp/d2trans_XXXXXX"));
#endif
      flux_in=fdopen(fd_stdin,"w+");
#ifdef HAVE_ICONV
      if (subircs!=(iconv_t)(-1)) {
	size_t beaucoup = strlen(texte_entree);
	char *out = malloc(beaucoup*4*MB_CUR_MAX+1);
	size_t encoreplus = subircser(texte_entree,strlen(texte_entree),out,beaucoup*4*MB_CUR_MAX);
	out[encoreplus] = 0;
	fwrite(out,1,encoreplus+1,flux_in);
	frite(out);
      } else
#endif
      fwrite(texte_entree,strlen(texte_entree)+1,1,flux_in);
      rewind(flux_in);
    }

  if(texte_sortie!=NULL || erni->fichier_sortie!=NULL)
    {
#ifdef __CYGWIN__
      fd_stdout=mkstemp(chaine2=strdup("_d2trans_XXXXXX"));
#else
      fd_stdout=mkstemp(chaine2=strdup("/tmp/d2trans_XXXXXX"));
#endif
    }

  if((pid_fils=fork())==0)
    {
      if(argu_supp!=NULL)
	{
	  erni->argus[erni->nbarg++]=argu_supp;
	  erni->argus[erni->nbarg]=NULL;
	}
      if(debug & DEBUG_DEFAULT)
	{
	  for(toto=0;erni->argus[toto];toto++)
	    fprintf(logfile," Argument %i : %s\n",toto,erni->argus[toto]);
	  fflush(logfile);
	}
      if(erni->virerstdout)
	{
	  toto=open("/dev/null",O_WRONLY);
	  dup2(toto,2);
	  close(toto);
	}
      if(fd_stdin)
	{
	  dup2(fd_stdin,STDIN_FILENO);
	  close(fd_stdin);
	}
      if(fd_stdout)
	{
	  dup2(fd_stdout,STDOUT_FILENO);
	  close(fd_stdout);
	}
      umask(077);
      execvp(erni->argus[0],erni->argus);
      //      perror("execvp");
      quitte(-1,_("Launching error."));
    }
  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Pid du fils : %i\n",(int)pid_fils);
      fflush(logfile);
    }

  if(erni->asynchrone==0)
    while(waitpid(pid_fils,&toto,0)<0);
  
  pid_fils=0;

  if(fd_stdin)
    {
      fclose(flux_in);
      remove(chaine1);
      frite(chaine1);
    }

  if(fd_stdout)
    {
      char leclerc[BUFSIZE*MB_CUR_MAX];
      int len;
      
      flux_out=fdopen(fd_stdout,"r+");
      rewind(flux_out);
      len=fread(leclerc,1,BUFSIZE*MB_CUR_MAX-1,flux_out);
      leclerc[len]=0;
      len=strlen(leclerc);
      fclose(flux_out);
      remove(chaine2);
      frite(chaine2);
      if(erni->fichier_sortie!=NULL)
	{
	  FILE *zobi;
	  if((zobi=fopen(erni->fichier_sortie,"a"))!=NULL)
	    {
	      fprintf(zobi,"%s\n",leclerc);
	      fclose(zobi);
	    }
	}
#ifdef HAVE_ICONV
      if (scribus!=(iconv_t)(-1)) {
	char out[BUFSIZE];
	size_t done = scribuser(leclerc,len,out,BUFSIZE);
	memcpy(leclerc,out,done);
	leclerc[done]=0;
      }
#endif
      if(texte_sortie!=NULL)
	{
	  strcpy(texte_sortie,leclerc);
	}
    }
  
  if(erni->asynchrone==0 && texte_sortie==NULL)
    init_ecran();
  
  if(WEXITSTATUS(toto))
    {
      status_bar(_("Error in an external process."),0);
      return 1;
    }
  return 0;
}

message_t *message_dans_tube(message_t *original,const char *commande)
{
  extern_t *rain;
  message_t *grouik;
  int egrale=0;
  char *trouduc;
  char *troudbal;
  char *fion;

  grouik=calloc(1,sizeof(message_t));
  grouik->numero=original->numero;
  if(original->reponses!=NULL)
    {
      while(original->reponses[egrale++]);
      grouik->reponses=malloc(egrale*sizeof(int));
      memcpy(grouik->reponses,original->reponses,egrale*sizeof(int));
    }
  grouik->auteur=strbleurp(original->auteur);
  grouik->signe=strbleurp(original->signe);
  grouik->date=strbleurp(original->date);
  grouik->html=1;
  grouik->sujet=strbleurp(original->sujet);
  grouik->nbthemes=original->nbthemes;
  grouik->themes=malloc(grouik->nbthemes*sizeof(theme *));
  memcpy(grouik->themes,original->themes,grouik->nbthemes*sizeof(theme *));
  grouik->censure=malloc(grouik->nbthemes*sizeof(int));
  memcpy(grouik->censure,original->censure,grouik->nbthemes*sizeof(int));
  
  trouduc=strdup(commande);
  rain=separ_argus(trouduc);
  rain->asynchrone=0;

  if(original->corps==NULL)
    troudbal=strdup(" \n");
  else
    troudbal=conversion(original->corps,2*original->html,0);
  fion=malloc(BUFSIZE);
  if(lancer_externe(rain,NULL,troudbal,fion))
    {
      frite(fion);
      fion=strdup(_("Sorry, filtering failed.\n"));
    }
  frite(rain);
  frite(troudbal);
  frite(trouduc);

  grouik->corps=conversion(fion,-2,0);
  frite(fion);
  return grouik;
}
