/* init.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <termios.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <libintl.h>
#include <string.h>
#include "config.h"

#include "defs.h"
#ifdef HAVE_ICONV
#include <limits.h>
#include <iconv.h>
#include "conv.h"
#endif
#include "externe.h"
#include "touches.h"
#include "main.h"


char *hote=NULL;
char *login=NULL;
char *motdepasse=NULL;
char *nickname=NULL;
char **serveurs=NULL;
char *port=PORT_DEFAUT;
int defaut_signe=0;
int couleur=1;
int sousx=0;
int login_anonyme=0;
char *editeur=NULL;
extern_t *editeeur;
char *browser=NULL;
extern_t *browseer;
char *dinorc_file;
char *repoonse=NULL;
int lire_censure=0;
int taille_cache=CACHE_DEFAUT;
int read_ahead_blk=READ_AHEAD_BLK;
int read_ahead_max=READ_AHEAD_MAX;
int frequence_reconnexion=10;
int timeout_complet=60;
int coolitude=0;
int debug=0;
int defaut_type=1; // 0 = texte brut, 1 = HTML avec vérification, 2 = HTML brut.
int termpourri=0;
int enable_killallfred=0;

#ifdef HAVE_NANOSLEEP
struct timespec *une_seconde;
#endif

/* Une fonction à la con */

static void prchar(char c) 
{
  write(1,&c,1);
}

/**************** readpass ****************
 *                                        *
 * Demande un mot de passe, en affichant  *
 * prompt, et l'enregistre dans pass.     *
 *                                        *
 ******************************************/

static void readpass(char *prompt,char *pass)
{
  struct termios ter,oter;
  int c;
  int ind=0;
  tcgetattr(0,&ter);
  oter=ter;
  ter.c_lflag &= ~ECHO;
  ter.c_lflag &= ~ICANON;
  ter.c_oflag &= ~ONLCR;
#ifdef OCRNL
  ter.c_oflag &= ~OCRNL;
#endif
#ifdef ONLRET
  ter.c_oflag &= ~ONLRET;
#endif
  ter.c_cc[VMIN]=1;
  ter.c_cc[VTIME]=0;
  tcsetattr(0,TCSANOW,&ter);
 
  printf("%s", prompt);
  
  while(1)
    {
      c=getchar();
      if (c==EOF)
        exit(-1);
      if (c=='\n')
        {
          pass[ind]=0;
          break;
        }
      if (ind && (c==oter.c_cc[VERASE] || c==8))
        {
          ind--;
          if (oter.c_lflag & ECHOE)
            {
              write(1,"\b \b",3);
            }
          else
            prchar('\b');
        }
      else if(ind<8 && c>=' ' && c!=oter.c_cc[VERASE])
        {
          pass[ind++]=c;
          prchar('*');
        }
    }
  write(1,"\n\r",2);
  tcsetattr(0,TCSANOW,&oter);
}


/********* lire_fichier_config *********
 *                                     *
 * Si fichier_a_lire existe, lit les   *
 * paramètres de configuration dedans. *
 * Sinon, renvoie -1.                  *
 *                                     *
 ***************************************/

static int lire_fichier_config(char *fichier_a_lire)
{
  FILE *fichier;
  char champ1[BUFMSIZE];
  char *champ2;
  int erreur=0;
  int grou;
  int gneu;

  fichier=fopen(fichier_a_lire,"r");
  if(fichier==NULL)
    return -1;
  while(fgets(champ1,BUFMSIZE-1,fichier) != NULL)
  {
    gneu=0;
    grou=0;
    if(champ1[grou]!='#')
      {
	while(gneu==0)
	  switch(champ1[grou])
	    {
	    case ':' :
	    case ' ' :
	      gneu=1;
	      break;
	    case '\r' :
	    case '\n' :
	    case '\0' :
	      gneu=2;
	      break;
	    default :
	      grou++;
	    }
	if(gneu==1)
	  {
	    champ1[grou++]='\0';
	    while((champ1[grou]==':')||(champ1[grou]==' '))
	      grou++;
	    champ2=champ1+grou;
	    grou=0;
	    while((champ2[grou]!='\0')&&(champ2[grou]!='\n')&&(champ2[grou]!='\r'))
	      grou++;
	    champ2[grou]='\0';
	    if(strcmp(champ1,"login")==0)
	      {
		frite(login);
		login=malloc(grou+1);
		strcpy(login,champ2);
	      }
	    else if(strcmp(champ1,"password")==0)
	      {
		frite(motdepasse);
		motdepasse=malloc(grou+1);
		strcpy(motdepasse,champ2);
	      }
	    else if(strcmp(champ1,"nick")==0)
	      {
		frite(nickname);
		nickname=malloc(grou+1);
		strcpy(nickname,champ2);
	      }
	    else if(strcmp(champ1,"serveur")==0 || strcmp(champ1,"server")==0)
	      {
		int erimaire=0;
		char *labruni;

		frite(serveurs);
		serveurs=malloc(NMAXARGS*sizeof(char *));
		  // J'ai pris NMAXARGS, car sa valeur est raisonnable.
		while(champ2[0]!=0 && erimaire<NMAXARGS-1)
		  {
		    labruni=index(champ2,':');
		    if(labruni==NULL) labruni=index(champ2,'\0');
		    if(labruni!=champ2)
		      {
			serveurs[erimaire]=malloc(labruni-champ2+1);
			strncpy(serveurs[erimaire],champ2,labruni-champ2);
			serveurs[erimaire][labruni-champ2]=0;
			erimaire++;
		      }
		    champ2=labruni+1;
		  }
		serveurs[erimaire]=NULL;
		if(erimaire==0)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"editeur")==0 || strcmp(champ1,"editor")==0)
	      {
		frite(editeur);
		editeur=malloc(grou+1);
		strcpy(editeur,champ2);
	      }
	    else if(strcmp(champ1,"browser")==0)
	      {
		frite(browser);
		browser=malloc(grou+1);
		strcpy(browser,champ2);
	      }
	    else if(strcmp(champ1,"reponse")==0 || strcmp(champ1,"reply")==0)
	      {
		frite(repoonse);
		repoonse=malloc(grou+1);
		strcpy(repoonse,champ2);
	      }
	    else if(strcmp(champ1,"type")==0)
	      {
		if(sscanf(champ2,"%i",&defaut_type)!=1 || defaut_type > 2)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    defaut_type=1;
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"reconnexion")==0 || strcmp(champ1,"reconnection")==0)
	      {
		if(sscanf(champ2,"%i",&frequence_reconnexion)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"timeout")==0)
	      {
		if(sscanf(champ2,"%i",&timeout_complet)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"taille_cache")==0 || strcmp(champ1,"cache_size")==0)
	      {
		if(sscanf(champ2,"%i",&taille_cache)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"bloc_paravance")==0 || strcmp(champ1,"readahead_block")==0)
	      {
		if(sscanf(champ2,"%i",&read_ahead_blk)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"max_paravance")==0 || strcmp(champ1,"readahead_max")==0)
	      {
		if(sscanf(champ2,"%i",&read_ahead_max)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"defaut_signe")==0 || strcmp(champ1,"sign_default")==0)
	      {
		if(sscanf(champ2,"%i",&defaut_signe)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"cache")==0)
	      {
		if(sscanf(champ2,"%i",&login_anonyme)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"lire_censure")==0 || strcmp(champ1,"read_censored")==0)
	      {
		if(sscanf(champ2,"%i",&lire_censure)!=1)
		  {

		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else if(strcmp(champ1,"port")==0)
	      {
		port = strdup(champ2);
	      }
	    else if(strcmp(champ1,"filter")==0)
	      {
		if(sscanf(champ2,"%i",&enable_killallfred)!=1)
		  {
		    printf(_("%s : invalid %s field\n"),fichier_a_lire,champ1);
		    erreur++;
		  }
	      }
	    else
	      {
		printf(_("%s : unrecognized %s field\n"),fichier_a_lire,champ1);
		erreur++;
	      }
	  }
      }
  }
  fclose(fichier);
  return erreur;
}

/*************** DinoInit ***************
 *                                      *
 * Initialisation de ce qui est initia- *
 * lisable, en utilisant les arguments  *
 *                                      *
 ***************************************/

int DinoInit(int argc, char **argv)
{
  char config_file[LONGMAXNOMFICH];
  int erreur=0;
  char petite_fleur_bleue[BUFMSIZE];
  int coquelicot_des_pres,i,j;
  int demandermdp=0;

#ifdef HAVE_NANOSLEEP
  une_seconde=malloc(sizeof(struct timespec));
  une_seconde->tv_sec=1;
  une_seconde->tv_nsec=0;
#endif

#ifdef HAVE_GETHOSTNAME
  if( gethostname(petite_fleur_bleue,BUFMSIZE) < 0 )
    {
      perror("gethostname");
      return -2;
    }
#else
  petite_fleur_bleue="localhost";
#endif

  hote=strdup(petite_fleur_bleue);
  srandom(time(NULL));

  sprintf(config_file,"%s/config",DINO2_DEFS_DIR); // Lecture du fichier
  lire_fichier_config(config_file);                // de config globale

  sprintf(config_file,"%s/%s",getenv("HOME"),DINO2_DIR);

  { /* initialize debug depuis la variable d'environnement.
     * Si DINO2_DEBUG ne contient pas de nombre, atoi renvoie 0
     */
    char* d=getenv("DINO2_DEBUG");
    if (d) {
      debug=atoi(d);
    }
  }

#ifdef HAVE_MKDIR
  mkdir(config_file,0700); // On crée le répertoire s'il n'existe pas, en mode parano s'il vous plaît.
#endif

  sprintf(config_file,"%s/%s/config",getenv("HOME"),DINO2_DIR); // config perso
  if( (coquelicot_des_pres=lire_fichier_config(config_file))!=0 )
    {
      erreur++;
      if(coquelicot_des_pres<0)
	printf(_("Warning : configuration file not found.\nYou should create it in ~/%s/config, with paranoid permissions.\n"),DINO2_DIR);
    }

    while(argc>1)
    {
      if(strcmp(argv[1],"-color")==0)
	{
	  argc--;
	  argv++;
	}
      else if(strcmp(argv[1],"-nocolor")==0)
	{
	  argc--;
	  argv++;
	  couleur=0;
	}
      else if(strcmp(argv[1],"-x")==0)
	{
	  argc--;
	  argv++;
	  sousx++;
	}
      else if(strcmp(argv[1],"-badterm")==0)
	{
	  argc--;
	  argv++;
	  termpourri++;
	}
      else if(strcmp(argv[1],"-concombre")==0)
	{
	  argc--;
	  argv++;
	  coolitude++;
	}
      else if(strcmp(argv[1],"-signe")==0 || strcmp(argv[1],"-sign")==0)
	{
	  argc--;
	  argv++;
	  defaut_signe++;
	}
      else if(strcmp(argv[1],"-cache")==0 || strcmp(argv[1],"-hidden")==0)
	{
	  argc--;
	  argv++;
	  login_anonyme++;
	}
      else if(strcmp(argv[1],"-debug")==0)
	{
	  argc--;
	  argv++;
	  debug++;
	}
      else if(strcmp(argv[1],"-filter")==0)
	{
	  argc--;
	  argv++;
	  enable_killallfred++;
	}
      else if(strcmp(argv[1],"-login")==0)
	{
	  argc--;
	  argv++;
	  if(argc>1)
	    {
	      frite(login);
	      login=argv[1];
	      argc--;
	      argv++;
	      demandermdp++;
	    }
	  else
	    {
	      erreur++;
	      printf(_("Warning : the %s option requires an argument.\n"),argv[0]);
	    }
	}
      else if(strcmp(argv[1],"-nick")==0)
	{
	  argc--;
	  argv++;
	  if(argc>1)
	    {
	      frite(nickname);
	      nickname=argv[1];
	      argc--;
	      argv++;
	    }
	  else
	    {
	      erreur++;
	      printf(_("Warning : the %s option requires an argument.\n"),argv[0]);
	    }
	}
      else break;
    }


  if(login==NULL)
    if((login=getenv("DINO_LOGIN"))==NULL)
      if((login=getenv("OEUF_NAME"))==NULL)
	{
	  printf(_("%s not found. Please put it in ~/%s/config\n"),_("Login"),DINO2_DIR);
	  return -1;
	}

  if(argc>1)
    {
      frite(serveurs);
      serveurs=malloc(NMAXARGS*sizeof(char *));
      serveurs[0]=argv[1];
      serveurs[1]=NULL;
      if(argc>2)
	port=strdup(argv[2]);
    }
  else if(serveurs==NULL)
    {
      char *serveur;
      if((serveur=getenv("DINO_SERV"))==NULL)
	if((serveur=getenv("OEUF_SERV"))==NULL)
	  {
	    printf(_("%s not found. Please put it in ~/%s/config\n"),_("Server name"),DINO2_DIR);
	    return -1;
	  }
      serveurs=malloc(NMAXARGS*sizeof(char *));
      serveurs[0]=serveur;
      serveurs[1]=NULL;
    }
  else
    {
      j=0;
      while(serveurs[j]!=NULL)
	{
	  i=strlen(serveurs[j])-1;
	  while(serveurs[j][i]==' ')
	    serveurs[j][i--]=0;
	  j++;
	}
    }

  if(demandermdp || (motdepasse==NULL && (motdepasse=getenv("DINO_PASS"))==NULL && (motdepasse=getenv("OEUF_PASS"))==NULL))
	{
	  erreur=0;
	  printf(_("Password for %s@%s :"),login,serveurs[0]);
	  fflush(stdout);
	  frite(motdepasse);
	  motdepasse=malloc(BUFMSIZE);
	  readpass(" ",motdepasse);
	  motdepasse=realloc(motdepasse,strlen(motdepasse)+1);
	}
  if(nickname==NULL)
    if((nickname=getenv("DINO_NICK"))==NULL)
      {
	printf(_("%s not found. You can put it in ~/%s/config\n"),_("Nickname"),DINO2_DIR);
	nickname=login;
      }

#ifdef HAVE_ICONV
  if(scribus!=(iconv_t)(-1)) {
    int nickla = strlen(nickname);
    char nicktam[4*nickla+1];
    nicktam[scribuser(nickname,nickla,nicktam,4*nickla)]=0;
    /* fuite mémoire de l'ancien nickname ici */
    nickname=strdup(nicktam);
  }
#endif

  if(repoonse==NULL) {
#ifdef HAVE_ICONV
    if (subircs!=(iconv_t)(-1)) {
      char repin[] = REPONSE_DEFAUT;
      size_t si = sizeof(repin)-1, so = 4*MB_CUR_MAX*si;
      char repout[so+1];
      repout[subircser(repin,si,repout,so)] = 0;
      repoonse = strdup(repout);
    } else
#endif
    repoonse=strdup(REPONSE_DEFAUT);
  }

  if(editeur==NULL && (editeur=getenv("DINO_EDITOR"))==NULL)
    editeur=strdup(EDITEUR_DEFAUT);
  editeeur=separ_argus(editeur);
  editeeur->asynchrone=0;

  if(browser==NULL)
    browser=strdup(BROWSER_DEFAUT);
  browseer=separ_argus(browser);
  
  dinorc_file=malloc(BUFMSIZE);
  sprintf(dinorc_file,"%s/%s",getenv("HOME"),FICHIER_DINORC);
  dinorc_file=realloc(dinorc_file,strlen(dinorc_file)+1);

  if(init_touches()<0)
    return -3;

  /*  if(erreur)
      {
      printf("Appuyez sur une touche pour continuer...\n");
      getchar();
      } */
  return erreur;
}


char *coool()
{
  char *contenu[]={
    "<concombre> ca veut dire quoi SO ?",
    "d'abord je me fais toutes les bonnasses que je veux ouais, meme\nque je le fais quand je veux, ouais, ouais, ouais !",
    "doudou : Carrie Fisher, pour etre precis.\nconcombre : si c'est encore un feuilleton debile je vais avoir du mal a\npercuter\ndoudou : Et qui est un peu Jedi sur les bords.\nconcombre : comprends pas. C'est un personnage de notre dAme de paris ?",
    "VELORUTION\nJ'ai mis plus d'une demi-heure a comprendre le jeu de mot",
    "et moi ca fait deux semaines que j'essaie de faire :qui caché !!",
    "<LCQ> ah mais concombre il fait tres bien l'humour\n<LCQ> mais il ne comprend pas celui des autres",
    "<concombre> tiens c marrant cabud en verlan ca fait dubac",
    "Laktineh au cafe, il ya 5 minutes :\n\n-Alors rincon, tu veux toujours aller faire de l'astrophysique ?",
    "> Mais le probleme est peut-etre plus profond. Suite a un possible delit\n\nOH OUI VAS-Y CONCOMBRE",
    "en direct du palais borgnat, peu avant la fermeture,\non nous signale que la branche cucurbitacees de Legumes Inc. &amp; Sons\nest en chute libre suite aux problemes de transport aeronautiques\ndes produites de ladite compagnie.",
    ">>> doudou a écrit :\n\n> NOSFERATU, (quelque chose) DE LA NUIT, fantaisie\n\nta description ne reflete pas vraiment le film",
    "PARIS (AP) -- Le ministère de l'Agriculture\net de la Pêche a pris acte\njeudi soir de la décision du gouvernement canadien de\ntaxer à 100% les concombres de l'Union\neuropéenne.",
    "Je t'en file 10, et tu gardes les 25 autres",
    "Je t'emmerde, sans aucune connotation sexuelle",
    "C'est un rond-point amenage en carrefour giratoire",
    "Je veux la tirer .. enfin, je precise : l'\"apostrophe\" tirer",
    "euh scuse mais je comprends pas tout entre Sion et Jerusalem, la...\n(peut-etre suis-je en train de copseudoconcombre, la mais la ville de Sion\na-t-elle qqc a voir avec monsieur Hertz?)",
    "C'est une honte de lire des choses pareilles !\nNon mais comme si je ne comprenais jamais rien a rien.",
    "Bon j'en ai ras le bol s ca continue j'arrete dino",
    "--- Topic for #vieuxcons is pas dans la tour Magne a Nimes\n--- Topic for #vieuxcons set by concombre at Mon Mar 26 17:26:07"
  };
  int i;

  i=sizeof(contenu)/sizeof(char *);
  
  return contenu[random()%i];
}

