/* interface.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include "config.h"
#include <ncurses.h>
#include <pthread.h>
#include <locale.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <libintl.h>
#include <wchar.h>

#include "defs.h"
#ifdef HAVE_ICONV
#include <limits.h>
#include <iconv.h>
#include "conv.h"
#endif
#include "init.h"
#include "main.h"
#include "routineur.h"
#include "noms.h"
#include "serveur.h"
#include "numeros.h"
#include "pile.h"
#include "poste.h"
#include "externe.h"
#include "commandes.h"
#include "touches.h"
#include "killallfred.h"
#include "utf8.h"


pthread_mutex_t mutex_interface=PTHREAD_MUTEX_INITIALIZER;
int ecran_ok=0;
int effacer_status_bar=1;
int status_bar_est_url=0;
// int status_bar_est_poste=0;
char *contenu_status_bar[2];
static WINDOW *WIN;
//static int flag_winch;
//static int flag_sigint;
static int ourep; // Dégueulasse, mais je n'ai pas trouvé comment m'en passer.
                  // Indique à quelle colonne commence le [Re: x y z].
static char *ligblanche=NULL; // Uniquement utilisé pour les terminaux pourris.


void afficher_pile();
void init_ecran();
void status_bar(const char *pissenlit_qui_pue,int salade_verte);

/* myclrtoeol

   Remplacement avantageux de move(ligne,colonne); clrtoeol(); */

void myclrtoeol(int ligne,int colonne)
{
  if(termpourri)
    mvaddnstr(ligne,colonne,ligblanche,COLS-colonne);
  else
    {
      move(ligne,colonne);
      clrtoeol();
    }
}

int myaddnstr(const char *str, int n) {
#ifdef HAVE_ICONV
  if (subircs!=(iconv_t)(-1)) {
    int m = strlen(str);
    size_t so=4*MB_CUR_MAX*n;
    char bufo[so];
    if (m<n || n == -1)
      n = m;
    return addnstr(bufo,subircser(str,n,bufo,so));
  }
#endif
  return addnstr(str, n);
}

int myaddstr(const char *str) {
#ifdef HAVE_ICONV
  if (subircs!=(iconv_t)(-1)) {
    int n=strlen(str);
    int so=4*MB_CUR_MAX*n;
    char bufo[so];
    return addnstr(bufo,subircser(str,n,bufo,so));
  }
#endif
  return addstr(str);
}
int mymvaddstr(int y, int x, const char *str) {
  move(y,x);
  return myaddstr(str);
}
int mymvaddnstr(int y, int x, const char *str, int n) {
  move(y,x);
  return myaddnstr(str, n);
}

int myprintw(const char *fmt, ...) {
  va_list ap;
  int res;
  char buf[160];
  va_start(ap, fmt);
  res=vsnprintf(buf,sizeof(buf),fmt,ap);
  myaddnstr(buf, res);
  va_end(ap);
  return res;
}

int mymvprintw(int y, int x, const char *fmt, ...) {
  va_list ap;
  int res;
  char buf[160];
  va_start(ap, fmt);
  res=vsnprintf(buf,sizeof(buf),fmt,ap);
  mymvaddnstr(y, x, buf, res);
  va_end(ap);
  return res;
}

/* mybeep

Fait un beep. Est ici car il pourrait dépendre de l'implémentation. */

void mybeep()
{
  beep();
}

void attriset(int bloup)
{
  attrset(bloup);
  bkgdset(' '|bloup);
}

void effacer_ecran()
{
  pthread_mutex_lock(&mutex_interface);
  move(LINES-1,0);
  endwin();
  //  resetty();
  ecran_ok=0;
  pthread_mutex_unlock(&mutex_interface);
}

void quitte(int n, char *message)
{
  effacer_ecran();
  pthread_mutex_lock(&mutex_interface);
#ifdef HAVE_ICONV
  if (subircs!=(iconv_t)(-1)) {
    int sin=strlen(message),sout=4*MB_CUR_MAX*sin;
    char mess[sout+1];
    mess[subircser(message,sin,mess,sout)] = 0;
    printf("%s\n",mess);
  } else
#endif
  printf("%s\n",message);
  fflush(stdout);
  if(sousx || n<0)
    {
#ifdef HAVE_NANOSLEEP
      nanosleep(une_seconde,NULL);
#else
      sleep(1);
#endif
    }
  exit(n);
}


/* rafraichir
   rafraîchit l'écran */

void rafraichir()
{
  move(LINES-1,0);
  refresh();
}


/* prompt_chaine

Affiche prompt sur la dernière ligne, et Remplit chaine avec la réponse. taillebuf donne la longueur maximale de la chaîne.
completion active la complétion sur les noms de thèmes
renvoie 1 si on a appuyé sur Control+G
*/

int prompt_chaine(const char *prompt, char *chaine, int taillebuf, int completion)
{
  int i,j;
  int debut=0;
  int position,longueur;
  int fini=0;
  int foutu=0;
  int erne;
  char *tes;
  char don[BUFMSIZE];
  int x,y __attribute__((unused));
  
  
  curs_set(1);
  tes=strdup(chaine);
  longueur=strlen(chaine);
#ifdef HAVE_ICONV
  if (subircs!=(iconv_t)(-1)) {
    int sin=longueur,sout=longueur*4*MB_CUR_MAX;
    char out[sout];
    longueur = subircser(chaine,sin,out,sout);
    memcpy(chaine,out,longueur);
    chaine[longueur]=0;
  }
#endif
  i=strlen(prompt);
  position=longueur;
  if(position+i>COLS-1)
    debut=position+i-COLS+1;

  while(fini==0)
    {
      pthread_mutex_lock(&mutex_interface);
      attriset(0);
      myclrtoeol(LINES-1,0);
      mymvaddstr(LINES-1,0,prompt);
      mvaddnstr(LINES-1,i,chaine+debut,position-debut);
      getyx(stdscr,y,x);
      addnstr(chaine+position,COLS-i-(position-debut));
      move(LINES-1,x);

      refresh();
      pthread_mutex_unlock(&mutex_interface);
      j=get_carac();
      switch(j)
	{
	case CONTROL_L:
	  effacer_ecran();
	  init_ecran();
	  curs_set(1);
	  break;
	case CONTROL_G:
	  sprintf(chaine,"%s",tes);
	  fini=1;
	  foutu=1;
	  break;
	case '\n':
	  fini=1;
	  break;
	case '\t':
	  if(completion)
	    {
	      int k,l,m=0,m2=0,flag=0,flag2=0;
	      k=position;
	      while(k>0 && chaine[k-1]!=' ')
		k--;
	      if(k==position)
		{
		  mybeep();
		  break;
		}
	      erne=0;
	      for(l=0;l<nbthemes;l++)
		{
		  if(strncmp(themes[l].nom,chaine+k,position-k)==0)
		    {
		      flag++;
		      m=l;
		      erne+=sprintf(don+erne," %s",themes[l].nom);
		    }
		  else if(strncasecmp(themes[l].nom,chaine+k,position-k)==0)
		    {
		      flag2++;
		      m2=l;
		      erne+=sprintf(don+erne," %s",themes[l].nom);
		    }
		}
	      switch(flag)
		{
		case 1:
		  l=strlen(themes[m].nom);
		  if(longueur+l<taillebuf-1)
		    {
		      memmove(chaine+k+l,chaine+position,longueur-position+1);
		      strncpy(chaine+k,themes[m].nom,l);
		      m=l+k-position;
		      longueur+=m;
		      position+=m;
		    }
		  else
		    mybeep();
		  break;
		case 0:
		  switch(flag2)
		    {
		    case 1:
		      l=strlen(themes[m2].nom);
		      if(longueur+l<taillebuf-1)
			{
			  memmove(chaine+k+l,chaine+position,longueur-position+1);
			  strncpy(chaine+k,themes[m2].nom,l);
			  m2=l+k-position;
			  longueur+=m2;
			  position+=m2;
			  break;
			}
		    case 0:
		      mybeep();
		      break;
		    default:
		      status_bar(don,1);
		    }
		  break;
		default:
		  status_bar(don,1);
		}
	    }
	  else
	    {
	      position+=10;
	      if(position>longueur)
		position=longueur;
	    }
	  break;
	case KEY_BTAB:
	  if(!completion)
	    {
	      position-=10;
	      if(position<0)
		position=0;
	    }
	  else
	    mybeep();
	  break;
	case KEY_LEFT:
	  if (position>0)
	    {
	      mbstate_t ps;
	      memset(&ps,0,sizeof(ps));
	      do {
		position--;
	      } while (mbrlen(chaine+position, longueur-position, &ps) == (size_t)-1 && position > 0);
	    }
	  else
	    mybeep();
	  break;
	case KEY_RIGHT:
	  if(position<longueur)
	    {
	      mbstate_t ps;
	      memset(&ps,0,sizeof(ps));
	      size_t size = mbrlen(chaine+position, longueur-position, &ps);
	      if (size <= 0)
		size = 1;
	      position += size;
	    }
	  else
	    mybeep();
	  break;
	case KEY_HOME:
	  debut=0;
	  position=0;
	  break;
	case KEY_END:
	  position=longueur;
	  debut=position-COLS+1+i;
	  if(debut<0)
	    debut=0;
	  break;
	case KEY_BACKSPACE:
	  if(position>0)
	    {
	      mbstate_t ps;
	      int bs = 0;
	      memset(&ps,0,sizeof(ps));
	      do {
		bs++;
	      } while (mbrlen(chaine+position-bs, longueur-position+bs, &ps) == (size_t)-1 && bs < position);
	      memmove(chaine+position-bs,chaine+position,longueur-position+1);
	      position-=bs;
	      longueur-=bs;
	    }
	  else
	    mybeep();
	  break;
	case KEY_DC:
	  if(position<longueur)
	    {
	      mbstate_t ps;
	      memset(&ps,0,sizeof(ps));
	      size_t size = mbrlen(chaine+position, longueur-position, &ps);
	      if (size <= 0)
		size = 1;
	      memmove(chaine+position,chaine+position+size,longueur-position-size+1);
	      longueur-=size;
	    }
	  else
	    mybeep();
	  break;
	case CONTROL_K:
	  chaine[position]=0;
	  longueur=position;
	  break;
	case CONTROL_U:
	  memmove(chaine,chaine+position,longueur-position+1);
	  longueur-=position;
	  position=0;
	  debut=0;
	  break;
	default:
	  if(affichable(j) && longueur<taillebuf-1)
	    {
	      memmove(chaine+position+1,chaine+position,longueur-position+1);
	      chaine[position++]=j;
	      longueur++;
	    }
	  else
	    mybeep();
	}
      if(position+i-debut>COLS-1)
	debut+=10;
      if(position<=debut) /* = for backspace to work */
	{
	  debut-=10;
	  if(debut<0)
	    debut=0;
	}
    }
  pthread_mutex_lock(&mutex_interface);
  attriset(0);
  myclrtoeol(LINES-1,0);
  pthread_mutex_unlock(&mutex_interface);
#ifdef HAVE_ICONV
  if (scribus!=(iconv_t)(-1)) {
    char out[longueur];
    longueur = scribuser(chaine,longueur,out,longueur);
    memcpy(chaine,out,longueur);
    chaine[longueur]=0;
  }
#endif
  frite(tes);
  curs_set(0);
  return foutu;
}


/* prompt_themes

   Demande de rentrer un ou plusieurs thèmes. Modifie la chaine thms, qui peut être rendue vide.
   Si plusieurs est à zéro, renvoie le thème concerné.
*/

theme *prompt_themes(const char *prompt, char *thms, int taillebuf, int plusieurs)
{
  int i,j,k,l,gneu,gnu=0;
  char lot[BUFMSIZE];
  strcpy(lot,thms);
  while(1)
    {
      if(prompt_chaine(prompt,thms,taillebuf,1))
	{
	  strcpy(thms,lot);
	  return NULL;
	}
      i=1;k=-1;gneu=strlen(thms)+1;
      
      if(gneu==1 /*&& plusieurs==0*/)
	return NULL;
      // La chaîne thms est-elle conforme ?
      for(j=0;j<gneu;j++)
	{
	  if(thms[j]==' ' || thms[j]==0)
	    {
	      i=0;
	      for(l=0;l<nbthemes;l++)
		if(strlen(themes[l].nom)-j+k+1==0 && strncmp(themes[l].nom,thms+k+1,j-k-1)==0)
		  {
		    i=1;
		    gnu=l;
		    break;
		  }
	      if(i==0) break;
	      k=j;
	    }
	}
      if(i==0)
	{
	  mybeep();
	  status_bar(_("Nonexistent theme"),0);
	}
      else if(plusieurs==0)
	{
	  if(i>1 || strcmp(thms,themes[gnu].nom))
	    {
	      mybeep();
	      status_bar(_("Nonexistent theme"),0);
	    }
	  else
	    return themes+gnu;
	}
      else
	return themes+gnu;
    }
}


/* ouinon

   Pose une question, à laquelle on doit répondre oui ou non. Renvoie 0 ou 1 selon la réponse. */

int ouinon(const char *prompt)
{
  int i;
  
  while(1)
    {
      afficher_pile();
      pthread_mutex_lock(&mutex_interface);
      attriset(0);
      myclrtoeol(LINES-1,0);
      mymvprintw(LINES-1,0,"%s (yo/n)  ",prompt);
      rafraichir();
      pthread_mutex_unlock(&mutex_interface);
      i=0;
      while(i==0)
	{
	  i=get_carac();
	  switch(i)
	    {
	    case 'o':
	    case 'O':
	    case 'y':
	    case 'Y':
	    case '\n':
	      i='o';
	      break;
	    case CONTROL_L:
	      i=0;
	      break;
	    default:
	      i='n';
	      break;
	    }
	}
      if(i!=CONTROL_L)
	break;
      effacer_ecran();
      init_ecran();
    }
  
  pthread_mutex_lock(&mutex_interface);
  attriset(0);
  myclrtoeol(LINES-1,0);
  rafraichir();
  pthread_mutex_unlock(&mutex_interface);
  
  if(i=='o')
    return 1;
  return 0;
}


/* init_ecran
   Initialise tout. À utiliser au début, lors d'un redimensionnement, ou de la fermeture de l'éditeur. */

void init_ecran()
{
  //  setlocale(LC_ALL,"fr_FR");
  pthread_mutex_lock(&mutex_interface);
  WIN=initscr();
  //  savetty();
  if(couleur) {
    start_color();
    init_pair(1,COLOR_GREEN,0);
    init_pair(2,COLOR_BLUE,COLOR_CYAN);
    init_pair(3,COLOR_BLUE,COLOR_YELLOW);
    init_pair(4,COLOR_RED,0);
    init_pair(5,COLOR_YELLOW,0);
    init_pair(6,COLOR_CYAN,0);
    init_pair(7,COLOR_MAGENTA,0);
    init_pair(8,COLOR_BLUE,0);
  }
  keypad(WIN,TRUE);
  cbreak();
  //halfdelay(2);
  noecho();
  curs_set(0);
  // pour que SIGWINCH interrompe getch()
  timeout(60000);
  //timeout(200);
  //  clear();
  rafraichir();
  ecran_ok=1;
  if(termpourri)
    {
      frite(ligblanche);
      ligblanche=malloc(COLS);
      memset(ligblanche,-96,COLS);
    }
  pthread_mutex_unlock(&mutex_interface);
}



/* dessine_haut
   
   (re)dessine la première ligne, avec la version, le nombre de messages, et le nombre de connectés
*/

void dessine_haut()
{
  char bon[BUFMSIZE];
  pthread_mutex_lock(&mutex_interface);
  if(ecran_ok)
    {
      if(yadunouvo)
	attriset(COUL(1) | A_BOLD);
      else
	attriset(COUL(1));
      myclrtoeol(0,0);
      mymvprintw(0,0,_("Dino Client V%s : %i Messages"),VERSION,nb_messages);
      attriset(COUL(1));
      sprintf(bon,_n("%i connected","%i are connected",nb_connectes),nb_connectes);
      mymvaddstr(0,COLS-2-strlen(bon),bon);
      rafraichir();
    }
  pthread_mutex_unlock(&mutex_interface);
}

/* status_bar
   
   Redessine la status bar, si cela est permis.
   Si salade_verte<0, ne fait que redessiner. pissenlit_qui_pue est ignoré.
   Si salade_verte=0, pissenlit_qui_pue contient la partie gaucho (l'état du serveur).
   Si salade_verte=1, pissenlit_qui_pue contient la partie facho de droite (les crossposts).
   Si salade_verte=2, c'est la partie gauche, mais elle ne s'efface pas au bout de 5 secondes.
   Si pissenlit_qui_pue vaut NULL, on met une chaîne vide à la place. */

void status_bar(const char *pissenlit_qui_pue,int salade_verte)
{
  int podzob;

  if(salade_verte>2)
    return;

  pthread_mutex_lock(&mutex_interface);

  if(salade_verte>=0)
    {
      if(salade_verte!=1)
	{
	  if(salade_verte==0 && pissenlit_qui_pue!=NULL)
	    {
	      effacer_status_bar=1;
	      temps_status_bar=0;
	    }
	  else
	    effacer_status_bar=0;
	}

      if(salade_verte>1)
	salade_verte=0;
      
      if(salade_verte==0)
	{
	  status_bar_est_url=0;
	  //	  status_bar_est_poste=0;
	}

      frite(contenu_status_bar[salade_verte]);
      if(pissenlit_qui_pue!=NULL)
	{
	  podzob=strlen(pissenlit_qui_pue);
	  if(podzob>COLS-2)
	    {
	      contenu_status_bar[salade_verte]=malloc(COLS-1);
	      strncpy(contenu_status_bar[salade_verte],pissenlit_qui_pue,COLS-2);
	      contenu_status_bar[salade_verte][COLS-2]=0;
	    }
	  else
	    {
	      contenu_status_bar[salade_verte]=malloc(podzob+1);
	      strcpy(contenu_status_bar[salade_verte],pissenlit_qui_pue);
	    }
	}
      else
	contenu_status_bar[salade_verte]=strdup(" ");
    }

  for(podzob=0;contenu_status_bar[salade_verte][podzob];podzob++)
    if(contenu_status_bar[salade_verte][podzob]=='\n')
      {
	contenu_status_bar[salade_verte][podzob]=0;
	break;
      }

  if(ecran_ok)
    {
      attriset(COUL(2)|A_REVERSE);
      myclrtoeol(LINES-2,0);
      mymvaddstr(LINES-2,COLS-2-strlen(contenu_status_bar[1]),contenu_status_bar[1]);
      attriset(COUL(3)|A_REVERSE);
      // attriset(COUL(2)|A_REVERSE|A_BOLD);
      mymvprintw(LINES-2,0,"%s ",contenu_status_bar[0]);
      rafraichir();
    }
  pthread_mutex_unlock(&mutex_interface);
}


/* afficher_pile
   
   affiche le contenu de la pile pile_courante en bas à droite, avec la bonne couleur.*/

void afficher_pile()
{
  char topinambour[BUFMSIZE];
  int patate=0;
  int tomate;
  int courge=0;

  if(remplissage_pile[pile_courante]>TAILLEMINPILE)
    patate=remplissage_pile[pile_courante]-TAILLEMINPILE;
  if(remplissage_pile[pile_courante])
    courge+=sprintf(topinambour,"%i",pile[pile_courante][patate]);
  for(tomate=patate+1;tomate<remplissage_pile[pile_courante];tomate++)
    courge+=sprintf(topinambour+courge,"->%i",pile[pile_courante][tomate]);
  patate=0;
  if(courge>COLS-20)
    patate=courge-COLS+20;
  pthread_mutex_lock(&mutex_interface);
  if(ecran_ok)
    {
      attriset(0);
      myclrtoeol(LINES-1,0);
      if(remplissage_pile[pile_courante])
	{
	  attriset(COUL(5+pile_courante));
	  mymvaddstr(LINES-1,COLS-2-courge+patate,topinambour+patate);
	}
      rafraichir();
    }
  pthread_mutex_unlock(&mutex_interface);
}


/* dessine_replys

   Dessine les replys. Si evidence est non négatif, met en évidence la réponse concernée. mutex_interface doit être bloqué à l'avance. */

static void dessine_replys(int *quoi,int evidence)
{
  int i;
  attriset(COUL(4));

  mymvprintw(3,ourep,"[Re :");
  for(i=0;quoi[i];i++)
    {
      if(i==evidence)
	attriset(COUL(4)|A_REVERSE);
      else
	attriset(COUL(4));
	 myprintw(" %i",quoi[i]);
    }
  myprintw("]");
}


int choisir_reply(message_t *iroflan)
{
  int tutu=0;
  int i=0;

  if(iroflan==NULL || iroflan->reponses==NULL || iroflan->reponses[0]==0)
    return 0;
  if(iroflan->reponses[1]==0)
    return iroflan->reponses[0];
  status_bar(_("Choose a reply"),0);
  while(i==0)
    {
      dessine_replys(iroflan->reponses,tutu);
      switch(get_carac())
	{
	case CONTROL_G:
	  i=2;
	  break;
	case CONTROL_L:
	  effacer_ecran();
	  init_ecran();
	  break;
	case KEY_LEFT:
	  if(tutu>0)
	    tutu--;
	  else
	    mybeep();
	  break;
	case KEY_RIGHT:
	  if(iroflan->reponses[tutu+1])
	    tutu++;
	  else
	    mybeep();
	  break;
	case KEY_HOME:
	  tutu=0;
	  break;
	case KEY_END:
	  while(iroflan->reponses[tutu+1])
	    tutu++;
	  break;
	case '\n':
	  i=1;
	  break;
	default:
	  mybeep();
	}
    }
  if(i>1)
    return 0;
  return iroflan->reponses[tutu];
}


/* coul_rep

Renvoie la paire de couleurs correspondant au niveau de réponse niveau. */

static int coul_rep(int niveau)
{
  switch(niveau%5)
    {
    case 0:
      return 0;
    case 1:
      return COUL(6);
    case 2:
      return COUL(1);
    case 3:
      return COUL(8);
    case 4:
      return COUL(4);
    default:
      return 0;
    }
}



/* pager

   Affiche le message qu'on lui fourgue. Si on appuie sur une touche qui fait sortir du pager, retourne le caractère correspondant. */

int pager(message_t *mess,theme *thm)
{ // Si thm vaut NULL, on n'affiche rien en haut.
  // Si mess est NULL, le message est INEXISTANT (et pas indisponible).
  int nblignes; // nombre de lignes du message
  int li;
  int i=0,j;
  char *signature=NULL;
  char toto[BUFMSIZE];
  char *tata;
  int touche;
  int redessiner;
  int deb,l,c,flag_url,flag_gras,flag_it,flag_sou,flag_pcent,alacon,temp,flag_rep;
  wchar_t carac;
  unsigned int nonsigne;
  int url_courante=0;
  int nb_urls=0;
  int flag_auth=0;
  int url_debut;
  int compteur_urls;
  char url_actuelle[BUFMSIZE];
  
  // on compte les lignes
  nblignes=0;
  c=alacon=temp=0;

  if(mess!=NULL && mess->corps!=NULL)
    nblignes=nombre_lignes(mess->corps);
  
  if(mess!=NULL && mess->signe!=NULL)
    signature=quiest(mess->signe);

  for(;;)
    {
      pthread_mutex_lock(&mutex_interface);
      
      attriset(COUL(2)|A_REVERSE);
      myclrtoeol(1,0);
      
      if(thm!=NULL)
	{ // infos du thème
	  mymvaddstr(1,COLS-2-strlen(thm->infos),thm->infos);
	  mymvaddstr(1,(COLS-strlen(thm->nom))/2,thm->nom);
	}
      
      attriset(COUL(2)|A_REVERSE|A_BOLD);
      // Numéro du message
      if(mess!=NULL)
	{
	  tata=texte_numero(mess);
	  mymvaddstr(1,0,tata);
	  frite(tata);
	}

      rafraichir();
      
      attriset(0);
      myclrtoeol(2,0);

      // Date du message      
      if(mess!=NULL && mess->date!=NULL)
	{
	  nonsigne=COLS-6-strlen(mess->date);
	  mymvaddstr(2,nonsigne+4,mess->date);
	}
      else
	nonsigne=COLS-2;
      
      // Nom de l'auteur (avec éventuellement sa signature)
      if(signature!=NULL)
	nonsigne=nonsigne-3-strlen(signature);
      if(mess!=NULL && mess->auteur!=NULL)
	{
	  attriset(A_BOLD);
	  if(strlen(mess->auteur)>nonsigne)
	    {
	      mymvaddnstr(2,2,mess->auteur,nonsigne-3);
	      mymvaddstr(2,nonsigne-1,"...");
	    }
	  else
	    mymvaddstr(2,2,mess->auteur);
	  if(signature!=NULL)
	    {
	      attriset(0);
	      myprintw(" (%s)",signature);
	    }
	}
      attriset(0);
      myclrtoeol(3,0);
      myclrtoeol(4,0);

      // Les messages auxquels ce message répond
      if(mess!=NULL && mess->reponses!=NULL)
	{
	  j=6;
	  for(i=0;mess->reponses[i];i++) {
	    l = sprintf(toto,"%i",mess->reponses[i]);
	    if (j+1+l+7>COLS) {
	      /* vraiment trop, abandonne */
	      mess->reponses[i] = 0;
	      break;
	    }
	    j=j+1+l;
	  }
	  i=(mess->sujet!=NULL)?strlen(mess->sujet):0;
	  attriset(COUL(5)|A_UNDERLINE);
	  if(i+j+4>COLS)
	    {
	      mymvaddnstr(3,0,mess->sujet,COLS-7-j);
	      myaddstr("...");
	      ourep=COLS-2-j;
	    }
	  // Le sujet
	  else if(mess->sujet!=NULL)
	    {
	      mymvaddstr(3,0,mess->sujet);
	      ourep=i+2;
	    }
	  dessine_replys(mess->reponses,-1);
	}
      else if(mess!=NULL && mess->sujet!=NULL)
	{
	  attriset(COUL(5)|A_UNDERLINE);
	  mymvaddnstr(3,0,mess->sujet,COLS-2);
	}
      
      rafraichir();

      pthread_mutex_unlock(&mutex_interface);
      
      j=0;
      if(mess!=NULL)
	for(i=0;i<mess->nbthemes;i++)
	  j+=sprintf(toto+j," %s",mess->themes[i]->nom);
      if(j==0)
	sprintf(toto," ");
      status_bar(toto,1);
      
      afficher_pile();

      deb=0;

      redessiner=0;
      flag_pcent=0;

      url_courante=0;
      url_actuelle[0]=0;

      while(redessiner==0)
	{
	  pthread_mutex_lock(&mutex_interface);
	  attriset(0);
	  // effacement de l'écran
	  for(l=5;l<LINES-2;l++)
	    {
	      myclrtoeol(l,0);
	    }
	  
	  l=5;
	  c=0;
	  flag_url=0;
	  flag_gras=0;
	  flag_it=0;
	  flag_sou=0;
	  flag_rep=0;
	  flag_auth=0;
	  li=0;

	  compteur_urls=0;
	  url_debut=0;

	  if(mess==NULL)
	    {
	      j=sprintf(toto,_("This message doesn't exist."));
	      mymvaddstr(LINES/2,(COLS-j)/2,toto);
	    }
	  else if(mess->numero==0)
	    {
	      j=sprintf(toto,_("Finished for the theme %s."),thm->nom);
	      mymvaddstr(LINES/2,(COLS-j)/2,toto);
	    }
	  else if(mess->numero==-3)
	    {
	      j=sprintf(toto,_("The message number is unavailable."));
	      mymvaddstr(LINES/2,(COLS-j)/2,toto);
	    }
	  else if(mess->numero==-4)
	    {
	      j=sprintf(toto,_("You have read everything."));
	      mymvaddstr(LINES/2,(COLS-j)/2,toto);
	    }
	  else if(mess->corps==NULL)
	    {
	      j=sprintf(toto,_("The message body is unavailable."));
	      mymvaddstr(LINES/2,(COLS-j)/2,toto);
	    }
	  else if(msg_good_to_display(mess)==0)
	    {
	      j=sprintf(toto,_("Message filtered."));
	      attriset(COUL(7)|A_BOLD);
	      mymvaddstr(LINES/2,(COLS-j)/2,toto);
	      attriset(0);
	    }
	  else
	    for(i=0;mess->corps[i] && l<LINES-3;i++)
	      {
		/* Nouvelle gestion des couleurs */
		while(mess->html)
		  {
		    if(mess->corps[i]=='<')
		      {
			if(strncasecmp(mess->corps+i,"<b>",3)==0)
			  flag_gras++;
			else if(strncasecmp(mess->corps+i,"</b>",4)==0)
			  flag_gras--;
			else if(strncasecmp(mess->corps+i,"<i>",3)==0)
			  flag_it++;
			else if(strncasecmp(mess->corps+i,"</i>",4)==0)
			  flag_it--;
			else if(strncasecmp(mess->corps+i,"<u>",3)==0 || strncasecmp(mess->corps+i,"<s>",3)==0)
			  flag_sou++;
			else if(strncasecmp(mess->corps+i,"</u>",4)==0 || strncasecmp(mess->corps+i,"</s>",4)==0)
			  flag_sou--;
			else if(strncasecmp(mess->corps+i,"</a>",4)==0)
			  flag_url=0;
			else if(strncasecmp(mess->corps+i,"<a href=\"",9)==0)
			  {
			    flag_url=1;
			    i+=9;
			    compteur_urls++;
			    if(compteur_urls>nb_urls)
			      nb_urls=compteur_urls;
			    if(li>deb-1)
			      {
				if(url_debut==0)
				  url_debut=compteur_urls;
				if(url_courante==0)
				  url_courante=compteur_urls;
				if(url_courante==compteur_urls)
				  {
				    flag_url=2;
				    tata=strchr(mess->corps+i,'\"');
				    if(tata==NULL || tata-(mess->corps+i)>BUFMSIZE-2)
				      url_actuelle[0]=0;
				    else
				      {
					strncpy(url_actuelle,mess->corps+i,tata-(mess->corps+i));
					url_actuelle[tata-(mess->corps+i)]=0;
				      }
				    pthread_mutex_unlock(&mutex_interface);
				    status_bar(url_actuelle,2);
				    status_bar_est_url=1;
				    pthread_mutex_lock(&mutex_interface);
				  }
			      }
			    while(mess->corps[i] && mess->corps[i]!='\"') i++;
			    if(mess->corps[i]==0) break;
			    
			  }
			
			while(mess->corps[i] && mess->corps[i]!='>') i++;
			if(mess->corps[i])
			  i++;
		      }
		    else break;
		  }
		if(mess->corps[i]==0) break;
		
		if(c==flag_rep*2 && strncmp(mess->corps+i,"> ",2)==0)
		  if(strncmp(mess->corps+i,"> >>>> ",7)) // Détection de DineL
		    flag_rep++;
		
		if(strncmp(mess->corps+i,">>> ",4)==0) // >>> toto a écrit :
		                                 // Marche aussi avec DineL
		  flag_auth=1;
		if(flag_auth)
		  {
		    if(flag_auth==1 && mess->corps[i]==' ')
		      flag_auth=2;
		    if(flag_auth==2 && mess->corps[i]!=' ')
		      flag_auth=3; // C'est là qu'il faut l'afficher.
		    if(flag_auth==3 && mess->corps[i]==' ')
		      flag_auth=0;
		  }

		if(mess->html && mess->corps[i]=='&')
		  {
		    if(strncasecmp(mess->corps+i,"&nbsp;",6)==0)
		      carac=L' ';
		    else if(strncasecmp(mess->corps+i,"&lt;",4)==0)
		      carac='<';
		    else if(strncasecmp(mess->corps+i,"&gt;",4)==0)
		      carac='>';
		    else if(strncasecmp(mess->corps+i,"&amp;",5)==0)
		      carac='&';
		    else
		      carac='?';
		    
		    while(mess->corps[i] && mess->corps[i]!=';') i++;
		    if(mess->corps[i]==0)
		      break;
		  }
		else
		  {
		    int index = 0;
		    carac = u8_nextchar(&mess->corps[i], &index);
		    i += index-1;
		  }
		
		if(li>deb-1)
		  {
		    alacon=0;
		    if(flag_it>0)
		      alacon=COUL(5);
		    else if(flag_url)
		      {
			alacon=COUL(7);
			if(flag_url==2)
			  alacon=alacon|A_REVERSE;
		      }
		    else if(flag_gras>0)
		      alacon=COUL(4);
		    else if(flag_auth==3)
		      alacon=coul_rep(flag_rep+1);
		    else if(flag_rep)
		      alacon=coul_rep(flag_rep);
		    if(flag_gras>0 || flag_auth==3)
		      alacon=alacon|A_BOLD;
		    /* if(flag_it>0)
		       alacon=alacon|A_REVERSE; */
		    if(flag_sou>0 || flag_url)
		      alacon=alacon|A_UNDERLINE;
		    attriset(alacon);
		  }
		if(affichable(carac))
		  {
		    if(li>deb-1)
		      mymvprintw(l,c,"%lc",carac);
		    c+=wcwidth(carac);
		    if(c>COLS-1)
		      {
			c=0;
			if(li>deb-1)
			  l++;
			li++;
		      }
		  }
		if(carac=='\n')
		  {
		    flag_rep=0;
		    flag_auth=0;
		    if(li>deb-1)
		      l++;
		    c=0;
		    li++;
		  }
		if(carac=='\t')
		  {
		    c+=8-(c%8);
		    if(c>COLS-1)
		      {
			c=0;
			if(li>deb-1)
			  l++;
			li++;
		      }
		  }
	      }
	  if(l>=LINES-3 && mess->corps[i])
	    flag_pcent=1;
	  if(flag_pcent)
	    {
	      attriset(COUL(7) | A_BOLD);
	      mymvprintw(LINES-3,0,_("--- continued ---  %i %%"),(100*li+1)/nblignes);
	    }
	  temp=0;
	  if(mess!=NULL) // Censure
	    for(j=0;j<mess->nbthemes;j++)
	      if(mess->themes[j]==thm)
		{
		  temp=mess->censure[j];
		  break;
		}
	  if(temp>1)
	    {
	      attriset(COUL(5));
	      mymvaddstr(7,27,"-----------------------");
	      mymvaddstr(8,27,"|                     |");
	      mymvaddstr(9,27,"-----------------------");
	      attriset(COUL(4)|A_BOLD);
	        mymvaddstr(8,29,_("  C E N S O R E D"));
	    }
	  else if(temp && LINES>20)
	    {
	      attriset(COUL(5)|A_BOLD);
	      mvinsstr( 5,6,"|      /");
	      mvinsstr( 6,6,"|     |");
	      mvinsstr(7,6,"\\     |");
	      mvinsstr( 8,7, "|    /");
	      mvinsstr(9,7, "\\   |");
	      mvinsstr(10,8,  "|  /");
	      mvinsstr(11,8,  "| |");
	      mvinsstr(12,8,  "|/");
	      mvinsstr(13,7, "/");
	      mvinsstr(14,6,"/");
	      mvinsstr(15,6,"|");
	      mvinsstr(16,6,"|");
	      mvinsstr(17,6,"|");
	    }
	  rafraichir();
	  alacon=0;
	  pthread_mutex_unlock(&mutex_interface);
	  while(alacon==0)
	    {
	      touche=fonction_touche(get_carac());
	      switch(touche)
		{
		case F_REDRAW:
		  alacon=1;
		  redessiner=1;
		  break;
		case F_NPAGE_OR_NMESS:
		  if(flag_pcent)
		    {
		      flag_pcent=0;
		      if(mess->corps[i])
			deb=deb+LINES-10;
		      alacon=1;
		      break;
		    }
		  else
		    return touche;
		case F_CHANGE_STACK:
		  changer_pile();
		  break;
		case F_SERVER_DATE:
		  date_serveur();
		  break;
		case F_BIDOU_BIDOU:
		  bidous_bidous(mess);
		  break;
		case F_PUSH_YSTACK:
		case F_PUSH_BSTACK:
		  if(touche==F_PUSH_BSTACK)
		    pile_courante=1;
		  else
		    pile_courante=0;
		  if(mess!=NULL)
		    empiler(mess->numero);
		  else
		    mybeep();
		  break;
		case F_CHANGE_MSG_TYPE:
		  changer_type();
		  break;
		case F_LAUNCHBROWSER:
		  if(url_actuelle[0])
		    {
		      status_bar(_("Launching the browser"),0);
		      lancer_externe(browseer,url_actuelle,NULL,NULL);
		    }
		  else
		    status_bar("Où ça ?",0);
		  break;
		case F_RIGHT_ROLL:
		  roll_droite();
		  break;
		case F_LEFT_ROLL:
		  roll_gauche();
		  break;
		case F_REVERSE_STACK:
		  retourner_pile();
		  break;
		case F_STACK_DROP:
		  if(depiler()==0)
		    mybeep();
		  break;
		case F_BEGINNING:
		  deb=0;
		  alacon=1;
		  url_courante=0;
		  break;
		case F_END:
		  if(flag_pcent)
		    {
		      deb=nblignes-LINES+8;
		      alacon=1;
		      url_courante=0;
		    }
		  break;
		case F_NPAGE:
		  if(flag_pcent && mess->corps[i])
		    {
		      deb=deb+LINES-10;
		      alacon=1;
		      url_courante=0;
		    }
		  break;
		case F_PPAGE:
		  if(flag_pcent && deb>0)
		    {
		      deb=deb-LINES+10;
		      if(deb<0)
			deb=0;
		      alacon=1;
		      url_courante=0;
		    }
		  break;
		case F_NLINE:
		  if(flag_pcent && mess->corps[i])
		    {
		      deb++;
		      alacon=1;
		      url_courante=0;
		    }
		  else if(url_courante<nb_urls)
		    {
		      url_courante++;
		      alacon=1;
		    }
		  break;
		case F_PLINE:
		  if(url_courante>url_debut)
		    {
		      url_courante--;
		      alacon=1;
		    }
		  else if(flag_pcent && deb>0)
		    {
		      deb--;
		      alacon=1;
		    }
		  break;
		case F_DISCONNECT:
		  if(serveur_up==0)
		    {
		      mybeep();
		      break;
		    }
		  tata=recup_commande(envoyer_commande("quitte\n"));
		  frite(tata); // Bordel ! frite est une macro !
		  break;
		case F_NONE:
		  status_bar(_("Unrecognized command !"),0);
		  mybeep();
		  break;
		default:
		  return touche;
		}
	    }
	}
      effacer_ecran();
      init_ecran();
    }
}
