/* killallfred.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <libintl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "defs.h"
#include "interface.h"
#include "init.h"

static char **bwlists[2]; // 0 = blacklist des logins
                          // 1 = whitelists des pseudos
static int taille_bwlists[2];
static int remplissage_bwlists[2];

static char *bwlfiles[2] = { "blacklist","whitelist" };

static void glouglou_sibesoin(int laquelle)
{
  if(remplissage_bwlists[laquelle]>taille_bwlists[laquelle]-2)
    {
      taille_bwlists[laquelle]*=2;
      bwlists[laquelle]=realloc(bwlists[laquelle],taille_bwlists[laquelle]*sizeof(char *));
    }
}

void InitFilter()
{
  FILE *fichier;
  char te[BUFMSIZE];
  int i,j;
  
  if(!enable_killallfred)
    return;
  
  for(i=0;i<2;i++)
    {
      bwlists[i]=malloc(TAILLEMINPILE*sizeof(char *));
      taille_bwlists[i]=TAILLEMINPILE;
      remplissage_bwlists[i]=0;
      
      sprintf(te,"%s/%s/%s",getenv("HOME"),DINO2_DIR,bwlfiles[i]);
      fichier=fopen(te,"r");
      if(fichier!=NULL)
	{
	  while(fgets(te,BUFMSIZE,fichier)!=NULL)
	    {
	      j=0;
	      while(te[j]!='\n' && te[j]!=0)
		j++;
	      if(j==0)
		break;
	      glouglou_sibesoin(i);
	      bwlists[i][remplissage_bwlists[i]]=malloc(j+1);
	      strncpy(bwlists[i][remplissage_bwlists[i]],te,j);
	      bwlists[i][remplissage_bwlists[i]][j]=0;
	      remplissage_bwlists[i]++;
	    }
	  fclose(fichier);
	}
    }
}

static void ecrire_fichlistes(int laquelle)
{
  FILE *fichier;
  char te[BUFMSIZE];
  int i;

  sprintf(te,"%s/%s/%s",getenv("HOME"),DINO2_DIR,bwlfiles[laquelle]);

  fichier=fopen(te,"w");
  if(fichier!=NULL)
    {
      for(i=0;i<remplissage_bwlists[laquelle];i++)
	fprintf(fichier,"%s\n",bwlists[laquelle][i]);
      fclose(fichier);
    }
}

int msg_good_to_display(message_t *coincoin)
{
  int i,detected,black_or_white;
  char *tres;

  if(!enable_killallfred)
    return 1;

  if(coincoin==NULL || coincoin->numero<=0) // Ne devrait jamais arriver mais bon
    return 1;

  if(coincoin->signe==NULL)
    {
      black_or_white=1;
      tres=coincoin->auteur;
    }
  else
    {
      black_or_white=0;
      tres=coincoin->signe;
    }
  
  detected=0;
  for(i=0;i<remplissage_bwlists[black_or_white];i++)
    if(strcmp(bwlists[black_or_white][i],tres)==0)
      {
	detected=1;
	break;
      }
  
  return (detected==black_or_white);

}


void toggle_filter(message_t *coincoin)
{
  int i,black_or_white,eff_ou_ajout;
  char *tres;
  char *vite=NULL;
  char don[BUFMSIZE];

  if(coincoin==NULL || coincoin->numero<=0)
    {
      mybeep();
      return;
    }

  if(!enable_killallfred)
    {
      status_bar(_("Filtering functions are deactivated."),0);
      return;
    }

  if(coincoin->signe==NULL)
    {
      black_or_white=1;
      tres=coincoin->auteur;
    }
  else
    {
      black_or_white=0;
      tres=coincoin->signe;
    }

  eff_ou_ajout = 1;
  for(i=0;i<remplissage_bwlists[black_or_white];i++)
    if(strcmp(bwlists[black_or_white][i],tres)==0)
      {
	eff_ou_ajout=0;
	break;
      }
  
  switch(10*black_or_white+eff_ou_ajout)
    {
    case 0:
      vite=_("Removing %s from blacklist");
      break;
    case 1:
      vite=_("Adding %s to blacklist");
      break;
    case 10:
      vite=_("Removing %s from whitelist");
      break;
    case 11:
      vite=_("Adding %s to whitelist");
      break;
    }
  snprintf(don,BUFMSIZE,vite,tres);
  status_bar(don,0);

  if(eff_ou_ajout)
    {
      glouglou_sibesoin(black_or_white);
      bwlists[black_or_white][remplissage_bwlists[black_or_white]++]=strdup(tres);
    }
  else
    {
      free(bwlists[black_or_white][i]);
      memmove(bwlists[black_or_white]+i,bwlists[black_or_white]+i+1,(remplissage_bwlists[black_or_white]-i-1)*sizeof(char *));
      remplissage_bwlists[black_or_white]--;
    }
  ecrire_fichlistes(black_or_white);
}
