/* main.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <string.h>
// #include <ncurses.h>
#include <unistd.h>
#include <libintl.h>
#include <locale.h>
#include <errno.h>
#include "defs.h"
#include "init.h"
#include "routineur.h"
#include "interface.h"
#include "serveur.h"
#include "cache.h"
#include "numeros.h"
#include "noms.h"
#include "poste.h"
#include "pile.h"
#include "externe.h"
// #include "commandes.h"
#include "touches.h"
#include "killallfred.h"
#include "conv.h"
#include "sem.h"


FILE *logfile;

int nb_messages=0;
int nb_connectes=0;
int message_courant=0;
int dernier_msg_lu=0;
int theme_courant=0;
int sens_lecture=0; /* 0(comme 10) ou 9(comme 1) pour une position définie
		     -1 ou 1 pour la lecture séquentielle
		     -2 ou 2 pour la lecture séquentielle dans un thème
		     10 pour la lecture classique (barre espace) */

// J'aime pas trop, mais bon...
int message_courant_est_plus_grand_que_nb_messages=0;


static pthread_t thread_serveur_virtuel;
static pthread_t thread_routineur;
static pthread_t thread_cache;

/* main

   Initialisation de l'ensemble et boucle d'attente principale. */

int main(int argc, char **argv)
{
  int toto,oldtoto;
  message_t *messe;
  message_t *mess2;
  theme *taime;
  theme *tm2;
  int onchange;
  int temp,temp2;
  char aze[BUFMSIZE];
  char *rata;
  char commande_tube[BUFMSIZE];


  setlocale(LC_ALL,"");

#ifdef HAVE_ICONV
  amen();
#endif

  bindtextdomain(PACKAGE,LOCALEDIR);
  bind_textdomain_codeset(PACKAGE,"UTF-8");
  textdomain (PACKAGE);
  
  if((toto=DinoInit(argc, argv))<0)   // erreur d'initialisation
    return toto;

  if(debug & DEBUG_DEFAULT)
    {
      rename(LOGFILE,LOGFILE_OLD);
      logfile=fopen(LOGFILE,"w");
      fprintf(logfile,"hote: %s\nlogin: %s\nmotdepasse: %s\nnick: %s\nserveur: %s\nport: %s\ndefaut_signe: %i\n",hote,login,"xxxxxxxx",nickname,serveurs[0],port,defaut_signe);
      fflush(logfile);
    }
  
  init_signaux();

  InitPile();
  InitFilter();

  init_ecran();
  
  // truc con, mais il faut bien le mettre là
  contenu_status_bar[1]=strdup(" ");

  // Lancement du serveur virtuel

  if (sem_init(semaphore_init,0,0) == -1)
    semaphore_init = sem_anon();
  pthread_create(&thread_serveur_virtuel,NULL,(void *)ServeurVirtuel,NULL);
  if(debug & DEBUG_DEFAULT)
    {
      fputs("Serveur virtuel lancé.\n",logfile);
      fflush(logfile);
    }

  while (sem_wait(semaphore_init)==-1)
    if (errno != EINTR) {
      perror("sem_wait(semaphore_init)");
      exit(1);
    }

  pthread_create(&thread_routineur,NULL,(void *)routineur,NULL);
  if(debug & DEBUG_DEFAULT)
    {
      fputs("Routineur lancé.\n",logfile);
      fflush(logfile);
    }

  dernier_msg_lu=init_recup_numeros();
  message_courant=dernier_msg_lu;
  
  lire_fichnoms();
  
  while (sem_wait(semaphore_init)==-1)
    if (errno != EINTR) {
      perror("sem_wait(semaphore_init) (2)");
      exit(1);
    }

  pthread_mutex_lock(&mutex_yadunouvo);
  if(dernier_msg_lu>=nb_messages)
    {
      yadunouvo=0;
      dessine_haut();
    }
  pthread_mutex_unlock(&mutex_yadunouvo);

  pthread_create(&thread_cache,NULL,(void *)CacheMessages,NULL);
  if(debug & DEBUG_DEFAULT)
    {
      fputs("Cache de messages lancé.\n",logfile);
      fflush(logfile);
    }


  while(themes[theme_courant].abonne==0 && theme_courant<nbthemes) theme_courant++;

  sprintf(commande_tube,"rot13");

  messe=liste_themes(0);
  taime=NULL;
  toto=-2000;
  for(;;)
    {
      mess2=messe;
      tm2=taime;
      onchange=0;
      oldtoto=toto;
      toto=pager(messe,taime);
      switch(toto)
	{
	case F_NEXT_MSG:
	  sens_lecture=1;
	  if((messe!=NULL && messe->numero>0) || oldtoto==-2000)
	    if(++message_courant>nb_messages+1)
	      message_courant=nb_messages+1;
	  mess2=recup_message(message_courant);
	  if(mess2!=NULL && mess2->themes!=NULL)
	    {
	      tm2=mess2->themes[0];
	      theme_courant=tm2-themes;
	    }
	  onchange=1;
	  break;
	case F_PREV_MSG:
	  sens_lecture=-1;
	  if((messe!=NULL && messe->numero>0) || message_courant>nb_messages)
	    if(--message_courant<1)
	      message_courant=0;

	  mess2=recup_message(message_courant);

	  if(mess2!=NULL && mess2->themes!=NULL)
	    {
	      tm2=mess2->themes[0];
	      theme_courant=tm2-themes;
	    }
	  onchange=1;
	  break;
	case F_NPAGE_OR_NMESS:
	  if(oldtoto==-2000)
	    message_courant=themes[theme_courant].dernier_lu;
	  sens_lecture=10;
	  temp=theme_courant;
	  pthread_mutex_lock(&mutex_yadunouvo);
	  temp2=message_suivant_absolu(message_courant,&temp,0);
	  if(temp2==0 || (temp!=theme_courant && messe!=NULL && messe->numero>0))
	    {
	      mess2=calloc(1,sizeof(message_t)); // On affiche un "Fin du thème"
	      if(temp2==0)
		{
		  yadunouvo=0;
		  dessine_haut();
		  mess2->numero=-4; // Mieux : on a tout lu.
		}
	    }
	  else
	    {
	      theme_courant=temp;
	      if(temp2>0)
		message_courant=temp2;
	      mess2=recup_message(temp2);
	    }
	  pthread_mutex_unlock(&mutex_yadunouvo);
	  tm2=themes+theme_courant;
	  onchange=1;
	  break;
	case 1:
	case 2:
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
	case 9:
	  sprintf(aze,"%i",toto);
	  temp=0;
	  while(temp==0)
	    {
	      if(prompt_chaine(_("Go to message # : "),aze,BUFMSIZE,0)==0)
		{
		  temp2=atoi(aze);
		  if(temp2>0 && temp2<=nb_messages)
		    temp=1;
		  else
		    mybeep();
		}
	      else
		{
		  temp=1;
		  temp2=0;
		}
	    }
	  if(temp2)
	    {
	      onchange=1;
	      sens_lecture=0;
	      mess2=recup_message(temp2);
	      message_courant=temp2;
	      if(mess2!=NULL && mess2->themes!=NULL)
		{
		  tm2=mess2->themes[0];
		  theme_courant=tm2-themes;
		}
	    }
	  break;
	case F_HELP:
	  mess2=aide();
	  tm2=NULL;
	  onchange=1;
	  break;
	case F_POP_YSTACK:
	case F_POP_BSTACK:
	  if(toto==F_POP_BSTACK)
	    pile_courante=1;
	  else
	    pile_courante=0;
	  temp2=depiler();
	  if(temp2<=0)
	    {
	      mybeep();
	      status_bar(_("Nothing on the stack"),0);
	      break;
	    }
	  status_bar(_("Recalling message"),0);
	  onchange=1;
	  sens_lecture=0;
	  mess2=recup_message(temp2);
	  message_courant=temp2;
	  if(mess2!=NULL && mess2->themes!=NULL)
	    {
	      tm2=mess2->themes[0];
	      theme_courant=tm2-themes;
	    }
	  break;
	case F_PUSH_REPLY:
	  empiler_reponse(messe,0);
	  break;
	case F_LAST_MSG:
	case F_LAST_READ_MSG:
	  if(toto==F_LAST_MSG)
	    message_courant=nb_messages;
	  else
	    message_courant=dernier_msg_lu;
          mess2=recup_message(message_courant);
          if(mess2!=NULL && mess2->themes!=NULL)
            {
              tm2=mess2->themes[0];
              theme_courant=tm2-themes;
            }
          onchange=1;
	  sens_lecture=1;
          break;
	case F_CHANGE_THEME:
	  aze[0]=0;

	  tm2=prompt_themes(_("Goto theme: "),aze,BUFMSIZE,0);
	  if(tm2!=NULL)
	    {
	      onchange=1;
	      theme_courant=tm2-themes;
	      message_courant=tm2->dernier_lu;
	      temp2=message_suivant_alire(tm2->dernier_lu,tm2,1);
	      if(temp2>0)
		message_courant=temp2;
	      mess2=recup_message(message_courant);
	    }
	  break;
	case F_APPLY_FILTER:
	  if(messe!=NULL && prompt_chaine(_("Filter to apply: "),commande_tube,BUFMSIZE,0)==0)
	    {
	      mess2=message_dans_tube(messe,commande_tube);
	      onchange=1;
	    }
	  break;
	case F_TOGGLE_READCENS:
	  if(lire_censure)
	    {
	      lire_censure=0;
	      status_bar(_("Not reading censored messages."),0);
	    }
	  else
	    {
	      lire_censure=1;
	      status_bar(_("Reading censored messages."),0);
	    }
	  break;
	case F_CENSOR:
	  if(censure(messe,taime))
	    mybeep();
	  break;
	case F_LIST_THEMES:
	  mess2=liste_themes(0);
	  tm2=NULL;
	  onchange=1;
	  break;
	case F_LIST_ALL_THEMES:
	  mess2=liste_themes(1);
	  tm2=NULL;
	  onchange=1;
	  break;
	case F_NEW_MESSAGE:
	  repondre(NULL,taime,0,0);
	  break;
	case F_MAIL_REPLY:
	  repondre(messe,taime,1,1);
	  break;
	case F_PREV_IN_THEME:
	  if(oldtoto==-2000)
	    message_courant=themes[theme_courant].dernier_lu;
	  sens_lecture=-2;
	  if(messe!=NULL && messe->numero>0)
	    {
	      temp=message_precedent_alire(message_courant,themes+theme_courant,0);
	      if(temp<=nb_messages && temp>0)
		message_courant=temp;
	    }
	  else
	    temp=message_courant;
	  onchange=1;
	  mess2=recup_message(temp);
	  tm2=themes+theme_courant;
	  break;
	case F_NEXT_IN_THEME:
	  if(oldtoto==-2000)
	    message_courant=themes[theme_courant].dernier_lu;
	  sens_lecture=2;
	  if(messe!=NULL && messe->numero>0)
	    {
	      temp=message_suivant_alire(message_courant,themes+theme_courant,0);
	      if(temp<=nb_messages && temp>0)
		message_courant=temp;
	    }
	  else
	    temp=message_courant;
	  onchange=1;
	  mess2=recup_message(temp);
	  tm2=themes+theme_courant;
	  break;
	case F_QUIT:
	  if(ouinon(_("Do you really want to quit ?"))==0)
	    break;
	case F_FAST_QUIT:
	  marquer_lu(messe,0);
	  quitte(0,_("Goodbye..."));
	case F_REPLY:
	  repondre(messe,taime,1,0);
	  break;
	case F_FAST_REPLY:
	  repondre(messe,taime,0,0);
	  break;
	case F_FILTER:
	  toggle_filter(messe);
	  break;
	case F_SERVER_COMMAND:
	  if(serveur_up==0)
	    {
	      mybeep();
	      break;
	    }
	  aze[0]=0;
	  if(prompt_chaine(_("Server command: "),aze,BUFMSIZE-1,0)==0)
	    {
	      temp=strlen(aze);
	      aze[temp]='\n';
	      aze[temp+1]=0;
	      rata=recup_commande(envoyer_commande(aze));
	      mess2=calloc(1,sizeof(message_t));
	      onchange=1;
	      mess2->numero=-2;
	      mess2->corps=rata;
	      tm2=NULL;
	    }
	  break;
	case F_GOTO_REF_Y:
	case F_GOTO_REF_B:
	  if(toto==F_GOTO_REF_B)
	    pile_courante=1;
	  else
	    pile_courante=0;
	  if((temp2=choisir_reply(messe))>0)
	    {
	      status_bar(_("Going to reference"),0);
	      empiler(message_courant);
	      onchange=1;
	      sens_lecture=0;
	      mess2=recup_message(temp2);
	      message_courant=temp2;
	      if(mess2!=NULL && mess2->themes!=NULL)
		{
		  tm2=mess2->themes[0];
		  theme_courant=tm2-themes;
		}
	    }
	  break;
	case F_LIST_USERS:
	  if(serveur_up)
	    {
	      mess2=liste_logues();
	      tm2=NULL;
	      onchange=1;
            }
	  break;
	case F_TOGGLE_SUBSCRIBE:
	  if(taime!=NULL)
	    strcpy(aze,taime->nom);
	  else
	    aze[0]=0;
	  
	  tm2=prompt_themes(_("Subscribe/unsubscribe to theme: "),aze,BUFMSIZE,0);
	  if(tm2!=NULL)
	    {
	      if(tm2->abonne)
		{
		  tm2->abonne=0;
		  sprintf(aze,_("Unsubscribing to theme %s"),tm2->nom);
		}
	      else
		{
		  tm2->abonne=1;
		  sprintf(aze,_("Subscribing to theme %s"),tm2->nom);
		}
	      status_bar(aze,0);
	      ecrire_dinorc();
	    }
	  break;
	case F_MARK_READ:
	  if(taime!=NULL)
	    {
	      sprintf(aze,_("Mark the theme %s as read ?"),taime->nom);
	      if(ouinon(aze))
		zapper_theme(taime);
	    }
	  else
	    mybeep();
	  break;
	case F_MARK_ALL_READ:
	  if(ouinon(_("Mark all themes as read ?")) && ouinon(_("Are you sure ?")))
	    zapper_theme(NULL);
	  break;
	default:
	  status_bar(_("Unknown command !"),0);
	  mybeep();
	}

      if(onchange)
	{
	  pthread_mutex_lock(&mutex_yadunouvo);
	  switch(sens_lecture)
	    {
	    case 0:
	    case 9:
	    case -1:
	    case 1:
	      if(message_courant>=nb_messages)
		yadunouvo=0;
	      break;
	    case 2:
	    case -2:
	    case 10:
	      if(message_courant>nb_messages)
		yadunouvo=0;
	    }
	  if(message_courant>nb_messages)
	    message_courant_est_plus_grand_que_nb_messages=1;
	  else
	    message_courant_est_plus_grand_que_nb_messages=0;
	  pthread_mutex_unlock(&mutex_yadunouvo);
	  dessine_haut();
	  marquer_lu(messe,0);
	  messe=mess2;
	  taime=tm2;
	  // On efface la barre de statut si elle contient une URL.
	  if(status_bar_est_url)
	    status_bar(NULL,2);
	  //	  effacer_status_bar=1;
	}
    }
}
