/* noms.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <libintl.h>

#include "main.h"
#include "defs.h"
#include "serveur.h"
#include "cache.h"

static char **stock_logins;
static char **stock_noms;
static int *nums_requetes; // On le met à la même taille que les deux précédents, c'est de la mémoire perdue, mais rien de dramatique (~1 ko), et ça simplifie bien les choses.
static int operation_en_cours=0;
static int taille_stock=0;
static int stock_alloue;
static int stock_rempli=0;
static pthread_mutex_t mutex_noms=PTHREAD_MUTEX_INITIALIZER;


/* reallouestock_sibesoin

   Si besoin est, double la taille des 3 tableaux à la con.
   À toujours exécuter avant de faire une opération qui incrémentera taille_stock. On présuppose bien entendu que mutex_noms est bloqué. */

static void reallouestock_sibesoin()
{
  if(stock_alloue==taille_stock)
    { // Plus de place
      stock_alloue=2*stock_alloue;
      stock_logins=realloc(stock_logins,stock_alloue*sizeof(char *));
      stock_noms=realloc(stock_noms,stock_alloue*sizeof(char *));
      nums_requetes=realloc(nums_requetes,stock_alloue*sizeof(int *));
    }
}


/* lire_fichnoms

   lit le fichier de noms stocké localement pour savoir à quel nom correspond un login.*/

void lire_fichnoms()
{
  char boeuf[BUFMSIZE];
  FILE *fichier;
  int vache,taureau;

  stock_alloue=TAILLEMINPILE;
  stock_logins=malloc(stock_alloue*sizeof(char *));
  stock_noms=malloc(stock_alloue*sizeof(char *));
  nums_requetes=malloc(stock_alloue*sizeof(int *));
    

  sprintf(boeuf,"%s/%s/noms",getenv("HOME"),DINO2_DIR);
  fichier=fopen(boeuf,"r");
  if(fichier!=NULL)
    {
      pthread_mutex_lock(&mutex_noms);
      while(fgets(boeuf,BUFMSIZE-1,fichier) != NULL)
	{
	  vache=0;
	  while(boeuf[vache]!='\t' && boeuf[vache]!='\n' && boeuf[vache]!='\0')
	    vache++;
	  if(boeuf[vache]=='\t')
	    {
	      taureau=vache++;
	      while(boeuf[vache]!='\n' && boeuf[vache]!='\0')
		vache++;
	      vache-=taureau;
	      reallouestock_sibesoin();
	      stock_logins[taille_stock]=malloc(taureau+1);
	      strncpy(stock_logins[taille_stock],boeuf,taureau);
	      stock_logins[taille_stock][taureau]='\0';
	      stock_noms[taille_stock]=malloc(vache);
	      strncpy(stock_noms[taille_stock],boeuf+taureau+1,vache-1);
	      stock_noms[taille_stock][vache-1]='\0';
	      taille_stock++;
	      stock_rempli++;
	    }
	}
      pthread_mutex_unlock(&mutex_noms);
      fclose(fichier);
    }
}


/* ecrire_fichnoms

   Y vous faut un dessin ?*/

static void ecrire_fichnoms()
{
  FILE *fichier;
  int jayce;
  char goldorak[BUFMSIZE];

  sprintf(goldorak,"%s/%s/noms",getenv("HOME"),DINO2_DIR);
  fichier=fopen(goldorak,"w");
  if(fichier!=NULL)
    {
      for(jayce=0;jayce<stock_rempli;jayce++)
	{
	  fprintf(fichier,"%s\t%s\n",stock_logins[jayce],stock_noms[jayce]);
	}
      fclose(fichier);
    }
}


/* enregistrer_nom

 Enregistre, à partir du résultat du serveur, le nom dans la base de données.
 Il va de soi que le mutex doit être verrouillé. */

static void enregistrer_nom(char *resultat)
{
  char *kooy;
  size_t mol;

  if(resultat[0]=='E')
    stock_noms[stock_rempli]=strdup(stock_logins[stock_rempli]);
  else
    {
      kooy=strchr(resultat,'(')+1;
      mol=strcspn(kooy,")");
      stock_noms[stock_rempli]=malloc(mol+1);
      strncpy(stock_noms[stock_rempli],kooy,mol);
      stock_noms[stock_rempli][mol]=0;
    }
  stock_rempli++;
  frite(resultat);
}


/* donner_email

Donne l'email d'un gusse, à partir du retour de la commande serveur qui.
Cette email n'est pas stockée, pour la bonne raison qu'un utilisateur est
susceptible d'en changer.
Libère son argument et rend un char * à libérer.  */

char *donner_email(char *resultat)
{
  char *kooy;
  char *trouy;
  size_t mol;

  if(resultat[0]=='E' || (kooy=strstr(resultat," : "))==NULL)
    trouy=strdup("/dev/null@localhost");
  else
    {
      kooy+=3;
      mol=strcspn(kooy," ");
      trouy=malloc(mol+1);
      strncpy(trouy,kooy,mol);
      trouy[mol]=0;
    }
  frite(resultat);
  return trouy;
}


/* recup_cekonpeut

   Récupère du serveur virtuel les résultats des requêtes qui nous sont parvenus. */

static void recup_cekonpeut()
{
  char *baf;
  int i;
  int ontouche=0;

  pthread_mutex_lock(&mutex_noms);
  if(operation_en_cours==0)
    for(i=stock_rempli;i<taille_stock;i++)
      {
	baf=essaye_recup_commande(nums_requetes[i]);
	if(baf==NULL)
	  break;
	else
	  {
	    ontouche=1;
	    enregistrer_nom(baf);
	  }
      }
  if(ontouche)
    ecrire_fichnoms();
  pthread_mutex_unlock(&mutex_noms);
}


/* quisera

   Lance une recherche sur un nom, en prévision du besoin impérieux du résultat dans un avenir proche. */

void quisera(char *loguine)
{
  char bouf[BUFMSIZE];
  int i;

  recup_cekonpeut();
  if(loguine==NULL)
    return;
  pthread_mutex_lock(&mutex_noms);
  for(i=0;i<taille_stock;i++)
    if(strcmp(stock_logins[i],loguine)==0)
      {
	pthread_mutex_unlock(&mutex_noms);
	return; // On a déjà (ou presque).
      }
  reallouestock_sibesoin();
  stock_logins[taille_stock]=strdup(loguine);
  stock_noms[taille_stock]=NULL;
  sprintf(bouf,"qui %s\n",loguine);
  nums_requetes[taille_stock]=envoyer_commande(bouf);
  taille_stock++;
  pthread_mutex_unlock(&mutex_noms);
}


/* quiest

   Comme le 3615 quidonc : renvoie le nom correspondant à un login. 
   Attention : renvoie un truc qu'il ne faut absolument pas libérer avec free.
   Ne lancer que depuis le thread principal (les autres ont quisera).
   Normalement, quisera a déjà été lancé par le cache de messages sur chaque nom qu'on peut avoir à chercher.
*/

char *quiest(char *loguine)
{
  int i;
  char *burp;
  
  recup_cekonpeut();
  pthread_mutex_lock(&mutex_noms);
  for(i=0;i<stock_rempli;i++)
    if(strcmp(loguine,stock_logins[i])==0) // On a déjà
      {
	pthread_mutex_unlock(&mutex_noms);
	return stock_noms[i];
      }
  // Nan, on n'a pas.
  operation_en_cours=1;
  for(;i<taille_stock;i++)
    {
      pthread_mutex_unlock(&mutex_noms);
      burp=recup_commande(nums_requetes[i]);
      pthread_mutex_lock(&mutex_noms);
      enregistrer_nom(burp);
      if(strcmp(loguine,stock_logins[i])==0)
	{
	  ecrire_fichnoms();
	  pthread_mutex_unlock(&mutex_noms);
	  return stock_noms[i];
	}
    }
  // Foiré (ne devrait jamais arriver mais bon)
  ecrire_fichnoms();
  pthread_mutex_unlock(&mutex_noms);
  return loguine;
}

char *login_aleatoire()
{
  return stock_logins[random()%taille_stock];
}


message_t *liste_logues()
{
  char *toto;
  char *tata;
  char *tutu;
  char me[BUFMSIZE];
  char titi[BUFSIZE];
  int j=0;
  int numb=0;
  message_t *retour;

  toto=recup_commande(envoyer_commande("who\n"));
  tata=strstr(toto,"\n|");
  while(tata!=NULL)
    {
      tata+=14;
      tutu=strstr(tata," depuis ");
      if(tutu==NULL || tutu > strchr(tata,'\n'))
	j+=sprintf(titi+j,_("  <i>Hidden user</i>.\n"));
      else
	{
	  strncpy(me,tata,tutu-tata);
	  me[tutu-tata]=0;
	  quisera(me);
	  j+=sprintf(titi+j,_("  User <b>%s</b> (%s) from <i>"),me,quiest(me));
	  tata=tutu+8;
	  tutu=strchr(tata,'\n');
	  strncpy(titi+j,tata,tutu-tata);
	  j=j+tutu-tata;
	  j+=sprintf(titi+j,"</i>.\n");
	}
      numb++;
      tata=strstr(tata,"\n|");
    }
  frite(toto);
  retour=calloc(1,sizeof(message_t));
  retour->numero=-5;
  retour->html=1;
  retour->corps=strdup(titi);
  sprintf(titi,_n("%i connected user","%i connected users",numb),numb);
  retour->sujet=strdup(titi);
  return retour;
}

