/* numeros.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <libintl.h>
#include <sys/stat.h>
#include "defs.h"
#include "init.h"
#include "serveur.h"
#include "main.h"
#include "cache.h"
#include "interface.h"

theme *themes=NULL;
int nbthemes=0;
static int maxthemes;
pthread_mutex_t mutex_themes=PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t mutex_nouveau_theme=PTHREAD_MUTEX_INITIALIZER;



/* realloc_sibesoin

   Si besoin, réalloue de la mémoire pour les numéros de messages du theme atheme, de façon à pouvoir en rajouter combien (qui ne doit pas dépasser TAILLEMINPILE (=20)) */

static void realloc_sibesoin(theme *atheme, int combien)
{
  if( atheme->nb_mesg + combien > atheme->nbms_alloc )
    {
      atheme->nbms_alloc*=2;
      atheme->messages=realloc(atheme->messages,atheme->nbms_alloc*sizeof(int));
    }
}


/* nb_nonlu

   Compte le nombre de messages non lus dans un thème.
   Rajoute dans le pseudo-thème total les messages non lus en question.

*/

int nb_nonlu(theme *park, theme *total)
{
  int i,j,k,l;
  message_t *greuh;

  i=0;j=0;
  while(i<park->nb_mesg && park->messages[i]<=park->dernier_lu) i++;
  for(;i<park->nb_mesg;i++)
    {
      greuh=trouver_message(park->messages[i]);
      if(greuh==NULL)
	{
	  j++;
	  for(l=0;l<total->nb_mesg;l++)
	    if(total->messages[l]==park->messages[i])
	      break;
	  if(l==total->nb_mesg)
	    {
	      realloc_sibesoin(total,1);
	      total->messages[total->nb_mesg++]=park->messages[i];
	    }
	}
      else if(greuh->lu==0)
	{
	  for(k=0;k<greuh->nbthemes;k++)
	    if(greuh->themes[k]==park)
	      break;
	  if(lire_censure || greuh->censure[k]==0)
	    {
	      j++;
	      for(l=0;l<total->nb_mesg;l++)
		if(total->messages[l]==park->messages[i])
		  break;
	      if(l==total->nb_mesg)
		{
		  realloc_sibesoin(total,1);
		  total->messages[total->nb_mesg++]=park->messages[i];
		}
	    }
	}
    }
  return j;
}


/* liste_themes

   Donne un pseudo-message qui contient la liste des/de tous les thèmes */

message_t *liste_themes(int tous)
{
  message_t *rinite;
  int i,j,c,z,temp;
  char yo[BUFMSIZE];
  int nombre=0;
  int new=0;
  int empestif=0;
  theme total;

  rinite=calloc(1,sizeof(message_t));
  
  rinite->numero=-1;
  rinite->heure=0;
  rinite->html=1;
  rinite->corps=malloc(BUFSIZE);
  j=0;c=0;
  if(coolitude)
    j=sprintf(rinite->corps,"%s\n\n",coool());
  pthread_mutex_lock(&mutex_themes);

  total.nb_mesg=0;
  total.nbms_alloc=TAILLEMINPILE;
  total.messages=malloc(TAILLEMINPILE*sizeof(int));

  for(i=0;i<nbthemes && j<BUFSIZE-100;i++)
    if(tous || themes[i].abonne)
      {
	temp=nb_nonlu(themes+i,&total);
	nombre++;
	if(temp)
	  new++;
	z=sprintf(yo,"  %s%s (%i)%s",temp?"<b>":"",themes[i].nom,temp,temp?"</b>":"")-(temp?7:0);
	if(c+z>79)
	  {
	    c=0;
	    rinite->corps[j++]='\n';
	  }
	c+=z;
	j+=sprintf(rinite->corps+j,"%s",yo);
	if(c>60)
	  {
	    c=0;
	    rinite->corps[j++]='\n';
	  }
	while(c%20)
	  {
	    rinite->corps[j++]=' ';
	    c++;
	  }
      }
  pthread_mutex_unlock(&mutex_themes);
  empestif=total.nb_mesg;
  frite(total.messages);
  sprintf(yo,_("%i %s, %i %s in %i %s"),nombre,tous?_("total themes"):_("subscribed themes"),empestif,_n("new message","new messages",empestif),new,_n("theme","themes",new));
  rinite->sujet=strdup(yo);
  while(rinite->corps[j-1]==' ' || rinite->corps[j-1]=='\n') j--;
  rinite->corps[j++]='\n';
  rinite->corps[j++]=0;
  rinite->corps=realloc(rinite->corps,j);
  return rinite;
}


/* ajouter_message_theme

   Ajoute le message anumero dans la liste des messages du thème atheme.
   voisin peut prendre 3 valeurs :
    - 0 pour le mettre à la fin (invoqué pour un nouveau message)
    - -1 pour un message sans relation avec les autres messages (on le sépare alors des autres par des 0) (invoqué quand on affiche un message au hasard)
    - le numéro d'un message *déjà dans la liste*, pour le mettre à côté (quand on passe d'un message au précédent ou au suivant)

    Le deuxième et le troisième cas doivent gérer les doublons.

*/

void ajouter_message_theme(theme *atheme, int anumero, int voisin)
{
  int i;
  pthread_mutex_lock(&mutex_themes);

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Avant\nThème %s :",atheme->nom);
      for(i=0;i<atheme->nb_mesg;i++)
	fprintf(logfile," %i",atheme->messages[i]);
      fprintf(logfile,"\nAjout du message %i\n",anumero);
      fflush(logfile);
    }
  
  if(voisin==0)
    {
      realloc_sibesoin(atheme,1);
      atheme->messages[atheme->nb_mesg++]=anumero;
    }
  else if(anumero==0)
    ;
  else if(voisin<0)
    {
      for(i=0;i<atheme->nb_mesg;i++)
	{
	  if(atheme->messages[i]==anumero) // doublon
	    break;
	  if(atheme->messages[i]>anumero)
	    {
	      realloc_sibesoin(atheme,2);
	      memmove(atheme->messages+i+2,atheme->messages+i,(atheme->nb_mesg-i)*sizeof(int));
	      atheme->nb_mesg+=2;
	      atheme->messages[i]=anumero;
	      atheme->messages[i+1]=0;
	      break;
	    }
	}
      // Si anumero est plus grand que tout le contenu, on ne l'ajoute pas : il sera ajouté proprement par le routineur
    }
  else
    for(i=0;i<atheme->nb_mesg;i++)
      {
	if(atheme->messages[i]==anumero) // doublon
	  {
	    if(i+1<atheme->nb_mesg && atheme->messages[i+1]==0) // on a une info supplémentaire
	      {
		memmove(atheme->messages+i+1,atheme->messages+i+2,(atheme->nb_mesg-i-2)*sizeof(int));
		atheme->nb_mesg--;
	      }
	    break;
	  }
	if(atheme->messages[i]==voisin)
	  {
	    if(voisin>anumero) // Aucune inquiétude, on le fout à côté.
	      {
		realloc_sibesoin(atheme,1);
		memmove(atheme->messages+i+1,atheme->messages+i,(atheme->nb_mesg-i)*sizeof(int));
		atheme->nb_mesg++;
		atheme->messages[i]=anumero;
	      }
	    // il peut encore se situer après
	    else if(i+1<atheme->nb_mesg && atheme->messages[i+1]==anumero) // on n'a rien appris
	      break;
	    else if(i+2<atheme->nb_mesg && atheme->messages[i+2]==anumero) // on va pouvoir virer le zéro entre les deux.
	      {
		memmove(atheme->messages+i+1,atheme->messages+i+2,(atheme->nb_mesg-i-2)*sizeof(int));
		atheme->nb_mesg--;
	      }
	    else // On l'ajoute tranquillement à la suite
	      {
		realloc_sibesoin(atheme,1);
		memmove(atheme->messages+i+2,atheme->messages+i+1,(atheme->nb_mesg-i-1)*sizeof(int));
		atheme->nb_mesg++;
		atheme->messages[i+1]=anumero;
	      }
	    break;
	  }
      }

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Après\nThème %s :",atheme->nom);
      for(i=0;i<atheme->nb_mesg;i++)
	fprintf(logfile," %i",atheme->messages[i]);
      fprintf(logfile,"\n");
      fflush(logfile);
    }

  pthread_mutex_unlock(&mutex_themes);
}


/* themes_nouveau_message

   Regarde dans un message, et ajoute dans les thèmes les informations.
   Si nouveau est placé à 1, c'est qu'il est nouveau (ajouté à priori par les récupérations d'en-têtes du routineur). S'il est à 0, c'est un numéro arbitraire.
 */

void themes_nouveau_message(message_t *amesg,int nouveau)
{
  int i;
  
  if(amesg==NULL)
    return;
  for(i=0;i<amesg->nbthemes;i++)
    ajouter_message_theme(amesg->themes[i],amesg->numero,nouveau-1);
}


/* lire_dinorc

   Remplit le tableau des thèmes à partir du .dinorc, en mettant juste le nom, le dernier message lu et si on y est abonné. */

static int lire_dinorc()
{
  FILE *fichier;
  char rhinoferoce[BUFMSIZE];
  char poissonvert[BUFMSIZE];
  char girafon=0;
  int tigron;
  int gazouillis;
  int i;
  struct stat savane;

  if (stat(dinorc_file,&savane))
    return -1;
  if (savane.st_size)
    fichier=fopen(dinorc_file,"r");
  else {
    int girafe = strlen(dinorc_file);
    char tamanoir[girafe+5+1];
    snprintf(tamanoir, sizeof(tamanoir), "%s.save", dinorc_file);
    if (stat(tamanoir,&savane) || !savane.st_size)
      /* vraiment pas :( */
      return -1;
    fichier=fopen(tamanoir,"r");
  }
  if(fichier!=NULL)
    {
      while(fgets(rhinoferoce,BUFMSIZE-1,fichier) != NULL)
	{
	  gazouillis=sscanf(rhinoferoce,"%s %i %c",poissonvert,&tigron,&girafon);
	  if(gazouillis>1)
	    {
	      for(i=0;i<nbthemes;i++)
		{
		  if(strcmp(themes[i].nom,poissonvert)==0)
		    {
		      themes[i].dernier_lu=tigron;
		      /* if(tigron>message_courant)
			 message_courant=tigron; */
		      ajouter_message_theme(themes+i,tigron,0);
		      if(gazouillis==3 && girafon=='*')
			themes[i].abonne=0;
		      break;
		    }
		}
	    }
	}
      fclose(fichier);
      return 0;
    }
  return -1; // foiré
}


static int lire_dernier_lu()
{
  char rhinoferoce[BUFMSIZE];
  FILE *fichier;
  int tigron,ligron;

  sprintf(rhinoferoce,"%s/%s/dernier_lu",getenv("HOME"),DINO2_DIR);
  fichier=fopen(rhinoferoce,"r");
  ligron=0;
  if(fichier!=NULL)
    {
      ligron=fscanf(fichier,"%i",&tigron);
      fclose(fichier);
    }
  if(ligron==1)
    return tigron;
  else
    return -1;
}


/* ecrire_dinorc

   Écrit dans ~/.dinorc la liste des thèmes, les abonnements, et le dernier message lu de chaque thème. */

void ecrire_dinorc()
{
  FILE *fichier;
  int boulet;
  char canon;
  char sauvage[BUFMSIZE];

  sprintf(sauvage,"%s.temp",dinorc_file);
  fichier=fopen(sauvage,"w");
  if(fichier!=NULL)
    {
      for(boulet=0;boulet<nbthemes;boulet++)
	{
	  if(themes[boulet].abonne)
	    canon=' ';
	  else
	    canon='*';
	  
	  fprintf(fichier,"%s %i %c\n",themes[boulet].nom,themes[boulet].dernier_lu,canon);
	}
      fclose(fichier);
    }
  sprintf(sauvage,"%s.save",dinorc_file);
  remove(sauvage);
  rename(dinorc_file,sauvage);
  sprintf(sauvage,"%s.temp",dinorc_file);
  rename(sauvage,dinorc_file);
}

void ecrire_dernier_lu(int erne)
{
  char sauvage[BUFMSIZE];
  FILE *fichier;

  sprintf(sauvage,"%s/%s/dernier_lu",getenv("HOME"),DINO2_DIR);
  fichier=fopen(sauvage,"w");
  if(fichier!=NULL)
    {
      fprintf(fichier,"%i\n",erne);
      fclose(fichier);
    }
}

/* lire fichthemes

   Lit ~/.dino2/themes pour y trouver les informations sur les thèmes qui sont déjà en notre possession. */

static void lire_fichthemes()
{
  char winnie[BUFMSIZE];
  char bourriquet[BUFMSIZE];
  FILE *fichier;
  int porcinet,tigrou,jeannot;
  
  sprintf(winnie,"%s/%s/themes",getenv("HOME"),DINO2_DIR);
  fichier=fopen(winnie,"r");
  if(fichier!=NULL)
    {
      while(fgets(bourriquet,BUFMSIZE-1,fichier) != NULL)
	{
	  porcinet=0;
	  while(bourriquet[porcinet]!='\t' && bourriquet[porcinet]!='\n' && bourriquet[porcinet]!='\0')
	    porcinet++;
	  if(bourriquet[porcinet]=='\t')
	    {
	      jeannot=porcinet++;
	      while(bourriquet[porcinet]!='\n' && bourriquet[porcinet]!='\0')
		porcinet++;
	      porcinet-=jeannot;
	      for(tigrou=0;tigrou<nbthemes;tigrou++)
		if(strncmp(bourriquet,themes[tigrou].nom,jeannot)==0 && themes[tigrou].nom[jeannot]==0)
		  {
		    frite(themes[tigrou].infos);
		    themes[tigrou].infos=malloc(porcinet);
		    strncpy(themes[tigrou].infos,bourriquet+jeannot+1,porcinet-1);
		    themes[tigrou].infos[porcinet-1]='\0';
		    break;
		  }
	    }
	}
      fclose(fichier);
    }
}


/* ecrire_fichthemes

Écriture du fichier des thèmes, avec les informations sur le créateur et la censure (gniark) */

void ecrire_fichthemes()
{
  FILE *fichier;
  int jayce;
  char goldorak[BUFMSIZE];

  sprintf(goldorak,"%s/%s/themes",getenv("HOME"),DINO2_DIR);
  fichier=fopen(goldorak,"w");
  if(fichier!=NULL)
    {
      for(jayce=0;jayce<nbthemes;jayce++)
	{
	  fprintf(fichier,"%s\t%s\n",themes[jayce].nom,themes[jayce].infos);
	}
      fclose(fichier);
    }
}


/* info_theme

   Donne les infos du thème sous leur forme affichable. Peut s'utiliser directement avec recup_commande. */

char *info_theme(char *satan)
{
  char *antechrist;
  char demon[BUFMSIZE];
  int j;

  antechrist=strstr(satan,"cree par ")+9;
  j=0;
  while(antechrist[j]!='.') j++;
  antechrist[j]=0;
  sprintf(demon,"%s %s (%s)",(strstr(satan,"modere")?_("Moderated"):_("Free")),(strstr(satan,"signe")?_("Signed"):_("Anonymous")),antechrist);
  frite(satan);
  return strdup(demon);
}


/* resultat_commande_suivants

   Enregistre les résultats de la commande suivants dans le thème considéré. Les envoie à la fin de la liste des messages, comme de bien entendu. Retourne la valeur du dernier. */

int resultat_commande_suivants(char *broups, theme *atheme)
{
  int j=0,a=0;

  if(broups[0]=='E')
    return 0;

  while(1)
    {
      while(broups[j]!='|' && broups[j]!='#') j++;
      if(broups[j]=='#')
	break;
      j++;
      sscanf(broups+j,"%d\n",&a);
      ajouter_message_theme(atheme,a,0);
    }
  frite(broups);
  return a;
}


/* nouveau_theme

   Un nouveau thème est trouvé en cours de fonctionnement, on l'ajoute à la base de données.
   mutex_themes ne DOIT pas être bloqué.*/

theme *nouveau_theme(char *groar)
{
  int j;
  int a,b;
  char trouduc[BUFMSIZE];

  pthread_mutex_lock(&mutex_nouveau_theme);
  for(j=0;j<nbthemes;j++)
    if(strcmp(groar,themes[j].nom)==0)
      break;

  if(j==nbthemes)
    {
      if(nbthemes==maxthemes)
	quitte(1,_("Non fatal error: too many themes created.\nPlease launch again the client."));
      
      sprintf(trouduc,"info %s\n",groar);
      a=envoyer_commande(trouduc);
      sprintf(trouduc,"suivants 0 %s\n",groar);
      b=envoyer_commande(trouduc);
      
      themes[nbthemes].nom=strdup(groar);
      themes[nbthemes].infos=info_theme(recup_commande(a));
      themes[nbthemes].abonne=1;
      themes[nbthemes].nbms_alloc=TAILLEMINPILE;
      themes[nbthemes].messages=malloc(TAILLEMINPILE*sizeof(int));
      themes[nbthemes].messages[0]=0;
      themes[nbthemes].nb_mesg=1;
      themes[nbthemes].dernier_msg=resultat_commande_suivants(recup_commande(b),themes+nbthemes);
      themes[nbthemes].dernier_lu=0;
      pthread_mutex_lock(&mutex_themes);
      nbthemes++;
      pthread_mutex_unlock(&mutex_themes);
    }
  pthread_mutex_unlock(&mutex_nouveau_theme);
  return themes+j;
}


/* zapper_theme

   Marque tout un thème comme lu. Si l'argument vaut NULL, on fait pareil pour tous les thèmes */

void zapper_theme(theme *attik)
{
  int i;
  char g[BUFMSIZE];

  pthread_mutex_lock(&mutex_themes);
  if(attik!=NULL)
    attik->dernier_lu=attik->dernier_msg;
  else
    for(i=0;i<nbthemes;i++)
      themes[i].dernier_lu=themes[i].dernier_msg;
  pthread_mutex_unlock(&mutex_themes);

  if(attik!=NULL)
    sprintf(g,_("Theme %s zapped."),attik->nom);
  else
    sprintf(g,_("All the themes have been zapped !"));
  status_bar(g,0);
  ecrire_dinorc();
}


/* init_recup_numeros

   Initialisation (dans le thread principal) de la liste des thèmes, avec ce qui reste à lire dedans. 
   Renvoie le numéro du dernier message lu. */

int init_recup_numeros()
{
  int belzebuth;
  int diablo;
  int i,j,kloups;
  char *satan;
  int rivano[MAX_SIMULT_COMMANDES]; // Si on dépasse 250 thèmes environ, on risque de s'exposer à une erreur "trop de commmandes simultanées", il faudra alors augmenter cette constante.
  char demon[BUFMSIZE];

  belzebuth=envoyer_commande("derniers\n");

  themes=calloc(MAX_THEMES,sizeof(theme));

  satan=recup_commande(belzebuth);
  i=0;
  for(;;) {
    while(satan[i]!='|' && satan[i]!='#') i++;
    if((satan[i]=='#') || (nbthemes==MAX_THEMES)) break;
    i++;
    sscanf(satan+i,"%s : %d\n",demon,&diablo);
    for(j=0;j<nbthemes;j++)
      if(strcasecmp(demon,themes[j].nom)<0)
	break;
    if(j<nbthemes) // Il va falloir bouger des trucs
      memmove(themes+j+1,themes+j,(nbthemes-j)*sizeof(theme));
    // Vaut moins qu'un tri à bulles, mais c'est plus propre.
    themes[j].nom=strdup(demon);
    themes[j].abonne=1;
    themes[j].dernier_msg=diablo;
    themes[j].nbms_alloc=TAILLEMINPILE;
    themes[j].messages=malloc(TAILLEMINPILE*sizeof(int));
    themes[j].messages[0]=0;
    themes[j].nb_mesg=1;
    nbthemes++;
  }
  frite(satan);

  maxthemes=nbthemes+MAX_NVX_THEMES;
  themes=realloc(themes,maxthemes*sizeof(theme));

  // Qu'est-ce qu'on a cheux nous ?
  kloups=lire_dinorc(); // -1 si c'est le premier lancement
  lire_fichthemes();

  diablo=0;
  // On demande ce qui manque.
  for(belzebuth=0;belzebuth<nbthemes;belzebuth++)
    {
      if(themes[belzebuth].infos==NULL)
	{
	  sprintf(demon,"info %s\n",themes[belzebuth].nom);
	  rivano[diablo++]=envoyer_commande(demon);
	}
      if(kloups<0 || themes[belzebuth].abonne==0)
	{ // on marque les thèmes désabonnés comme lus
	  if(themes[belzebuth].dernier_lu!=themes[belzebuth].dernier_msg)
	    {
	      themes[belzebuth].dernier_lu=themes[belzebuth].dernier_msg;
	      ajouter_message_theme(themes+belzebuth,0,0);
	      ajouter_message_theme(themes+belzebuth,themes[belzebuth].dernier_msg,0);
	    }
	}

      if(themes[belzebuth].dernier_msg > themes[belzebuth].dernier_lu) // Y'a du nouveau
	{
	  sprintf(demon,"suivants %i %s\n",themes[belzebuth].dernier_lu,themes[belzebuth].nom);
	  rivano[diablo++]=envoyer_commande(demon);
	}
    }

  // Bon maintenant on va récupérer toute cette merde.
  diablo=0;
  for(belzebuth=0;belzebuth<nbthemes;belzebuth++)
    {
      if(themes[belzebuth].infos==NULL)
	{
	  themes[belzebuth].infos=info_theme(recup_commande(rivano[diablo++]));
	}
      if(themes[belzebuth].dernier_msg > themes[belzebuth].dernier_lu)
	{
	  resultat_commande_suivants(recup_commande(rivano[diablo++]),themes+belzebuth);
	}
    }
  ecrire_fichthemes();
  ecrire_dinorc();

  kloups=lire_dernier_lu();
  if(kloups<=0)
    {
      kloups=0;
      for(i=0;i<nbthemes;i++)
	if(themes[i].abonne && themes[i].dernier_lu>kloups)
	  kloups=themes[i].dernier_lu;
    }
  
  return kloups;
}


/* message_suivant

 Donne le message suivant binquoi dans le thème atheme.
 Si le résultat n'est pas immédiatement trouvé, que le serveur est indisponible et que indispensable est à zéro (ça en fait des conditions), il ne cherche pas plus loin et retourne -1.
 On retourne 0 si le message est inexistant.
 */

int message_suivant(int binquoi,theme *atheme,int indispensable) // spensable
{
  int i,iii;
  char mouif[BUFMSIZE];
  char *mouaf;

  pthread_mutex_lock(&mutex_themes);

  for(i=0;i<atheme->nb_mesg;i++)
    if(binquoi==atheme->messages[i])
      break;
  if(i==atheme->nb_mesg) // binquoi ne figure pas dans la base de données. Non mais !
    {
      pthread_mutex_unlock(&mutex_themes);
      return 0;
    }
  if(i==atheme->nb_mesg-1)
    { // binquoi est le dernier message
      pthread_mutex_unlock(&mutex_themes);
      return 0;
    }
  if(atheme->messages[i+1])
    { // On connaît déjà l'information.
      pthread_mutex_unlock(&mutex_themes);
      return atheme->messages[i+1];
    }
  pthread_mutex_unlock(&mutex_themes);
  if(serveur_up==0 && indispensable==0)
    return -1; // On ne dispose pas de l'info immédiatement. 
  
  sprintf(mouif,"suivant %i %s\n",binquoi,atheme->nom);
  iii=envoyer_commande(mouif);
  mouaf=recup_commande(iii);
  if(mouaf[0]=='E') // Ne devrait jamais arriver avec suivant, mais bon.
    {
      frite(mouaf);
      return 0;
    }
  sscanf(mouaf,"Ok/1: %i",&iii);
  frite(mouaf);
  ajouter_message_theme(atheme,iii,binquoi);
  return iii;
}


/* message_precedent

 Donne le message précédant binquoi dans le thème atheme.
 Voir la fonction précédente.
 */

int message_precedent(int binquoi,theme *atheme,int indispensable)
{
  int i,iii;
  char mouif[BUFMSIZE];
  char *mouaf;

  pthread_mutex_lock(&mutex_themes);
  
  for(i=1;i<atheme->nb_mesg;i++)
    if(binquoi==atheme->messages[i])
      break;
  if(i==atheme->nb_mesg) // binquoi ne figure pas dans la base de données. Non mais !
    {
      pthread_mutex_unlock(&mutex_themes);
      return 0;
    }
  if(atheme->messages[i-1])
    { // On connaît déjà l'information.
      pthread_mutex_unlock(&mutex_themes);
      return atheme->messages[i-1];
    }
  pthread_mutex_unlock(&mutex_themes);
  if(serveur_up==0 && indispensable==0)
    return -1; // On ne dispose pas de l'info immédiatement. 
  
  sprintf(mouif,"precedent %i %s\n",binquoi,atheme->nom);
  iii=envoyer_commande(mouif);
  mouaf=recup_commande(iii);
  if(mouaf[0]=='E') // On est au début du thème
    {
      frite(mouaf);
      return 0;
    }
  sscanf(mouaf,"Ok/1: %i",&iii);
  frite(mouaf);
  ajouter_message_theme(atheme,iii,binquoi);
  return iii;
}


/* message_suivant_alire
   message_precedent_alire

 Donne le message qui suit/précède quoi dans le thème ttheme, en tenant compte de la censure (on saute les messages censurés si on a configuré le client pour).
 Comme toujours, indispensable définit si on doit se bloquer si besoin.
*/

int message_suivant_alire(int quoi,theme *atheme,int indispensable)
{
  int buf,i;
  message_t *bif;
  
  buf=quoi;
  for(;;)
    {
      buf=message_suivant(buf,atheme,indispensable);
      if(lire_censure || buf<=0)
	return buf;
      bif=trouver_message(buf);
      if(bif==NULL)
	return buf;
      for(i=0;i<bif->nbthemes;i++)
	if(bif->themes[i]==atheme)
	  if(bif->censure[i]==0)
	    return buf;
    }
}

int message_precedent_alire(int quoi,theme *atheme,int indispensable)
{
  int buf,i;
  message_t *bif;
  
  buf=quoi;
  for(;;)
    {
      buf=message_precedent(buf,atheme,indispensable);
      if(lire_censure || buf<=0)
	return buf;
      bif=trouver_message(buf);
      if(bif==NULL)
	return buf;
      for(i=0;i<bif->nbthemes;i++)
	if(bif->themes[i]==atheme)
	  if(bif->censure[i]==0)
	    return buf;
    }
}


/* message_suivant_absolu

   Donne le message qui suit quoi dans le thème ttheme, dans l'ordre de la lecture, en tenant compte de la censure, des messages lus et des abonnements. Modifie le thème le cas échéant (faire gaffe, donc !).
*/

int message_suivant_absolu(int quoi,int *ttheme, int indispensable)
{
  int buf,i,gloup;
  message_t *bif;
  
  buf=quoi;
  gloup=*ttheme;
  if(buf<themes[*ttheme].dernier_lu)
    buf=themes[*ttheme].dernier_lu;
  for(;;)
    {
      buf=message_suivant(buf,themes+*ttheme,indispensable);
      
      while(buf==0)
	{
	  i=0;
	  while(i==0)
	    {
	      *ttheme=*ttheme+1;
	      if(*ttheme==nbthemes)
		*ttheme=0;
	      if(*ttheme==gloup)
		return 0; // On a fait le tour.
	      if(themes[*ttheme].abonne)
		i=1;
	    }
	  buf=message_suivant(themes[*ttheme].dernier_lu,themes+*ttheme,indispensable);
	}
      if(buf<0)
	return buf;
      bif=trouver_message(buf);
      if(bif==NULL)
	return buf;
      if(bif->lu==0) // Si déjà lu, on saute
	{
	  if(lire_censure)
	    return buf;
	  for(i=0;i<bif->nbthemes;i++)
	    if(bif->themes[i]==themes+*ttheme)
	      if(bif->censure[i]==0)
		return buf;
	}
    }
}
