/* pile.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <libintl.h>
#include "defs.h"
#include "interface.h"
#include "main.h"


int pile_courante=0;  // 0 ou 1 (il y a 2 piles)
int *pile[2];
int taille_pile[2];
int remplissage_pile[2];

static void glouglou_sibesoin()
{
  if(remplissage_pile[pile_courante]>taille_pile[pile_courante]-2)
    {
      taille_pile[pile_courante]*=2;
      pile[pile_courante]=realloc(pile[pile_courante],taille_pile[pile_courante]*sizeof(int));
    }
}


void InitPile()
{
  FILE *fichier;
  char te[BUFSIZE];
  int vache,boeuf;

  pile[0]=malloc(TAILLEMINPILE*sizeof(int));
  taille_pile[0]=TAILLEMINPILE;
  remplissage_pile[0]=0;
  pile[1]=malloc(TAILLEMINPILE*sizeof(int));
  taille_pile[1]=TAILLEMINPILE;
  remplissage_pile[1]=0;
  
  sprintf(te,"%s/%s/piles",getenv("HOME"),DINO2_DIR);

  fichier=fopen(te,"r");
  if(fichier!=NULL)
    {
      for(pile_courante=0;pile_courante<2;pile_courante++)
	if(fgets(te,BUFSIZE,fichier)!=NULL)
	  {
	    vache=0;
	    while(te[vache]!=0 && te[vache]!='\n')
	      {
		if(sscanf(te+vache,"\t%i",&boeuf)<1)
		  break;
		if(boeuf<=0)
		  break;
		glouglou_sibesoin();
		pile[pile_courante][remplissage_pile[pile_courante]++]=boeuf;
		vache++;
		while(te[vache]!='\t' && te[vache]!='\n' && te[vache]!=0) vache++;
	      }	    
	  }
      fclose(fichier);
    }
  pile_courante=0;
}


void ecrire_fichpile()
{
  FILE *fichier;
  int i,j;
  char te[BUFMSIZE];
  
  sprintf(te,"%s/%s/piles",getenv("HOME"),DINO2_DIR);

  fichier=fopen(te,"w");
  if(fichier!=NULL)
    {
      for(i=0;i<2;i++)
	{
	  for(j=0;j<remplissage_pile[i];j++)
	    fprintf(fichier,"\t%i",pile[i][j]);
	  fprintf(fichier,"\n");
	}
      fclose(fichier);
    }
}


void retourner_pile()
{
  int i,temp;
  for(i=0;i<remplissage_pile[pile_courante]/2;i++)
    {
      temp=pile[pile_courante][i];
      pile[pile_courante][i]=pile[pile_courante][remplissage_pile[pile_courante]-1-i];
      pile[pile_courante][remplissage_pile[pile_courante]-1-i]=temp;
    }
  afficher_pile();
  ecrire_fichpile();
}

void roll_droite()
{
  int temp;
  if(remplissage_pile[pile_courante]>1)
    {
      temp=pile[pile_courante][remplissage_pile[pile_courante]-1];
      memmove(pile[pile_courante]+1,pile[pile_courante],(remplissage_pile[pile_courante]-1)*sizeof(int));
      pile[pile_courante][0]=temp;
    }
  afficher_pile();
  ecrire_fichpile();
}


void roll_gauche()
{
  int temp;
  if(remplissage_pile[pile_courante]>1)
    {
      temp=pile[pile_courante][0];
      memmove(pile[pile_courante],pile[pile_courante]+1,(remplissage_pile[pile_courante]-1)*sizeof(int));
      pile[pile_courante][remplissage_pile[pile_courante]-1]=temp;
    }
  afficher_pile();
  ecrire_fichpile();
}


void empiler(int ernet)
{
  if(ernet<=0)
    return;
  glouglou_sibesoin();
  pile[pile_courante][remplissage_pile[pile_courante]++]=ernet;
  afficher_pile();
  ecrire_fichpile();
}

int depiler()
{
  int toto=0;

  if(remplissage_pile[pile_courante])
    toto=pile[pile_courante][--remplissage_pile[pile_courante]];
  if(remplissage_pile[pile_courante]==0 && remplissage_pile[1-pile_courante]>0)
    pile_courante=1-pile_courante;
  
  afficher_pile();
  ecrire_fichpile();
  return toto;
}


void changer_pile()
{
  pile_courante=1-pile_courante;
  afficher_pile();
}
