/* poste.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <pthread.h>
#include <semaphore.h>
#include <ncurses.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <libintl.h>
#include <errno.h>
#include "defs.h"
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_ICONV
#include <limits.h>
#include <iconv.h>
#endif
#include "serveur.h"
#include "interface.h"
#include "init.h"
#include "conv.h"
#include "routineur.h"
#include "noms.h"
#include "numeros.h"
#include "main.h"
#include "cache.h"
#include "externe.h"
#include "sem.h"

extern int mymvprintw(int y, int x, const char *fmt, ...);

static int pile_reponses[MAXREPLYS];
static int nb_reponses=0;
static char *fichier_temporaire;

typedef struct {
  int *reponses;
  sem_t _attente;
  sem_t *attente;
  char *lesfraises;
  char *fichier;
  char *sujet;
  char *email;
} argu_poste;


void empiler_reponse(message_t *act, int onrepond)
{
  char toto[BUFMSIZE];
  FILE *etnerevienspas;
  char *rue;
  int i;

  if(nb_reponses==0)
    {
#ifdef __CYGWIN__
      fichier_temporaire=strdup("_dino2_XXXXXX");
#else
      fichier_temporaire=strdup("/tmp/dino2_XXXXXX");
#endif
      close(mkstemp(fichier_temporaire));
    }

  if(act!=NULL && act->numero>0 && nb_reponses<MAXREPLYS)
    {
      pile_reponses[nb_reponses++]=act->numero;
      if(onrepond)
	sprintf(toto,_("Reply to the message %i"),act->numero);
      else
	sprintf(toto,_("Message %i added to the next reply."),act->numero);
      status_bar(toto,0);
    }
  if(act!=NULL && act->corps!=NULL)
    {
      rue=conversion(act->corps,defaut_type,1);
      etnerevienspas=fopen(fichier_temporaire,"a");
      for(i=0;repoonse[i];i++)
	{
	  if(repoonse[i]=='%')
	    {
	      switch(repoonse[i+1])
		{
		case 'a': {
		  char *auteur=(act->auteur!=NULL)?act->auteur:_("A fool");
#ifdef HAVE_ICONV
		  if (subircs!=(iconv_t)(-1)) {
		    size_t si = strlen(auteur), so = 4*MB_CUR_MAX*si;
		    char bufo[so];
		    fwrite(bufo,subircser(act->auteur,si,bufo,so),1,etnerevienspas);
		  } else
#endif
		  fputs(auteur,etnerevienspas);
		  i++;
		  break;
		}
		case 'd':
#ifdef HAVE_ICONV
		  if (subircs!=(iconv_t)(-1)) {
		    size_t si = strlen(act->date), so = 4*MB_CUR_MAX*si;
		    char bufo[so];
		    fwrite(bufo,subircser(act->date,si,bufo,so),1,etnerevienspas);
		  } else
#endif
		  fputs(act->date,etnerevienspas);
		  i++;
		  break;
		case 'n':
		  if(act->numero>0)
		    fprintf(etnerevienspas,"%i",act->numero);
		  else
		    fputs(_("what ?"),etnerevienspas);
		  i++;
		  break;
		case '%':
		  i++;
		default:
		  fputc('%',etnerevienspas);
		  break;
		}
	    }
	  else
	    fputc(repoonse[i],etnerevienspas);
	}
#ifdef HAVE_ICONV
      if (scribus!=(iconv_t)(-1)) {
	size_t bidi=strlen(rue),bop=4*MB_CUR_MAX*bidi;
	char avenue[bop+1];
	avenue[subircser(rue,bidi,avenue,bop)]=0;
	fprintf(etnerevienspas,"\n\n%s\n\n",avenue);
      } else
#endif
      fprintf(etnerevienspas,"\n\n%s\n\n",rue);
      fclose(etnerevienspas);
      frite(rue);
    }
}



static void thread_poste(argu_poste *gloup)
{
  int i;
  FILE *etnerevienspas;
  int onquitte=0;int onedite;
  char *pseud;char *thms;
  int sig=defaut_signe;
  char *patate=NULL;
  char *douce=NULL;
  int type=defaut_type;
  char filtre[BUFMSIZE];
  int zarma=0;

  //  init_signaux();

  filtre[0]=0;

  pseud=malloc(BUFMSIZE);
  sprintf(pseud,"%s",nickname);

  thms=malloc(BUFMSIZE);
  sprintf(thms,"%s",gloup->lesfraises);

  onedite=1;
  while(onquitte==0)
    {
      if(onedite>0)
	lancer_externe(editeeur,gloup->fichier,NULL,NULL);
      onedite=0;
      dessine_haut();
      while(onquitte==0 && onedite==0)
	{
	  status_bar(_("New message"),1);
	  pthread_mutex_lock(&mutex_interface);
	  attriset(COUL(2)|A_REVERSE);
	  myclrtoeol(1,0);
	  mymvprintw(1,3,_("Edit | pOst | caNcel"));
	  attriset(0);
	  myclrtoeol(2,0);
	  mymvprintw(2,0,_("Nick     : %s"),pseud);
	  myclrtoeol(3,0);
	  mymvprintw(3,0,_("Subject  : %s"),gloup->sujet);
	  myclrtoeol(4,0);
	  mymvprintw(4,0,_("Theme(s) : %s"),thms);
	  myclrtoeol(5,0);
	  mymvprintw(5,0,_("e-Mail   : %s"),gloup->email);
	  myclrtoeol(6,0);	  
	  mymvprintw(6,0,_("sIgned   : %s"),sig?quiest(login):"");
	  myclrtoeol(7,0);
	  mymvprintw(7,0,_("tYpe     : %s"),type?((type==1)?_("HTML with checking"):_("Basic text")):_("HTML without checking (be CAREFUL)"));
	  myclrtoeol(8,0);
	  mymvprintw(8,0,_("F|lter   : %s"),filtre);
	  for(i=9;i<LINES-2;i++)
	    {
	      myclrtoeol(i,0);
	    }
	  rafraichir();
	  pthread_mutex_unlock(&mutex_interface);
	  switch(get_carac())
	    {
	    case CONTROL_L:
	      onedite=-1;
	      effacer_ecran();
	      init_ecran();
	      dessine_haut();
	      break;
	    case 201:
	    case 'E':
	    case 233:
	    case 'e':
	      onedite=1;
	      break;
	    case 'O':
	    case 'o':
	    case 'x':
	    case 'X':
	      if(thms[0]==0 && gloup->email[0]==0)
		{
		  status_bar(_("No theme given"),0);
		  mybeep();
		}
	      else
		onquitte=2;
	      break;
	    case 'a':
	    case 'A':
	    case 'n':
	    case 'N':
	    case CONTROL_G:
	      onquitte=1;
	      break;
	    case 'P':
	    case 'p':
	      prompt_chaine(_("Nickname: "),pseud,BUFMSIZE,0);
	      break;
	    case 's':
	    case 'S':
	      prompt_chaine(_("Subject: "),gloup->sujet,BUFMSIZE,0);
	      break;
	    case 'T':
	    case 't':
	      prompt_themes(_("Theme(s): "),thms,BUFMSIZE,1);
	      break;
	    case 'm':
	    case 'M':
	      prompt_chaine(_("E-Mail : "),gloup->email,BUFMSIZE,0);
	      break;
	    case 'i':
	    case 'I':
	      sig=1-sig;
	      break;
	    case 'f':
	    case 'F':
	    case '|':
	      prompt_chaine(_("Filter to apply: "),filtre,BUFMSIZE,0);
	      break;
	    case 'y':
	    case 'Y':
	      type++;
	      if(type>2)
		type=0;
	      break;
	    default:
	      mybeep();
	    }
	}
    }

#ifndef __CYGWIN__
  sem_post(gloup->attente);
#endif

  for(i=0;pseud[i];i++)
    if(pseud[i]==' ')
      pseud[i]=-96;

  if(onquitte>1)
    {
      if((etnerevienspas=fopen(gloup->fichier,"r"))!=NULL)
	{
	  patate=calloc(BUFSIZE,1);
	  zarma=fread(patate,1,BUFSIZE-1,etnerevienspas);
	  fclose(etnerevienspas);
#ifdef HAVE_ICONV
	  if (scribus!=(iconv_t)(-1)) {
	    char *hidaho=malloc(4*zarma);
	    zarma = scribuser(patate,zarma,hidaho,4*zarma);
	    frite(patate);
	    patate=hidaho;
	  }
#endif
	  patate[zarma]=0;
	  patate=realloc(patate,zarma+1);

	  douce=conversion(patate,-type,0);
	  frite(patate);

	  if(gloup->email[0])
	    {
	      char me[BUFMSIZE];
	      sprintf(me,"qui %s\n",login);
	      zarma=envoyer_commande(me);
	    }
	  if(filtre[0])
	    {
	      char *zob;
	      char *zib;
	      extern_t *blop;
	      
	      blop=separ_argus(zob=strdup(filtre));
	      patate=conversion(douce,2,0);
	      zib=malloc(BUFSIZE);
	      i=lancer_externe(blop,NULL,patate,zib);
	      frite(patate);
	      frite(blop);
	      frite(zob);
	      if(i==0)
		{
		  frite(douce);
		  douce=conversion(zib,-2,0);
		}
	      frite(zib);
	    }
	  if(thms[0])
	    {
	      i=envoyer_poste(douce,thms,pseud,gloup->reponses,sig,gloup->sujet);
	      if(i>0)
		{
		  message_lu_dans_cache(i);
		  sprintf(thms,_("Message %i posted !"),i);
		  status_bar(thms,0);
		  remove(gloup->fichier);
		}
	      else
		{
		  status_bar(_("Error ! Message saved to ~/dinopost."),2);
		  sprintf(thms,"mv %s %s/dinopost",gloup->fichier,getenv("HOME"));
		  system(thms);
		}
	    }
	  if(gloup->email[0])
	    {
	      extern_t *errible;
	      char treux[BUFMSIZE];
	      char *treuse;
	      int u=1;

	      errible=malloc(sizeof(extern_t));
	      errible->asynchrone=0;
	      errible->virerstdout=1;
	      errible->fichier_sortie=NULL;
	      errible->argus[0]=strdup("mailx");
	      errible->argus[1]=strdup("-s");
	      errible->argus[2]=strdup(gloup->sujet);
	      errible->argus[3]=strdup("-a");
	      treuse=donner_email(recup_commande(zarma));
	      sprintf(treux,"From: %s <%s>",pseud,treuse);
	      frite(treuse);
	      errible->argus[4]=strdup(treux);
	      errible->argus[5]=strdup(gloup->email);
	      errible->argus[6]=NULL;
	      errible->nbarg=6;
	      
	      patate=conversion(douce,2,0);
	      frite(douce);
	      douce=malloc(BUFSIZE);
	      if(lancer_externe(errible,NULL,patate,douce))
		{ // On réessaye sans le -a (qui est une option GNU)
		  // frite(errible->argus[0]);
		  // errible->argus[0]=strdup("mail");
		  frite(errible->argus[3]);
		  frite(errible->argus[4]);
		  errible->argus[3]=errible->argus[5];
		  errible->argus[4]=NULL;
		  errible->nbarg=4;
		  if(lancer_externe(errible,NULL,patate,douce))
		    {
		      status_bar(_("Mail error ! Message saved to ~/dinopost."),2);
		      sprintf(thms,"mv %s %s/dinopost",gloup->fichier,getenv("HOME"));
		      system(thms);
		      u=0;
		    }
		}
	      if(u==1)
		{
		  sprintf(treux,_("Mail sent to %s."),gloup->email);
		  status_bar(treux,0);
		}

	      frite(patate);
	      
	      for(i=0;i<errible->nbarg;i++)
		frite(errible->argus[i]);
	      frite(errible);
	    }
	}
      else
	{
	  status_bar(_("Eeeer, where has gone the file ?"),2);
	}
    }
  else
    status_bar(_("Message cancelled."),0);

  frite(gloup->email);
  frite(gloup->reponses);
  frite(gloup->fichier);
  frite(gloup->sujet);
  frite(gloup->lesfraises);
  frite(gloup);
  frite(pseud);
  frite(thms);
  frite(douce);
}



void repondre(message_t *erre, theme *lechocolat, int confirmation, int mail)
{
  argu_poste *bougez;
  pthread_t prop;
  char don[BUFMSIZE];
  char pie[BUFMSIZE];
  int grouik=1;
  int blah=-1;
  FILE *defer;

  bougez=malloc(sizeof(argu_poste));
  empiler_reponse(erre,1);
  
  bougez->reponses=calloc(nb_reponses+1,sizeof(int));
  memcpy(bougez->reponses,pile_reponses,nb_reponses*sizeof(int));

  if(confirmation && erre!=NULL && ouinon(_n("Include the message in the reply ?","Include the messages in the reply ?",nb_reponses))==0)
    {
      if((defer=fopen(fichier_temporaire,"w"))!=NULL)
        fclose(defer);
    }
  bougez->sujet=malloc(BUFMSIZE);
  if(erre!=NULL && erre->sujet!=NULL)
    snprintf(bougez->sujet,BUFMSIZE,"%s%s",strncmp(erre->sujet,"Re:",3)?"Re: ":"",erre->sujet);
  else
    bougez->sujet[0]=0;
  nb_reponses=0;
  bougez->fichier=fichier_temporaire;
  fichier_temporaire=NULL;

  if(lechocolat!=NULL && mail==0)
    strcpy(don,lechocolat->nom);
  else
    don[0]=0;
  
  if(mail && erre!=NULL && erre->signe!=NULL)
    {
      sprintf(pie,"qui %s\n",erre->signe);
      blah=envoyer_commande(pie);
    }

  if(prompt_chaine(_("Subject: "),bougez->sujet,BUFMSIZE,0))
    grouik=0;
  if(grouik && mail==0 && bougez->reponses[0]==0 && prompt_themes(_("Theme(s): "),don,BUFMSIZE,1)==NULL)
    grouik=0;

  if(blah>=0)
    {
      bougez->email=donner_email(recup_commande(blah));
      bougez->email=realloc(bougez->email,BUFMSIZE);
    }
  else
    {
      bougez->email=malloc(BUFMSIZE);
      bougez->email[0]=0;
    }
  if(grouik && mail && prompt_chaine(_("Send to: "),bougez->email,BUFMSIZE,0))
    grouik=0;
  if(grouik==0)
    {
      frite(bougez->email);
      frite(bougez->sujet);
      frite(bougez->reponses);
      frite(bougez->fichier);
      frite(bougez);
      status_bar(_("Message cancelled."),0);
      return;
    }
  bougez->lesfraises=strdup(don);
// Détection de Cygwin, c'est plus lent mais ça devrait marcher.
#ifdef __CYGWIN__
  thread_poste(bougez);
#else
  if (sem_init(&bougez->_attente,0,0) != -1)
    bougez->attente = &bougez->_attente;
  else
    bougez->attente = sem_anon();
  pthread_create(&prop,NULL,(void *)thread_poste,bougez);
  pthread_detach(prop);
  while (sem_wait(bougez->attente)==-1)
    if (errno != EINTR)
      perror("sem_wait(bougez->attente)");
  sem_close(bougez->attente);
#endif
}

