/* routineur.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <ncurses.h>
#include <signal.h>
#include <pthread.h>
#include <time.h>
#include <sys/time.h>
#include <libintl.h>
#include "defs.h"
#include "serveur.h"
#include "main.h"
#include "interface.h"
#include "cache.h"
#include "numeros.h"
#include "init.h"
#include "externe.h"

int yadunouvo=1;

int temps_status_bar=0;

static int gtape=0;

static int flag_winch=0;

pthread_mutex_t mutex_yadunouvo=PTHREAD_MUTEX_INITIALIZER;

// static int ZEpid;

RETSIGTYPE sighandler(int nume)
{
  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Signal %i attrappé.\n",nume);
      fflush(logfile);
    }
  switch(nume)
    {
    case SIGWINCH:
      flag_winch=1;
      break;
    case SIGINT:
      if(pid_fils)
	{
	  kill(pid_fils,SIGINT);
	  break;
	}
    case SIGTERM:
    case SIGHUP:
      quitte(2,_("OK, see you next time."));
    case SIGTSTP:
      effacer_ecran();
      kill(0,SIGSTOP);
      break;
    case SIGCONT:
      if(pid_fils)
	kill(pid_fils,SIGCONT);
      else
	init_ecran();
      flag_winch=1;
      break;
    }
  return;
}


int get_carac()
{
  int i=ERR;

  while(i==ERR)
    {
      i=getch();
#ifdef KEY_RESIZE
      if(i==KEY_RESIZE)
	i=CONTROL_L;
#endif
      if(flag_winch)
	{
	  flag_winch=0;
	  i=CONTROL_L;
	}

    }
  gtape=1;
  if(serveur_en_attente)
    {
      serveur_en_attente=0;
      sem_post(attente_frappe_touche);
    }
  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Touche %i tapée.\n",i);
      fflush(logfile);
    }

  switch(i)
    {
    case 1: // control-A
    case HOME2:
      i=KEY_HOME;
      break;
    case 5: // control-E
    case END2:
      i=KEY_END;
      break;
    case 25: // control-Y
      i=KEY_PPAGE;
      break;
    case 22: // control-V
      i=KEY_NPAGE;
      break;
    case 4: // control-D
      i=KEY_DC;
      break;
    case 263: // BS sur Solaris
    case MBACKSPACE:
    case MDELETE:
      i=KEY_BACKSPACE;
      break;
    }
  return i;
}

void init_signaux()
{
  sigset_t set;
  struct sigaction siga;
  
  sigemptyset(&set);
  sigaddset(&set,SIGINT);
  sigaddset(&set,SIGWINCH);
  sigaddset(&set,SIGTSTP);
  sigaddset(&set,SIGCONT);
  sigaddset(&set,SIGHUP);
  sigaddset(&set,SIGALRM);
  
  siga.sa_handler=&sighandler;
  siga.sa_mask=set;
  siga.sa_flags=SA_RESTART;
  
  sigaction(SIGWINCH,&siga,NULL);
  sigaction(SIGCONT,&siga,NULL);
  sigaction(SIGINT,&siga,NULL);
  sigaction(SIGTSTP,&siga,NULL);
  sigaction(SIGHUP,&siga,NULL);

  signal(SIGPIPE,SIG_IGN);

  //  ZEpid=getpid();
}

/* Faut-il récupérer les nouveaux messages après titi secondes ? */

static int fautvoir(int titi)
{
  if(titi>60*timeout_complet)
    return 0;
  if((titi<15 && titi%3==0) || titi==18 || titi==30 || titi==60)
    return 1;
  if(titi<60*frequence_reconnexion && titi%60==0)
    return 1;
  if(titi%(60*frequence_reconnexion)==0)
    return 1;
  return 0;
}



void routineur()
{
  int i;
  int lapin=-1;
  int canard=-1;
  int toto=1;
  int titi=0;
  int truelle=0;
  int oldnbmsg=0;
  char *cheval;
  char *quinarbre;
  int *blouck = NULL;
  char meur[BUFMSIZE];
  char *treux;

  //  init_signaux();

  while(1)
    {
      truelle++;
      titi++;
      if(gtape)
	{
	  titi=0;
	  gtape=0;
	}
      if((toto || (fautvoir(titi) && truelle>1)) && canard==-1 && lapin==-1 && blouck==NULL)
	{
	  if(serveur_en_attente)
	    {
	      serveur_en_attente=0;
	      sem_post(attente_frappe_touche);
	    }
	  lapin=envoyer_commande("nbmsg\n");
	  canard=envoyer_commande("nbuser\n");
	}
      if(lapin!=-1)
	{
	  cheval=essaye_recup_commande(lapin);
	  if(cheval!=NULL)
	    {
	      int newnbmsg;
	      
	      sscanf(cheval,"Ok/1: %d",&newnbmsg);
	      frite(cheval);
	      if(toto)
		oldnbmsg=nb_messages=newnbmsg;
	      if(newnbmsg>nb_messages)
		{
		  oldnbmsg=nb_messages;
		  nb_messages=newnbmsg;

		  blouck=calloc(nb_messages-oldnbmsg,sizeof(int));
		  for(i=0;i<nb_messages-oldnbmsg;i++)
		    {
		      sprintf(meur,"entete %i\n",oldnbmsg+i+1);
		      blouck[i]=envoyer_commande(meur);
		    }
		}

	      pthread_mutex_lock(&mutex_yadunouvo);
	      if(nb_messages>dernier_msg_lu && (nb_messages>message_courant || message_courant_est_plus_grand_que_nb_messages))
		yadunouvo=1;
	      else
		yadunouvo=0;
	      pthread_mutex_unlock(&mutex_yadunouvo);


	      lapin=-1;
	    }
	}
      if(canard!=-1)
	{
	  quinarbre=essaye_recup_commande(canard);
	  if(quinarbre!=NULL)
	    {
	      sscanf(quinarbre,"Ok/1: %d",&nb_connectes);
	      frite(quinarbre);
	      canard=-1;
	      dessine_haut();
	      // beep();    // Pratique pour le déboguage...
	      truelle=0;
	      if(toto)
		{
		  sem_post(semaphore_init);
		  toto=0;
		}
	    }
	}

      if(blouck!=NULL)
	{
	  for(i=0;i<nb_messages-oldnbmsg;i++)
	    {
	      if(blouck[i]!=-1)
		{
		  treux=essaye_recup_commande(blouck[i]);
		  if(treux!=NULL)
		    {
		      themes_nouveau_message(ajouter_message_cache(treux),1);
		      blouck[i]=-1;
		    }
		  else
		    break;
		}
	    }
	  if(blouck[nb_messages-oldnbmsg-1]==-1)
	    {
	      // oldnbmsg=nb_messages;
	      frite(blouck);
	      blouck=NULL;
	    }
	}
      if(temps_status_bar++>DELAI_STATUS_BAR && effacer_status_bar)
	status_bar(NULL,2);
#ifdef HAVE_NANOSLEEP
      nanosleep(une_seconde,NULL);
#else
      sleep(1);
#endif
    }
}
