/* sem.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <semaphore.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#ifdef HAVE_SEM_OPEN
sem_t *sem_anon(void) {
  static char c[2];
  sem_t *sem;
  /* on se fiche de l'atomicité */
  c[0]++;
  while ((sem = sem_open(c, O_CREAT|O_EXCL, 0, 0)) == SEM_FAILED) {
    if (errno != EEXIST)
      perror("création sémaphore anonyme");
#ifdef HAVE_SEM_UNLINK
    else
      sem_unlink(c);
#endif
  }
#ifdef HAVE_SEM_UNLINK
  sem_unlink(c);
#endif
  return sem;
}
#else
sem_t *sem_anon(void) {
  fprintf(stderr, "sem_init failed and no sem_open, can't do much\n");
  exit(1);
}
#endif
