/* serveur.c

   Ce programme peut être librement distribué suivant les termes de la
   « General Public License », version 2 ou ultérieure. Voir le fichier
   COPYING pour les détails. Si vous n'avez pas reçu de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <pthread.h>
#include <semaphore.h>
#include <time.h>
#include <sys/time.h>
#include <string.h>
#include <fcntl.h>
#include <libintl.h>
#include "defs.h"
#include "init.h"
#include "interface.h"
#include "main.h"
#include "routineur.h"
#include "sem.h"

int serveur_up=0;
static int fd;
static FILE *fluxw;
static int faire_connexion();
static void recup_erreur();

static int tutube[2];
int guichet;
static int caissiere;
static sem_t _semaphore_init;
sem_t *semaphore_init = &_semaphore_init;
static int num_commande_affectee=0;
static int num_commande_envoyee=0;
static int num_commande_recue=0;
static char *commandes_envoyees[MAX_SIMULT_COMMANDES];
static char *commandes_recues[MAX_SIMULT_COMMANDES];
static struct sem {
	sem_t _sem;
	sem_t *sem;
} libe_commandes[MAX_SIMULT_COMMANDES];
static pthread_mutex_t mutex_envoie_commande=PTHREAD_MUTEX_INITIALIZER;
static sem_t _attente_frappe_touche;
sem_t *attente_frappe_touche = &_attente_frappe_touche;
int serveur_en_attente=0;

static float priorites_serveurs[NMAXARGS];
static int nb_serveurs;
static int serveur_actuel;
static time_t derniere_connexion=0;

/* lire_ligne

   lit une ligne de ce qui vient du serveur.
   Renvoie un pointeur dessus, à freere, ou NULL en cas d'échec. */

static char bourbier[BUFMSIZE-1];
static char *bourbe;
static size_t cote;
char *lire_ligne()
{
  char *youpi;
  char *panthere;
  int la_peche;
  int epsilon;

  while (!(youpi = memchr(bourbe, '\n', cote))
      && cote < BUFMSIZE-1 - (bourbe - bourbier)) {
    errno = 0;
    la_peche = read(fd, bourbe+cote, BUFMSIZE-1-(bourbe-bourbier)-cote);
    if (la_peche <= 0) {
      if (errno == EINTR || errno == EAGAIN) continue;
      if (debug & DEBUG_DEFAULT) {
        fprintf(logfile,"Le serveur a mouru (%s)",strerror(errno));
        fflush(logfile);
      }
      return NULL;
    }
    cote += la_peche;
  }

  if (!youpi && bourbe != bourbier) {
    memmove(bourbier, bourbe, cote);
    bourbe = bourbier;
    return lire_ligne();
  }

  epsilon = *bourbe == '\r';

  if (youpi) {
    la_peche = youpi+1 - (bourbe + epsilon);
    panthere = malloc(la_peche+1);
    memcpy(panthere, bourbe + epsilon, la_peche);
    panthere[la_peche] = '\0';
  } else {
    panthere = malloc(BUFMSIZE - epsilon);
    memcpy(panthere, bourbier + epsilon, BUFMSIZE-1 - epsilon);
    panthere[BUFMSIZE-1 - epsilon] = '\0';
    do {
      errno = 0;
      la_peche = read(fd, bourbier, BUFMSIZE-1);
      if (la_peche <= 0) {
        if (errno == EINTR || errno == EAGAIN) continue;
	if (debug & DEBUG_DEFAULT) {
	  fprintf(logfile,"Le serveur a mouru (%s)",strerror(errno));
	  fflush(logfile);
	}
	break;
      }
    } while (!(youpi = memchr(bourbier, '\n', la_peche)));
    cote = la_peche;
  }

  cote -= youpi+1 - bourbe;
  bourbe = youpi+1;
  if (debug & DEBUG_DEFAULT) {
    fprintf(logfile,"Le serveur a envoyé '%s'",panthere);
    fflush(logfile);
  }
  return panthere;
}

/* init_priorites_serveurs

Initialise le tableau priorites_serveurs à 1 pour tous les serveurs. */

static int init_priorites_serveurs()
{
  int i=0;
  
  while(serveurs[i]!=NULL)
    priorites_serveurs[i++]=1;
  
  return i;
}


/* ServeurVirtuel

   Se connecte au serveur dino.
   Fonctionnement : z'avez qu'à regarder de plus près. */

void ServeurVirtuel()
{
  int camarche=1;
  int slurp;
  int bordel;
  char *panthere;
  char *puma=NULL;
  int savane;
  fd_set foutoir;
  struct timeval radio;

  //  init_signaux();

  nb_serveurs=init_priorites_serveurs();

  if((slurp=faire_connexion())<0)
    {
      if(slurp==-1)
	quitte(-2,_("I can't find the server !"));
      else
	quitte(-2,_("Hey, the server doesn't want of us !"));
    }
  
  pipe(tutube);
  guichet=tutube[1];
  caissiere=tutube[0];

  for(slurp=0;slurp<MAX_SIMULT_COMMANDES;slurp++) // On initialise bien les tableaux à zéro
    {
      commandes_envoyees[slurp]=NULL;
      commandes_recues[slurp]=NULL;
      libe_commandes[slurp].sem = & libe_commandes[slurp]._sem;
    }
  if (sem_init(&_attente_frappe_touche,0,0) == -1)
    attente_frappe_touche = sem_anon();
  sem_post(semaphore_init); // Libération du processus main : on peut écrire dans le tube.
  
  while(1)
    {
      FD_ZERO(&foutoir);
      FD_SET(caissiere,&foutoir);
      FD_SET(fd,&foutoir);
      bordel = (fd>caissiere?(fd+1):(caissiere+1));

      radio.tv_sec = 15;
      radio.tv_usec = 0;

      if (cote) {
        slurp=1;
	FD_CLR(caissiere,&foutoir);
      } else
        slurp=select(bordel,&foutoir,NULL,NULL,&radio);

      if(slurp<=0)
	camarche=0;

      if((slurp<0 && errno!=EINTR) || (slurp==0 && num_commande_envoyee!=num_commande_recue))
	recup_erreur();

      if(camarche && FD_ISSET(fd,&foutoir))
	{
	  //	  panthere=malloc(BUFMSIZE);
	  //if(fgets(panthere,BUFMSIZE,fluxr)==NULL || strncmp(panthere,"Err: temps depasse",18)==0)
	  panthere=lire_ligne();

	  if(panthere==NULL)
	    {
	      recup_erreur();
	      camarche=0;
	    }
	  else if(strncmp(panthere,"Err: temps depasse",18)==0)
	    {
	      frite(panthere);
	      status_bar(_("Temporary deconnection"),2);
	      serveur_en_attente=1;
	      while (sem_wait(attente_frappe_touche)==-1)
	        if (errno != EINTR)
		  perror("sem_wait(attente_frappe_touche)");
	      recup_erreur();
	      camarche=0;
	    }
	  
	  if(camarche)
	    {
	      if(puma==NULL)
		{
		  if(panthere[3]=='n') // On a une réponse multi-lignes
		    {
		      puma=malloc(BUFSIZE);
		      savane=strlen(panthere);
		      memcpy(puma,panthere,savane+1);
		      frite(panthere);
		      panthere=NULL;
		    }
		}
	      else
		{
		  int jungle = strlen(panthere);
		  if (savane+jungle+1>BUFSIZE)
		    jungle = BUFSIZE-(savane+1);
		  memcpy(puma+savane,panthere,jungle);
		  savane+=jungle;
		  puma[savane]=0;
		  if(panthere[0]=='#') // Fin de la réponse multi-lignes
		    {
		      frite(panthere);
		      panthere=puma;
		      puma=NULL;
		    }
		  else
		    { // Continuation de la réponse multi-lignes
		      frite(panthere);
		      panthere=NULL;
		    }
		}
	      
	      if(panthere!=NULL)
		{
		  panthere=realloc(panthere,strlen(panthere)+1);
		  pthread_mutex_lock(&mutex_envoie_commande);
		  // Remplissage du tableau
		  commandes_recues[num_commande_recue]=panthere;
		  // Libération du thread correspondant
		  sem_post(libe_commandes[num_commande_recue++].sem);
		  if(num_commande_recue==MAX_SIMULT_COMMANDES)
		    num_commande_recue=0;
		  pthread_mutex_unlock(&mutex_envoie_commande);
		}
	    }
	}
      
      if(camarche && FD_ISSET(caissiere,&foutoir))
	{
	  read(caissiere,&panthere,sizeof(char *));
	  
	  num_commande_envoyee++;
	  if(num_commande_envoyee==MAX_SIMULT_COMMANDES)
	    num_commande_envoyee=0;
	  
	  if((fputs(panthere,fluxw)<0) || (fflush(fluxw)<0))
	    {
	      recup_erreur();
	      camarche=0;
	    }
	}
      
      camarche=1;
    }
}


/* envoyer_commande
   
envoie une commande au serveur virtuel, et retourne un numéro d'ordre.
*/
int envoyer_commande(char *elephant)
{
  char *gazelle;
  int rhinoceros;

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Demande de la commande %s",elephant);
      fflush(logfile);
    }
  
  if((elephant[0]<'a') || (elephant[0]>'z') || (strncmp(elephant,"poste",5)==0) || (strncmp(elephant,"passwd",6)==0) || (strncmp(elephant,"su ",3)==0 ))
    {// Interception des commandes non désirées
      gazelle=strdup("broaps\n");
    }
  else
    {
      gazelle=strdup(elephant);
      /* gazelle=malloc(strlen(elephant)+1);
	 strcpy(gazelle,elephant); */
    }
  
  pthread_mutex_lock(&mutex_envoie_commande);
  if(commandes_envoyees[num_commande_affectee]!=NULL)
    quitte(-3,_("Fatal error : too many commands sent together (it's a bug)."));
  rhinoceros=num_commande_affectee;
  // Et un petit sémaphore pour le libérer quand ça sera prêt.
  if (sem_init(&libe_commandes[num_commande_affectee]._sem,0,0) == -1)
    libe_commandes[num_commande_affectee].sem = sem_anon();

  commandes_envoyees[num_commande_affectee++]=gazelle;
  if(num_commande_affectee==MAX_SIMULT_COMMANDES)
    num_commande_affectee=0;

  write(guichet,&gazelle,sizeof(char *));
  pthread_mutex_unlock(&mutex_envoie_commande);

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"%i > %s",rhinoceros,gazelle);
      fflush(logfile);
    }
  return rhinoceros;
}


/* recup_commande

   recupère la commande de numero mouton. */

char *recup_commande(int mouton)
{
  char *guepard;

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"J'attends la commande %i.\n",mouton);
      fflush(logfile);
    }

  while (sem_wait(libe_commandes[mouton].sem)==-1)
    if (errno != EINTR)
      perror("sem_wait(libe_commandes)");

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"La commande %i est arrivée.\n",mouton);
      fflush(logfile);
    }

  pthread_mutex_lock(&mutex_envoie_commande);

  guepard=commandes_recues[mouton];
  
  frite(commandes_envoyees[mouton]);
  sem_close(libe_commandes[mouton].sem);
  libe_commandes[mouton].sem = & libe_commandes[mouton]._sem;
  commandes_envoyees[mouton]=NULL;
  commandes_recues[mouton]=NULL;
  pthread_mutex_unlock(&mutex_envoie_commande);
  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"%i < %s",mouton,guepard);
      fflush(logfile);
    }
  return guepard;
}


/* essaye_recup_commande

   Tente de récupérer la commande de numéro jars. Renvoie le résultat s'il est disponible (sponible) ou NULL s'il ne l'est pas encore. */
char *essaye_recup_commande(int jars)
{
  char *oie;

  if(sem_trywait(libe_commandes[jars].sem)==0)
    { // C'est prêt !
      pthread_mutex_lock(&mutex_envoie_commande);
      oie=commandes_recues[jars];
      frite(commandes_envoyees[jars]);
      sem_close(libe_commandes[jars].sem);
      libe_commandes[jars].sem = & libe_commandes[jars]._sem;
      commandes_envoyees[jars]=NULL;
      commandes_recues[jars]=NULL;
      pthread_mutex_unlock(&mutex_envoie_commande);
      if(debug & DEBUG_DEFAULT)
	{
	  fprintf(logfile,"%i < %s",jars,oie);
	  fflush(logfile);
	}
      return oie;
    }
  else // Attends encore un peu
    return NULL;
}


/* rend_pret_a_poster

Prend un message et recherche les lignes avec juste un point pour les remplacer par un point et une espace.

En profite pour suprimmer les éventuelles lignes vides de fin.

Attention : ne pas oublier de freere la valeur retournée après usage.

Ça peut sembler con de mettre cette procédure ici, mais c'est la structure du serveur qui impose de ne pas avoir de ligne avec juste un point.
 */

static char *rend_pret_a_poster(char *groin)
{
  char *beuzenot;
  int schnorbl=0;
  int schnouf=0;
  int agreu=0;

  beuzenot=malloc(2*BUFSIZE);

  if(groin!=NULL)
    while(groin[schnouf])
      {
	if((agreu==0) && (groin[schnouf]=='.') && (groin[schnouf+1]=='\n'))
	  {
	    beuzenot[schnorbl++]='.';
	    beuzenot[schnorbl++]=' ';
	  }
	else
	  {
	    beuzenot[schnorbl++]=groin[schnouf];
	    if(groin[schnouf]=='\n')
	      agreu=0;
	    else
	      {
		agreu++;
	      }
	  }
	schnouf++;
      }
  
  if(schnorbl>BUFSIZE-4)
    schnorbl=BUFSIZE-4;
  while(beuzenot[schnorbl-1]=='\n')
    schnorbl--;
  beuzenot[schnorbl++]='\n';
  beuzenot[schnorbl++]='.';
  beuzenot[schnorbl++]='\n';
  beuzenot[schnorbl++]=0;
  beuzenot=realloc(beuzenot,schnorbl);

  return beuzenot;
}


/* envoyer_poste

   Poste un message. Attention : bloque le thread appelant.

   C'est implémenté directement au niveau de serveur.c pour permettre les corrections d'erreur et de ne pas trop accaparer les mutex.

   Entrée :
     - mess = contenu du message
     - themes = thèmes où on poste, séparés par des espaces
     - pseudo = pseudo, ou vide ou NULL si on l'omet
     - reponses = pointe vers des int numérotant les réponses. On s'arrête quand on trouve un 0.
     - signe = booléen, le message est-il signé ?
     - sujet = chaîne contenant le sujet, ou vide ou NULL si on l'omet.
     (j'ai mis des z dans les noms pour éviter les conflits avec des variables globales, on ne sait jamais)
   Valeur retournée : numéro du message, ou zéro en cas de plus de 3 échecs successifs (c'est que là ça a bien foiré de chez foiré)

*/

int envoyer_poste(char *messz, char *themesz, char *pseudoz, int *reponsesz, int signez, char *sujetz)
{
  int ulysse;
  int nono;
  int tridents;
  char *zeus;
  char *bibi1;
  char *bibi2;
  char *telemaque;

  telemaque=malloc(BUFMSIZE);

  nono=sprintf(telemaque,"poste2 them ");
  tridents=0;
  while(themesz[tridents]) // Attention, on ne vérifie pas DU TOUT la cohérence de la chaîne themes.
    {
      if(themesz[tridents]!=' ')
	telemaque[nono++]=themesz[tridents];
      else
	{
	  nono+=sprintf(telemaque+nono," them ");
	}
      tridents++;
    }

  nono+=sprintf(telemaque+nono," charset utf-8");
  if(signez)
    {
      nono+=sprintf(telemaque+nono," signe");
    }
  
  if((pseudoz!=NULL) && pseudoz[0])
    {
      nono+=sprintf(telemaque+nono," pseudo %s",pseudoz);
    }

  while(*reponsesz!=0)
    {
      nono+=sprintf(telemaque+nono," rep %i",*reponsesz);
      reponsesz++;
    }
  
  if((sujetz!=NULL) && sujetz[0])
    {
      nono+=sprintf(telemaque+nono," sujet %s",sujetz);
    }

  telemaque[nono++]='\n';
  telemaque[nono++]='\0';

  zeus=rend_pret_a_poster(messz);

  // 3 essais maxi, ça ira ben.
  for(ulysse=0;ulysse<3;ulysse++)
    {
      pthread_mutex_lock(&mutex_envoie_commande);
      if(commandes_envoyees[num_commande_affectee]!=NULL)
       	quitte(-3,_("Fatal error : too many commands sent together (it's a bug)."));
      nono=num_commande_affectee;
      if (sem_init(&libe_commandes[num_commande_affectee]._sem,0,0) == -1)
	libe_commandes[num_commande_affectee].sem = sem_anon();
      commandes_envoyees[num_commande_affectee++]=strdup("broaps\n");
      if(num_commande_affectee==MAX_SIMULT_COMMANDES)
	num_commande_affectee=0;


      if(commandes_envoyees[num_commande_affectee]!=NULL)
       	quitte(-3,_("Fatal error : too many commands sent together (it's a bug)."));
      tridents=num_commande_affectee;
      if (sem_init(&libe_commandes[num_commande_affectee]._sem,0,0) == -1)
	libe_commandes[num_commande_affectee].sem = sem_anon();
      commandes_envoyees[num_commande_affectee++]=strdup("broaps\n");
      if(num_commande_affectee==MAX_SIMULT_COMMANDES)
	num_commande_affectee=0;
      
      write(guichet,&telemaque,sizeof(char *));
      write(guichet,&zeus,sizeof(char *));
      pthread_mutex_unlock(&mutex_envoie_commande);
	  
      if(debug & DEBUG_DEFAULT)
	{
	  fprintf(logfile,"%i > %s",nono,telemaque);
	  fprintf(logfile,"%i > %s",tridents,zeus);
	  fflush(logfile);
	}
      bibi1=recup_commande(nono);
      bibi2=recup_commande(tridents);
      
      if((bibi1[0]!='E') && (bibi2[0]!='E') && (sscanf(bibi2,"Ok/1: Message %i",&tridents)==1))
	{//Nom de dieu ! Ça a marché !
	  frite(bibi1);
	  frite(bibi2);
	  frite(telemaque);
	  frite(zeus);
	  return tridents;
	}
      frite(bibi1);
      frite(bibi2);
    }
  frite(telemaque);
  frite(zeus);
  return 0; // Tant pis, c'est foutu.
}



/* attente

   donne le temps à attendre pour se reconnecter en fonction du numéro j
   de l'essai.*/

static int attente(int j) {
  if(j<4)
    return 3;
  else if(j<10)
    return 10;
  else
    return 30;
}

/* recup_erreur

   Merde alors, ça a foiré !
   Heureusement, recup_erreur est là pour tout relancer la machine... */
static void recup_erreur()
{
  int pingouin=0;
  int manchot;
  int camarche=0;
  struct timespec alibur;

  alibur.tv_nsec=0;

  while(camarche==0)
    {
      serveur_up=0;
      camarche=1;
      status_bar(_("Connection lost."),0);
      manchot=num_commande_envoyee - num_commande_recue;
      if(manchot<0)
	manchot+=MAX_SIMULT_COMMANDES;
      //      fclose(fluxr);
      fclose(fluxw);
      close(fd);
      while(faire_connexion()<0)
	{
	  alibur.tv_sec=attente(pingouin++);
#ifdef HAVE_NANOSLEEP
	  nanosleep(&alibur,NULL);
#else
	  sleep(1);
#endif
	}
      if(manchot!=0)
	{
	  status_bar(_("Re-sending lost commands..."),2);
	  if(debug & DEBUG_DEFAULT)
	    {
	      fprintf(logfile,"Ré-envoi de %i commandes.\n",manchot);
	      fflush(logfile);
	    }
	  for(pingouin=0;pingouin<manchot;pingouin++)
	    if(fputs(commandes_envoyees[(num_commande_recue+pingouin)%MAX_SIMULT_COMMANDES],fluxw)<0)
	      {
		camarche=0;
		break;
	      }
	  
	  if(camarche && (fflush(fluxw)<0))
	    camarche=0;
	}
    }
  status_bar(_("Connection OK"),0);
}


/* faire_connexion_sur_serveur

Se connecte au serveur sur le port spécifié, affecte fd et flux, et renvoie 0 en cas de succès (on ne sait jamais), -1 en cas d'erreur de connexion, -2 en cas d'erreur d'initialisation.
*/
static int faire_connexion_sur_serveur(char *serveur)
{
  char zobi_la_mouche[BUFMSIZE];
  char *zub;
  struct addrinfo zab = { .ai_socktype = SOCK_STREAM }, *cestla, *vraimentla;

  sprintf(zobi_la_mouche,_("Looking for %s..."),serveur);
  status_bar(zobi_la_mouche,2);

  if (getaddrinfo(serveur, port, &zab, &cestla))
    {
      status_bar(_("Cannot find the server."),0);
      return -1;
    }

  for (vraimentla = cestla; vraimentla; vraimentla = vraimentla->ai_next)
    {
      if ( (fd = socket(vraimentla->ai_family, vraimentla->ai_socktype, vraimentla->ai_protocol)) < 0)
	continue;

      sprintf(zobi_la_mouche,_("Connection to %s:%s..."),serveur,port);
      status_bar(zobi_la_mouche,2);

      if(debug & DEBUG_DEFAULT)
	{
	  fprintf(logfile,"Connexion à %s:%s...\n",serveur,port);
	  fflush(logfile);
	}

retry:
      if(connect(fd,vraimentla->ai_addr,vraimentla->ai_addrlen)<0)
	{
	  if (errno == EINTR || errno == EAGAIN) goto retry;
	  close(fd);
	  if(debug & DEBUG_DEFAULT)
	    {
	      fprintf(logfile,"echec: %s...\n", strerror(errno));
	      fflush(logfile);
	    }
	  continue;
	}

      break;
    }

  freeaddrinfo(cestla);

  if (!vraimentla)
    {
      status_bar(_("Connection to the server was denied."),2);
      return -1;
    }

  // Mise en place de l'attribut close-on-exec
  fcntl(fd,F_SETFD,FD_CLOEXEC);

  /*  if((fluxr = fdopen(fd,"r"))==NULL)
      {
      close(fd);
      return -1;
      }*/
      
  if((fluxw = fdopen(fd,"w"))==NULL)
    {
      //      fclose(fluxr);
      close(fd);
      return -1;
    }

  cote = 0;
  bourbe = bourbier;

  sprintf(zobi_la_mouche,_("%s logging in..."),login);
  status_bar(zobi_la_mouche,2);

  zub=lire_ligne();
  if(zub==NULL)
    return -2;
  frite(zub);
  
  if(fprintf(fluxw,"%s\n%s\n%s\n",(login_anonyme?"off_anonymous":"interface"),login,motdepasse)<0 || fflush(fluxw)<0)
    return -2;

  zub=lire_ligne();
  if(zub==NULL)
    {
      perror("Gloups");
      return -2;
    }

  if(zub[0]=='E')
    return -2;
  frite(zub);

  sprintf(zobi_la_mouche,_("OK, %s logged on ! Press a to get some help."),nickname);
  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"OK, %s logué !\n",nickname);
      fflush(logfile);
    }

  status_bar(zobi_la_mouche,0);
  serveur_up=1;
  
  return 0;
}


/* faire_connexion

Se connecte à UN serveur, et renvoie 0 en cas de succès (on ne sait jamais), -1 en cas d'erreur de connexion, -2 en cas d'erreur d'initialisation. */

static int faire_connexion()
{
  int masque_serveurs[NMAXARGS];
  int i,j,k,l;
  float f,g;

  if(derniere_connexion)
    priorites_serveurs[serveur_actuel] += 
      ( (float) difftime(time(NULL),derniere_connexion)) / 300;
  // 300 = 5 minutes pour un point.
  derniere_connexion=0;

  if(debug & DEBUG_DEFAULT)
    {
      fprintf(logfile,"Connexion demandée. Priorités des serveurs :\n");
      for(i=0;i<nb_serveurs;i++)
	fprintf(logfile,"%s : %f\n",serveurs[i],priorites_serveurs[i]);
      fflush(logfile);
    }
  
  for(i=0;i<nb_serveurs;i++)
    masque_serveurs[i]=1;

  k=0;
  while(1)
    {
      j=-1; f=0; l=-3;
      for(i=0;i<nb_serveurs;i++)
	{
	  g = masque_serveurs[i]*priorites_serveurs[i]*random() ;
	  if(g > f)
	    {
	      f=g;
	      j=i;
	    }
	}
      if(j<0) //Toutes les passerelles ont échoué
	break;

      l=faire_connexion_sur_serveur(serveurs[j]);
      if(l==0) // Réussi
	{
	  serveur_actuel=j;
	  derniere_connexion=time(NULL);
	  break;
	}

      priorites_serveurs[j]/=2; // Mange-toi ça.
      masque_serveurs[j]=0; // On arrête les frais sur ce serveur.

      f=0; g=0;
      for(i=0;i<nb_serveurs;i++)
	{
	  if(g==0 || priorites_serveurs[i]<g)
	    g=priorites_serveurs[i]; // recherche du min
	  if(priorites_serveurs[i]>f)
	    f=priorites_serveurs[i]; // recherche du max
	}
      if(10*g < f && k>1)
	break; // Si l'écart entre min/max est plus de 10x, on n'en teste que 2
    }
  return l;
}
