/* touches.c

   Ce programme peut Ãªtre librement distribuÃ© suivant les termes de la
   Â« General Public License Â», version 2 ou ultÃ©rieure. Voir le fichier
   COPYING pour les dÃ©tails. Si vous n'avez pas reÃ§u de copie de cette
   licence avec le programme, allez voir le site www.gnu.org pour l'obtenir.

   This program can be freely distributed following the terms of the
   General Public Licence, version 2 or later. See file COPYING for
   details. If you haven't received a copy of this license with the
   program, please visit www.gnu.org to obtain it.

*/

#include <ncurses.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libintl.h>

#include "defs.h"
#include "init.h"
#include "main.h"


int keymap_defaut=0;

typedef struct
{
  char *short_desc; // La description qu'on aura dans le fichier de conf
  char *long_desc;  // La description que renverra l'aide
} dino_fonction;

static dino_fonction lesfonctions[FUNCTIONS_NUMBER];

typedef struct
{
  char *desc;
  int ncurses_key;
  int next_is_maj; // Est-ce que la structure suivante contient la majuscule correspondante ?
  int fonc;
} dino_touche;


static dino_touche lestouches[]={
{"0",'0',0,0},
{"1",'1',0,1},
{"2",'2',0,2},
{"3",'3',0,3},
{"4",'4',0,4},
{"5",'5',0,5},
{"6",'6',0,6},
{"7",'7',0,7},
{"8",'8',0,8},
{"9",'9',0,9},
{"a",'a',1,0},
{"A",'A',0,0},
{"b",'b',1,0},
{"B",'B',0,0},
{"c",'c',1,0},
{"C",'C',0,0},
{"d",'d',1,0},
{"D",'D',0,0},
{"e",'e',1,0},
{"E",'E',0,0},
{"f",'f',1,0},
{"F",'F',0,0},
{"g",'g',1,0},
{"G",'G',0,0},
{"h",'h',1,0},
{"H",'H',0,0},
{"i",'i',1,0},
{"I",'I',0,0},
{"j",'j',1,0},
{"J",'J',0,0},
{"k",'k',1,0},
{"K",'K',0,0},
{"l",'l',1,0},
{"L",'L',0,0},
{"m",'m',1,0},
{"M",'M',0,0},
{"n",'n',1,0},
{"N",'N',0,0},
{"o",'o',1,0},
{"O",'O',0,0},
{"p",'p',1,0},
{"P",'P',0,0},
{"q",'q',1,0},
{"Q",'Q',0,0},
{"r",'r',1,0},
{"R",'R',0,0},
{"s",'s',1,0},
{"S",'S',0,0},
{"t",'t',1,0},
{"T",'T',0,0},
{"u",'u',1,0},
{"U",'U',0,0},
{"v",'v',1,0},
{"V",'V',0,0},
{"w",'w',1,0},
{"W",'W',0,0},
{"x",'x',1,0},
{"X",'X',0,0},
{"y",'y',1,0},
{"Y",'Y',0,0},
{"z",'z',1,0},
{"Z",'Z',0,0},
{"space",' ',1,0},
{"enter",'\n',0,0},
{"-",'-',0,0},
{"+",'+',0,0},
{"*",'*',0,0},
{"/",'/',0,0},
{"<",'<',0,0},
{">",'>',0,0},
{",",',',0,0},
{".",'.',0,0},
{";",';',0,0},
{":",':',0,0},
{"?",'?',0,0},
{"left",KEY_LEFT,0,0},
{"right",KEY_RIGHT,0,0},
{"up",KEY_UP,0,0},
{"down",KEY_DOWN,0,0},
{"&",'&',0,0},
{"~",'~',0,0},
{"\"",'\"',0,0},
{"#",'#',0,0},
{"\'",'\'',0,0},
{"{",'}',0,0},
{"(",')',0,0},
{"[",'[',0,0},
{"]",']',0,0},
{"|",'|',0,0},
{"`",'`',0,0},
{"_",'_',0,0},
{"\\",'\\',0,0},
{"^",'^',0,0},
{"@",'@',0,0},
{"=",'=',0,0},
{"$",'$',0,0},
{"%",'%',0,0},
{"!",'!',0,0},
{"control-g",CONTROL_G,0,0},
{"control-k",CONTROL_K,0,0},
{"control-u",CONTROL_U,0,0},
{"redraw",CONTROL_L,0,F_REDRAW}, // Vaut pour Control-L
{"home",KEY_HOME,0,0},
{"end",KEY_END,0,0},
{"page-up",KEY_PPAGE,0,0},
{"page-down",KEY_NPAGE,0,0},
{"delete",KEY_DC,0,0},
{"backspace",KEY_BACKSPACE,0,0},
{"tab",'\t',0,0},
{"backtab",KEY_BTAB,0,0} };


static int nb_touches;

static void assigner_fonc(int n,char *shdesc,char *lndesc)
{
  lesfonctions[n].short_desc=shdesc;
  lesfonctions[n].long_desc=lndesc;
}

static void init_fonctions()
{
  int i;

  nb_touches=sizeof(lestouches)/sizeof(dino_touche);
  
  for(i=0;i<FUNCTIONS_NUMBER;i++)
    {
      lesfonctions[i].short_desc=NULL;
      lesfonctions[i].long_desc=NULL;
    }
  
  assigner_fonc(0,"none","Touche désactivée");
  assigner_fonc(1,"1","Aller au message");
  assigner_fonc(2,"2","Aller au message");
  assigner_fonc(3,"3","Aller au message");
  assigner_fonc(4,"4","Aller au message");
  assigner_fonc(5,"5","Aller au message");
  assigner_fonc(6,"6","Aller au message");
  assigner_fonc(7,"7","Aller au message");
  assigner_fonc(8,"8","Aller au message");
  assigner_fonc(9,"9","Aller au message");
  
  assigner_fonc(F_NPAGE_OR_NMESS,"npage-or-nmess","Lire les messages dans l'ordre des thèmes.");
  assigner_fonc(F_REDRAW,"redraw","Rafraîchir l'écran");
  assigner_fonc(F_LAUNCHBROWSER,"browser","Lancer le navigateur sur l'URL surlignée");
  assigner_fonc(F_BEGINNING,"beginning","Début du message");
  assigner_fonc(F_END,"end","Fin du message");
  assigner_fonc(F_PPAGE,"prev-page","Remonter d'une page");
  assigner_fonc(F_NPAGE,"next-page","Descendre d'une page");
  assigner_fonc(F_PLINE,"prev-line","Remonter d'une ligne");
  assigner_fonc(F_NLINE,"next-line","Descendre d'une ligne");

  assigner_fonc(F_CHANGE_STACK,"change-stack","Changer la pile courante");
  assigner_fonc(F_PUSH_YSTACK,"push-yellow-stack","Empiler sur la pile jaune");
  assigner_fonc(F_PUSH_BSTACK,"push-blue-stack","Empiler sur la pile bleue");
  assigner_fonc(F_POP_YSTACK,"pop-yellow-stack","Dépiler la pile jaune et aller au message");
  assigner_fonc(F_POP_BSTACK,"pop-blue-stack","Dépiler la pile bleue et aller au message");
  assigner_fonc(F_RIGHT_ROLL,"right-roll","Rotation à droite de la pile courante");
  assigner_fonc(F_LEFT_ROLL,"left-roll","Rotation à gauche de la pile courante");
  assigner_fonc(F_REVERSE_STACK,"reverse-stack","Retourner la pile courante");
  assigner_fonc(F_STACK_DROP,"stack-drop","Dépiler la pile courante, sans aller au message");
  assigner_fonc(F_GOTO_REF_Y,"goto-ref-yellow","Empiler sur la pile jaune et aller à la réponse");
  assigner_fonc(F_GOTO_REF_B,"goto-ref-blue","Empiler sur la pile bleue et aller à la réponse");

  assigner_fonc(F_PREV_MSG,"prev-msg","Aller au message précédent");
  assigner_fonc(F_NEXT_MSG,"next-msg","Aller au message suivant");
  assigner_fonc(F_LAST_MSG,"last-msg","Aller au dernier message");
  assigner_fonc(F_LAST_READ_MSG,"last-read-msg","Aller au dernier message lu");
  assigner_fonc(F_PREV_IN_THEME,"prev-in-theme","Aller au message précédent dans le thème");
  assigner_fonc(F_NEXT_IN_THEME,"next-in-theme","Aller au message suivant dans le thème");

  assigner_fonc(F_CHANGE_THEME,"goto-theme","Aller au thème");
  assigner_fonc(F_LIST_THEMES,"list-themes","Liste des thèmes abonnés");
  assigner_fonc(F_LIST_ALL_THEMES,"list-all-themes","Liste de tous les thèmes");
  assigner_fonc(F_TOGGLE_SUBSCRIBE,"subscribe","Abonnement/désabonnement à un thème");
  assigner_fonc(F_MARK_READ,"mark-read","Marquer le thème comme lu");
  assigner_fonc(F_MARK_ALL_READ,"mark-all-read","Marquer tous les thèmes comme lus");

  assigner_fonc(F_PUSH_REPLY,"push-reply","Ajouter le message dans la prochaine réponse");
  assigner_fonc(F_REPLY,"reply","Répondre à un message");
  assigner_fonc(F_FAST_REPLY,"fast-reply","Répondre à un message, sans confirmer l'inclusion");
  assigner_fonc(F_NEW_MESSAGE,"new-message","Poster un nouveau message");
  assigner_fonc(F_MAIL_REPLY,"mail-reply","Répondre par mail");

  assigner_fonc(F_TOGGLE_READCENS,"read-cens","Activer/désactiver la lecture des messages censurés");
  assigner_fonc(F_CENSOR,"censor","Censurer/libérer un message");
  assigner_fonc(F_FILTER,"filter","Filtrer les messages de l'auteur");

  assigner_fonc(F_SERVER_DATE,"server-date","Afficher la date du serveur");
  assigner_fonc(F_SERVER_COMMAND,"server-command","Envoyer une commande brute au serveur");
  assigner_fonc(F_BIDOU_BIDOU,"bidou-bidou","Envoyer des bidous-bidous");
  assigner_fonc(F_CHANGE_MSG_TYPE,"change-msg-type","Changer le type de contenu des messages");
  assigner_fonc(F_HELP,"view-help","Afficher l'aide");
  assigner_fonc(F_APPLY_FILTER,"apply-filter","Passer le message à travers un filtre");
  assigner_fonc(F_LIST_USERS,"list-users","Afficher la liste des utilisateurs connectés");
  assigner_fonc(F_DISCONNECT,"disconnect","Se déconnecter du serveur courant");
  assigner_fonc(F_QUIT,"quit","Quitter");
  assigner_fonc(F_FAST_QUIT,"fast-quit","Quitter sans demander confirmation");
}


static int lire_keymap(char *chemin)
{
  FILE *fichier;
  char ligne[BUFMSIZE];
  int result;
  char toutouche[BUFMSIZE];
  char fonfonc[BUFMSIZE];
  int i,j=0,li=0;

  fichier=fopen(chemin,"r");
  if(fichier==NULL)
    return -1;
  while(fgets(ligne,BUFMSIZE-1,fichier)!=NULL)
    {
      li++;
      result=sscanf(ligne,"%s %s",toutouche,fonfonc);
      if(result==2)
	{
	  for(i=0;i<nb_touches;i++)
	    if(strcmp(lestouches[i].desc,toutouche)==0)
	      {
		for(j=0;j<FUNCTIONS_NUMBER;j++)
		  if(strcmp(lesfonctions[j].short_desc,fonfonc)==0)
		    {
		      lestouches[i].fonc=j;
		      if(debug & DEBUG_DEFAULT)
			{
			  printf("Touche %s : %s\n",lestouches[i].desc,lesfonctions[j].long_desc);
			}
		      if(lestouches[i].next_is_maj && lestouches[i+1].fonc==0)
			lestouches[i+1].fonc=j;
		      break;
		    }
		break;
	      }
	  if((debug & DEBUG_DEFAULT) && (i==nb_touches || j==FUNCTIONS_NUMBER))
	    {
	      printf("Erreur dans le fichier %s, ligne %i.\n",chemin,li);
	    }
	}
    }
  return 0;
  
}

int init_touches()
{
  char config_file[LONGMAXNOMFICH];

  init_fonctions();

  sprintf(config_file,"%s/%s/keymap",getenv("HOME"),DINO2_DIR);
  if(lire_keymap(config_file)<0)
    {
      keymap_defaut=1;
      sprintf(config_file,"%s/keymap",DINO2_DEFS_DIR);
      if(lire_keymap(config_file)<0)
	{
	  fprintf(stderr,_("Error : keymap configuration not found.\n"));
	  return -1;
	}
    }
  return 0;
}

int fonction_touche(int touche)
{
  int i;
  
  for(i=0;i<nb_touches;i++)
    {
      if(lestouches[i].ncurses_key==touche)
	return lestouches[i].fonc;
    }
  return F_NONE;
}

/* aide

   Renvoie un message qui contient le fichier d'aide. */

message_t *aide()
{
  message_t *retour;
  FILE *fichier;
  int i,j,k,realc,visiblec;
  int rougeoujaune=0;
  char *temp;
  
  retour=calloc(1,sizeof(message_t));
  
  retour->numero=-6;
  retour->html=1;
  retour->sujet=strdup(_("The keys, and their effetcs"));

  retour->corps=malloc(BUFSIZE);

  if(keymap_defaut && (fichier=fopen(FICHIER_AIDE,"r"))!=NULL)
    {
      retour->corps=malloc(BUFSIZE);
      i=fread(retour->corps,1,BUFSIZE,fichier);
      fclose(fichier);
      retour->corps[i]=0;
      retour->corps=realloc(retour->corps,i+1);
    }
  else
    {
      i=0;
      for(j=0;j<nb_touches;j++)
	if(lestouches[j].fonc>9)
	  {
	    rougeoujaune = !rougeoujaune;
	    realc=0;
	    visiblec=0;
	    temp=lestouches[j].desc;
	    k=strlen(temp);
	    switch(temp[0]) {
	    case '>':
	      temp="&gt;";
	      break;
	    case '<':
	      temp="&lt;";
	      break;
	    case '&':
	      temp="&amp;";
	      break;
	    }	    
	    while(k+visiblec<9)
	      {
		retour->corps[i+realc++]=' ';
		visiblec++;
	      }
	    realc+=sprintf(retour->corps+i+realc,"%s%s%s : ",rougeoujaune?"<b>":"<b><i>",temp,rougeoujaune?"</b>":"</i></b>");
	    visiblec+=k+3;
	    k=strlen(lesfonctions[lestouches[j].fonc].short_desc);
	    realc+=sprintf(retour->corps+i+realc,"%s ",lesfonctions[lestouches[j].fonc].short_desc);
	    visiblec+=k+1;
	    while(visiblec<27)
	      {
		retour->corps[i+realc++]=' ';
		visiblec++;
	      }
	    realc+=sprintf(retour->corps+i+realc,"<i>%s</i>\n",lesfonctions[lestouches[j].fonc].long_desc);
	    i+=realc;
	    
	    if(lestouches[j].next_is_maj && lestouches[j+1].fonc==lestouches[j].fonc)
	      j++;
	  }
      i+=sprintf(retour->corps+i,"      1-9 : Aller au message en entrant son numéro\n");
      retour->corps=realloc(retour->corps,i+1);
      // Ajouter 0-9
    }
  return retour;
}
