(* $Id: being_edited.ml,v 1.4 2001/06/12 23:23:12 mjambon Exp $ *)


type t = { rep_ident : string;
	   rep_hdr : New_msg.t;
	   rep_msg : Dino_message_type.t;
	   rep_newmsg : Dino_message_type.t;
	   mutable rep_not_shown : bool }

let file = Default.being_edited

let counter = ref 0
let list = ref ([] : t list)

type file_contents = { fc_list : t list;
		       fc_counter : int }

let input () = 
  try
    let inchan = open_in file in
    let contents : file_contents = Marshal.from_channel inchan in
    counter := contents.fc_counter;
    list := !list @ contents.fc_list;
    close_in inchan
  with _ -> ()

let output () =
  let outchan = open_out file in
  List.iter ~f:(fun m -> m.rep_not_shown <- true) !list;
  let contents = { fc_list = !list;
		   fc_counter = !counter } in
  Marshal.to_channel outchan contents ~mode:[];
  close_out outchan

let async_output () =
  ignore (Dodo_thread.create output ())
