(* $Id: com.ml,v 1.2 2001/03/19 13:22:50 mjambon Exp $ *)
open Str

type response =
    Finite_response of int * string list
  | Infinite_response of string list
  | Must_reconnect
  | Error of string
  | Any_response of string

let print_list = List.iter ~f:print_endline

let print_response = function
    Finite_response (n, l) -> 
      Printf.printf "Finite response (%i):\n" n;
      print_list l;
      print_newline ()
  | Infinite_response l ->
      Printf.printf "Infinite response:\n";
      print_list l;
      print_newline ()
  | Must_reconnect -> 
      Printf.printf "You must reconnect...\n"; 
      flush stdout
  | Error err ->
      Printf.printf "Error: %s\n" err;
      flush stdout;
  | Any_response s -> 
      Printf.printf "Unknown response: %s\n" s;
      flush stdout


let bad_response response =
  print_endline "Unexpected response from server:\n";
  print_response response;
  failwith "Bad response"

let bad_response_light response =
  print_endline "Unexpected response from server:\n";
  print_response response


let expr_finite = regexp "Ok/\\([0-9]+\\): \\(.*\\)"
let expr_infinite = regexp "Ok/n: \\(.*\\)"
let temps_depasse = "Error: temps depasse"
let expr_err = regexp "Err: \\(.*\\)"


let rec input_finite in_chan = function
    0 -> []
  | n -> input_line in_chan :: input_finite in_chan (n-1)

let rec input_infinite in_chan = 
  match input_line in_chan with
      "#fin" -> []
    | s -> s :: input_infinite in_chan  

let read_response in_chan =
  let s = input_line in_chan in

  if string_match ~pat:expr_finite s ~pos:0 then
    let n = int_of_string (matched_group 1 s)
    and first = matched_group 2 s in
    let l = first :: input_finite in_chan (n-1) in
    Finite_response (n,l)

  else if string_match ~pat:expr_infinite s ~pos:0 then
    let first = matched_group 1 s in
    let l = first :: input_infinite in_chan in
    Infinite_response l

  else if string_match ~pat:expr_err s ~pos:0 then
    Error (matched_group 1 s)

  else Any_response s
