(* $Id: default.ml,v 1.23 2001/06/18 23:17:34 mjambon Exp $ *)

open Unix
open ThreadUnix

open Dodo

let checkdir dir =
  if not (Sys.file_exists dir) then
    mkdir dir ~perm:0o700
  else
    let s = stat dir in
    (match s.st_kind with
	 S_DIR -> ()
       | _ -> failwith (dir^" should be a directory"))


let host = "dragon.ens-lyon.fr"
let server = host
let port = 4030
let editors : editor list = 
  let make_editor ed = { ed_name = ed;
			 ed_active = true } in
  [ make_editor `Native;
    make_editor (`External ("dino-editor","xterm -e dino-editor %s"));
    make_editor (`External ("vi","xterm -e vi %s"));
    make_editor (`External ("nano","xterm -e nano -t -r72 %s"));
    make_editor (`External ("pico","xterm -e pico -t -r72 %s"));
    make_editor (`External 
		   ("nedit","nedit -autowrap -columns 72 -autosave %s"))]

let home = try Unix.getenv "HOME" with Not_found -> ""
let dododir = home^"/.dodo"
let _ = checkdir dododir
let dodorc = dododir^"/dodorc"
let dinorc = home^"/.dinorc"
let dinostack = home^"/.dino-pile"
let being_edited = dododir^"/being_edited"
let theme_infos = dododir^"/theme_infos"
let user_infos = dododir^"/user_infos"
let tmpdir = "/tmp"

let cache_size = 400 (* maximal number of messages to keep within
			the same session *)
let download_size = 300


let reply_author_begin = "  "
let reply_author_middle = " a crit ("
let reply_author_end = ") :"
let reply_string = "> "
let reply_additional_line = ""
let line_length = 72
let browser = "if ! netscape %s -remote; then netscape %s; fi"
let mailer = "xterm +sb -e pine %s"
let timeout = 30 (* seconds *)
let auto_unzap = false
let psy = false
