(* $Id: dino_commands.ml,v 1.6 2001/06/19 19:25:18 mjambon Exp $ *)

open Tk

open Tk_dino_init
open Com

let current_pos = `Mark "insert"
let current_index = (current_pos,[])
let line_start = (current_pos, [`Linestart])
let line_end = (current_pos, [`Lineend])
let text_end = (`End,[])

let convert s = 
  let len = String.length s in
  if len > 0 then
    (let buf = Buffer.create 100 in
     let len' = len-1 in
     let rec loop i = 
       if i < len' then
	 let c = s.[i] in
	 if c = '\\' then
	   let c' = s.[i+1] in
	   if c' = 'n' then (Buffer.add_char buf '\n'; loop (i+2))
	   else if c' = '\\' then (Buffer.add_char buf '\\'; loop (i+2))
	   else (Buffer.add_char buf '\\'; loop (i+1))
	 else (Buffer.add_char buf c; loop (i+1))
       else if i = len' then
         Buffer.add_char buf s.[len'] in
     loop 0;
     Buffer.contents buf)
  else ""




let print_response tw =
  let ins = Text.insert tw ~index:text_end in 
  let insert s = ins ~text:s in
  let insert_line = (fun s -> insert s; insert "\n") in
  let insert_list = List.iter ~f:insert_line in
  fun q r ->
    try 
      begin
	Text.configure tw ~state:`Normal;
	let `Linechar (line,_) = Text.index tw ~index:text_end in
	(*let index = (Text.index tw ~index:current_index, []) in*)
	insert "# "; insert_line q;
	begin
	  match r with
	      Finite_response (n, l) -> 
		insert "--- Rponse OK (";
		insert (string_of_int n);
		insert_line " ligne(s)) ---";
		insert_list l
	    | Infinite_response l ->
		insert_line "--- Rponse OK ---";
		insert_list l
	    | Must_reconnect -> 
		insert_line "--- Vous devez vous reconnecter ---"
	    | Error err ->
		insert_line "--- Erreur ---"; 
		insert_line err
	    | Any_response s -> 
		insert_line "--- Rponse inconnue ---";
		insert_line s
	end;
	Text.configure tw ~state:`Disabled;
	Text.yview_line tw ~line:(line-1)
      end
    with (*Protocol.TkError*) _ -> ()


let send_command twin twout = 
  let print = print_response twout in
  fun _ ->
    let q = convert (Text.get twin ~start:line_start ~stop:line_end) in
    Connect.dino_send_command [q;"\n"] [print q]


let init () =
  let win = Toplevel.create top in
  Wm.title_set win "Communication presque directe avec le serveur";
  let frame = Frame.create win in
  
  let blabla = Label.create frame 
	       ~text:"Attention : une rponse par ligne est attendue.
Pour envoyer plusieurs lignes, utiliser \\n.
Tapez  aide  pour demander la liste des commandes." in

  let my_frame = Frame.create frame in
  let server_frame = Frame.create frame in
  
  let my_text = Text.create my_frame 
		~width:80
		~height:8
		~state:`Normal 
		~background:!Dodo_settings.textbg
		~foreground:!Dodo_settings.textfg
		~font:Tk_default.msg_font
		~cursor:!Dodo_settings.textcursor
		~insertbackground:!Dodo_settings.textinsertbg in

  let my_textsb = Scrollbar.create my_frame 
		  ~takefocus:false
		  ~command:(Text.yview my_text) in
  Text.configure my_text ~yscrollcommand:(Scrollbar.set my_textsb);


  let server_text = Text.create server_frame
		    ~width:80
		    ~height:20
		    ~state:`Disabled
		    ~background:!Dodo_settings.textbg
		    ~foreground:!Dodo_settings.textfg
		    ~font:Tk_default.msg_font
		    ~cursor:!Dodo_settings.textcursor
		    ~insertbackground:!Dodo_settings.textinsertbg
		    ~takefocus:false in

  let server_textsb = Scrollbar.create server_frame 
		      ~command:(Text.yview server_text)
		      ~takefocus:false in
  Text.configure server_text ~yscrollcommand:(Scrollbar.set server_textsb);

  let close () = destroy win in

  let button_close = Button.create frame 
		     ~text:"Fermer"
		     ~takefocus:false
		     ~command:close in

  bind my_text ~events:[`KeyPressDetail "Return"] 
  ~action:(send_command my_text server_text);
(*  bind server_text ~events:[`Enter] 
  ~action:(fun _ -> Focus.set server_textsb);*)


  pack [my_text] ~side:`Left ~expand:true ~fill:`Both;
  pack [my_textsb] ~side:`Right ~expand:false ~fill:`Y;

  pack [server_text] ~side:`Left ~expand:true ~fill:`Both;
  pack [server_textsb] ~side:`Right ~expand:false ~fill:`Y;

  pack [blabla] ~side:`Top ~expand:true ~fill:`Both;
  pack [my_frame;server_frame] ~side:`Top ~expand:true ~fill:`Both;
  pack [button_close] ~side:`Top ~expand:true ~fill:`None;
  pack [frame] ~expand:true ~fill:`Both;

  Focus.set my_text
