(* $Id: dinorc.ml,v 1.6 2001/05/06 18:55:48 mjambon Exp $ *)
open Str
open Theme

let dinorc = ref Default.dinorc

let expr = regexp "\\([^ ]*\\)[ ]+\\([0-9]+\\)[^\\*]*\\(\\*?\\)"


let read () =
  let cur_dinorc = !dinorc in
  if Sys.file_exists cur_dinorc then
    let inchan = open_in cur_dinorc in
    let rec loop () =
      try 
	let s = input_line inchan in
	if string_match ~pat:expr s ~pos:0 then
	  let theme_name = matched_group 1 s in
	  let theme_last_read = int_of_string (matched_group 2 s) in
	  let theme_ignored = match matched_group 3 s with
	      "*" -> true
	    | _ -> false in
	  { theme_name = theme_name;
	    theme_info = Theme_info.get theme_name;
	    theme_ignored = theme_ignored;
	    theme_last_read = theme_last_read;
	    theme_current = theme_last_read;
	    theme_read = false } :: loop ()
	else [] (*loop ()*)
      with
	  End_of_file -> [] in
    
    let theme_list = loop () in
    close_in inchan;
    theme_list
  else 
    (Printf.printf "File %s not found\n" cur_dinorc;
     flush stdout;
     [])

let save () =
  let out_chan = open_out !dinorc in
  let theme_list = Theme.get_all () in
  List.iter ~f:(fun th -> 
		  if th.theme_ignored then 
		    Printf.fprintf out_chan "%s %i *\n" 
		      th.theme_name th.theme_last_read
		  else
		    Printf.fprintf out_chan "%s %i\n"
		      th.theme_name th.theme_last_read) theme_list;
  close_out out_chan
