(* $Id: display_dino_message.ml,v 1.17 2001/06/16 13:53:53 mjambon Exp $ *)

open Printf

open Tk_dino_init
open Header
open Dino_message_type
open Theme
open Dodo_settings

let tk_text = Tk_dino_init.text

let null_msg = Dino_message_type.create ()
let current_msg = ref null_msg
let current_num = ref 0

let history = History.create !current_num

let body msg =
  Text.configure tk_text ~state:`Normal;
  Text.delete tk_text ~start:beginning ~stop:text_end;
  let s = msg.msg_contents in
  Text.insert ~index:beginning ~text:s tk_text;

  if !highlight_quotes then
    Tag.scan_quotes s;
  if !highlight_urls then
    Tag.scan_urls s;
  if !highlight_emails then
    Tag.scan_emails s;

  Tag.configure ();
  Text.configure tk_text ~state:`Disabled

let header = Header.fill

let push num =
  if History.current history <> num then
    History.push history num

let rec message ?(must_push=true) msg =
  msg.msg_read <- true;
  let n = msg.msg_header.hr_num in
  if must_push then push n;
  current_num := n;
  let l = msg.msg_header.hr_themes in
  if not (List.mem (Theme.current ()).theme_name l) then
    (try Theme.set (Theme.get (List.hd l)) with _ -> ());
  let t = Theme.current () in
  if n > t.theme_last_read then
    t.theme_last_read <- n;
  t.theme_current <- n;
  header num msg.msg_header;
  body msg;
  current_msg := msg

and message_pseudo msg =
    msg.msg_read <- true;
  let n = msg.msg_header.hr_num in
  current_num := n;
  let t = Theme.current () in
  if n > t.theme_last_read then
    t.theme_last_read <- n;
  t.theme_current <- n;
  current_msg := msg


and num number =
  if number = 0 then
    message ~must_push:false null_msg
  else
    match Dino_message.get number with
	Some msg -> message ~must_push:true msg
      | None -> ()
	  
exception Nothing
let num_exn number =
  if number = 0 then
    message ~must_push:false null_msg
  else
    match Dino_message.get number with
	Some msg -> message ~must_push:true msg
      | None -> raise Nothing


let num' number =
  if number = 0 then
    message ~must_push:false null_msg
  else
    match Dino_message.get number with
	Some msg ->
	  message ~must_push:true msg;
	  let hdr = msg.msg_header in
	  (match hdr.hr_cens with
	       [] -> 
		 if hdr.hr_effa then
		   Tk_info.display ("Message "^(string_of_int number)^" effac")
		 else
		   Tk_info.display ("Message "^(string_of_int number))
	     | l ->
		 let l' = List.map ~f:(fun (who,th_name) -> 
					 sprintf "%s/%s" th_name 
					   (censtype_to_string who)) l in
		 let s = String.concat ~sep:"; " l' in
		 Tk_info.display (sprintf "Message %i censur [%s]" number s))

      | None -> ()


let current () = message !current_msg


let history_num number =
  if number = 0 then
    message ~must_push:false null_msg
  else
    match Dino_message.get number with
	Some msg -> message ~must_push:false msg
      | None -> ()


let back () = 
  try
    let msg_num = History.back history in
    history_num msg_num
  with History.Beginning -> 
    Tk_info.display "Vous tes au dbut de l'historique"

let forward () = 
  try
    let msg_num = History.forward history in
    history_num msg_num
  with History.End -> 
    Tk_info.display "Vous tes  la fin de l'historique"

let _ = Theme.display_num := num_exn

let next () = 
  try num' (succ !current_num) 
  with Dino_message.Bad_number -> Tk_info.display "Dernier message" 
      

let previous () =
  if !current_num > 1 then num' (pred !current_num)
  else
    Tk_info.display "Pas de message prcdent"

let next_th () =
  match Dino_message.get_next ~th:(Theme.current ()) with
      Some n -> num' n
    | None -> ()

let previous_th () =
  match Dino_message.get_previous ~th:(Theme.current ()) with
      Some n -> num' n
    | None -> ()

let nothing_new () =
  if Connect.on () then 
    (if !Dodo_settings.auto_unzap then Zap.unzap_all ();
     Tk_info.display "Pas de nouveau message")


let rec next_unread () =
  let th = Theme.current () in
  match Dino_message.get_new th with
      Some n -> 
	(match Dino_message.get n with
	    Some msg -> 
	      if Zap.should_zap msg then 
		(message_pseudo msg;
		 next_unread ())
	      else num' n
	   | None -> nothing_new ())
    | None -> nothing_new ()


let re_dernier = Str.regexp " *[Dd][Ee][Rr][Nn][Ii][Ee][Rr]"

let from_entry () =
  let s = Textvariable.get msg_entry_var in
  if Str.string_match ~pat:re_dernier s ~pos:0 then
    (num' (Dino_message.nbmsg ());
     Textvariable.set msg_entry_var "dernier")
  else
    let l = Intlist.of_string s in
    match l with
	[] -> Textvariable.set msg_entry_var ""
      | [hd] -> 	
	  (try 
	     (num' hd;
 	      Textvariable.set msg_entry_var (string_of_int hd))
	   with Dino_message.Bad_number -> 
	     (Tk_info.display "Message inexistant";
	      Textvariable.set msg_entry_var ""))
      | hd::tl -> 
	  (try num' hd 
	   with Dino_message.Bad_number -> 
	     Tk_info.display "Message inexistant");
	  Textvariable.set msg_entry_var 
	    (String.concat ~sep:" " (List.map ~f:string_of_int tl))
