(* n firsts elements of a list *)
let rec n_firsts n = function
    [] -> []
  | hd::tl -> if n > 0 then hd :: n_firsts (n-1) tl else []

let rec n_firsts_term term n = function
    [] -> []
  | hd::tl -> if n > 0 then hd :: n_firsts_term term (n-1) tl else [term]

let rec optmap ~f = function
    [] -> []
  | hd::tl -> match f hd with 
	None -> optmap ~f tl
      | Some v -> v :: optmap ~f tl


let insert ins l =
  let inslen = String.length ins in
  let len = List.fold_left ~f:(fun sum e ->
				 match e with
				     `String s -> String.length s + sum
				   | `Subst -> inslen + sum) ~init:0 l in
  let str = String.create len in
  ignore (List.fold_left ~f:(fun i e ->
			       match e with
				   `String s ->
				     let n = String.length s in
				     String.blit ~src:s ~src_pos:0
				     ~dst:str ~dst_pos:i ~len:n;
				     i+n
				 | `Subst -> 
				     String.blit ~src:ins ~src_pos:0
				     ~dst:str ~dst_pos:i ~len:inslen;
				     i+inslen) ~init:0 l);
  str


let subst s ~ins = 
  let len = String.length s in
  let rec loop start i =
    if i >= len-1 then
      [`String (String.sub s ~pos:start ~len:(len-start))]
    else
      if s.[i] = '%' then
	let next = s.[i+1] in
	if next = 's' then
	  `String (String.sub s ~pos:start ~len:(i-start)) 
	  :: `Subst
	  :: loop (i+2) (i+2)
	else if next = '%' then 
	  `String (String.sub s ~pos:start ~len:(i-start+1))
	  :: loop (i+2) (i+2)
	else
	  loop start (i+2)
      else
	loop start (i+1) in
  if len >= 2 then
    insert ins (loop 0 0)
  else
    s

let is_white s =
  try 
    for i = 0 to String.length s - 1 do
      if s.[i] <> ' ' then raise Exit
    done;
  true
  with Exit -> false

let prn s = print_string s; print_newline ()
