(* $Id: dodo_option.ml,v 1.4 2001/07/06 11:43:59 mjambon Exp $ *)

open Printf
open Str
open Dodo_settings

let dodorc = Default.dodorc

let input_internal label x = 
  try
    let opt = Hashtbl.find table label in
    opt.dodo_input x
  with 
      Not_found -> 
	Hashtbl.add table ~key:label ~data:{ dodo_label = label;
					     dodo_input = (fun _ -> ());
					     dodo_output = (fun () -> x) };
				  
	eprintf "Warning: unknown option %s (= %s)\n" label x

let re_entry = regexp "^\\([A-Z_]+\\)=\\(.*\\)$"

let input () =
  try
    let inchan = open_in dodorc in
    let rec input' () = 
      try
	let line = input_line inchan in
	if string_match ~pat:re_entry line ~pos:0 then
	  let label = matched_group 1 line
	  and x = matched_group 2 line in
	  input_internal label x;
	  input' ()
	else
	  input' ()
      with End_of_file -> () in
    input' ();
    close_in inchan
  with Sys_error _ -> () (* no dodorc *)


let save () = 
  let outchan = open_out dodorc in 
  Hashtbl.iter ~f:(fun ~key ~data -> 
		     let s = data.dodo_output () in
		     if s <> "" then
		       fprintf outchan "%s=%s\n" 
			 data.dodo_label s) table;
  close_out outchan

let _ = 
  input ();
  check_editor_list Default.editors
