(* $Id: dodo_settings_window.ml,v 1.12 2001/06/16 20:32:52 mjambon Exp $ *)

open Tk

open Tk_dino_init
open Dodo_settings


let show () =
  let t = Toplevel.create top in
  Wm.title_set t "Options diverses";

  let eco_var = Textvariable.create () in
  let eco_button = Checkbutton.create t 
		    ~text:"Au dmarrage, ne pas se connecter automatiquement ( mode conomique )"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:eco_var in
  Textvariable.set eco_var (if !dodo_eco then "y" else "");

  let anonymous_var = Textvariable.create () in
  let anonymous_button = Checkbutton.create t 
		    ~text:"Se connecter anonymement au serveur (effet  la prochaine reconnexion)"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:anonymous_var in
  Textvariable.set anonymous_var (if !dodo_anonymous then "y" else "");


  let sign_var = Textvariable.create () in
  let sign_button = Checkbutton.create t 
		    ~text:"Par dfaut, signer les messages"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:sign_var in
  Textvariable.set sign_var (if !dino_sign then "y" else "");

  let send_html_var = Textvariable.create () in
  let send_html_button = Checkbutton.create t 
		    ~text:"Par dfaut, supposer que les messages  envoyer sont en dino-HTML"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:send_html_var in
  Textvariable.set send_html_var (if !send_html then "y" else "");

  let get_html_var = Textvariable.create () in
  let get_html_button = Checkbutton.create t 
		    ~text:"Rcuprer les messages en dino-HTML (en phase de dveloppement...)"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:get_html_var in
  Textvariable.set get_html_var (if !get_html then "y" else "");


  let hlquotes_var = Textvariable.create () in
  let hlquotes_button = Checkbutton.create t 
			~text:"Colorer les diffrents niveaux de rponses"
			~takefocus:false
			~onvalue:"y"
			~offvalue:""
			~variable:hlquotes_var in
  Textvariable.set hlquotes_var (if !highlight_quotes then "y" else "");

  let hlurls_var = Textvariable.create () in
  let hlurls_button = Checkbutton.create t 
			~text:"Mettre en vidence ce qui ressemble  une URL"
			~takefocus:false
			~onvalue:"y"
			~offvalue:""
			~variable:hlurls_var in
  Textvariable.set hlurls_var (if !highlight_urls then "y" else "");

  let hlemails_var = Textvariable.create () in
  let hlemails_button = Checkbutton.create t 
			~text:"Mettre en vidence ce qui ressemble  une adresse e-mail"
			~takefocus:false
			~onvalue:"y"
			~offvalue:""
			~variable:hlemails_var in
  Textvariable.set hlemails_var (if !highlight_emails then "y" else "");


  let white_var = Textvariable.create () in
  let white_button = Checkbutton.create t 
		    ~text:"Fond blanc"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:white_var in
  Textvariable.set white_var (if !bg_white then "y" else "");

  let auto_unzap_var = Textvariable.create () in
  let auto_unzap_button = Checkbutton.create t 
		    ~text:"Rabonnement automatique  toutes les discussions zappes une fois que tous les nouveaux messages ont t lus"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:auto_unzap_var in
  Textvariable.set auto_unzap_var (if !auto_unzap then "y" else "");

  let psy_var = Textvariable.create () in
  let psy_button = Checkbutton.create t 
		    ~text:"Option psychdlique (effet  la prochaine utilisation)"
		    ~takefocus:false
		    ~onvalue:"y"
		    ~offvalue:""
		    ~variable:psy_var in
  Textvariable.set psy_var (if !psy then "y" else "");


  let dino_nick_frame = Frame.create t in
  let dino_nick_label = Label.create ~text:"Pseudonyme par dfaut : " dino_nick_frame in
  let dino_nick_var = Textvariable.create () in
  let dino_nick_entry = Entry.create ~textvariable:dino_nick_var dino_nick_frame in
  Textvariable.set dino_nick_var !dino_nick;


  let browser_frame = Frame.create t in
  let browser_label = Label.create ~text:"Lire les pages web avec : " browser_frame in
  let browser_var = Textvariable.create () in
  let browser_entry = Entry.create ~textvariable:browser_var browser_frame in
  Textvariable.set browser_var !browser;

  let mailer_frame = Frame.create t in
  let mailer_label = Label.create ~text:"Envoyer les e-mails avec : " mailer_frame in
  let mailer_var = Textvariable.create () in
  let mailer_entry = Entry.create ~textvariable:mailer_var mailer_frame in
  Textvariable.set mailer_var !mailer;

  let close () =
    if Textvariable.get eco_var = "y" 
    then (dodo_eco := true; eco := true)
    else (dodo_eco := false; eco := false);

    if Textvariable.get anonymous_var = "y" 
    then (dodo_anonymous := true; anonymous := true)
    else (dodo_anonymous := false; anonymous := false);

    if Textvariable.get sign_var = "y" 
    then dino_sign := true 
    else dino_sign := false;

    if Textvariable.get send_html_var = "y" 
    then send_html := true 
    else send_html := false;

    if Textvariable.get get_html_var = "y" 
    then get_html := true 
    else get_html := false;

    if Textvariable.get hlquotes_var = "y" 
    then highlight_quotes := true 
    else highlight_quotes := false;

    if Textvariable.get hlurls_var = "y" 
    then highlight_urls := true 
    else highlight_urls := false;

    if Textvariable.get hlemails_var = "y" 
    then highlight_emails := true 
    else highlight_emails := false;

    if Textvariable.get white_var = "y" 
    then bg_white := true
    else bg_white := false;

    if Textvariable.get auto_unzap_var = "y" 
    then auto_unzap := true
    else auto_unzap := false;

    if Textvariable.get psy_var = "y" 
    then psy := true
    else psy := false;

    set_color ();
    Text.configure text ~foreground:!textfg ~background:!textbg;

    dino_nick := Textvariable.get dino_nick_var;

    let s = Textvariable.get browser_var in
    let len = String.length s in
    browser :=
    if len > 0 then 
      if s.[len-1] = ' ' then s 
      else s^" "
    else s;

    let s = Textvariable.get mailer_var in
    let len = String.length s in
    mailer :=
    if len > 0 then 
      if s.[len-1] = ' ' then s 
      else s^" "
    else s;

    destroy t in

  let bottom_frame = Frame.create t in
  let close_button = Button.create bottom_frame
		     ~text:"Fermer" ~command:close in
  let cancel_button = Button.create bottom_frame
		      ~text:"Annuler" ~command:(fun () -> destroy t) in

  pack [close_button;cancel_button] ~side:`Left;
  pack [eco_button; anonymous_button; sign_button; send_html_button;
	get_html_button; hlquotes_button; hlurls_button; hlemails_button; 
	auto_unzap_button; white_button; psy_button]
  ~side:`Top ~anchor:`W;

  pack [dino_nick_label] ~side:`Left;
  pack [dino_nick_entry] ~side:`Left ~expand:true ~fill:`X;
  pack [dino_nick_frame] ~side:`Top ~expand:true ~fill:`X;

  pack [browser_label] ~side:`Left;
  pack [browser_entry] ~side:`Left ~expand:true ~fill:`X;
  pack [browser_frame] ~side:`Top ~expand:true ~fill:`X;

  pack [mailer_label] ~side:`Left;
  pack [mailer_entry] ~side:`Left ~expand:true ~fill:`X;
  pack [mailer_frame] ~side:`Top ~expand:true ~fill:`X;

  pack [bottom_frame] ~side:`Bottom
