(* $Id: dodo_thread.ml,v 1.1 2001/05/27 18:27:23 mjambon Exp $ *)
open Unix
open ThreadUnix (* overrides some definitions of module Unix *)
open Printf

let create f = Thread.create 
		 (fun x -> try f x with 
		      Sys.Break -> exit 1
		    | exn -> 
			eprintf 
			  "Uncaught exception in thread %i: %s\n" 
			  (Thread.id (Thread.self ())) 
			  (Printexc.to_string exn); 
			exit 2)
