(* $Id: dodo_window.ml,v 1.1 2001/06/17 01:11:52 mjambon Exp $ *)

open Tk_dino_init

(* Manipulation of toplevel windows *)

let unique_window f =
  let win = ref None in
  fun () ->
    try 
      ((match !win with
	    Some t -> 
	      if Winfo.exists t then raise Exit
	  | None -> ());
       let t = Toplevel.create top in
       win := Some t;
       f t)
    with Exit -> ()

exception No_selection
let lb_num = function
    [] -> raise No_selection
  | `Num num::_ -> num
