type ('a,'b) t = { q1 : 'a Queue.t;
		   q2 : 'b Queue.t;
		   transition : ('a -> 'b list) }

(* transition is a function which should not raise any exceptions *)
let create ~transition =
    { q1 = Queue.create ();
      q2 = Queue.create ();
      transition = transition }

(* the transition function is applied during transfer. 
   If an exception is raised (e.g Reconnect_later), 
   it is ignored and the result is the empty list. *)
let transfer q =
  let a = Queue.take q.q1 in
  let b_list = q.transition a in
  List.iter ~f:(fun b -> Queue.add b q.q2) b_list


let add a q = Queue.add a q.q1
let take q = Queue.take q.q2

let length1 q = Queue.length q.q1
let length2 q = Queue.length q.q2
let length q = (Queue.length q.q1, Queue.length q.q2)

let is_empty1 q = try ignore (Queue.peek q.q1); false with Queue.Empty -> true
let is_empty2 q = try ignore (Queue.peek q.q2); false with Queue.Empty -> true
