(* $Id: editor.ml,v 1.3 2001/06/18 23:29:10 mjambon Exp $ *)

open Unix
open ThreadUnix
open Printf
open Tk

open Dodo_misc
open Dodo_settings
open Dodo_window
open Dodo

let make ?(active=true) ed = { ed_name = ed;
			       ed_active = active }

let get_name = 
  let nat = "diteur natif" in 
  function
      { ed_name = `Native } -> nat
    | { ed_name = `External (edname,edcommand) } -> edname

let config_window_internal t =
  let bottom_frame = Frame.create t in
  let top_frame = Frame.create t in

  let message = Label.create bottom_frame 
		
		~text:"Cliquer sur  Modifier  pour prendre en compte chaque changement" in

  let left_frame = Frame.create top_frame in
  let lb = Listbox.create left_frame in
  let sb = Scrollbar.create left_frame in
  Listbox.configure lb ~yscrollcommand:(Scrollbar.set sb);
  Scrollbar.configure sb ~command:(Listbox.yview lb);
  
  
  let right_frame = Frame.create top_frame in
  

  let buttons_frame = Frame.create right_frame in

  let upper_frame = Frame.create right_frame in
  let label_frame = Frame.create upper_frame in
  let entry_frame = Frame.create upper_frame in
  
  let edname_label = Label.create label_frame ~text:"Nom symbolique"
  and edname_entry = Entry.create entry_frame in
  let edcommand_label = Label.create label_frame ~text:"Commande"
  and edcommand_entry = Entry.create entry_frame in
  
  let active_var = Textvariable.create () in
  let get_active_var () = match Textvariable.get active_var with
      "y" -> true
    | _ -> false in
  let active_button = Checkbutton.create buttons_frame
		      ~onvalue:"y"
		      ~offvalue:""
		      ~variable:active_var
		      ~text:"Activ" in
  Textvariable.set active_var "";

  let add_button = Button.create buttons_frame ~text:"Ajouter"
  and rm_button = Button.create buttons_frame ~text:"Supprimer"
  and edit_button = Button.create buttons_frame ~text:"Modifier"
  and set_button = Button.create buttons_frame ~text:"Prfrer cet diteur"
  and close_button = Button.create buttons_frame 
		     ~text:"Fermer" ~command:(fun () -> destroy t) in
  
  Wm.title_set t "diteurs de messages";
  
  let table = ref [||] in
  let display () =
    let list = !editors in
    table := Array.of_list list;
    let texts = List.map 
		~f:get_name
		  list in
    Listbox.delete lb ~first:(`Num 0) ~last:`End;
    Listbox.insert lb ~index:`End ~texts in
  
  let add () =
    try 
      let active = get_active_var () in
      let edname = Entry.get edname_entry
      and edcommand = Entry.get edcommand_entry in
      add_editor (make ~active (`External (edname,edcommand)));
      display ()
    with _ -> () in
  
  let remove () =
    try
      let num = lb_num (Listbox.curselection lb) in
      let l = ref [] in
      let t = !table in
      let len = Array.length t in
      if len > 1 then
	(for i = len - 1 downto 0 do
	   if i <> num then
	     l := t.(i) :: !l
	 done;
	 editors := !l;
	 display ())
    with No_selection -> () in
  
  let put_first () =
    try
      let num = lb_num (Listbox.curselection lb) in
      let l = ref [] in
      let t = !table in
      let len = Array.length t in
      if len > 0 then
	let x = t.(num) in
	for i = len - 1 downto 0 do
	  if i <> num then
	    l := t.(i) :: !l
	done;
	editors := x::!l;
	for i = num-1 downto 0 do
	  t.(i+1) <- t.(i)
	done;
	t.(0) <- x;
	display ()
    with No_selection -> () in
  
  let change () =
    try
      let active = get_active_var () in
      let edname = Entry.get edname_entry
      and edcommand = Entry.get edcommand_entry in
      
      let num = lb_num (Listbox.curselection lb) in
      let t = !table in
      t.(num) <- (if Dodo_misc.is_white edcommand then make ~active `Native
		  else make ~active (`External (edname,edcommand)));
      editors := Array.to_list t;
      display ()
    with _ -> () in
  
  Button.configure edit_button ~command:change;
  Button.configure add_button ~command:add;
  Button.configure rm_button ~command:remove;
  Button.configure set_button ~command:put_first;
  
  let fill _ =
    try
      let t = !table in
      let num = lb_num (Listbox.curselection lb) in
      let ed = t.(num) in
      let active = ed.ed_active in
      let (edname,edcommand) = match ed with
	  { ed_name = `Native } -> "diteur natif",""
	| { ed_name = `External cpl } -> cpl in
      Entry.delete_range edname_entry ~start:(`Num 0) ~stop:`End;
      Entry.insert edname_entry ~index:(`Num 0) ~text:edname;
      Textvariable.set active_var (if active then "y" else "");
      Entry.delete_range edcommand_entry ~start:(`Num 0) ~stop:`End;
      Entry.insert edcommand_entry ~index:(`Num 0) ~text:edcommand;
    with _ -> () in
  
  bind lb ~events:[`ButtonReleaseDetail 1] ~action:fill;
  
  pack [lb] ~side:`Left ~expand:true ~fill:`Both;
  pack [sb] ~side:`Right ~expand:false ~fill:`Y;
  
  pack [active_button] ~anchor:`W;
  pack [edit_button;add_button;rm_button;set_button;close_button] 
  ~side:`Top ~expand:true ~fill:`Both ~anchor:`N;
  pack [edname_label;edcommand_label] 
  ~side:`Top ~expand:true ~fill:`None ~anchor:`Ne;
  pack [edname_entry] 
  ~side:`Top ~expand:true ~fill:`X ~anchor:`N;
  pack [edcommand_entry] 
  ~side:`Top ~expand:true ~fill:`X ~anchor:`N;
  pack [label_frame] ~side:`Left ~expand:false ~fill:`X;
  pack [entry_frame] ~side:`Left ~expand:true ~fill:`X;
  pack [upper_frame] ~side:`Top ~expand:false ~fill:`Both ~anchor:`N;
  pack [buttons_frame] ~side:`Top ~expand:true ~fill:`Both ~anchor:`N;

  pack [message] ~expand:true ~fill:`Both;
  


  pack [left_frame; right_frame] ~side:`Left ~expand:true ~fill:`Both;
  pack [top_frame; bottom_frame] ~side:`Top ~expand:true ~fill:`Both;
  
  display ()

let config_window = unique_window config_window_internal


let create_file s =
  let name = sprintf "%s/dodo_%x" Default.tmpdir (Random.bits ()) in
  let fd = openfile
	     name
	   ~mode:[O_CREAT;O_TRUNC;O_WRONLY]
	   ~perm:0o600 in
  ignore (write fd ~buf:s ~pos:0 ~len:(String.length s));
  close fd;
  name

let filecontents filename =
  let fd = openfile filename ~mode:[O_RDONLY] ~perm:0o400 in
  let st = fstat fd in
  let size = st.st_size in
  if st.st_kind = S_REG then
    let size = st.st_size in
    let buf = String.create size in
    let len = read fd ~buf ~pos:0 ~len:size in
    close fd;
    if len < size then
      String.sub buf ~pos:0 ~len
    else buf
  else ""
