open Printf
open Tk

open Tk_dino_init
open Com
open Connect
open Theme
open Dodo_settings
open User_info

type censtype = Moderator | Author | God


type t = { mutable hr_subject : string;
	   mutable hr_themes : string list;
	   mutable hr_author : string;
	   mutable hr_realauthor : User_info.t;
	   mutable hr_date : string;
	   mutable hr_num : int;
	   mutable hr_rep : int list;
	   mutable hr_sign : bool;
	   mutable hr_cens : (censtype * string) list;
	   mutable hr_effa : bool;
	   mutable hr_html : bool }

let censtype_to_string = function
    Moderator -> "modrateur"
  | Author -> "auteur"
  | God -> "Dieu"

let reply_buttons = ref []

let fill display_num hdr =
  let themes = 
    let selection = Dodo_misc.n_firsts_term "..." 5 hdr.hr_themes in
    String.concat ~sep:" " selection in
(*  let replies =
    String.concat ~sep:" " (List.map ~f:string_of_int hdr.hr_rep) in*)

  if !reply_buttons <> [] then
    Pack.forget !reply_buttons;
  let rep_buttons = 
    List.map ~f:(fun i -> 
		   Button.create rep_frame ~pady:0 ~takefocus:false
		   ~text:(string_of_int i) ~command:(fun () -> display_num i))
      hdr.hr_rep in
  reply_buttons := rep_buttons;
  if rep_buttons <> [] then
    pack rep_buttons ~side:`Left;

  Label.configure subject_field     ~text:hdr.hr_subject;
  Label.configure themes_field      ~text:themes;
  Label.configure author_field      ~text:hdr.hr_author;
  Label.configure realauthor_field  ~text:hdr.hr_realauthor.ui_name;
  Label.configure date_field        ~text:hdr.hr_date;
  Label.configure num_field         ~text:(string_of_int hdr.hr_num)
(*  Label.configure rep_field         ~text:replies*)


let rec print_slist outchan = function
    [s] -> fprintf outchan "%s" s
  | s::l -> fprintf outchan "%s " s; print_slist outchan l
  | [] -> ()

let rec print_ilist outchan = function
    [i] -> fprintf outchan "%i" i
  | i::l -> fprintf outchan "%i " i; print_ilist outchan l
  | [] -> ()

let print outchan hdr =
  fprintf outchan 
"subject: %s
themes: %a
author: %s
real_author: %s
date: %s
num: %i
replies to: %a
" 
    hdr.hr_subject 
    print_slist hdr.hr_themes
    hdr.hr_author 
    hdr.hr_realauthor.ui_name
    hdr.hr_date
    hdr.hr_num
    print_ilist hdr.hr_rep    

let set_header 
  ?subject ?themes ?author ?realauthor ?date ?num ?rep header =
  (match subject with 
      Some text -> header.hr_subject <- text
    | None -> ());
  (match themes with 
      Some l -> header.hr_themes <- l
    | None -> ());
  (match author with 
      Some text -> header.hr_author <- text
    | None -> ());
  (match realauthor with 
      Some text -> header.hr_realauthor <- text
    | None -> ());
  (match date with 
      Some text -> header.hr_date <- text
    | None -> ());
  (match num with 
      Some num -> header.hr_num <- num
    | None -> ());
  (match rep with 
      Some l -> header.hr_rep <- l
    | None -> ())


let create () =
  { hr_subject = "";
    hr_themes = [];
    hr_author = "";
    hr_realauthor = User_info.create ();
    hr_date = "";
    hr_num = 0;
    hr_rep = [];
    hr_sign = false;
    hr_cens = [];
    hr_effa = false;
    hr_html = !Dodo_settings.send_html }

let add_re s =
  if String.length s >= 3 then
    match String.sub s ~pos:0 ~len:3 with
	"Re:" -> s
      | "re:" -> s
      | _ -> "Re: "^s
  else
    "Re: "^s


let reply hdr =
  { hr_subject = add_re hdr.hr_subject;
    hr_themes = hdr.hr_themes;
    hr_author = !Dodo_settings.dino_nick;
    hr_realauthor = User_info.null;
    hr_date = "";
    hr_num = 0;
    hr_rep = hdr.hr_num :: [] (* :: Dodo_misc.n_firsts 3 hdr.hr_rep*);
    hr_sign = !dino_sign;
    hr_cens = [];
    hr_effa = false;
    hr_html = !Dodo_settings.send_html }

let edit_new hdr =
  { hr_subject = "";
    hr_themes = hdr.hr_themes;
    hr_author = !Dodo_settings.dino_nick;
    hr_realauthor = User_info.null;
    hr_date = "";
    hr_num = 0;
    hr_rep = [];
    hr_sign = !dino_sign;
    hr_cens = [];
    hr_effa = false;
    hr_html = !Dodo_settings.send_html }
